/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001aR\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0018H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"evaluatedInPlace", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getEvaluatedInPlace", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "requiresInitialization", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getRequiresInitialization$annotations", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)V", "getRequiresInitialization", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "checkPropertyAccesses", "", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "properties", "", "scope", "scopes", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyInitializationAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n857#2,2:124\n1747#2,3:126\n1747#2,3:130\n42#3:129\n1#4:133\n*S KotlinDebug\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzerKt\n*L\n55#1:124,2\n91#1:126,3\n105#1:130,3\n104#1:129\n*E\n"})
public final class FirPropertyInitializationAnalyzerKt {
    public static final boolean getEvaluatedInPlace(@NotNull FirDeclaration $this$evaluatedInPlace) {
        Intrinsics.checkNotNullParameter((Object)$this$evaluatedInPlace, (String)"<this>");
        FirDeclaration firDeclaration = $this$evaluatedInPlace;
        return firDeclaration instanceof FirAnonymousFunction ? EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)$this$evaluatedInPlace).getInvocationKind()) : (firDeclaration instanceof FirAnonymousObject ? ((FirAnonymousObject)$this$evaluatedInPlace).getClassKind() != ClassKind.ENUM_ENTRY : (firDeclaration instanceof FirConstructor ? true : !(firDeclaration instanceof FirFunction ? true : firDeclaration instanceof FirClass)));
    }

    public static final boolean getRequiresInitialization(@NotNull FirPropertySymbol $this$requiresInitialization) {
        Intrinsics.checkNotNullParameter((Object)$this$requiresInitialization, (String)"<this>");
        return !($this$requiresInitialization instanceof FirSyntheticPropertySymbol) && !$this$requiresInitialization.getHasInitializer() && !DeclarationAttributesKt.getHasExplicitBackingField($this$requiresInitialization) && DeclarationAttributesKt.getHasBackingField($this$requiresInitialization) && !Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter((FirProperty)$this$requiresInitialization.getFir()), (Object)true);
    }

    public static /* synthetic */ void getRequiresInitialization$annotations(FirPropertySymbol firPropertySymbol) {
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkPropertyAccesses(@NotNull PropertyInitializationInfoData $this$checkPropertyAccesses, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$checkPropertyAccesses, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable iterable = $this$checkPropertyAccesses.getProperties();
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            FirPropertySymbol it = (FirPropertySymbol)element$iv;
            boolean bl = false;
            if (!FirPropertyInitializationAnalyzerKt.getRequiresInitialization(it)) continue;
            destination$iv.add(element$iv);
        }
        Set filtered = (Set)destination$iv;
        if (filtered.isEmpty()) {
            return;
        }
        FirPropertyInitializationAnalyzerKt.checkPropertyAccesses($this$checkPropertyAccesses, $this$checkPropertyAccesses.getGraph(), filtered, context, reporter, null, new LinkedHashMap());
    }

    private static final void checkPropertyAccesses(PropertyInitializationInfoData $this$checkPropertyAccesses, ControlFlowGraph graph, Set<? extends FirPropertySymbol> properties2, CheckerContext context, DiagnosticReporter reporter, FirDeclaration scope2, Map<FirPropertySymbol, FirDeclaration> scopes) {
        for (CFGNode<?> node : graph.getNodes()) {
            PropertyInitializationInfo it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            Object symbol2;
            if (node instanceof VariableDeclarationNode) {
                symbol2 = ((VariableDeclarationNode)node).getFir().getSymbol();
                if (scope2 == null || $this$checkPropertyAccesses.getReceiver() != null || !((VariableDeclarationNode)node).getFir().isVal() || !properties2.contains(symbol2)) continue;
                scopes.put((FirPropertySymbol)symbol2, scope2);
                continue;
            }
            if (node instanceof VariableAssignmentNode) {
                boolean bl;
                block16: {
                    Object object = FirExpressionUtilKt.getCalleeReference(((VariableAssignmentNode)node).getFir());
                    if (object == null) continue;
                    if ((object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null || !((FirProperty)((FirBasedSymbol)(symbol2 = object)).getFir()).isVal()) continue;
                    FirQualifiedAccessExpression firQualifiedAccessExpression = FirExpressionUtilKt.unwrapLValue(((VariableAssignmentNode)node).getFir());
                    boolean bl2 = firQualifiedAccessExpression != null ? FirPropertyInitializationAnalyzerKt.checkPropertyAccesses$hasCorrectReceiver(firQualifiedAccessExpression, $this$checkPropertyAccesses) : false;
                    if (!bl2 || !properties2.contains(symbol2)) continue;
                    $this$any$iv = $this$checkPropertyAccesses.getValue(node).values();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (PropertyInitializationInfo)element$iv;
                            boolean bl3 = false;
                            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)it.get(symbol2));
                            boolean bl4 = eventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(eventOccurrencesRange) : false;
                            if (!bl4) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((VariableAssignmentNode)node).getFir().getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), symbol2, (DiagnosticContext)context, null, 16, null);
                    continue;
                }
                if (Intrinsics.areEqual((Object)scope2, (Object)scopes.get(symbol2))) continue;
                KtDiagnosticFactory1<FirPropertySymbol> error = $this$checkPropertyAccesses.getReceiver() != null ? FirErrors.INSTANCE.getCAPTURED_MEMBER_VAL_INITIALIZATION() : FirErrors.INSTANCE.getCAPTURED_VAL_INITIALIZATION();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((VariableAssignmentNode)node).getFir().getLValue().getSource(), error, symbol2, (DiagnosticContext)context, null, 16, null);
                continue;
            }
            if (node instanceof QualifiedAccessNode) {
                boolean bl;
                block17: {
                    if (FirReferenceUtilsKt.toResolvedPropertySymbol$default(((QualifiedAccessNode)node).getFir().getCalleeReference(), false, 1, null) == null) continue;
                    FirCallableSymbol $this$isLateInit$iv = (FirCallableSymbol)symbol2;
                    boolean $i$f$isLateInit = false;
                    if ($this$isLateInit$iv.getRawStatus().isLateInit() || !FirPropertyInitializationAnalyzerKt.checkPropertyAccesses$hasCorrectReceiver(((QualifiedAccessNode)node).getFir(), $this$checkPropertyAccesses) || !properties2.contains(symbol2)) continue;
                    $this$any$iv = $this$checkPropertyAccesses.getValue(node).values();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (PropertyInitializationInfo)element$iv;
                            boolean bl5 = false;
                            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)it.get(symbol2));
                            boolean bl6 = eventOccurrencesRange != null ? EventOccurrencesRangeKt.isDefinitelyVisited(eventOccurrencesRange) : false;
                            if (!(!bl6)) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((QualifiedAccessNode)node).getFir().getSource(), FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), symbol2, (DiagnosticContext)context, null, 16, null);
                continue;
            }
            if (!(node instanceof CFGNodeWithSubgraphs) || $this$checkPropertyAccesses.getReceiver() != null && node == graph.getExitNode()) continue;
            for (ControlFlowGraph subGraph : ((CFGNodeWithSubgraphs)node).getSubGraphs()) {
                FirDeclaration firDeclaration;
                block19: {
                    block18: {
                        FirDeclaration firDeclaration2;
                        firDeclaration = subGraph.getDeclaration();
                        if (firDeclaration == null) break block18;
                        FirDeclaration it2 = firDeclaration2 = firDeclaration;
                        boolean bl = false;
                        firDeclaration = !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(it2) ? firDeclaration2 : null;
                        if (firDeclaration != null) break block19;
                    }
                    firDeclaration = scope2;
                }
                FirDeclaration newScope = firDeclaration;
                FirPropertyInitializationAnalyzerKt.checkPropertyAccesses($this$checkPropertyAccesses, subGraph, properties2, context, reporter, newScope, scopes);
            }
        }
    }

    private static final boolean checkPropertyAccesses$hasCorrectReceiver(FirQualifiedAccessExpression $this$checkPropertyAccesses_u24hasCorrectReceiver, PropertyInitializationInfoData $this_checkPropertyAccesses) {
        FirExpression firExpression2 = $this$checkPropertyAccesses_u24hasCorrectReceiver.getDispatchReceiver();
        FirPureAbstractElement firPureAbstractElement = firExpression2 instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)firExpression2 : null;
        return Intrinsics.areEqual(firPureAbstractElement != null && (firPureAbstractElement = ((FirThisReceiverExpression)firPureAbstractElement).getCalleeReference()) != null ? ((FirThisReference)firPureAbstractElement).getBoundSymbol() : null, $this_checkPropertyAccesses.getReceiver());
    }
}

