/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent;", "Lorg/jetbrains/kotlin/fir/FirLookupTrackerComponent;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "sourceToFilePath", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/KtSourceElement;", "", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;Lkotlin/jvm/functions/Function1;)V", "requiresPosition", "", "sourceToFilePathsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "recordLookup", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "inScope", "source", "fileSource", "inScopes", "", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nIncrementalPassThroughLookupTrackerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalPassThroughLookupTrackerComponent.kt\norg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n73#2,2:50\n1#3:52\n1#3:53\n*S KotlinDebug\n*F\n+ 1 IncrementalPassThroughLookupTrackerComponent.kt\norg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent\n*L\n31#1:50,2\n31#1:52\n*E\n"})
public final class IncrementalPassThroughLookupTrackerComponent
extends FirLookupTrackerComponent {
    @NotNull
    private final LookupTracker lookupTracker;
    @NotNull
    private final Function1<KtSourceElement, String> sourceToFilePath;
    private final boolean requiresPosition;
    @NotNull
    private final ConcurrentHashMap<KtSourceElement, String> sourceToFilePathsCache;

    public IncrementalPassThroughLookupTrackerComponent(@NotNull LookupTracker lookupTracker, @NotNull Function1<? super KtSourceElement, String> sourceToFilePath) {
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter(sourceToFilePath, (String)"sourceToFilePath");
        this.lookupTracker = lookupTracker;
        this.sourceToFilePath = sourceToFilePath;
        this.requiresPosition = this.lookupTracker.getRequiresPosition();
        this.sourceToFilePathsCache = new ConcurrentHashMap();
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull List<String> inScopes, @Nullable KtSourceElement source, @Nullable KtSourceElement fileSource) {
        Position position;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(inScopes, (String)"inScopes");
        KtSourceElement ktSourceElement = fileSource;
        if (ktSourceElement == null) {
            KtPsiSourceElement ktPsiSourceElement = source instanceof KtPsiSourceElement ? (KtPsiSourceElement)source : null;
            if (ktPsiSourceElement != null) {
                ktSourceElement = ktPsiSourceElement;
            } else {
                return;
            }
        }
        KtSourceElement definedSource = ktSourceElement;
        ConcurrentMap $this$getOrPut$iv = this.sourceToFilePathsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(definedSource);
        if (object == null) {
            boolean bl = false;
            String string2 = (String)this.sourceToFilePath.invoke((Object)definedSource);
            if (string2 == null) {
                return;
            }
            String default$iv = string2;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(definedSource, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        String path2 = (String)object;
        if (this.requiresPosition && source != null && source instanceof KtPsiSourceElement) {
            PsiDiagnosticUtils.LineAndColumn it = DiagnosticUtils.getLineAndColumnInPsiFile(((KtPsiSourceElement)source).getPsi().getContainingFile(), ((KtPsiSourceElement)source).getPsi().getTextRange());
            boolean bl = false;
            position = new Position(it.getLine(), it.getColumn());
        } else {
            position = Position.Companion.getNO_POSITION();
        }
        Position position2 = position;
        for (String scope2 : inScopes) {
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            String string3 = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name.asString()");
            this.lookupTracker.record(path2, position2, scope2, ScopeKind.PACKAGE, string3);
        }
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull String inScope, @Nullable KtSourceElement source, @Nullable KtSourceElement fileSource) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inScope, (String)"inScope");
        this.recordLookup(name, (List<String>)new SmartList<String>(inScope), source, fileSource);
    }
}

