/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MaxLocalsCalculator
extends MethodVisitor {
    private int maxLocals;

    public MaxLocalsCalculator(int api, int access, String descriptor2, MethodVisitor mv) {
        super(api, mv);
        int size = Type.getArgumentsAndReturnSizes((String)descriptor2) >> 2;
        if ((access & 8) != 0) {
            --size;
        }
        this.maxLocals = size;
    }

    public void visitVarInsn(int opcode, int var) {
        int n = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1;
        this.updateMaxLocals(n);
        super.visitVarInsn(opcode, var);
    }

    public void visitIincInsn(int var, int increment) {
        this.updateMaxLocals(var + 1);
        super.visitIincInsn(var, increment);
    }

    public void visitLocalVariable(@NotNull String name, @NotNull String desc, String signature2, @NotNull Label start, @NotNull Label end, int index2) {
        char c;
        if (name == null) {
            MaxLocalsCalculator.$$$reportNull$$$1(0);
        }
        if (desc == null) {
            MaxLocalsCalculator.$$$reportNull$$$1(1);
        }
        if (start == null) {
            MaxLocalsCalculator.$$$reportNull$$$1(2);
        }
        if (end == null) {
            MaxLocalsCalculator.$$$reportNull$$$1(3);
        }
        if (name == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(0);
        }
        if (desc == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(1);
        }
        if (start == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(2);
        }
        if (end == null) {
            MaxLocalsCalculator.$$$reportNull$$$0(3);
        }
        int n = index2 + ((c = desc.charAt(0)) == 'J' || c == 'D' ? 2 : 1);
        this.updateMaxLocals(n);
        super.visitLocalVariable(name, desc, signature2, start, end, index2);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, this.maxLocals);
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    private void updateMaxLocals(int nextFreeSlotNumber) {
        if (nextFreeSlotNumber > this.maxLocals) {
            this.maxLocals = nextFreeSlotNumber;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "desc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "end";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator";
        objectArray[2] = "visitLocalVariable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "desc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "end";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator";
        objectArray[2] = "visitLocalVariable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

