/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.InlineStatus;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLoopJumpChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "tryInline", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,128:1\n1747#2,3:129\n1747#2,3:133\n47#3:132\n47#3:136\n*S KotlinDebug\n*F\n+ 1 FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker\n*L\n38#1:129,3\n75#1:133,3\n75#1:132\n78#1:136\n*E\n"})
public final class FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker
extends FirExpressionChecker<FirLoopJump> {
    @NotNull
    public static final FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker INSTANCE = new FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker();

    private FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker() {
    }

    @Override
    public void check(@NotNull FirLoopJump expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean allowInlined = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.BreakContinueInInlineLambdas);
        ArrayDeque errorPathElements = new ArrayDeque();
        FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck(expression2, (ArrayDeque<FirElement>)errorPathElements, reporter, context, allowInlined, expression2.getTarget().getLabeledElement().getBlock());
    }

    private final FirExpression tryInline(FirExpression $this$tryInline) {
        FirExpression firExpression2;
        FirAnonymousFunctionExpression anonymousFunctionExpression;
        FirPureAbstractElement firPureAbstractElement;
        FirExpression firExpression3 = $this$tryInline instanceof FirLambdaArgumentExpression ? (FirLambdaArgumentExpression)$this$tryInline : null;
        if (firExpression3 == null || (firExpression3 = firExpression3.getExpression()) == null) {
            firExpression3 = $this$tryInline;
        }
        return (firPureAbstractElement = (anonymousFunctionExpression = (firExpression2 = firExpression3) instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression2 : null)) != null && (firPureAbstractElement = ((FirAnonymousFunctionExpression)firPureAbstractElement).getAnonymousFunction()) != null && (firPureAbstractElement = ((FirAnonymousFunction)firPureAbstractElement).getBody()) != null ? (FirExpression)firPureAbstractElement : $this$tryInline;
    }

    private static final boolean check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(ArrayDeque<FirElement> errorPathElements, FirLoopJump $expression, DiagnosticReporter $reporter, CheckerContext $context, boolean allowInlined, FirElement errorElement, FirElement checkElement) {
        errorPathElements.addLast((Object)errorElement);
        boolean result2 = FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, checkElement);
        errorPathElements.removeLast();
        return result2;
    }

    private static final boolean check$findPathAndCheck(FirLoopJump $expression, ArrayDeque<FirElement> errorPathElements, DiagnosticReporter $reporter, CheckerContext $context, boolean allowInlined, FirElement element) {
        if (element == null) {
            return false;
        }
        FirElement firElement = element;
        if (Intrinsics.areEqual((Object)firElement, (Object)$expression)) {
            if (!((Collection)errorPathElements).isEmpty()) {
                boolean hasNonInline;
                block41: {
                    boolean bl;
                    Iterable $this$any$iv = (Iterable)errorPathElements;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirElement it = (FirElement)element$iv;
                            boolean bl2 = false;
                            FirElement firElement2 = it;
                            boolean bl3 = firElement2 instanceof FirAnonymousFunction ? ((FirAnonymousFunction)it).getInlineStatus() != InlineStatus.Inline : (firElement2 instanceof FirAnonymousFunctionExpression ? ((FirAnonymousFunctionExpression)it).getAnonymousFunction().getInlineStatus() != InlineStatus.Inline : true);
                            if (!bl3) continue;
                            bl = true;
                            break block41;
                        }
                        bl = hasNonInline = false;
                    }
                }
                if (hasNonInline) {
                    KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$expression.getSource(), FirErrors.INSTANCE.getBREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY(), (DiagnosticContext)$context, null, 8, null);
                } else if (!allowInlined) {
                    KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$expression.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.BreakContinueInInlineLambdas), (Object)$context.getLanguageVersionSettings()), (DiagnosticContext)$context, null, 16, null);
                }
            }
            return true;
        }
        if (firElement instanceof FirBlock) {
            for (FirStatement statement2 : ((FirBlock)element).getStatements()) {
                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, statement2)) continue;
                return true;
            }
        } else {
            if (firElement instanceof FirLoop) {
                return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirLoop)element).getCondition()) || FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirLoop)element).getBlock());
            }
            if (firElement instanceof FirWhenExpression) {
                for (FirWhenBranch branch : ((FirWhenExpression)element).getBranches()) {
                    if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, branch.getResult())) continue;
                    return true;
                }
            } else {
                if (firElement instanceof FirVariable) {
                    return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirVariable)element).getInitializer());
                }
                if (firElement instanceof FirWrappedExpression) {
                    return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirWrappedExpression)element).getExpression());
                }
                if (firElement instanceof FirNoReceiverExpression) {
                    return false;
                }
                if (firElement instanceof FirFunctionCall) {
                    boolean bl;
                    block42: {
                        if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirFunctionCall)element).getExtensionReceiver()) || FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, ((FirFunctionCall)element).getDispatchReceiver())) {
                            return true;
                        }
                        FirCall $this$arguments$iv = (FirCall)element;
                        boolean $i$f$getArguments = false;
                        Iterable $this$any$iv = $this$arguments$iv.getArgumentList().getArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FirElement p0 = (FirElement)element$iv;
                                boolean bl4 = false;
                                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, p0)) continue;
                                bl = true;
                                break block42;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return true;
                    }
                } else if (firElement instanceof FirCall) {
                    FirCall $this$arguments$iv = (FirCall)element;
                    boolean $i$f$getArguments = false;
                    for (FirExpression argument2 : $this$arguments$iv.getArgumentList().getArguments()) {
                        if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, argument2)) continue;
                        return true;
                    }
                } else if (firElement instanceof FirClass) {
                    errorPathElements.addLast((Object)element);
                    for (FirDeclaration declaration : ((FirClass)element).getDeclarations()) {
                        if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, declaration)) continue;
                        errorPathElements.removeLast();
                        return true;
                    }
                    errorPathElements.removeLast();
                } else if (firElement instanceof FirFunction) {
                    if (FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirFunction)element).getBody())) {
                        return true;
                    }
                    if (element instanceof FirConstructor) {
                        FirArgumentList argumentList2;
                        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)element).getDelegatedConstructor();
                        FirArgumentList firArgumentList = argumentList2 = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getArgumentList() : null;
                        if (argumentList2 != null) {
                            errorPathElements.addLast((Object)element);
                            for (FirExpression argument3 : argumentList2.getArguments()) {
                                if (!FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck($expression, errorPathElements, $reporter, $context, allowInlined, argument3)) continue;
                                errorPathElements.removeLast();
                                return true;
                            }
                            errorPathElements.removeLast();
                        }
                    }
                } else {
                    if (firElement instanceof FirAnonymousInitializer) {
                        return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirAnonymousInitializer)element).getBody());
                    }
                    if (firElement instanceof FirAnonymousObjectExpression) {
                        return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirAnonymousObjectExpression)element).getAnonymousObject());
                    }
                    if (firElement instanceof FirAnonymousFunctionExpression) {
                        return FirBreakOrContinueJumpsAcrossFunctionBoundaryChecker.check$findPathAndCheck$findPathAndCheckWithAddingErrorElement(errorPathElements, $expression, $reporter, $context, allowInlined, element, ((FirAnonymousFunctionExpression)element).getAnonymousFunction());
                    }
                }
            }
        }
        return false;
    }
}

