/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionElement;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionVisitor;
import org.jetbrains.kotlin.fir.contracts.description.ConeErroneousCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeErroneousConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeErroneousContractElement;
import org.jetbrains.kotlin.fir.contracts.description.ConeErroneousIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeErroneousValueParameterReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeReturnsEffectDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "EMPTY_CONTRACT_MESSAGE", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkContractNotAllowed", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "checkUnresolvedEffects", "DiagnosticExtractor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,144:1\n12#2,2:145\n37#2:147\n38#2:148\n21#2:149\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n64#1:145,2\n64#1:147\n65#1:148\n66#1:149\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String EMPTY_CONTRACT_MESSAGE = "Empty contract block is not allowed";

    private FirContractChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription = ((FirContractDescriptionOwner)((Object)declaration)).getContractDescription();
        FirResolvedContractDescription firResolvedContractDescription = firContractDescription instanceof FirResolvedContractDescription ? (FirResolvedContractDescription)firContractDescription : null;
        if (firResolvedContractDescription == null) {
            return;
        }
        FirResolvedContractDescription contractDescription = firResolvedContractDescription;
        this.checkUnresolvedEffects(contractDescription, context, reporter);
        this.checkContractNotAllowed(declaration, contractDescription, context, reporter);
        if (contractDescription.getEffects().isEmpty() && contractDescription.getUnresolvedEffects().isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)contractDescription.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)EMPTY_CONTRACT_MESSAGE, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkUnresolvedEffects(FirResolvedContractDescription contractDescription, CheckerContext context, DiagnosticReporter reporter) {
        for (FirContractElementDeclaration unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            ConeDiagnostic diagnostic;
            if ((ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkContractNotAllowed(FirFunction declaration, FirResolvedContractDescription contractDescription, CheckerContext context, DiagnosticReporter reporter) {
        block5: {
            KtSourceElement source;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                KtSourceElement ktSourceElement = source = contractDescription.getSource();
                                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                                    return;
                                }
                                if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirAnonymousFunction)) break block4;
                                FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are only allowed for functions");
                                break block5;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block6;
                            FirMemberDeclaration $this$isOpen$iv = declaration;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block6;
                            FirMemberDeclaration $this$isOverride$iv = declaration;
                            boolean $i$f$isOverride = false;
                            if (!$this$isOverride$iv.getStatus().isOverride()) break block7;
                        }
                        FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for open or override functions");
                        break block5;
                    }
                    FirMemberDeclaration $this$isOperator$iv = declaration;
                    boolean $i$f$isOperator = false;
                    if (!$this$isOperator$iv.getStatus().isOperator()) break block8;
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for operator functions");
                    break block5;
                }
                if (declaration.getSymbol().getCallableId().isLocal()) break block9;
                FirMemberDeclaration $this$visibility$iv = declaration;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block5;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for local functions");
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, String message) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, (DiagnosticContext)$context, null, 16, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u001e2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020*2\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "()V", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitContractDescriptionElement", "contractDescriptionElement", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "visitErroneousCallsEffectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeErroneousCallsEffectDeclaration;", "visitErroneousConstantReference", "erroneousConstantReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeErroneousConstantReference;", "visitErroneousElement", "element", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeErroneousContractElement;", "visitErroneousIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeErroneousIsInstancePredicate;", "visitErroneousValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeErroneousValueParameterReference;", "visitIsInstancePredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "checkers"})
    private static final class DiagnosticExtractor
    extends ConeContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull ConeContractDescriptionElement contractDescriptionElement, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull ConeConditionalEffectDeclaration conditionalEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull ConeReturnsEffectDeclaration returnsEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)returnsEffect, (String)"returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull ConeCallsEffectDeclaration callsEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)callsEffect, (String)"callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data2);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull ConeErroneousCallsEffectDeclaration callsEffect, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)callsEffect, (String)"callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull ConeBinaryLogicExpression binaryLogicExpression, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull ConeLogicalNot logicalNot, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull ConeIsInstancePredicate isInstancePredicate, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data2);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull ConeErroneousIsInstancePredicate isInstancePredicate, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull ConeIsNullPredicate isNullPredicate, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)isNullPredicate, (String)"isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data2);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull ConeErroneousConstantReference erroneousConstantReference, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)erroneousConstantReference, (String)"erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull ConeErroneousValueParameterReference valueParameterReference, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)valueParameterReference, (String)"valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull ConeErroneousContractElement element, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.getDiagnostic();
        }
    }
}

