/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContextForProvider;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J6\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0$0\fH\u0014J(\u0010%\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0004J \u0010&\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J6\u0010'\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0$0\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010(\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0004J \u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0002J0\u0010/\u001a\u00020\u0017*\u0002002\u0006\u00101\u001a\u00020\u001a2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a032\u0006\u00104\u001a\u00020\u0002H\u0002J\"\u00105\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0$0\f*\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0089\u0001\u0010\u0005\u001aw\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "inlineVisitor", "Lkotlin/reflect/KFunction5;", "Lkotlin/ParameterName;", "name", "inlineFunction", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inlineFunEffectiveVisibility", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "inalienableParameters", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor;", "getInlineVisitor", "()Lkotlin/reflect/KFunction;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkCallableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkCanBeInlined", "", "effectiveVisibility", "checkFunctionalParametersWithInheritedDefaultValues", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkInlineFunctionBody", "checkNothingToInline", "checkParameters", "checkParametersInNotInline", "checkSuspendFunctionalParameterWithDefaultValue", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "isInlinableDefaultValue", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkChildrenWithCustomVisitor", "Lorg/jetbrains/kotlin/fir/FirElement;", "parentContext", "visitorVoid", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "rootFunction", "getOverriddenSymbols", "BasicInlineVisitor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,558:1\n40#2:559\n28#2:560\n43#2:568\n43#2:569\n37#2:570\n34#2,10:571\n28#2:587\n766#3:561\n857#3,2:562\n1549#3:564\n1620#3,3:565\n1747#3,3:581\n1747#3,3:584\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n*L\n44#1:559\n51#1:560\n418#1:568\n423#1:569\n475#1:570\n485#1:571,10\n531#1:587\n63#1:561\n63#1:562,2\n67#1:564\n67#1:565,3\n486#1:581,3\n489#1:584,3\n*E\n"})
public abstract class FirInlineDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isInline$iv = declaration;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            this.checkParametersInNotInline(declaration, context, reporter);
            return;
        }
        if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirSimpleFunction)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        Object effectiveVisibility = object;
        this.checkInlineFunctionBody(declaration, (EffectiveVisibility)effectiveVisibility, context, reporter);
        this.checkCallableDeclaration(declaration, context, reporter);
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkInlineFunctionBody(@NotNull FirFunction function2, @NotNull EffectiveVisibility effectiveVisibility, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirValueParameter it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)effectiveVisibility, (String)"effectiveVisibility");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirBlock firBlock = function2.getBody();
        if (firBlock == null) {
            return;
        }
        FirBlock body2 = firBlock;
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConeKotlinType type2;
            it = (FirValueParameter)element$iv$iv;
            boolean bl = false;
            if (!(it.isNoinline() ? false : !ConeTypeUtilsKt.isMarkedNullable(type2 = FirTypeUtilsKt.getConeType(it.getReturnTypeRef())) && FunctionalTypeUtilsKt.isNonReflectFunctionType(type2, context.getSession()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List inalienableParameters = (List)destination$iv$iv;
        BasicInlineVisitor visitor2 = (BasicInlineVisitor)((Function5)this.getInlineVisitor()).invoke((Object)function2, (Object)effectiveVisibility, (Object)inalienableParameters, (Object)context.getSession(), (Object)reporter);
        this.checkChildrenWithCustomVisitor(body2, context, visitor2, function2);
    }

    @NotNull
    public KFunction<BasicInlineVisitor> getInlineVisitor() {
        return (KFunction)inlineVisitor.1.INSTANCE;
    }

    protected void checkSuspendFunctionalParameterWithDefaultValue(@NotNull FirValueParameter param, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
    }

    protected void checkFunctionalParametersWithInheritedDefaultValues(@NotNull FirSimpleFunction function2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(overriddenSymbols2, (String)"overriddenSymbols");
    }

    private final void checkParameters(FirSimpleFunction function2, List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2, CheckerContext context, DiagnosticReporter reporter) {
        for (FirValueParameter firValueParameter : function2.getValueParameters()) {
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(firValueParameter.getReturnTypeRef());
            FunctionTypeKind functionKind = FunctionalTypeUtilsKt.functionTypeKind(coneType, context.getSession());
            boolean isFunctionalType = functionKind != null;
            FunctionTypeKind functionTypeKind = functionKind;
            boolean isSuspendFunctionType = functionTypeKind != null ? FunctionTypeKindKt.isSuspendOrKSuspendFunction(functionTypeKind) : false;
            FirExpression defaultValue = firValueParameter.getDefaultValue();
            if (!isFunctionalType && !isSuspendFunctionType && (firValueParameter.isNoinline() || firValueParameter.isCrossinline())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context, null, 8, null);
            }
            if (firValueParameter.isNoinline()) continue;
            FirMemberDeclaration $this$isSuspend$iv = function2;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend() && defaultValue != null && isSuspendFunctionType) {
                this.checkSuspendFunctionalParameterWithDefaultValue(firValueParameter, context, reporter);
            }
            if (isSuspendFunctionType && !firValueParameter.isCrossinline()) {
                $this$isSuspend$iv = function2;
                $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend()) {
                    FirElement firElement = firValueParameter.getReturnTypeRef();
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"SUSPEND_KEYWORD");
                    FirModifier<?> modifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
                    if (modifier != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getREDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
                    }
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getINLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED(), (DiagnosticContext)context, null, 8, null);
                }
            }
            if (ConeTypeUtilsKt.isNullable(coneType) && isFunctionalType) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getNULLABLE_INLINE_PARAMETER(), (Object)firValueParameter.getSymbol(), (Object)function2.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
            if (!isFunctionalType || defaultValue == null || this.isInlinableDefaultValue(defaultValue)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getINVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE(), (Object)defaultValue, (Object)firValueParameter.getSymbol(), (DiagnosticContext)context, null, 32, null);
        }
        if (!((Collection)overriddenSymbols2).isEmpty()) {
            for (FirTypeParameter firTypeParameter : function2.getTypeParameters()) {
                if (!firTypeParameter.isReified()) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firTypeParameter.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_IN_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
            }
        }
        this.checkFunctionalParametersWithInheritedDefaultValues(function2, context, reporter, overriddenSymbols2);
    }

    protected final void checkParametersInNotInline(@NotNull FirFunction function2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirValueParameter param : function2.getValueParameters()) {
            if (!param.isNoinline() && !param.isCrossinline()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final List<FirCallableSymbol<? extends FirCallableDeclaration>> getOverriddenSymbols(FirCallableDeclaration $this$getOverriddenSymbols, CheckerContext context) {
        FirMemberDeclaration $this$isOverride$iv = $this$getOverriddenSymbols;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return CollectionsKt.emptyList();
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$getOverriddenSymbols);
        FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context.getSession()) : null;
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return CollectionsKt.emptyList();
        }
        FirClassSymbol classSymbol = firClassSymbol;
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope(classSymbol, context);
        scope2.processFunctionsByName($this$getOverriddenSymbols.getSymbol().getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)getOverriddenSymbols.1.INSTANCE));
        return FirTypeScopeKt.getDirectOverriddenMembers(scope2, $this$getOverriddenSymbols.getSymbol(), true);
    }

    private final void checkNothingToInline(FirSimpleFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        boolean hasInlinableParameters;
        FirSession session;
        block15: {
            boolean bl;
            boolean bl2;
            block14: {
                block17: {
                    block16: {
                        FirMemberDeclaration $this$isExpect$iv = function2;
                        boolean $i$f$isExpect = false;
                        if ($this$isExpect$iv.getStatus().isExpect()) break block16;
                        FirMemberDeclaration $this$isSuspend$iv = function2;
                        boolean $i$f$isSuspend = false;
                        if (!$this$isSuspend$iv.getStatus().isSuspend()) break block17;
                    }
                    return;
                }
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameter it = (FirTypeParameter)element$iv;
                        boolean bl3 = false;
                        if (!it.getSymbol().isReified()) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            session = context.getSession();
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    ConeKotlinType type2 = FirTypeUtilsKt.getConeType(param.getReturnTypeRef());
                    boolean bl5 = !param.isNoinline() && !ConeTypeUtilsKt.isNullable(type2) && (FunctionalTypeUtilsKt.isBasicFunctionType(type2, session) || FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(type2, session));
                    if (!bl5) continue;
                    bl = true;
                    break block15;
                }
                bl = hasInlinableParameters = false;
            }
        }
        if (hasInlinableParameters) {
            return;
        }
        if (FirHelpersKt.isInlineOnly(function2, session)) {
            return;
        }
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(function2.getReturnTypeRef(), session)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getNOTHING_TO_INLINE(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean checkCanBeInlined(FirCallableDeclaration declaration, EffectiveVisibility effectiveVisibility, CheckerContext context, DiagnosticReporter reporter) {
        if (ClassMembersKt.containingClassLookupTag(declaration) == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)effectiveVisibility, (Object)EffectiveVisibility.PrivateInClass.INSTANCE)) {
            return true;
        }
        if (!DeclarationUtilsKt.isEffectivelyFinal(declaration, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED(), (DiagnosticContext)context, null, 8, null);
            return false;
        }
        return true;
    }

    private final boolean isInlinableDefaultValue(FirExpression expression2) {
        return expression2 instanceof FirCallableReferenceAccess || expression2 instanceof FirFunctionCall || expression2 instanceof FirLambdaArgumentExpression || expression2 instanceof FirAnonymousFunctionExpression || expression2 instanceof FirConstExpression && ((FirConstExpression)expression2).getValue() == null;
    }

    public final void checkCallableDeclaration(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean canBeInlined;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        List<FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols2 = this.getOverriddenSymbols(declaration, context);
        if (declaration instanceof FirSimpleFunction) {
            this.checkParameters((FirSimpleFunction)declaration, overriddenSymbols2, context, reporter);
            this.checkNothingToInline((FirSimpleFunction)declaration, context, reporter);
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if ((canBeInlined = this.checkCanBeInlined(declaration, (EffectiveVisibility)object, context, reporter)) && !((Collection)overriddenSymbols2).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getOVERRIDE_BY_INLINE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkChildrenWithCustomVisitor(FirElement $this$checkChildrenWithCustomVisitor, CheckerContext parentContext, FirVisitor<Unit, ? super CheckerContext> visitorVoid, FirFunction rootFunction) {
        if (!(parentContext instanceof CheckerContextForProvider)) {
            boolean bl = false;
            String string2 = "This checked violates the contract for read-only checkers";
            throw new IllegalArgumentException(string2.toString());
        }
        ((CheckerContextForProvider)parentContext).withDeclaration(rootFunction, (Function1)new Function1<CheckerContextForProvider, Unit>($this$checkChildrenWithCustomVisitor, visitorVoid){
            final /* synthetic */ FirElement $this_checkChildrenWithCustomVisitor;
            final /* synthetic */ FirVisitor<Unit, CheckerContext> $visitorVoid;
            {
                this.$this_checkChildrenWithCustomVisitor = $receiver;
                this.$visitorVoid = $visitorVoid;
                super(1);
            }

            public final void invoke(@NotNull CheckerContextForProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AbstractDiagnosticCollectorVisitor collectingVisitor2 = new AbstractDiagnosticCollectorVisitor(it, this.$visitorVoid){
                    final /* synthetic */ FirVisitor<Unit, CheckerContext> $visitorVoid;
                    {
                        this.$visitorVoid = $visitorVoid;
                        super($it);
                    }

                    protected void checkElement(@NotNull FirElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        element.accept(this.$visitorVoid, this.getContext());
                    }
                };
                this.$this_checkChildrenWithCustomVisitor.accept(collectingVisitor2, null);
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001OB3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0002J&\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u0003H\u0002J$\u0010*\u001a\u00020\u00022\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0003H\u0002J&\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u0003H\u0002J.\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u0003H\u0002J&\u00104\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010%\u001a\u00020\u0003H\u0002J$\u00105\u001a\u00020\u00022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0003H\u0002J$\u00106\u001a\u00020\u00022\n\u0010+\u001a\u0006\u0012\u0002\b\u0003072\u0006\u00108\u001a\u00020.2\u0006\u0010%\u001a\u00020\u0003H\u0002J.\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020.2\f\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0016\u0010;\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J\u0018\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0018\u0010@\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0018\u0010A\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0018\u0010B\u001a\u00020\u00022\u0006\u0010C\u001a\u00020D2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0018\u0010E\u001a\u00020\u00022\u0006\u0010F\u001a\u00020G2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0018\u0010H\u001a\u00020\u00022\u0006\u0010I\u001a\u00020J2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0010\u0010K\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030LH\u0002J\u0010\u0010M\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\"H\u0002J\u0014\u0010N\u001a\u00020\u0017*\u00020.2\u0006\u0010%\u001a\u00020\u0003H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inalienableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getInalienableParameters", "()Ljava/util/List;", "getInlineFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getInlineFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isEffectivelyPrivateApiFunction", "", "prohibitProtectedCallFromInline", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "checkAccessedDeclaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor$AccessedDeclarationVisibilityData;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "accessedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "context", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "targetSymbol", "checkPrivateClassMemberAccess", "calledDeclaration", "checkQualifiedAccess", "qualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "checkReceiver", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkReceiversOfQualifiedAccessExpression", "checkRecursion", "checkSuperCalls", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callExpression", "checkVisibilityAndAccess", "accessExpression", "isInvokeOrInlineExtension", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFunctionCall", "visitQualifiedAccessExpression", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitSmartCastExpression", "smartCastExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "isDefinedInInlineFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "isInsidePrivateClass", "partOfCall", "AccessedDeclarationVisibilityData", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 publishedApiEffectiveVisibility.kt\norg/jetbrains/kotlin/fir/resolve/transformers/PublishedApiEffectiveVisibilityKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,558:1\n71#2:559\n59#2:560\n25#2:563\n60#2:566\n37#2:573\n24#2:578\n59#2:579\n59#2:580\n71#2:581\n23#3,2:561\n23#3,2:564\n61#4,4:567\n47#4:574\n288#5,2:571\n1747#5,3:575\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor\n*L\n122#1:559\n123#1:560\n134#1:563\n135#1:566\n199#1:573\n281#1:578\n370#1:579\n371#1:580\n377#1:581\n134#1:561,2\n135#1:564,2\n191#1:567,4\n263#1:574\n196#1:571,2\n263#1:575,3\n*E\n"})
    public static class BasicInlineVisitor
    extends FirDefaultVisitor<Unit, CheckerContext> {
        @NotNull
        private final FirFunction inlineFunction;
        @NotNull
        private final EffectiveVisibility inlineFunEffectiveVisibility;
        @NotNull
        private final List<FirValueParameterSymbol> inalienableParameters;
        @NotNull
        private final FirSession session;
        @NotNull
        private final DiagnosticReporter reporter;
        private final boolean isEffectivelyPrivateApiFunction;
        private final boolean prohibitProtectedCallFromInline;

        public BasicInlineVisitor(@NotNull FirFunction inlineFunction2, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inalienableParameters, @NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)inlineFunction2, (String)"inlineFunction");
            Intrinsics.checkNotNullParameter((Object)inlineFunEffectiveVisibility, (String)"inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inalienableParameters, (String)"inalienableParameters");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.inlineFunction = inlineFunction2;
            this.inlineFunEffectiveVisibility = inlineFunEffectiveVisibility;
            this.inalienableParameters = inalienableParameters;
            this.session = session;
            this.reporter = reporter;
            this.isEffectivelyPrivateApiFunction = this.inlineFunEffectiveVisibility.getPrivateApi();
            this.prohibitProtectedCallFromInline = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.ProhibitProtectedCallFromInline);
        }

        @NotNull
        public final FirFunction getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final EffectiveVisibility getInlineFunEffectiveVisibility() {
            return this.inlineFunEffectiveVisibility;
        }

        @NotNull
        public final List<FirValueParameterSymbol> getInalienableParameters() {
            return this.inalienableParameters;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        @Override
        public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirCallableSymbol<?> targetSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(functionCall);
            if (targetSymbol != null) {
                this.checkReceiversOfQualifiedAccessExpression(functionCall, (FirBasedSymbol)targetSymbol, data2);
                this.checkArgumentsOfCall(functionCall, (FirBasedSymbol)targetSymbol, data2);
                this.checkQualifiedAccess(functionCall, (FirBasedSymbol)targetSymbol, data2);
            }
        }

        @Override
        public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirCallableSymbol<?> targetSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
            this.checkQualifiedAccess(qualifiedAccessExpression, (FirBasedSymbol)targetSymbol, data2);
            this.checkReceiversOfQualifiedAccessExpression(qualifiedAccessExpression, (FirBasedSymbol)targetSymbol, data2);
        }

        @Override
        public void visitSmartCastExpression(@NotNull FirSmartCastExpression smartCastExpression, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)smartCastExpression, (String)"smartCastExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        @Override
        public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirReference firReference = FirExpressionUtilKt.getCalleeReference(variableAssignment);
            FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
            FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol propertySymbol = firPropertySymbol;
            FirPropertyAccessorSymbol firPropertyAccessorSymbol = propertySymbol.getSetterSymbol();
            if (firPropertyAccessorSymbol == null) {
                return;
            }
            FirPropertyAccessorSymbol setterSymbol = firPropertyAccessorSymbol;
            this.checkQualifiedAccess(variableAssignment, setterSymbol, data2);
        }

        @Override
        public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier, @NotNull CheckerContext data2) {
            Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirClassLikeSymbol<?> firClassLikeSymbol = resolvedQualifier.getSymbol();
            if (firClassLikeSymbol == null) {
                return;
            }
            FirClassLikeSymbol<?> accessedClass = firClassLikeSymbol;
            KtSourceElement ktSourceElement = resolvedQualifier.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            FirClassLikeSymbol<?> $this$isCompanion$iv = accessedClass;
            boolean $i$f$isCompanion = false;
            if ($this$isCompanion$iv.getRawStatus().isCompanion()) {
                FirClassLikeSymbol<?> $this$visibility$iv = accessedClass;
                boolean $i$f$getVisibility = false;
                this.checkAccessedDeclaration(source, (FirBasedSymbol)accessedClass, $this$visibility$iv.getResolvedStatus().getVisibility(), data2);
            }
        }

        private final AccessedDeclarationVisibilityData checkAccessedDeclaration(KtSourceElement source, FirBasedSymbol<?> accessedSymbol, Visibility declarationVisibility, CheckerContext context) {
            EffectiveVisibility recordedEffectiveVisibility;
            boolean $i$f$getEffectiveVisibility;
            FirBasedSymbol $this$effectiveVisibility$iv;
            EffectiveVisibility effectiveVisibility;
            boolean $i$f$getPublishedApiEffectiveVisibility;
            FirBasedSymbol<?> $this$publishedApiEffectiveVisibility$iv;
            FirBasedSymbol<?> firBasedSymbol = accessedSymbol;
            if (firBasedSymbol instanceof FirCallableSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirCallableSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirClassLikeSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw null;
            }
            EffectiveVisibility it = recordedEffectiveVisibility = effectiveVisibility;
            boolean bl = false;
            EffectiveVisibility accessedDeclarationEffectiveVisibility = Intrinsics.areEqual((Object)it, (Object)EffectiveVisibility.Local.INSTANCE) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : it;
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationEffectiveVisibility.getPublicApi();
            boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
            if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && declarationVisibility != Visibilities.Local.INSTANCE) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE(), accessedSymbol, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            } else {
                this.checkPrivateClassMemberAccess(accessedSymbol, source, context);
            }
            return new AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi, isCalledFunPublicOrPublishedApi, accessedDeclarationEffectiveVisibility);
        }

        private final void checkReceiversOfQualifiedAccessExpression(FirQualifiedAccessExpression qualifiedAccessExpression, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getDispatchReceiver(), targetSymbol, context);
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getExtensionReceiver(), targetSymbol, context);
        }

        private final void checkArgumentsOfCall(FirFunctionCall functionCall, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            if (context.isContractBody()) {
                return;
            }
            FirNamedFunctionSymbol firNamedFunctionSymbol = targetSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)targetSymbol : null;
            if (firNamedFunctionSymbol == null) {
                return;
            }
            FirNamedFunctionSymbol calledFunctionSymbol = firNamedFunctionSymbol;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMapping = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMapping).entrySet()) {
                KtDiagnosticFactory1<FirBasedSymbol<?>> ktDiagnosticFactory1;
                FirValueParameterSymbol valueParameterOfOriginalInlineFunction;
                Object v2;
                FirExpression argument2;
                FirValueParameter valueParameter2;
                block9: {
                    FirVariableSymbol resolvedArgumentSymbol;
                    FirExpression wrappedArgument = (FirExpression)entry.getKey();
                    valueParameter2 = (FirValueParameter)entry.getValue();
                    argument2 = FirExpressionUtilKt.unwrapArgument(wrappedArgument);
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(argument2);
                    if ((firCallableSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null) == null) continue;
                    resolvedArgumentSymbol = resolvedArgumentSymbol;
                    Iterable $this$firstOrNull$iv = this.inalienableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)resolvedArgumentSymbol)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameterSymbol)v2) == null) continue;
                FirCallableSymbol $this$isInline$iv = calledFunctionSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    if (valueParameter2.isNoinline()) {
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (!valueParameter2.isCrossinline() || valueParameterOfOriginalInlineFunction.isCrossinline()) continue;
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                KtDiagnosticFactory1<FirBasedSymbol<?>> factory2 = ktDiagnosticFactory1;
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)argument2.getSource(), factory2, (Object)valueParameterOfOriginalInlineFunction, (DiagnosticContext)context, null, 16, null);
            }
        }

        private final void checkReceiver(FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(receiverExpression);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> receiverSymbol = firCallableSymbol;
            if (CollectionsKt.contains((Iterable)this.inalienableParameters, receiverSymbol) && !this.isInvokeOrInlineExtension(targetSymbol)) {
                KtSourceElement ktSourceElement = receiverExpression.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = qualifiedAccessExpression.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), receiverSymbol, (DiagnosticContext)context, null, 16, null);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInvokeOrInlineExtension(FirBasedSymbol<?> targetSymbol) {
            if (!(targetSymbol instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)targetSymbol).getName(), (Object)OperatorNameConventions.INVOKE)) return false;
            ConeSimpleKotlinType coneSimpleKotlinType = ((FirNamedFunctionSymbol)targetSymbol).getDispatchReceiverType();
            if (coneSimpleKotlinType == null) return false;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(coneSimpleKotlinType, this.session)) return false;
            return true;
        }

        private final void checkQualifiedAccess(FirStatement qualifiedAccess, FirBasedSymbol<?> targetSymbol, CheckerContext context) {
            KtSourceElement ktSourceElement = qualifiedAccess.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (!(targetSymbol instanceof FirCallableSymbol)) {
                return;
            }
            if (CollectionsKt.contains((Iterable)this.inalienableParameters, targetSymbol) && !this.partOfCall(qualifiedAccess, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), targetSymbol, (DiagnosticContext)context, null, 16, null);
            }
            this.checkVisibilityAndAccess(qualifiedAccess, (FirCallableSymbol)targetSymbol, source, context);
            this.checkRecursion(targetSymbol, source, context);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(FirStatement $this$partOfCall, CheckerContext context) {
            boolean bl;
            block7: {
                void $this$any$iv;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = (FirStatement)CollectionsKt.getOrNull(context.getQualifiedAccessOrAssignmentsOrAnnotationCalls(), (int)(context.getQualifiedAccessOrAssignmentsOrAnnotationCalls().size() - 2));
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                FirQualifiedAccessExpression firQualifiedAccessExpression = containingQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)containingQualifiedAccess : null;
                if (Intrinsics.areEqual((Object)$this$partOfCall, (Object)(firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getExplicitReceiver() : null))) {
                    return true;
                }
                FirCall firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)FirExpressionUtilKt.unwrapArgument(it), (Object)$this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final void checkVisibilityAndAccess(FirStatement accessExpression, FirCallableSymbol<?> calledDeclaration, KtSourceElement source, CheckerContext context) {
            if (calledDeclaration == null || Intrinsics.areEqual((Object)calledDeclaration.getCallableId().getCallableName(), (Object)StandardNames.BACKING_FIELD)) {
                return;
            }
            FirCallableSymbol<?> $this$visibility$iv = calledDeclaration;
            boolean $i$f$getVisibility = false;
            AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = this.checkAccessedDeclaration(source, (FirBasedSymbol)calledDeclaration, $this$visibility$iv.getResolvedStatus().getVisibility(), context);
            boolean isInlineFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component1();
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component2();
            EffectiveVisibility calledFunEffectiveVisibility = accessedDeclarationVisibilityData.component3();
            if (isInlineFunPublicOrPublishedApi && isCalledFunPublicOrPublishedApi) {
                this.checkSuperCalls(calledDeclaration, accessExpression, context);
            }
            boolean isConstructorCall = calledDeclaration instanceof FirConstructorSymbol;
            if (isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE && calledFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE) {
                KtDiagnosticFactory2<FirBasedSymbol<?>, FirBasedSymbol<?>> factory2 = isConstructorCall ? FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE() : (this.prohibitProtectedCallFromInline ? FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR() : FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE());
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, factory2, calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
        }

        private final void checkPrivateClassMemberAccess(FirBasedSymbol<?> calledDeclaration, KtSourceElement source, CheckerContext context) {
            if (!this.isEffectivelyPrivateApiFunction && this.isInsidePrivateClass(calledDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
        }

        private final void checkSuperCalls(FirCallableSymbol<?> calledDeclaration, FirStatement callExpression, CheckerContext context) {
            FirStatement firStatement = callExpression;
            FirExpression firExpression2 = firStatement instanceof FirQualifiedAccessExpression ? ((FirQualifiedAccessExpression)callExpression).getDispatchReceiver() : (firStatement instanceof FirVariableAssignment ? FirExpressionUtilKt.getDispatchReceiver((FirVariableAssignment)callExpression) : null);
            FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            if (firQualifiedAccessExpression == null) {
                return;
            }
            FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
            if (receiver.getCalleeReference() instanceof FirSuperReference) {
                ConeKotlinType dispatchReceiverType = FirTypeUtilsKt.getConeType(receiver.getDispatchReceiver().getTypeRef());
                FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(dispatchReceiverType, this.session);
                if (firClassifierSymbol == null) {
                    return;
                }
                FirClassifierSymbol<?> classSymbol = firClassifierSymbol;
                if (!this.isDefinedInInlineFunction(classSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)receiver.getSource(), FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), calledDeclaration, (DiagnosticContext)context, null, 16, null);
                }
            }
        }

        private final boolean isDefinedInInlineFunction(FirClassifierSymbol<?> $this$isDefinedInInlineFunction) {
            boolean bl;
            FirClassifierSymbol<?> symbol2 = $this$isDefinedInInlineFunction;
            if (symbol2 instanceof FirAnonymousObjectSymbol) {
                bl = true;
            } else if (symbol2 instanceof FirRegularClassSymbol) {
                bl = ((FirRegularClassSymbol)symbol2).getClassId().isLocal();
            } else {
                if (symbol2 instanceof FirTypeAliasSymbol ? true : symbol2 instanceof FirTypeParameterSymbol) {
                    throw new IllegalStateException(("Unexpected classifier declaration type: " + symbol2).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private final void checkRecursion(FirBasedSymbol<?> targetSymbol, KtSourceElement source, CheckerContext context) {
            if (Intrinsics.areEqual(targetSymbol, this.inlineFunction.getSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRECURSION_IN_INLINE(), targetSymbol, (DiagnosticContext)context, null, 16, null);
            }
        }

        private final boolean isInsidePrivateClass(FirBasedSymbol<?> $this$isInsidePrivateClass) {
            Visibility visibility2;
            boolean $i$f$getVisibility;
            Object $this$visibility$iv;
            Object object = FirVisibilityCheckerKt.getOwnerLookupTag($this$isInsidePrivateClass);
            if (object == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.session)) == null) {
                return false;
            }
            Object containingClassSymbol = object;
            Object object2 = containingClassSymbol;
            if (object2 instanceof FirAnonymousObjectSymbol) {
                return false;
            }
            if (object2 instanceof FirRegularClassSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility2 = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else if (object2 instanceof FirTypeAliasSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility2 = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Visibility containingClassVisibility = visibility2;
            if (Intrinsics.areEqual((Object)containingClassVisibility, (Object)Visibilities.Private.INSTANCE) || Intrinsics.areEqual((Object)containingClassVisibility, (Object)Visibilities.PrivateToThis.INSTANCE)) {
                return true;
            }
            if ($this$isInsidePrivateClass instanceof FirCallableSymbol && containingClassSymbol instanceof FirRegularClassSymbol) {
                Object $this$isCompanion$iv = containingClassSymbol;
                boolean $i$f$isCompanion = false;
                if (((FirClassLikeSymbol)$this$isCompanion$iv).getRawStatus().isCompanion()) {
                    return this.isInsidePrivateClass((FirBasedSymbol)containingClassSymbol);
                }
            }
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor$AccessedDeclarationVisibilityData;", "", "isInlineFunPublicOrPublishedApi", "", "isCalledFunPublicOrPublishedApi", "calledFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "(ZZLorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "getCalledFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "checkers"})
        private static final class AccessedDeclarationVisibilityData {
            private final boolean isInlineFunPublicOrPublishedApi;
            private final boolean isCalledFunPublicOrPublishedApi;
            @NotNull
            private final EffectiveVisibility calledFunEffectiveVisibility;

            public AccessedDeclarationVisibilityData(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter((Object)calledFunEffectiveVisibility, (String)"calledFunEffectiveVisibility");
                this.isInlineFunPublicOrPublishedApi = isInlineFunPublicOrPublishedApi;
                this.isCalledFunPublicOrPublishedApi = isCalledFunPublicOrPublishedApi;
                this.calledFunEffectiveVisibility = calledFunEffectiveVisibility;
            }

            public final boolean isInlineFunPublicOrPublishedApi() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean isCalledFunPublicOrPublishedApi() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility getCalledFunEffectiveVisibility() {
                return this.calledFunEffectiveVisibility;
            }

            public final boolean component1() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean component2() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility component3() {
                return this.calledFunEffectiveVisibility;
            }

            @NotNull
            public final AccessedDeclarationVisibilityData copy(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter((Object)calledFunEffectiveVisibility, (String)"calledFunEffectiveVisibility");
                return new AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi, isCalledFunPublicOrPublishedApi, calledFunEffectiveVisibility);
            }

            public static /* synthetic */ AccessedDeclarationVisibilityData copy$default(AccessedDeclarationVisibilityData accessedDeclarationVisibilityData, boolean bl, boolean bl2, EffectiveVisibility effectiveVisibility, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi;
                }
                if ((n & 2) != 0) {
                    bl2 = accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi;
                }
                if ((n & 4) != 0) {
                    effectiveVisibility = accessedDeclarationVisibilityData.calledFunEffectiveVisibility;
                }
                return accessedDeclarationVisibilityData.copy(bl, bl2, effectiveVisibility);
            }

            @NotNull
            public String toString() {
                return "AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi=" + this.isInlineFunPublicOrPublishedApi + ", isCalledFunPublicOrPublishedApi=" + this.isCalledFunPublicOrPublishedApi + ", calledFunEffectiveVisibility=" + this.calledFunEffectiveVisibility + ')';
            }

            public int hashCode() {
                int n;
                int result2;
                int n2 = this.isInlineFunPublicOrPublishedApi ? 1 : 0;
                if (n2 != 0) {
                    n2 = result2 = 1;
                }
                if ((n = this.isCalledFunPublicOrPublishedApi) != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                result2 = result2 * 31 + this.calledFunEffectiveVisibility.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AccessedDeclarationVisibilityData)) {
                    return false;
                }
                AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = (AccessedDeclarationVisibilityData)other;
                if (this.isInlineFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi) {
                    return false;
                }
                if (this.isCalledFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.calledFunEffectiveVisibility, (Object)accessedDeclarationVisibilityData.calledFunEffectiveVisibility);
            }
        }
    }
}

