/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualLinker;
import org.jetbrains.kotlin.backend.common.actualizer.FunctionDefaultParametersActualizer;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizationResult;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.MissingFakeOverridesAdder;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJF\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizer;", "", "()V", "actualize", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizationResult;", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "addMissingFakeOverrides", "", "expectActualMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "expectActualTypeAliasMap", "Lorg/jetbrains/kotlin/name/FqName;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;", "linkExpectToActual", "mergeIrFragments", "removeExpectDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldRemoveExpectDeclaration", "", "irDeclaration", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrActualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1#2:81\n1855#3,2:82\n1855#3,2:84\n1360#3:86\n1446#3,5:87\n*S KotlinDebug\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n*L\n70#1:82,2\n74#1:84,2\n78#1:86\n78#1:87,5\n*E\n"})
public final class IrActualizer {
    @NotNull
    public static final IrActualizer INSTANCE = new IrActualizer();

    private IrActualizer() {
    }

    @NotNull
    public final IrActualizationResult actualize(@NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments, @NotNull DiagnosticReporter diagnosticReporter, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)mainFragment, (String)"mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, (String)"dependentFragments");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        KtDiagnosticReporterWithImplicitIrBasedContext ktDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(diagnosticReporter, languageVersionSettings2);
        Pair<Map<IrSymbol, IrSymbol>, Map<FqName, FqName>> pair = new ExpectActualCollector(mainFragment, dependentFragments, ktDiagnosticReporter).collect();
        Map expectActualMap = (Map)pair.component1();
        Map expectActualTypeAliasMap = (Map)pair.component2();
        new FunctionDefaultParametersActualizer(expectActualMap).actualize();
        List<IrDeclaration> removedExpectDeclarationMetadata = this.removeExpectDeclarations(dependentFragments, expectActualMap);
        this.addMissingFakeOverrides(expectActualMap, dependentFragments, expectActualTypeAliasMap, ktDiagnosticReporter);
        this.linkExpectToActual(expectActualMap, dependentFragments);
        this.mergeIrFragments(mainFragment, dependentFragments);
        return new IrActualizationResult(removedExpectDeclarationMetadata);
    }

    private final List<IrDeclaration> removeExpectDeclarations(List<? extends IrModuleFragment> dependentFragments, Map<IrSymbol, ? extends IrSymbol> expectActualMap) {
        List removedDeclarationMetadata = new ArrayList();
        for (IrModuleFragment irModuleFragment : dependentFragments) {
            for (IrFile file2 : irModuleFragment.getFiles()) {
                file2.getDeclarations().removeIf(arg_0 -> IrActualizer.removeExpectDeclarations$lambda$0((Function1)new Function1<IrDeclaration, Boolean>(expectActualMap, (List<IrDeclaration>)removedDeclarationMetadata){
                    final /* synthetic */ Map<IrSymbol, IrSymbol> $expectActualMap;
                    final /* synthetic */ List<IrDeclaration> $removedDeclarationMetadata;
                    {
                        this.$expectActualMap = $expectActualMap;
                        this.$removedDeclarationMetadata = $removedDeclarationMetadata;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull IrDeclaration it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (IrActualizer.access$shouldRemoveExpectDeclaration(IrActualizer.INSTANCE, it, this.$expectActualMap)) {
                            this.$removedDeclarationMetadata.add(it);
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                }, arg_0));
            }
        }
        return removedDeclarationMetadata;
    }

    private final boolean shouldRemoveExpectDeclaration(IrDeclaration irDeclaration2, Map<IrSymbol, ? extends IrSymbol> expectActualMap) {
        IrDeclaration irDeclaration3 = irDeclaration2;
        return irDeclaration3 instanceof IrClass ? ((IrClass)irDeclaration2).isExpect() && (!IrActualizerUtilsKt.containsOptionalExpectation(irDeclaration2) || expectActualMap.containsKey(((IrClass)irDeclaration2).getSymbol())) : (irDeclaration3 instanceof IrProperty ? ((IrProperty)irDeclaration2).isExpect() : (irDeclaration3 instanceof IrFunction ? ((IrFunction)irDeclaration2).isExpect() : false));
    }

    private final void addMissingFakeOverrides(Map<IrSymbol, ? extends IrSymbol> expectActualMap, List<? extends IrModuleFragment> dependentFragments, Map<FqName, FqName> expectActualTypeAliasMap, KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter) {
        MissingFakeOverridesAdder missingFakeOverridesAdder;
        MissingFakeOverridesAdder $this$addMissingFakeOverrides_u24lambda_u242 = missingFakeOverridesAdder = new MissingFakeOverridesAdder(expectActualMap, expectActualTypeAliasMap, diagnosticsReporter);
        boolean bl = false;
        Iterable $this$forEach$iv = dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl2 = false;
            $this$addMissingFakeOverrides_u24lambda_u242.visitModuleFragment(it);
        }
    }

    private final void linkExpectToActual(Map<IrSymbol, ? extends IrSymbol> expectActualMap, List<? extends IrModuleFragment> dependentFragments) {
        ExpectActualLinker expectActualLinker2;
        ExpectActualLinker $this$linkExpectToActual_u24lambda_u244 = expectActualLinker2 = new ExpectActualLinker(expectActualMap);
        boolean bl = false;
        Iterable $this$forEach$iv = dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl2 = false;
            $this$linkExpectToActual_u24lambda_u244.actualize(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeIrFragments(IrModuleFragment mainFragment, List<? extends IrModuleFragment> dependentFragments) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = dependentFragments;
        int n = 0;
        List<IrFile> list2 = mainFragment.getFiles();
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        list2.addAll(n, list3);
    }

    private static final boolean removeExpectDeclarations$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$shouldRemoveExpectDeclaration(IrActualizer $this, IrDeclaration irDeclaration2, Map expectActualMap) {
        return $this.shouldRemoveExpectDeclaration(irDeclaration2, expectActualMap);
    }
}

