/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.expression.WhenTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.InOperationTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.CoercionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0094\u0001\u0010\u0016\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a0\u0018\u0012\u0004\u0012\u00020\u001b0\u0017\"\b\b\u0000\u0010\u001c*\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0018\u0010\u001f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0006\u0012\u0004\u0018\u0001H\u001c0 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\f0 2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u0002H\u001c\u0012\u0006\u0012\u0004\u0018\u00010\n0 H\u0002JN\u0010$\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a0\u0018\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010%\u001a\u00020\u000fH\u0002JT\u0010&\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a0\u0018\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0018\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u00020\n2\u0006\u0010.\u001a\u0002072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020:2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\n2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010=\u001a\u00020\n2\u0006\u0010.\u001a\u00020>2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010?\u001a\u00020\n2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010@\u001a\u0004\u0018\u00010A*\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/WhenTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "expressionToMatch", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "isExhaustive", "", "()Z", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "uniqueConstants", "", "", "uniqueEnumNames", "", "collectConstantEntries", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "Lorg/jetbrains/kotlin/js/translate/expression/EntryWithConstants;", "", "T", "fromIndex", "entries", "extractor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "filter", "wrapper", "collectEnumEntries", "expectedType", "collectPrimitiveConstantEntries", "expectedTypes", "", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "translateAsSwitch", "Lorg/jetbrains/kotlin/js/backend/ast/JsSwitch;", "translateCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "translateConditions", "entry", "translateEntryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateExpressionCondition", "Lorg/jetbrains/kotlin/psi/KtWhenConditionWithExpression;", "translateIsCondition", "conditionIsPattern", "Lorg/jetbrains/kotlin/psi/KtWhenConditionIsPattern;", "translateOrCondition", "leftExpression", "translateRangeCondition", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "translateWhenConditionToBooleanExpression", "getEnumClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Companion", "js.translator"})
@SourceDebugExtension(value={"SMAP\nWhenTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/WhenTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,369:1\n1446#2,2:370\n1549#2:372\n1620#2,3:373\n1448#2,3:377\n766#2:393\n857#2,2:394\n1603#2,9:396\n1855#2:405\n1856#2:407\n1612#2:408\n1#3:376\n1#3:390\n1#3:406\n11653#4,9:380\n13579#4:389\n13580#4:391\n11662#4:392\n1266#5,3:409\n*S KotlinDebug\n*F\n+ 1 WhenTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/WhenTranslator\n*L\n164#1:370,2\n165#1:372\n165#1:373,3\n164#1:377,3\n248#1:393\n248#1:394,2\n248#1:396,9\n248#1:405\n248#1:407\n248#1:408\n239#1:390\n248#1:406\n239#1:380,9\n239#1:389\n239#1:391\n239#1:392\n291#1:409,3\n*E\n"})
public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtWhenExpression whenExpression;
    @Nullable
    private final KotlinType subjectType;
    @Nullable
    private final JsExpression expressionToMatch;
    @Nullable
    private final KotlinType type;
    @NotNull
    private final Set<Object> uniqueConstants;
    @NotNull
    private final Set<String> uniqueEnumNames;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    private WhenTranslator(KtWhenExpression whenExpression, TranslationContext context) {
        super(context);
        this.whenExpression = whenExpression;
        this.uniqueConstants = new LinkedHashSet();
        this.uniqueEnumNames = new LinkedHashSet();
        LanguageVersionSettings languageVersionSettings2 = context.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings2, (String)"context.languageVersionSettings");
        this.dataFlowValueFactory = new DataFlowValueFactoryImpl(languageVersionSettings2);
        KtProperty subjectVariable = this.whenExpression.getSubjectVariable();
        KtExpression subjectExpression = this.whenExpression.getSubjectExpression();
        if (subjectVariable != null) {
            CallableDescriptor descriptor2;
            JsStatement jsStatement = Translation.translateAsStatement(subjectVariable, context);
            Intrinsics.checkNotNull((Object)jsStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsVars");
            JsVars variable2 = (JsVars)jsStatement;
            context.addStatementToCurrentBlock(variable2);
            DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(context.bindingContext(), subjectVariable);
            CallableDescriptor callableDescriptor = descriptor2 = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            this.subjectType = callableDescriptor != null ? callableDescriptor.getReturnType() : null;
            List<JsVars.JsVar> list2 = variable2.getVars();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"variable.vars");
            this.expressionToMatch = ((JsVars.JsVar)CollectionsKt.first(list2)).getName().makeRef();
        } else if (subjectExpression != null) {
            this.subjectType = this.bindingContext().getType(subjectExpression);
            this.expressionToMatch = context.defineTemporary(Translation.translateAsExpression(subjectExpression, context));
        } else {
            this.subjectType = null;
            this.expressionToMatch = null;
        }
        this.type = this.bindingContext().getType(this.whenExpression);
    }

    private final boolean isExhaustive() {
        KotlinType type2 = this.bindingContext().getType(this.whenExpression);
        boolean isStatement = type2 != null && KotlinBuiltIns.isUnit(type2) && !type2.isMarkedNullable();
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext()");
        return CodegenUtil.isExhaustive(bindingContext, this.whenExpression, isStatement);
    }

    private final JsNode translate() {
        JsNode jsNode;
        Ref.ObjectRef resultIf = new Ref.ObjectRef();
        Function1 setWhenStatement2 = (Function1)new Function1<JsStatement, Unit>((Ref.ObjectRef<JsNode>)resultIf){
            final /* synthetic */ Ref.ObjectRef<JsNode> $resultIf;
            {
                this.$resultIf = $resultIf;
                super(1);
            }

            public final void invoke(@NotNull JsStatement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$resultIf.element = it;
            }
        };
        int i = 0;
        boolean hasElse = false;
        while (i < this.whenExpression.getEntries().size()) {
            JsStatement statementToAdd;
            JsIf jsIf;
            Pair<JsSwitch, Integer> asSwitch = this.translateAsSwitch(i);
            if (asSwitch != null) {
                JsSwitch jsSwitch = (JsSwitch)asSwitch.component1();
                int next = ((Number)asSwitch.component2()).intValue();
                setWhenStatement2.invoke((Object)jsSwitch);
                setWhenStatement2 = (Function1)new Function1<JsStatement, Unit>(jsSwitch, this){
                    final /* synthetic */ JsSwitch $jsSwitch;
                    final /* synthetic */ WhenTranslator this$0;
                    {
                        this.$jsSwitch = $jsSwitch;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull JsStatement whenStatement) {
                        JsBreak jsBreak;
                        Intrinsics.checkNotNullParameter((Object)whenStatement, (String)"whenStatement");
                        List<JsSwitchMember> list2 = this.$jsSwitch.getCases();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"jsSwitch.cases");
                        Collection collection = list2;
                        JsDefault jsDefault = new JsDefault();
                        WhenTranslator whenTranslator = this.this$0;
                        JsDefault $this$invoke_u24lambda_u241 = jsDefault;
                        boolean bl = false;
                        List<JsStatement> list3 = $this$invoke_u24lambda_u241.getStatements();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"statements");
                        ((Collection)list3).add(whenStatement);
                        List<JsStatement> list4 = $this$invoke_u24lambda_u241.getStatements();
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"statements");
                        Collection collection2 = list4;
                        JsBreak $this$invoke_u24lambda_u241_u24lambda_u240 = jsBreak = new JsBreak();
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setSource(WhenTranslator.access$getWhenExpression$p(whenTranslator));
                        collection2.add(jsBreak);
                        collection.add(jsDefault);
                    }
                };
                i = next;
                continue;
            }
            KtWhenEntry entry = this.whenExpression.getEntries().get(i++);
            JsBlock statementBlock = new JsBlock();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            TranslationContext translationContext = this.context();
            Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context()");
            JsStatement statement2 = this.translateEntryExpression(entry, translationContext, statementBlock);
            if (resultIf.element == null && entry.isElse()) {
                this.context().addStatementsToCurrentBlockFrom(statementBlock);
                return statement2;
            }
            JsStatement jsStatement = JsAstUtils.mergeStatementInBlockIfNeeded(statement2, statementBlock);
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"mergeStatementInBlockIfN\u2026tatement, statementBlock)");
            statement2 = jsStatement;
            JsBlock conditionsBlock = new JsBlock();
            if (entry.isElse()) {
                hasElse = true;
                setWhenStatement2.invoke((Object)statement2);
                break;
            }
            TranslationContext translationContext2 = this.context().innerBlock(conditionsBlock);
            Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"context().innerBlock(conditionsBlock)");
            Intrinsics.checkNotNullExpressionValue((Object)JsAstUtils.newJsIf(this.translateConditions(entry, translationContext2), statement2), (String)"newJsIf(translateConditi\u2026itionsBlock)), statement)");
            jsIf.setSource(entry);
            Intrinsics.checkNotNullExpressionValue((Object)JsAstUtils.mergeStatementInBlockIfNeeded(jsIf, conditionsBlock), (String)"mergeStatementInBlockIfN\u2026ed(jsIf, conditionsBlock)");
            setWhenStatement2.invoke((Object)statementToAdd);
            setWhenStatement2 = (Function1)new Function1<JsStatement, Unit>(jsIf){
                final /* synthetic */ JsIf $jsIf;
                {
                    this.$jsIf = $jsIf;
                    super(1);
                }

                public final void invoke(@NotNull JsStatement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$jsIf.setElseStatement(it);
                }
            };
        }
        if (this.isExhaustive() && !hasElse) {
            JsInvocation noWhenMatchedInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn("noWhenBranchMatched", (JsExpression)Namer.kotlinObject()), new JsExpression[0]);
            JsStatement jsStatement = JsAstUtils.asSyntheticStatement(noWhenMatchedInvocation);
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"asSyntheticStatement(noWhenMatchedInvocation)");
            setWhenStatement2.invoke((Object)jsStatement);
        }
        if (resultIf.element != null) {
            Object object = resultIf.element;
            Intrinsics.checkNotNull((Object)object);
            jsNode = (JsNode)object;
        } else {
            jsNode = new JsNullLiteral();
        }
        return jsNode;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsSwitch, Integer> translateAsSwitch(int fromIndex) {
        Pair pair;
        Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> pair2;
        KotlinType kotlinType = this.subjectType;
        if (kotlinType == null) {
            return null;
        }
        KotlinType subjectType = kotlinType;
        KtExpression ktExpression = this.whenExpression.getSubjectExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression ktSubject = ktExpression;
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext()");
        DeclarationDescriptor declarationDescriptor = this.context().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            declarationDescriptor = this.context().getCurrentModule();
        }
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"context().declarationDes\u2026: context().currentModule");
        DataFlowValue dataFlow = this.dataFlowValueFactory.createDataFlowValue(ktSubject, subjectType, bindingContext, declarationDescriptor);
        CompilerConfiguration compilerConfiguration = this.context().getConfig().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"context().config.configuration");
        LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        BindingContext bindingContext2 = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"bindingContext()");
        Set expectedTypes = SetsKt.plus(BindingContextUtilsKt.getDataFlowInfoBefore(bindingContext2, (PsiElement)ktSubject).getStableTypes(dataFlow, languageVersionSettings2), (Iterable)SetsKt.setOf((Object)subjectType));
        JsExpression jsExpression = this.expressionToMatch;
        if (jsExpression == null) {
            return null;
        }
        JsExpression subject = jsExpression;
        Function0 subjectSupplier2 = (Function0)new Function0<JsExpression>(subject){
            final /* synthetic */ JsExpression $subject;
            {
                this.$subject = $subject;
                super(0);
            }

            @NotNull
            public final JsExpression invoke() {
                return this.$subject;
            }
        };
        ClassDescriptor enumClass2 = (ClassDescriptor)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)expectedTypes), (Function1)((Function1)new Function1<KotlinType, ClassDescriptor>(this){
            final /* synthetic */ WhenTranslator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassDescriptor invoke(@NotNull KotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return WhenTranslator.access$getEnumClass(this.this$0, it);
            }
        })));
        if (enumClass2 != null) {
            subjectSupplier2 = (Function0)new Function0<JsNameRef>(enumClass2, this, subject){
                final /* synthetic */ ClassDescriptor $enumClass;
                final /* synthetic */ WhenTranslator this$0;
                final /* synthetic */ JsExpression $subject;
                {
                    this.$enumClass = $enumClass;
                    this.this$0 = $receiver;
                    this.$subject = $subject;
                    super(0);
                }

                @NotNull
                public final JsNameRef invoke() {
                    ClassDescriptor enumBaseClass = DescriptorUtilsKt.getSuperClassOrAny(this.$enumClass);
                    PropertyDescriptor propertyDescriptor = DescriptorUtils.getPropertyByName(enumBaseClass.getUnsubstitutedMemberScope(), Name.identifier("name"));
                    Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getPropertyByName(enumBa\u2026 Name.identifier(\"name\"))");
                    PropertyDescriptor nameProperty = propertyDescriptor;
                    return new JsNameRef(WhenTranslator.access$context(this.this$0).getNameForDescriptor(nameProperty), this.$subject);
                }
            };
            List<KtWhenEntry> list2 = this.whenExpression.getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"whenExpression.entries");
            SimpleType simpleType2 = enumClass2.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"enumClass.defaultType");
            pair2 = this.collectEnumEntries(fromIndex, list2, simpleType2);
        } else {
            List<KtWhenEntry> list3 = this.whenExpression.getEntries();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"whenExpression.entries");
            pair2 = this.collectPrimitiveConstantEntries(fromIndex, list3, expectedTypes);
        }
        Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> pair3 = pair2;
        List entriesForSwitch = (List)pair3.component1();
        int nextIndex = ((Number)pair3.component2()).intValue();
        if (SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)entriesForSwitch), (Function1)translateAsSwitch.2.INSTANCE)) > 1) {
            JsSwitch jsSwitch;
            List switchEntries = new ArrayList();
            Iterable $this$flatMapTo$iv = entriesForSwitch;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                JsBreak jsBreak;
                void $this$mapTo$iv$iv;
                Pair pair4 = (Pair)element$iv;
                boolean bl = false;
                List conditions2 = (List)pair4.component1();
                KtWhenEntry entry = (KtWhenEntry)pair4.component2();
                Iterable $this$map$iv = conditions2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsCase jsCase;
                    JsExpression jsExpression2 = (JsExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    JsCase $this$translateAsSwitch_u24lambda_u243_u24lambda_u241_u24lambda_u240 = jsCase = new JsCase();
                    boolean bl3 = false;
                    $this$translateAsSwitch_u24lambda_u243_u24lambda_u241_u24lambda_u240.setCaseExpression(it.source(entry));
                    collection.add(jsCase);
                }
                List members2 = (List)destination$iv$iv;
                JsBlock block = new JsBlock();
                TranslationContext translationContext = this.context();
                Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context()");
                JsStatement statement2 = this.translateEntryExpression(entry, translationContext, block);
                JsCase lastEntry = (JsCase)CollectionsKt.last((List)members2);
                List<JsStatement> list4 = lastEntry.getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"lastEntry.statements");
                Collection collection = list4;
                List<JsStatement> list5 = block.getStatements();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"block.statements");
                CollectionsKt.addAll((Collection)collection, (Iterable)list5);
                List<JsStatement> list6 = lastEntry.getStatements();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"lastEntry.statements");
                ((Collection)list6).add(statement2);
                List<JsStatement> list7 = lastEntry.getStatements();
                Intrinsics.checkNotNullExpressionValue(list7, (String)"lastEntry.statements");
                collection = list7;
                JsBreak $this$translateAsSwitch_u24lambda_u243_u24lambda_u242 = jsBreak = new JsBreak();
                boolean bl4 = false;
                $this$translateAsSwitch_u24lambda_u243_u24lambda_u242.setSource(entry);
                collection.add(jsBreak);
                Iterable list$iv = members2;
                CollectionsKt.addAll((Collection)switchEntries, (Iterable)list$iv);
            }
            JsSwitch $this$translateAsSwitch_u24lambda_u244 = jsSwitch = new JsSwitch((JsExpression)subjectSupplier2.invoke(), switchEntries);
            boolean bl = false;
            $this$translateAsSwitch_u24lambda_u244.setSource(this.whenExpression);
            Integer n = nextIndex;
            JsSwitch jsSwitch2 = jsSwitch;
            pair = new Pair((Object)jsSwitch2, (Object)n);
        } else {
            pair = null;
        }
        return pair;
    }

    private final Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> collectPrimitiveConstantEntries(int fromIndex, List<? extends KtWhenEntry> entries, Set<? extends KotlinType> expectedTypes) {
        return this.collectConstantEntries(fromIndex, entries, (Function1)new Function1<CompileTimeConstant<?>, Object>(expectedTypes){
            final /* synthetic */ Set<KotlinType> $expectedTypes;
            {
                this.$expectedTypes = $expectedTypes;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull CompileTimeConstant<?> constant) {
                Intrinsics.checkNotNullParameter(constant, (String)"constant");
                return SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.$expectedTypes), (Function1)((Function1)new Function1<KotlinType, Object>(constant){
                    final /* synthetic */ CompileTimeConstant<?> $constant;
                    {
                        this.$constant = $constant;
                        super(1);
                    }

                    @Nullable
                    public final Object invoke(@NotNull KotlinType it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$constant.getValue(it);
                    }
                })));
            }
        }, (Function1)new Function1<Object, Boolean>(this){
            final /* synthetic */ WhenTranslator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return WhenTranslator.access$getUniqueConstants$p(this.this$0).add(it);
            }
        }, collectPrimitiveConstantEntries.3.INSTANCE);
    }

    private final Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> collectEnumEntries(int fromIndex, List<? extends KtWhenEntry> entries, KotlinType expectedType) {
        ClassId classId = WhenChecker.getClassIdForTypeIfEnum(expectedType);
        return this.collectConstantEntries(fromIndex, entries, (Function1)new Function1<CompileTimeConstant<?>, String>(expectedType, classId){
            final /* synthetic */ KotlinType $expectedType;
            final /* synthetic */ ClassId $classId;
            {
                this.$expectedType = $expectedType;
                this.$classId = $classId;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final String invoke(@NotNull CompileTimeConstant<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                EnumValue enumValue = it.toConstantValue(this.$expectedType);
                if (!(enumValue instanceof EnumValue)) return null;
                EnumValue enumValue2 = enumValue;
                EnumValue enumValue3 = enumValue2;
                if (enumValue3 == null) return null;
                Object object = enumValue3;
                ClassId classId = this.$classId;
                EnumValue enumEntry = object;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)enumEntry.getEnumClassId(), (Object)classId)) return null;
                EnumValue enumValue4 = object;
                enumValue = enumValue4;
                if (enumValue == null) return null;
                object = enumValue.getEnumEntryName();
                if (object == null) return null;
                String string2 = ((Name)object).getIdentifier();
                return string2;
            }
        }, (Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ WhenTranslator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return WhenTranslator.access$getUniqueEnumNames$p(this.this$0).add(it);
            }
        }, collectEnumEntries.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> collectConstantEntries(int fromIndex, List<? extends KtWhenEntry> entries, Function1<? super CompileTimeConstant<?>, ? extends T> extractor2, Function1<? super T, Boolean> filter2, Function1<? super T, ? extends JsExpression> wrapper) {
        KtWhenEntry entry;
        int i;
        List entriesForSwitch = new ArrayList();
        for (i = fromIndex; i < entries.size() && !(entry = entries.get(i)).isElse(); ++i) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            boolean hasImproperConstants = false;
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"entry.conditions");
            Object[] $this$mapNotNull$iv2 = ktWhenConditionArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv2;
            Iterable<KtExpression> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                Object object;
                block9: {
                    block8: {
                        element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                        boolean bl = false;
                        KtWhenCondition condition = (KtWhenCondition)element$iv$iv;
                        boolean bl2 = false;
                        KtWhenConditionWithExpression ktWhenConditionWithExpression = condition instanceof KtWhenConditionWithExpression ? (KtWhenConditionWithExpression)condition : null;
                        KtExpression expression2 = ktWhenConditionWithExpression != null ? ktWhenConditionWithExpression.getExpression() : null;
                        object = expression2;
                        if (object == null) break block8;
                        KtExpression it = object;
                        boolean bl3 = false;
                        BindingContext bindingContext = this.bindingContext();
                        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext()");
                        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(it, bindingContext);
                        object = compileTimeConstant;
                        if (compileTimeConstant != null && (object = extractor2.invoke(object)) != null) break block9;
                    }
                    WhenTranslator $this$collectConstantEntries_u24lambda_u247_u24lambda_u246 = this;
                    boolean bl = false;
                    hasImproperConstants = true;
                    object = null;
                }
                if (object == null) continue;
                KtExpression it$iv$iv = object;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List constantValues = (List)destination$iv$iv;
            if (hasImproperConstants) break;
            Iterable $this$filter$iv = constantValues;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                if (!((Boolean)filter2.invoke(element$iv$iv2)).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull2 = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl4 = false;
                JsExpression jsExpression = (JsExpression)wrapper.invoke(it);
                if (jsExpression == null) {
                    WhenTranslator $this$collectConstantEntries_u24lambda_u249_u24lambda_u248 = this;
                    boolean bl5 = false;
                    hasImproperConstants = true;
                    jsExpression = null;
                }
                if (jsExpression == null) continue;
                JsExpression it$iv$iv = jsExpression;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List constants = (List)destination$iv$iv2;
            if (hasImproperConstants) break;
            if (!(!((Collection)constants).isEmpty())) continue;
            ((Collection)entriesForSwitch).add(new Pair((Object)constants, (Object)entry));
        }
        return new Pair((Object)entriesForSwitch, (Object)i);
    }

    private final ClassDescriptor getEnumClass(KotlinType $this$getEnumClass) {
        ClassDescriptor classDescriptor2;
        if ($this$getEnumClass.isMarkedNullable()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = $this$getEnumClass.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor3 = classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        return (classDescriptor3 != null ? classDescriptor3.getKind() : null) == ClassKind.ENUM_CLASS && !classDescriptor2.isExternal() ? classDescriptor2 : null;
    }

    private final JsStatement translateEntryExpression(KtWhenEntry entry, TranslationContext context, JsBlock block) {
        JsStatement jsStatement;
        KtExpression ktExpression = entry.getExpression();
        if (ktExpression == null) {
            throw new IllegalStateException("WhenEntry should have whenExpression to execute.".toString());
        }
        KtExpression expressionToExecute = ktExpression;
        JsStatement jsStatement2 = Translation.translateAsStatement(expressionToExecute, context, block);
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"translateAsStatement(exp\u2026oExecute, context, block)");
        JsStatement result2 = jsStatement2;
        if (this.type != null) {
            JsStatement jsStatement3 = LastExpressionMutator.mutateLastExpression(result2, new CoercionMutator(this.type, context));
            jsStatement = jsStatement3;
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"{\n            LastExpres\u2026type, context))\n        }");
        } else {
            jsStatement = result2;
        }
        return jsStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateConditions(KtWhenEntry entry, TranslationContext context) {
        boolean bl;
        Object[] objectArray = entry.getConditions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"entry.conditions");
        Object[] conditions2 = objectArray;
        boolean bl2 = bl = !(conditions2.length == 0);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WhenTranslator$translateConditions$22 = false;
            String $i$a$-assert-WhenTranslator$translateConditions$22 = "When entry (not else) should have at least one condition";
            throw new AssertionError((Object)$i$a$-assert-WhenTranslator$translateConditions$22);
        }
        KtWhenCondition ktWhenCondition = conditions2[0];
        Intrinsics.checkNotNullExpressionValue((Object)ktWhenCondition, (String)"conditions[0]");
        JsExpression first = this.translateCondition(ktWhenCondition, context);
        Sequence $this$fold$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])conditions2), (int)1);
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = first;
        for (Object element$iv : $this$fold$iv) {
            void condition;
            KtWhenCondition ktWhenCondition2 = (KtWhenCondition)element$iv;
            JsExpression acc = accumulator$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"condition");
            accumulator$iv = this.translateOrCondition(acc, (KtWhenCondition)condition, context);
        }
        return accumulator$iv;
    }

    private final JsExpression translateOrCondition(JsExpression leftExpression, KtWhenCondition condition, TranslationContext context) {
        JsExpression jsExpression;
        TranslationContext translationContext = context.innerBlock();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.innerBlock()");
        TranslationContext rightContext = translationContext;
        JsExpression rightExpression = this.translateCondition(condition, rightContext);
        context.moveVarsFrom(rightContext);
        if (rightContext.currentBlockIsEmpty()) {
            jsExpression = new JsBinaryOperation(JsBinaryOperator.OR, leftExpression, rightExpression);
        } else {
            boolean bl = rightExpression instanceof JsNameRef;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-WhenTranslator$translateOrCondition$22 = false;
                String $i$a$-assert-WhenTranslator$translateOrCondition$22 = "expected JsNameRef, but: " + rightExpression;
                throw new AssertionError((Object)$i$a$-assert-WhenTranslator$translateOrCondition$22);
            }
            Intrinsics.checkNotNull((Object)rightExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            JsNameRef result2 = (JsNameRef)rightExpression;
            JsIf jsIf = JsAstUtils.newJsIf(leftExpression, JsAstUtils.assignment(result2, new JsBooleanLiteral(true)).makeStmt(), rightContext.getCurrentBlock());
            Intrinsics.checkNotNullExpressionValue((Object)jsIf, (String)"newJsIf(leftExpression, \u2026ightContext.currentBlock)");
            JsIf ifStatement = jsIf;
            ifStatement.setSource(condition);
            context.addStatementToCurrentBlock(ifStatement);
            jsExpression = result2;
        }
        return jsExpression;
    }

    private final JsExpression translateCondition(KtWhenCondition condition, TranslationContext context) {
        JsExpression jsExpression;
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition, context);
        if (WhenTranslator.Companion.isNegated(condition)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(patternMatchExpression);
            Intrinsics.checkNotNullExpressionValue((Object)jsPrefixOperation, (String)"not(patternMatchExpression)");
            jsExpression = jsPrefixOperation;
        } else {
            jsExpression = patternMatchExpression;
        }
        return jsExpression;
    }

    private final JsExpression translateWhenConditionToBooleanExpression(KtWhenCondition condition, TranslationContext context) {
        JsExpression jsExpression;
        KtWhenCondition ktWhenCondition = condition;
        if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            jsExpression = this.translateIsCondition((KtWhenConditionIsPattern)condition, context);
        } else if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            jsExpression = this.translateExpressionCondition((KtWhenConditionWithExpression)condition, context);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            jsExpression = this.translateRangeCondition((KtWhenConditionInRange)condition, context);
        } else {
            throw new IllegalStateException(("Unsupported when condition " + condition.getClass()).toString());
        }
        return jsExpression;
    }

    private final JsExpression translateIsCondition(KtWhenConditionIsPattern conditionIsPattern, TranslationContext context) {
        JsExpression jsExpression = this.expressionToMatch;
        if (jsExpression == null) {
            throw new IllegalStateException("An is-check is not allowed in when() without subject.".toString());
        }
        JsExpression expressionToMatch = jsExpression;
        KtTypeReference ktTypeReference = conditionIsPattern.getTypeReference();
        if (ktTypeReference == null) {
            throw new IllegalStateException("An is-check must have a type reference.".toString());
        }
        KtTypeReference typeReference = ktTypeReference;
        JsExpression result2 = Translation.patternTranslator(context).translateIsCheck(expressionToMatch, typeReference);
        JsExpression jsExpression2 = result2;
        if (jsExpression2 == null) {
            jsExpression2 = new JsBooleanLiteral(true);
        }
        JsExpression jsExpression3 = jsExpression2.source(conditionIsPattern);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"result ?: JsBooleanLiter\u2026ource(conditionIsPattern)");
        return jsExpression3;
    }

    private final JsExpression translateExpressionCondition(KtWhenConditionWithExpression condition, TranslationContext context) {
        JsExpression jsExpression;
        KtExpression ktExpression = condition.getExpression();
        if (ktExpression == null) {
            throw new IllegalStateException("Expression pattern should have an expression.".toString());
        }
        KtExpression patternExpression = ktExpression;
        PatternTranslator patternTranslator = Translation.patternTranslator(context);
        Intrinsics.checkNotNullExpressionValue((Object)patternTranslator, (String)"patternTranslator(context)");
        PatternTranslator patternTranslator2 = patternTranslator;
        if (this.expressionToMatch == null) {
            JsExpression jsExpression2 = patternTranslator2.translateExpressionForExpressionPattern(patternExpression);
            jsExpression = jsExpression2;
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"{\n            patternTra\u2026ternExpression)\n        }");
        } else {
            KotlinType kotlinType = this.subjectType;
            Intrinsics.checkNotNull((Object)kotlinType);
            JsExpression jsExpression3 = patternTranslator2.translateExpressionPattern(kotlinType, this.expressionToMatch, patternExpression);
            jsExpression = jsExpression3;
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"{\n            patternTra\u2026ternExpression)\n        }");
        }
        return jsExpression;
    }

    private final JsExpression translateRangeCondition(KtWhenConditionInRange condition, TranslationContext context) {
        JsExpression jsExpression = this.expressionToMatch;
        if (jsExpression == null) {
            throw new IllegalStateException(("Range pattern is only available for 'when (C) { in ... }'  expressions: " + PsiUtilsKt.getTextWithLocation((PsiElement)condition)).toString());
        }
        JsExpression expressionToMatch = jsExpression;
        HashMap subjectAliases = new HashMap();
        Map map = subjectAliases;
        KtExpression ktExpression = this.whenExpression.getSubjectExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        map.put(ktExpression, expressionToMatch);
        TranslationContext translationContext = context.innerContextWithAliasesForExpressions(subjectAliases);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.innerContextWith\u2026pressions(subjectAliases)");
        TranslationContext callContext = translationContext;
        boolean negated = condition.getOperationReference().getReferencedNameElementType() == KtTokens.NOT_IN;
        KtExpression ktExpression2 = condition.getRangeExpression();
        Intrinsics.checkNotNull((Object)ktExpression2);
        JsExpression jsExpression2 = new InOperationTranslator(callContext, expressionToMatch, ktExpression2, condition.getOperationReference(), negated).translate().source(condition);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"InOperationTranslator(ca\u2026slate().source(condition)");
        return jsExpression2;
    }

    @JvmStatic
    @NotNull
    public static final JsNode translate(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
        return Companion.translate(expression2, context);
    }

    public static final /* synthetic */ KtWhenExpression access$getWhenExpression$p(WhenTranslator $this) {
        return $this.whenExpression;
    }

    public static final /* synthetic */ ClassDescriptor access$getEnumClass(WhenTranslator $this, KotlinType $receiver) {
        return $this.getEnumClass($receiver);
    }

    public static final /* synthetic */ TranslationContext access$context(WhenTranslator $this) {
        return $this.context();
    }

    public static final /* synthetic */ Set access$getUniqueConstants$p(WhenTranslator $this) {
        return $this.uniqueConstants;
    }

    public static final /* synthetic */ Set access$getUniqueEnumNames$p(WhenTranslator $this) {
        return $this.uniqueEnumNames;
    }

    public /* synthetic */ WhenTranslator(KtWhenExpression whenExpression, TranslationContext context, DefaultConstructorMarker $constructor_marker) {
        this(whenExpression, context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/WhenTranslator$Companion;", "", "()V", "isNegated", "", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsNode translate(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new WhenTranslator(expression2, context, null).translate();
        }

        private final boolean isNegated(KtWhenCondition condition) {
            KtWhenConditionIsPattern ktWhenConditionIsPattern = condition instanceof KtWhenConditionIsPattern ? (KtWhenConditionIsPattern)condition : null;
            return ktWhenConditionIsPattern != null ? ktWhenConditionIsPattern.isNegated() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

