/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationArgumentMappingBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.AnnotationValue;
import org.jetbrains.kotlin.fir.serialization.constant.ArrayValue;
import org.jetbrains.kotlin.fir.serialization.constant.BooleanValue;
import org.jetbrains.kotlin.fir.serialization.constant.ByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.CharValue;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValue;
import org.jetbrains.kotlin.fir.serialization.constant.DoubleValue;
import org.jetbrains.kotlin.fir.serialization.constant.EnumValue;
import org.jetbrains.kotlin.fir.serialization.constant.FloatValue;
import org.jetbrains.kotlin.fir.serialization.constant.IntValue;
import org.jetbrains.kotlin.fir.serialization.constant.KClassValue;
import org.jetbrains.kotlin.fir.serialization.constant.LongValue;
import org.jetbrains.kotlin.fir.serialization.constant.NullValue;
import org.jetbrains.kotlin.fir.serialization.constant.ShortValue;
import org.jetbrains.kotlin.fir.serialization.constant.StringValue;
import org.jetbrains.kotlin.fir.serialization.constant.UByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.UIntValue;
import org.jetbrains.kotlin.fir.serialization.constant.ULongValue;
import org.jetbrains.kotlin.fir.serialization.constant.UShortValue;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0003H\u0016J*\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001c\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*\u00b2\u0006\u0010\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstantValue;", "Lorg/jetbrains/kotlin/fir/FirSession;", "failOnNonConst", "", "(Z)V", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitArrayOfCall", "arrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "fir-serialization", "dispatchReceiverValue"})
@SourceDebugExtension(value={"SMAP\nFirToConstantValueTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 5 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 6 FirAnnotationArgumentMappingBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationArgumentMappingBuilderKt\n+ 7 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 9 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n*L\n1#1,179:1\n1603#2,9:180\n1855#2:189\n1856#2:191\n1612#2:192\n1603#2,9:216\n1855#2:225\n1856#2:227\n1612#2:228\n1#3:190\n1#3:226\n20#4:193\n24#4,4:194\n75#5,4:198\n34#6,4:202\n61#7,4:206\n215#8,2:210\n41#9,4:212\n*S KotlinDebug\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n*L\n75#1:180,9\n75#1:189\n75#1:191\n75#1:192\n172#1:216,9\n172#1:225\n172#1:227\n172#1:228\n75#1:190\n172#1:226\n93#1:193\n104#1:194,4\n114#1:198,4\n115#1:202,4\n116#1:206,4\n116#1:210,2\n121#1:212,4\n*E\n"})
abstract class FirToConstantValueTransformer
extends FirDefaultVisitor<ConstantValue<?>, FirSession> {
    private final boolean failOnNonConst;

    public FirToConstantValueTransformer(boolean failOnNonConst) {
        this.failOnNonConst = failOnNonConst;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitElement(@NotNull FirElement element, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (this.failOnNonConst) {
            throw new IllegalStateException(("Illegal element as annotation argument: " + Reflection.getOrCreateKotlinClass(element.getClass()).getQualifiedName() + " -> " + UtilsKt.render(element)).toString());
        }
        return null;
    }

    @Override
    @Nullable
    public <T> ConstantValue<?> visitConstExpression(@NotNull FirConstExpression<T> constExpression, @NotNull FirSession data2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(constExpression, (String)"constExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        T value2 = constExpression.getValue();
        ConstantValueKind<T> constantValueKind = constExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            constantValue = new BooleanValue((Boolean)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Char");
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new IntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UIntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new LongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ULongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.String");
            constantValue = new StringValue((String)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new FloatValue(((Number)value2).floatValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new DoubleValue(((Number)value2).doubleValue());
        } else {
            constantValue = Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE) ? (ConstantValue)NullValue.INSTANCE : null;
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitArrayOfCall(@NotNull FirArrayOfCall arrayOfCall, @NotNull FirSession data2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arrayOfCall, (String)"arrayOfCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$mapNotNull$iv = arrayOfCall.getArgumentList().getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if ((ConstantValue)it.accept(this, data2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return new AnnotationValue(annotation2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitAnnotation((FirAnnotation)annotationCall, data2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirTypeRef $this$coneTypeUnsafe$iv = getClassCall.getArgument().getTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        return KClassValue.Companion.create(coneKotlinType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ConstantValue<?> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirSession data2) {
        ConstantValue constantValue;
        block39: {
            block40: {
                FirCallableSymbol<?> symbol2;
                block38: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
                    if (firCallableSymbol == null) {
                        return null;
                    }
                    symbol2 = firCallableSymbol;
                    if (!(symbol2.getFir() instanceof FirEnumEntry)) break block38;
                    FirTypeRef $this$coneTypeSafe$iv = ((FirCallableDeclaration)symbol2.getFir()).getReturnTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ConeTypeUtilsKt.getClassId((ConeKotlinType)object)) == null) {
                        return null;
                    }
                    Object classId = object;
                    Object e = symbol2.getFir();
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
                    constantValue = new EnumValue((ClassId)classId, ((FirEnumEntry)e).getName());
                    break block39;
                }
                if (symbol2 instanceof FirConstructorSymbol) {
                    void $this$visitQualifiedAccessExpression_u24lambda_u244_u24lambda_u243;
                    Object $this$visitQualifiedAccessExpression_u24lambda_u244_u24lambda_u242;
                    FirAnnotationCallBuilder $i$f$coneTypeSafe;
                    FirFunctionCall constructorCall = (FirFunctionCall)qualifiedAccessExpression;
                    Object object = ClassMembersKt.containingClassLookupTag(symbol2);
                    if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data2)) == null) {
                        return null;
                    }
                    Object constructedClassSymbol = object;
                    if (((FirClassSymbol)constructedClassSymbol).getClassKind() != ClassKind.ANNOTATION_CLASS) {
                        return null;
                    }
                    boolean $i$f$buildAnnotationCall = false;
                    FirAnnotationCallBuilder $this$visitQualifiedAccessExpression_u24lambda_u244 = $i$f$coneTypeSafe = new FirAnnotationCallBuilder();
                    boolean bl = false;
                    boolean $i$f$buildAnnotationArgumentMapping = false;
                    Object object2 = new FirAnnotationArgumentMappingBuilder();
                    FirAnnotationArgumentMappingBuilder firAnnotationArgumentMappingBuilder = object2;
                    FirAnnotationCallBuilder firAnnotationCallBuilder = $this$visitQualifiedAccessExpression_u24lambda_u244;
                    boolean bl2 = false;
                    FirCall $this$resolvedArgumentMapping$iv = constructorCall;
                    boolean $i$f$getResolvedArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                    LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    if (linkedHashMap != null) {
                        Map $this$forEach$iv = linkedHashMap;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry entry = element$iv = iterator2.next();
                            boolean bl3 = false;
                            FirExpression firExpression2 = (FirExpression)entry.getKey();
                            FirValueParameter firValueParameter = (FirValueParameter)entry.getValue();
                            ((FirAnnotationArgumentMappingBuilder)$this$visitQualifiedAccessExpression_u24lambda_u244_u24lambda_u242).getMapping().put(firValueParameter.getName(), firExpression2);
                        }
                    }
                    firAnnotationCallBuilder.setArgumentMapping(((FirAnnotationArgumentMappingBuilder)object2).build());
                    $this$visitQualifiedAccessExpression_u24lambda_u244.setAnnotationTypeRef(qualifiedAccessExpression.getTypeRef());
                    boolean $i$f$buildSimpleNamedReference = false;
                    $this$visitQualifiedAccessExpression_u24lambda_u244_u24lambda_u242 = object2 = new FirSimpleNamedReferenceBuilder();
                    firAnnotationCallBuilder = $this$visitQualifiedAccessExpression_u24lambda_u244;
                    boolean bl4 = false;
                    $this$visitQualifiedAccessExpression_u24lambda_u244_u24lambda_u243.setSource(qualifiedAccessExpression.getSource());
                    $this$visitQualifiedAccessExpression_u24lambda_u244_u24lambda_u243.setName(((FirFunctionCall)qualifiedAccessExpression).getCalleeReference().getName());
                    firAnnotationCallBuilder.setCalleeReference(((FirSimpleNamedReferenceBuilder)object2).build());
                    FirAnnotation firAnnotation = $i$f$coneTypeSafe.build();
                    return new AnnotationValue(firAnnotation);
                }
                if (!Intrinsics.areEqual((Object)symbol2.getCallableId().getPackageName().asString(), (Object)"kotlin")) break block40;
                FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
                Lazy dispatchReceiverValue$delegate = LazyKt.lazy((Function0)new Function0<ConstantValue<?>>(dispatchReceiver, this, data2){
                    final /* synthetic */ FirExpression $dispatchReceiver;
                    final /* synthetic */ FirToConstantValueTransformer this$0;
                    final /* synthetic */ FirSession $data;
                    {
                        this.$dispatchReceiver = $dispatchReceiver;
                        this.this$0 = $receiver;
                        this.$data = $data;
                        super(0);
                    }

                    @Nullable
                    public final ConstantValue<?> invoke() {
                        return (ConstantValue)this.$dispatchReceiver.accept(this.this$0, this.$data);
                    }
                });
                switch (symbol2.getCallableId().getCallableName().asString()) {
                    case "toByte": {
                        ConstantValue<?> constantValue2 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue2);
                        Object obj = constantValue2.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ByteValue(((Number)obj).byteValue());
                        break;
                    }
                    case "toLong": {
                        ConstantValue<?> constantValue3 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue3);
                        Object obj = constantValue3.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new LongValue(((Number)obj).longValue());
                        break;
                    }
                    case "toShort": {
                        ConstantValue<?> constantValue4 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue4);
                        Object obj = constantValue4.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ShortValue(((Number)obj).shortValue());
                        break;
                    }
                    case "toFloat": {
                        ConstantValue<?> constantValue5 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue5);
                        Object obj = constantValue5.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new FloatValue(((Number)obj).floatValue());
                        break;
                    }
                    case "toDouble": {
                        ConstantValue<?> constantValue6 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue6);
                        Object obj = constantValue6.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new DoubleValue(((Number)obj).doubleValue());
                        break;
                    }
                    case "toChar": {
                        ConstantValue<?> constantValue7 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue7);
                        Object obj = constantValue7.getValue();
                        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
                        constantValue = new CharValue((char)((Number)obj).intValue());
                        break;
                    }
                    case "unaryMinus": {
                        ConstantValue<?> receiverValue = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda$5(dispatchReceiverValue$delegate);
                        if (receiverValue instanceof ByteValue) {
                            constantValue = new ByteValue(-((Number)((ByteValue)receiverValue).getValue()).byteValue());
                            break;
                        }
                        if (receiverValue instanceof LongValue) {
                            constantValue = new LongValue(-((Number)((LongValue)receiverValue).getValue()).longValue());
                            break;
                        }
                        if (receiverValue instanceof ShortValue) {
                            constantValue = new ShortValue(-((Number)((ShortValue)receiverValue).getValue()).shortValue());
                            break;
                        }
                        if (receiverValue instanceof FloatValue) {
                            constantValue = new FloatValue(-((Number)((FloatValue)receiverValue).getValue()).floatValue());
                            break;
                        }
                        if (receiverValue instanceof DoubleValue) {
                            constantValue = new DoubleValue(-((Number)((DoubleValue)receiverValue).getValue()).doubleValue());
                            break;
                        }
                        constantValue = null;
                        break;
                    }
                    default: {
                        constantValue = null;
                        break;
                    }
                }
                break block39;
            }
            constantValue = null;
        }
        return constantValue;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirSession data2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$mapNotNull$iv = varargArgumentsExpression.getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if ((ConstantValue)it.accept(this, data2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (ConstantValue)namedArgumentExpression.getExpression().accept(this, data2);
    }

    private static final ConstantValue<?> visitQualifiedAccessExpression$lambda$5(Lazy<? extends ConstantValue<?>> $dispatchReceiverValue$delegate) {
        Lazy<? extends ConstantValue<?>> lazy = $dispatchReceiverValue$delegate;
        return (ConstantValue)lazy.getValue();
    }
}

