/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000fH\u0002J \u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u0011\u0018\u00010\n\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/backend/ConstValueProviderImpl;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getConstantValueForProperty", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "firProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getConstantKind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "toFirConst", "T", "fir2ir"})
public final class ConstValueProviderImpl
extends ConstValueProvider {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final FirSession session;

    public ConstValueProviderImpl(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
        this.session = this.components.getSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public FirConstExpression<?> getConstantValueForProperty(@NotNull FirProperty firProperty) {
        Intrinsics.checkNotNullParameter((Object)firProperty, (String)"firProperty");
        IrProperty irProperty2 = this.components.getDeclarationStorage().getCachedIrProperty(firProperty);
        if (irProperty2 == null) {
            return null;
        }
        IrProperty irProperty3 = irProperty2;
        if (!irProperty3.isConst()) {
            return null;
        }
        IrElementBase irElementBase = irProperty3.getBackingField();
        IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
        IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (irConst == null) {
            return null;
        }
        IrConst irConst2 = irConst;
        return this.toFirConst(irConst2);
    }

    private final ConstantValueKind<?> getConstantKind(IrConst<?> $this$getConstantKind) {
        ConstantValueKind constantValueKind;
        if (Intrinsics.areEqual($this$getConstantKind.getKind(), (Object)IrConstKind.Null.INSTANCE)) {
            return ConstantValueKind.Null.INSTANCE;
        }
        IrType constType = IrTypesKt.removeAnnotations(IrTypesKt.makeNotNull($this$getConstantKind.getType()));
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType($this$getConstantKind.getType());
        block0 : switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[primitiveType.ordinal()]) {
            case 1: {
                constantValueKind = ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            case 2: {
                constantValueKind = ConstantValueKind.Char.INSTANCE;
                break;
            }
            case 3: {
                constantValueKind = ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case 4: {
                constantValueKind = ConstantValueKind.Short.INSTANCE;
                break;
            }
            case 5: {
                constantValueKind = ConstantValueKind.Int.INSTANCE;
                break;
            }
            case 6: {
                constantValueKind = ConstantValueKind.Long.INSTANCE;
                break;
            }
            case 7: {
                constantValueKind = ConstantValueKind.Float.INSTANCE;
                break;
            }
            case 8: {
                constantValueKind = ConstantValueKind.Double.INSTANCE;
                break;
            }
            case -1: {
                UnsignedType unsignedType = IrTypePredicatesKt.getUnsignedType(constType);
                switch (unsignedType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType.ordinal()]) {
                    case 1: {
                        constantValueKind = ConstantValueKind.UnsignedByte.INSTANCE;
                        break block0;
                    }
                    case 2: {
                        constantValueKind = ConstantValueKind.UnsignedShort.INSTANCE;
                        break block0;
                    }
                    case 3: {
                        constantValueKind = ConstantValueKind.UnsignedInt.INSTANCE;
                        break block0;
                    }
                    case 4: {
                        constantValueKind = ConstantValueKind.UnsignedLong.INSTANCE;
                        break block0;
                    }
                    case -1: {
                        constantValueKind = IrTypePredicatesKt.isString(constType) ? ConstantValueKind.String.INSTANCE : null;
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return constantValueKind;
    }

    private final <T> FirConstExpression<T> toFirConst(IrConst<T> $this$toFirConst) {
        ConstantValueKind<?> constantValueKind = this.getConstantKind($this$toFirConst);
        ConstantValueKind<Object> constantValueKind2 = constantValueKind instanceof ConstantValueKind ? constantValueKind : null;
        if (constantValueKind2 == null) {
            return null;
        }
        ConstantValueKind<?> kind = constantValueKind2;
        return FirConstExpressionBuilderKt.buildConstExpression$default(null, kind, $this$toFirConst.getValue(), null, false, 24, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            try {
                nArray[UnsignedType.UBYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.USHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.UINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.ULONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

