/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "supportedTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "[Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findMetaAnnotations", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCRefinementAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCRefinementAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class FirNativeObjCRefinementAnnotationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNativeObjCRefinementAnnotationChecker INSTANCE = new FirNativeObjCRefinementAnnotationChecker();
    @NotNull
    private static final KotlinTarget[] supportedTargets;

    private FirNativeObjCRefinementAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirAnnotation it;
            Set<KotlinTarget> targets;
            Set unsupportedTargets;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
                return;
            }
            FirSession session = context.getSession();
            Pair<FirAnnotation, FirAnnotation> pair = this.findMetaAnnotations(declaration, session);
            FirAnnotation objCAnnotation = (FirAnnotation)pair.component1();
            FirAnnotation swiftAnnotation = (FirAnnotation)pair.component2();
            if (objCAnnotation == null && swiftAnnotation == null) {
                return;
            }
            if (objCAnnotation != null && swiftAnnotation != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)swiftAnnotation.getSource(), FirNativeErrors.INSTANCE.getREDUNDANT_SWIFT_REFINEMENT(), (DiagnosticContext)context, null, 8, null);
            }
            if (!(!((Collection)(unsupportedTargets = SetsKt.minus(targets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration, session), (Object[])supportedTargets))).isEmpty())) break block5;
            FirAnnotation firAnnotation = objCAnnotation;
            if (firAnnotation != null) {
                it = firAnnotation;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getINVALID_OBJC_REFINEMENT_TARGETS(), (DiagnosticContext)context, null, 8, null);
            }
            FirAnnotation firAnnotation2 = swiftAnnotation;
            if (firAnnotation2 != null) {
                it = firAnnotation2;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getINVALID_OBJC_REFINEMENT_TARGETS(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final Pair<FirAnnotation, FirAnnotation> findMetaAnnotations(FirRegularClass $this$findMetaAnnotations, FirSession session) {
        FirAnnotation objCAnnotation = null;
        FirAnnotation swiftAnnotation = null;
        for (FirAnnotation annotation2 : $this$findMetaAnnotations.getAnnotations()) {
            ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(annotation2, session);
            if (Intrinsics.areEqual((Object)classId, (Object)FirNativeObjCRefinementChecker.INSTANCE.getHidesFromObjCClassId())) {
                objCAnnotation = annotation2;
            } else if (Intrinsics.areEqual((Object)classId, (Object)FirNativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftClassId())) {
                swiftAnnotation = annotation2;
            }
            if (objCAnnotation == null || swiftAnnotation == null) continue;
            break;
        }
        return TuplesKt.to(objCAnnotation, swiftAnnotation);
    }

    static {
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
        supportedTargets = kotlinTargetArray;
    }
}

