/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\"\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0003H\u0000\u001aN\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\b2\u0006\u0010\u0012\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u001a(\u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\bH\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010\u00a8\u0006\u001b"}, d2={"appendElementFullName", "", "declaration", "Lorg/jetbrains/kotlin/ir/IrElement;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "expectActualTypeAliasMap", "", "Lorg/jetbrains/kotlin/name/FqName;", "generateActualIrClassOrTypeAliasFullName", "", "generateIrElementFullNameFromExpect", "containsOptionalExpectation", "", "getMatch", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "", "expectDeclaration", "expectActualTypesMap", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "match", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "actualFunction", "reportMissingActual", "Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;", "irDeclaration", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrActualizerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizerUtils.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,165:1\n1#2:166\n216#3:167\n*S KotlinDebug\n*F\n+ 1 IrActualizerUtils.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizerUtilsKt\n*L\n32#1:167\n*E\n"})
public final class IrActualizerUtilsKt {
    @Nullable
    public static final IrDeclaration getMatch(@NotNull Map<String, ? extends List<? extends IrDeclaration>> $this$getMatch, @NotNull IrDeclaration expectDeclaration, @NotNull Map<IrSymbol, ? extends IrSymbol> expectActualTypesMap, @NotNull Map<FqName, FqName> expectActualTypeAliasMap) {
        IrDeclaration irDeclaration2;
        Intrinsics.checkNotNullParameter($this$getMatch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectDeclaration, (String)"expectDeclaration");
        Intrinsics.checkNotNullParameter(expectActualTypesMap, (String)"expectActualTypesMap");
        Intrinsics.checkNotNullParameter(expectActualTypeAliasMap, (String)"expectActualTypeAliasMap");
        List<? extends IrDeclaration> list2 = $this$getMatch.get(IrActualizerUtilsKt.generateIrElementFullNameFromExpect(expectDeclaration, expectActualTypeAliasMap));
        if (list2 == null) {
            return null;
        }
        List<? extends IrDeclaration> members2 = list2;
        if (expectDeclaration instanceof IrFunction) {
            IrFunction irFunction2;
            block6: {
                for (IrDeclaration it : (Iterable)members2) {
                    IrFunction irFunction3;
                    IrFunction irFunction4;
                    boolean bl = false;
                    IrFunction irFunction5 = (IrFunction)expectDeclaration;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                    boolean condition$iv = IrActualizerUtilsKt.match(irFunction5, (IrFunction)it, expectActualTypesMap);
                    boolean $i$f$runIf = false;
                    if (condition$iv) {
                        boolean bl2 = false;
                        irFunction4 = (IrFunction)it;
                    } else {
                        irFunction4 = null;
                    }
                    if ((irFunction3 = irFunction4) == null) continue;
                    irFunction2 = irFunction3;
                    break block6;
                }
                irFunction2 = null;
            }
            irDeclaration2 = irFunction2;
        } else {
            irDeclaration2 = (IrDeclaration)CollectionsKt.singleOrNull(members2);
        }
        return irDeclaration2;
    }

    private static final boolean match(IrFunction $this$match, IrFunction actualFunction, Map<IrSymbol, ? extends IrSymbol> expectActualTypesMap) {
        if ($this$match.getValueParameters().size() != actualFunction.getValueParameters().size() || $this$match.getTypeParameters().size() != actualFunction.getTypeParameters().size()) {
            return false;
        }
        Map localTypeParametersMap = new LinkedHashMap();
        for (Pair pair : CollectionsKt.zip((Iterable)$this$match.getTypeParameters(), (Iterable)actualFunction.getTypeParameters())) {
            IrTypeParameter expectTypeParameter = (IrTypeParameter)pair.component1();
            IrTypeParameter actualTypeParameter = (IrTypeParameter)pair.component2();
            if (!Intrinsics.areEqual((Object)expectTypeParameter.getName(), (Object)actualTypeParameter.getName())) {
                return false;
            }
            localTypeParametersMap.put(expectTypeParameter.getSymbol(), actualTypeParameter.getSymbol());
        }
        if (!IrActualizerUtilsKt.match$checkParameter(expectActualTypesMap, $this$match.getExtensionReceiverParameter(), actualFunction.getExtensionReceiverParameter(), localTypeParametersMap)) {
            return false;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)$this$match.getValueParameters(), (Iterable)actualFunction.getValueParameters())) {
            IrValueParameter actualParameter;
            IrValueParameter expectParameter = (IrValueParameter)pair.component1();
            if (IrActualizerUtilsKt.match$checkParameter(expectActualTypesMap, expectParameter, actualParameter = (IrValueParameter)pair.component2(), localTypeParametersMap)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final String generateActualIrClassOrTypeAliasFullName(@NotNull IrElement declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return IrActualizerUtilsKt.generateIrElementFullNameFromExpect(declaration, MapsKt.emptyMap());
    }

    @NotNull
    public static final String generateIrElementFullNameFromExpect(@NotNull IrElement declaration, @NotNull Map<FqName, FqName> expectActualTypeAliasMap) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(expectActualTypeAliasMap, (String)"expectActualTypeAliasMap");
        StringBuilder $this$generateIrElementFullNameFromExpect_u24lambda_u243 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        IrActualizerUtilsKt.appendElementFullName(declaration, $this$generateIrElementFullNameFromExpect_u24lambda_u243, expectActualTypeAliasMap);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private static final void appendElementFullName(IrElement declaration, StringBuilder result2, Map<FqName, FqName> expectActualTypeAliasMap) {
        if (!(declaration instanceof IrDeclarationBase)) {
            return;
        }
        List parents2 = new ArrayList();
        IrDeclarationParent parent2 = ((IrDeclarationBase)declaration).getParent();
        while (parent2 != null) {
            String parentString;
            IrDeclarationParent parentParent;
            if (parent2 instanceof IrDeclarationWithName && (parentParent = ((IrDeclarationWithName)((Object)parent2)).getParent()) instanceof IrClass) {
                String string2 = ((IrDeclarationWithName)((Object)parent2)).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.name.asString()");
                parents2.add(string2);
                parent2 = parentParent;
                continue;
            }
            FqName it = AdditionalIrUtilsKt.getKotlinFqName(parent2);
            boolean bl = false;
            FqName fqName2 = expectActualTypeAliasMap.get(it);
            if (fqName2 == null) {
                fqName2 = it;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fqName2.asString(), (String)"parent.kotlinFqName.let \u2026p[it] ?: it).asString() }");
            if (((CharSequence)parentString).length() > 0) {
                parents2.add(parentString);
            }
            parent2 = null;
        }
        if (!((Collection)parents2).isEmpty()) {
            result2.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversedMutable((List)parents2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            result2.append('.');
        }
        if (declaration instanceof IrDeclarationWithName) {
            result2.append(((IrDeclarationWithName)declaration).getName());
        }
        if (declaration instanceof IrFunction) {
            result2.append("()");
        }
    }

    public static final void reportMissingActual(@NotNull KtDiagnosticReporterWithImplicitIrBasedContext $this$reportMissingActual, @NotNull IrDeclaration irDeclaration2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$reportMissingActual, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = $this$reportMissingActual.at(irDeclaration2);
        KtDiagnosticFactory2<String, ModuleDescriptor> ktDiagnosticFactory2 = CommonBackendErrors.INSTANCE.getNO_ACTUAL_FOR_EXPECT();
        Object object = irDeclaration2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)irDeclaration2 : null;
        if ((object != null && (object = object.getName()) != null ? ((Name)object).asString() : (string2 = null)) == null) {
            string2 = "";
        }
        diagnosticContextImpl.report(ktDiagnosticFactory2, string2, AdditionalIrUtilsKt.getModule(irDeclaration2));
    }

    public static final boolean containsOptionalExpectation(@NotNull IrElement $this$containsOptionalExpectation) {
        Intrinsics.checkNotNullParameter((Object)$this$containsOptionalExpectation, (String)"<this>");
        return $this$containsOptionalExpectation instanceof IrClass && ((IrClass)$this$containsOptionalExpectation).getKind() == ClassKind.ANNOTATION_CLASS && IrUtilsKt.hasAnnotation((IrAnnotationContainer)((Object)$this$containsOptionalExpectation), OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME());
    }

    private static final IrSymbol match$getActualizedValueParameterSymbol(Map<IrSymbol, ? extends IrSymbol> $expectActualTypesMap, IrValueParameter expectParameter, Map<IrTypeParameterSymbol, ? extends IrTypeParameterSymbol> localTypeParametersMap) {
        IrSymbol irSymbol2;
        IrTypeParameterSymbol localMappedSymbol;
        IrClassifierSymbol it = IrTypesKt.getClassifierOrFail(expectParameter.getType());
        boolean bl = false;
        IrTypeParameterSymbol irTypeParameterSymbol = localMappedSymbol = localTypeParametersMap != null && it instanceof IrTypeParameterSymbol ? localTypeParametersMap.get(it) : null;
        if (irTypeParameterSymbol != null) {
            irSymbol2 = irTypeParameterSymbol;
        } else {
            irSymbol2 = $expectActualTypesMap.get(it);
            if (irSymbol2 == null) {
                irSymbol2 = it;
            }
        }
        return irSymbol2;
    }

    static /* synthetic */ IrSymbol match$getActualizedValueParameterSymbol$default(Map map, IrValueParameter irValueParameter, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return IrActualizerUtilsKt.match$getActualizedValueParameterSymbol(map, irValueParameter, map2);
    }

    private static final boolean match$checkParameter(Map<IrSymbol, ? extends IrSymbol> $expectActualTypesMap, IrValueParameter expectParameter, IrValueParameter actualParameter, Map<IrTypeParameterSymbol, ? extends IrTypeParameterSymbol> localTypeParametersMap) {
        if (expectParameter == null) {
            return actualParameter == null;
        }
        if (actualParameter == null) {
            return false;
        }
        if (expectParameter.getType() instanceof IrDynamicType || actualParameter.getType() instanceof IrDynamicType) {
            return true;
        }
        return Intrinsics.areEqual((Object)IrActualizerUtilsKt.match$getActualizedValueParameterSymbol($expectActualTypesMap, expectParameter, localTypeParametersMap), (Object)IrActualizerUtilsKt.match$getActualizedValueParameterSymbol$default($expectActualTypesMap, actualParameter, null, 4, null));
    }
}

