/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "", "sourceRoots", "", "Ljava/io/File;", "outputDir", "(Ljava/util/List;Ljava/io/File;)V", "cache", "", "", "outputDirPathResolver", "Lorg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator;", "", "calculatePathRelativeToOutput", "file", "calculatePathRelativeToSourceRoots", "getPathRelativeToSourceRoots", "Companion", "js.sourcemap"})
@SourceDebugExtension(value={"SMAP\nSourceFilePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1620#2,3:74\n1#3:77\n*S KotlinDebug\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver\n*L\n14#1:74,3\n*E\n"})
public final class SourceFilePathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<File> sourceRoots;
    @Nullable
    private final RelativePathCalculator outputDirPathResolver;
    @NotNull
    private final Map<File, String> cache;

    /*
     * WARNING - void declaration
     */
    public SourceFilePathResolver(@NotNull List<? extends File> sourceRoots, @Nullable File outputDir2) {
        RelativePathCalculator relativePathCalculator;
        File destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        Iterable iterable = sourceRoots;
        Collection collection = new LinkedHashSet();
        SourceFilePathResolver sourceFilePathResolver = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file2 = (File)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(it.getAbsoluteFile());
        }
        sourceFilePathResolver.sourceRoots = (Set)((Object)destination$iv);
        SourceFilePathResolver sourceFilePathResolver2 = this;
        File file3 = outputDir2;
        if (file3 != null) {
            void p0;
            destination$iv = file3;
            sourceFilePathResolver = sourceFilePathResolver2;
            boolean bl = false;
            relativePathCalculator = new RelativePathCalculator((File)p0);
            sourceFilePathResolver2 = sourceFilePathResolver;
        } else {
            relativePathCalculator = null;
        }
        sourceFilePathResolver2.outputDirPathResolver = relativePathCalculator;
        this.cache = new LinkedHashMap();
    }

    public /* synthetic */ SourceFilePathResolver(List list2, File file2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        this(list2, file2);
    }

    @NotNull
    public final String getPathRelativeToSourceRoots(@NotNull File file2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String path2 = this.cache.get(file2);
        if (path2 == null) {
            path2 = this.calculatePathRelativeToSourceRoots(file2);
            this.cache.put(file2, path2);
        }
        return path2;
    }

    private final String calculatePathRelativeToSourceRoots(File file2) throws IOException {
        String pathRelativeToOutput;
        String string2 = pathRelativeToOutput = this.calculatePathRelativeToOutput(file2);
        if (string2 != null) {
            return string2;
        }
        List parts2 = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)file2.getAbsoluteFile(), (String)"file.absoluteFile");
        for (File currentFile = FilesKt.normalize((File)(v1592548)); currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.sourceRoots.contains(currentFile)) {
                if (parts2.isEmpty()) break;
                CollectionsKt.reverse((List)parts2);
                Iterable iterable = parts2;
                String string3 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
            }
            String string4 = currentFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"currentFile.name");
            parts2.add(string4);
        }
        String string5 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"file.name");
        return string5;
    }

    private final String calculatePathRelativeToOutput(File file2) {
        RelativePathCalculator relativePathCalculator = this.outputDirPathResolver;
        return relativePathCalculator != null ? relativePathCalculator.calculateRelativePathTo(file2) : null;
    }

    @JvmStatic
    @NotNull
    public static final SourceFilePathResolver create(@NotNull JsConfig config) {
        return Companion.create(config);
    }

    @JvmStatic
    @NotNull
    public static final SourceFilePathResolver create(@NotNull CompilerConfiguration configuration2) {
        return Companion.create(configuration2);
    }

    @JvmStatic
    @NotNull
    public static final SourceFilePathResolver create(@NotNull List<String> sourceRoots, @NotNull String sourceMapPrefix, @Nullable File outputDir2) {
        return Companion.create(sourceRoots, sourceMapPrefix, outputDir2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "sourceRoots", "", "", "sourceMapPrefix", "outputDir", "Ljava/io/File;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "js.sourcemap"})
    @SourceDebugExtension(value={"SMAP\nSourceFilePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1549#2:74\n1620#2,3:75\n1#3:78\n*S KotlinDebug\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion\n*L\n67#1:74\n67#1:75,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SourceFilePathResolver create(@NotNull JsConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            CompilerConfiguration compilerConfiguration = config.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"config.configuration");
            return this.create(compilerConfiguration);
        }

        @JvmStatic
        @NotNull
        public final SourceFilePathResolver create(@NotNull CompilerConfiguration configuration2) {
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            List list2 = configuration2.get(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"configuration.get(JSConf\u2026OURCE_ROOTS, emptyList())");
            String string2 = configuration2.get(JSConfigurationKeys.SOURCE_MAP_PREFIX, "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configuration.get(JSConf\u2026ys.SOURCE_MAP_PREFIX, \"\")");
            return this.create(list2, string2, configuration2.get(JSConfigurationKeys.OUTPUT_DIR));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SourceFilePathResolver create(@NotNull List<String> sourceRoots, @NotNull String sourceMapPrefix, @Nullable File outputDir2) {
            File file2;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
            Intrinsics.checkNotNullParameter((Object)sourceMapPrefix, (String)"sourceMapPrefix");
            boolean generateRelativePathsInSourceMap = ((CharSequence)sourceMapPrefix).length() == 0 && sourceRoots.isEmpty();
            Iterable $this$map$iv = sourceRoots;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            File $i$f$map22 = file2 = outputDir2;
            collection = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = generateRelativePathsInSourceMap;
            File file3 = bl2 ? file2 : null;
            Collection collection2 = collection;
            return new SourceFilePathResolver((List<? extends File>)collection2, file3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

