/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeCapturedTypeConstructor;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.types.model.CaptureStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH&J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\rH\u0004J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\r*\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\r*\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 \u00b2\u0006\u0012\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\"X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;)V", "getTypeContext", "()Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "substituteArgument", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "projection", "index", "", "substituteOrNull", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "substituteType", "wrapProjection", "old", "newType", "substituteArguments", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "substituteBounds", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "substituteCapturedType", "Lorg/jetbrains/kotlin/fir/types/ConeCapturedType;", "substituteIntersectedTypes", "Lorg/jetbrains/kotlin/fir/types/ConeIntersectionType;", "substituteOriginal", "Lorg/jetbrains/kotlin/fir/types/ConeDefinitelyNotNullType;", "substituteRecursive", "updateNullabilityIfNeeded", "originalType", "providers", "newArguments", ""})
@SourceDebugExtension(value={"SMAP\nSubstitutors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Substitutors.kt\norg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1549#2:348\n1620#2,3:349\n*S KotlinDebug\n*F\n+ 1 Substitutors.kt\norg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor\n*L\n84#1:348\n84#1:349,3\n*E\n"})
public abstract class AbstractConeSubstitutor
extends ConeSubstitutor {
    @NotNull
    private final ConeTypeContext typeContext;

    public AbstractConeSubstitutor(@NotNull ConeTypeContext typeContext2) {
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        this.typeContext = typeContext2;
    }

    @NotNull
    protected final ConeTypeContext getTypeContext() {
        return this.typeContext;
    }

    @NotNull
    protected final ConeTypeProjection wrapProjection(@NotNull ConeTypeProjection old, @NotNull ConeKotlinType newType) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        ConeTypeProjection coneTypeProjection = old;
        return coneTypeProjection instanceof ConeStarProjection ? old : (coneTypeProjection instanceof ConeKotlinTypeProjectionIn ? (ConeTypeProjection)new ConeKotlinTypeProjectionIn(newType) : (coneTypeProjection instanceof ConeKotlinTypeProjectionOut ? (ConeTypeProjection)new ConeKotlinTypeProjectionOut(newType) : (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection ? (ConeTypeProjection)new ConeKotlinTypeConflictingProjection(newType) : (coneTypeProjection instanceof ConeKotlinType ? (ConeTypeProjection)newType : old))));
    }

    @Nullable
    public abstract ConeKotlinType substituteType(@NotNull ConeKotlinType var1);

    @Nullable
    public ConeTypeProjection substituteArgument(@NotNull ConeTypeProjection projection, int index2) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        ConeKotlinTypeProjection coneKotlinTypeProjection = projection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)projection : null;
        if (coneKotlinTypeProjection == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return null;
        }
        ConeKotlinTypeProjection type2 = coneKotlinTypeProjection;
        ConeKotlinType coneKotlinType = this.substituteOrNull((ConeKotlinType)type2);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType newType = coneKotlinType;
        return this.wrapProjection(projection, newType);
    }

    @Nullable
    public final ConeKotlinType updateNullabilityIfNeeded(@Nullable ConeKotlinType $this$updateNullabilityIfNeeded, @NotNull ConeKotlinType originalType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        if (originalType instanceof ConeDefinitelyNotNullType) {
            ConeKotlinType coneKotlinType2 = $this$updateNullabilityIfNeeded;
            coneKotlinType = coneKotlinType2 != null ? TypeUtilsKt.withNullability$default(coneKotlinType2, ConeNullability.NOT_NULL, this.typeContext, null, 4, null) : null;
        } else if (ConeTypeUtilsKt.isMarkedNullable(originalType)) {
            ConeKotlinType coneKotlinType3 = $this$updateNullabilityIfNeeded;
            coneKotlinType = coneKotlinType3 != null ? TypeUtilsKt.withNullability$default(coneKotlinType3, ConeNullability.NULLABLE, this.typeContext, null, 4, null) : null;
        } else {
            coneKotlinType = $this$updateNullabilityIfNeeded;
        }
        return coneKotlinType;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteOrNull(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType newType = this.substituteType(type2);
        if (newType != null && type2 instanceof ConeDefinitelyNotNullType) {
            return TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull(newType, this.typeContext, false);
        }
        ConeKotlinType coneKotlinType = newType;
        if (coneKotlinType == null) {
            coneKotlinType = this.substituteRecursive(type2);
        }
        return coneKotlinType;
    }

    private final ConeKotlinType substituteRecursive(ConeKotlinType $this$substituteRecursive) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$substituteRecursive;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.substituteArguments((ConeClassLikeType)$this$substituteRecursive);
        } else {
            if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
                return null;
            }
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                ConeFlexibleType coneFlexibleType = this.substituteBounds((ConeFlexibleType)$this$substituteRecursive);
                if (coneFlexibleType != null) {
                    ConeFlexibleType it = coneFlexibleType;
                    boolean bl = false;
                    coneKotlinType = Intrinsics.areEqual((Object)it.getLowerBound(), (Object)it.getUpperBound()) ? (ConeKotlinType)it.getLowerBound() : (ConeKotlinType)it;
                } else {
                    coneKotlinType = null;
                }
            } else {
                if (coneKotlinType2 instanceof ConeCapturedType) {
                    return this.substituteCapturedType((ConeCapturedType)$this$substituteRecursive);
                }
                if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                    coneKotlinType = this.substituteOriginal((ConeDefinitelyNotNullType)$this$substituteRecursive);
                } else if (coneKotlinType2 instanceof ConeIntersectionType) {
                    coneKotlinType = this.substituteIntersectedTypes((ConeIntersectionType)$this$substituteRecursive);
                } else {
                    if (coneKotlinType2 instanceof ConeStubType) {
                        return null;
                    }
                    if (coneKotlinType2 instanceof ConeIntegerLiteralType) {
                        return null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeCapturedType substituteCapturedType(ConeCapturedType $this$substituteCapturedType) {
        List list2;
        ConeKotlinType coneKotlinType = $this$substituteCapturedType.getLowerType();
        if (coneKotlinType == null) {
            coneKotlinType = ConeTypeProjectionKt.getType($this$substituteCapturedType.getConstructor().getProjection());
        }
        ConeKotlinType innerType = coneKotlinType;
        ConeKotlinType coneKotlinType2 = ConeSubstitutorKt.substituteOrNull(this, innerType);
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType substitutedInnerType = coneKotlinType2;
        if (substitutedInnerType instanceof ConeCapturedType) {
            return (ConeCapturedType)substitutedInnerType;
        }
        List<ConeKotlinType> list3 = $this$substituteCapturedType.getConstructor().getSupertypes();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeKotlinType coneKotlinType3 = (ConeKotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.substituteOrSelf((ConeKotlinType)it));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List substitutedSuperTypes = list2;
        CaptureStatus captureStatus = $this$substituteCapturedType.getCaptureStatus();
        ConeCapturedTypeConstructor coneCapturedTypeConstructor = new ConeCapturedTypeConstructor(this.wrapProjection($this$substituteCapturedType.getConstructor().getProjection(), substitutedInnerType), substitutedSuperTypes, $this$substituteCapturedType.getConstructor().getTypeParameterMarker());
        ConeKotlinType coneKotlinType4 = $this$substituteCapturedType.getLowerType() != null ? substitutedInnerType : null;
        return new ConeCapturedType(captureStatus, coneKotlinType4, null, coneCapturedTypeConstructor, null, false, 52, null);
    }

    private final ConeIntersectionType substituteIntersectedTypes(ConeIntersectionType $this$substituteIntersectedTypes) {
        ArrayList substitutedTypes = new ArrayList($this$substituteIntersectedTypes.getIntersectedTypes().size());
        boolean somethingIsSubstituted = false;
        for (ConeKotlinType type2 : $this$substituteIntersectedTypes.getIntersectedTypes()) {
            ConeKotlinType coneKotlinType;
            if (this.substituteOrNull(type2) != null) {
                ConeKotlinType coneKotlinType2;
                ConeKotlinType it = coneKotlinType2;
                boolean bl = false;
                somethingIsSubstituted = true;
                coneKotlinType = coneKotlinType2;
            } else {
                coneKotlinType = type2;
            }
            ConeKotlinType substitutedType = coneKotlinType;
            ((Collection)substitutedTypes).add(substitutedType);
        }
        if (!somethingIsSubstituted) {
            return null;
        }
        return new ConeIntersectionType(substitutedTypes, null, 2, null);
    }

    private final ConeKotlinType substituteOriginal(ConeDefinitelyNotNullType $this$substituteOriginal) {
        ConeKotlinType coneKotlinType = this.substituteOrNull($this$substituteOriginal.getOriginal());
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType substitutedOriginal = coneKotlinType;
        ConeKotlinType substituted = TypeUtilsKt.withNullability(substitutedOriginal, ConeNullability.NOT_NULL, this.typeContext, substitutedOriginal.getAttributes().add($this$substituteOriginal.getOriginal().getAttributes()));
        ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, substituted, this.typeContext, true);
        return coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : substituted;
    }

    private final ConeFlexibleType substituteBounds(ConeFlexibleType $this$substituteBounds) {
        ConeKotlinType newLowerBound = this.substituteOrNull($this$substituteBounds.getLowerBound());
        ConeKotlinType newUpperBound = this.substituteOrNull($this$substituteBounds.getUpperBound());
        if (newLowerBound != null || newUpperBound != null) {
            ConeKotlinType coneKotlinType;
            ConeKotlinType coneKotlinType2 = newLowerBound;
            if (coneKotlinType2 == null || (coneKotlinType2 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType2)) == null) {
                coneKotlinType2 = $this$substituteBounds.getLowerBound();
            }
            if ((coneKotlinType = newUpperBound) == null || (coneKotlinType = ConeTypeUtilsKt.upperBoundIfFlexible(coneKotlinType)) == null) {
                coneKotlinType = $this$substituteBounds.getUpperBound();
            }
            return new ConeFlexibleType((ConeSimpleKotlinType)coneKotlinType2, (ConeSimpleKotlinType)coneKotlinType);
        }
        return null;
    }

    private final ConeKotlinType substituteArguments(ConeClassLikeType $this$substituteArguments) {
        ConeTypeProjection typeArgument;
        int index2;
        int n;
        Lazy newArguments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConeTypeProjection[]>($this$substituteArguments){
            final /* synthetic */ ConeClassLikeType $this_substituteArguments;
            {
                this.$this_substituteArguments = $receiver;
                super(0);
            }

            @NotNull
            public final ConeTypeProjection[] invoke() {
                return new ConeTypeProjection[this.$this_substituteArguments.getTypeArguments().length];
            }
        }));
        boolean initialized = false;
        Object object = $this$substituteArguments.getTypeArguments();
        int n2 = ((ConeTypeProjection[])object).length;
        for (n = 0; n < n2; ++n) {
            ConeTypeProjection coneTypeProjection;
            index2 = n;
            typeArgument = object[n];
            ConeTypeProjection[] coneTypeProjectionArray = AbstractConeSubstitutor.substituteArguments$lambda$3((Lazy<ConeTypeProjection[]>)newArguments$delegate);
            int n3 = index2;
            if (this.substituteArgument(typeArgument, index2) != null) {
                ConeTypeProjection coneTypeProjection2;
                ConeTypeProjection coneTypeProjection3 = coneTypeProjection2;
                int n4 = n3;
                ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
                boolean bl = false;
                initialized = true;
                Unit unit2 = Unit.INSTANCE;
                coneTypeProjectionArray = coneTypeProjectionArray2;
                n3 = n4;
                coneTypeProjection = coneTypeProjection2;
            } else {
                coneTypeProjection = null;
            }
            coneTypeProjectionArray[n3] = coneTypeProjection;
        }
        if (initialized) {
            ConeKotlinType coneKotlinType;
            object = $this$substituteArguments.getTypeArguments();
            n2 = ((ConeTypeProjection[])object).length;
            for (n = 0; n < n2; ++n) {
                index2 = n;
                typeArgument = object[n];
                if (AbstractConeSubstitutor.substituteArguments$lambda$3((Lazy<ConeTypeProjection[]>)newArguments$delegate)[index2] != null) continue;
                AbstractConeSubstitutor.substituteArguments$lambda$3((Lazy<ConeTypeProjection[]>)newArguments$delegate)[index2] = typeArgument;
            }
            object = $this$substituteArguments;
            if (object instanceof ConeClassLikeTypeImpl) {
                coneKotlinType = new ConeClassLikeTypeImpl($this$substituteArguments.getLookupTag(), AbstractConeSubstitutor.substituteArguments$lambda$3((Lazy<ConeTypeProjection[]>)newArguments$delegate), $this$substituteArguments.getNullability().isNullable(), $this$substituteArguments.getAttributes());
            } else if (object instanceof ConeErrorType) {
                coneKotlinType = new ConeErrorType(((ConeErrorType)$this$substituteArguments).getDiagnostic(), ((ConeErrorType)$this$substituteArguments).isUninferredParameter(), AbstractConeSubstitutor.substituteArguments$lambda$3((Lazy<ConeTypeProjection[]>)newArguments$delegate), $this$substituteArguments.getAttributes());
            } else {
                throw new IllegalStateException(("Unknown class-like type to substitute: " + $this$substituteArguments + ", " + Reflection.getOrCreateKotlinClass($this$substituteArguments.getClass())).toString());
            }
            return coneKotlinType;
        }
        return null;
    }

    private static final ConeTypeProjection[] substituteArguments$lambda$3(Lazy<ConeTypeProjection[]> $newArguments$delegate) {
        Lazy<ConeTypeProjection[]> lazy = $newArguments$delegate;
        return (ConeTypeProjection[])lazy.getValue();
    }
}

