/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.TemporaryAssignmentElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "hasChanges", "", "namesToProcess", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "referenceCount", "", "", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "syntheticNames", "usageSequences", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "usages", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "analyze", "", "apply", "calculateDeclarations", "generateDeclarations", "getUsageSequence", "name", "process", "tryRecord", "expr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "usage", "use", "Usage", "UsageSequence", "js.translator"})
@SourceDebugExtension(value={"SMAP\nTemporaryAssignmentElimination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryAssignmentElimination.kt\norg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,285:1\n361#2,7:286\n1855#3,2:293\n1295#4,2:295\n*S KotlinDebug\n*F\n+ 1 TemporaryAssignmentElimination.kt\norg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination\n*L\n138#1:286,7\n154#1:293,2\n248#1:295,2\n*E\n"})
public final class TemporaryAssignmentElimination {
    @NotNull
    private final JsBlock root;
    @NotNull
    private final Map<JsName, Integer> referenceCount;
    @NotNull
    private final Map<JsName, Usage> usages;
    @NotNull
    private final Set<JsStatement> statementsToRemove;
    @NotNull
    private final Map<JsName, UsageSequence> usageSequences;
    @NotNull
    private final Set<JsName> syntheticNames;
    private boolean hasChanges;
    @NotNull
    private final Set<JsName> namesToProcess;

    public TemporaryAssignmentElimination(@NotNull JsBlock root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.referenceCount = new LinkedHashMap();
        this.usages = new LinkedHashMap();
        this.statementsToRemove = new LinkedHashSet();
        this.usageSequences = new LinkedHashMap();
        this.syntheticNames = new LinkedHashSet();
        this.namesToProcess = new LinkedHashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.calculateDeclarations();
        this.process();
        this.generateDeclarations();
        return this.hasChanges;
    }

    private final void analyze() {
        this.namesToProcess.addAll((Collection<JsName>)CollectUtilsKt.collectDefinedNames(this.root));
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression returnExpr = x.getExpression();
                if (returnExpr != null) {
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, returnExpr, new Usage.Return(x));
                }
                super.visitReturn(x);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsName, JsExpression> variableAssignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (variableAssignment != null) {
                    JsName name2 = (JsName)variableAssignment.component1();
                    JsExpression value2 = (JsExpression)variableAssignment.component2();
                    JsStatement jsStatement = x;
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                    Usage.VariableAssignment usage = new Usage.VariableAssignment(jsStatement, name2);
                    if (MetadataProperties.getSynthetic(x)) {
                        ((Collection)TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0)).add(name2);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, value2, usage);
                    this.accept((JsNode)value2);
                    return;
                }
                Pair<JsExpression, JsExpression> propertyMutation = JsAstUtils.decomposeAssignment(x.getExpression());
                if (propertyMutation != null) {
                    JsExpression target = (JsExpression)propertyMutation.component1();
                    JsExpression value3 = (JsExpression)propertyMutation.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
                    if (!SideEffectUtilsKt.canHaveSideEffect(target, TemporaryAssignmentElimination.access$getNamesToProcess$p(this.this$0))) {
                        Usage.PropertyMutation usage = new Usage.PropertyMutation((JsStatement)x, target);
                        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"value");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, value3, usage);
                        this.accept((JsNode)value3);
                        return;
                    }
                }
                super.visitExpressionStatement(x);
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.getVars().size() == 1) {
                    JsVars.JsVar declaration = x.getVars().get(0);
                    JsExpression initExpression = declaration.getInitExpression();
                    if (initExpression != null) {
                        JsStatement jsStatement = x;
                        JsName jsName = declaration.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declaration.name");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, initExpression, new Usage.VariableDeclaration(jsStatement, jsName));
                    }
                    if (MetadataProperties.getSynthetic(x)) {
                        ((Collection)TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0)).add(declaration.getName());
                    }
                }
                List<JsVars.JsVar> list2 = x.getVars();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"x.vars");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression jsExpression;
                    JsVars.JsVar v = (JsVars.JsVar)element$iv;
                    boolean bl = false;
                    SourceInfoAwareJsNode sourceInfoAwareJsNode = v;
                    if (sourceInfoAwareJsNode == null || (sourceInfoAwareJsNode = (jsExpression = sourceInfoAwareJsNode.getInitExpression())) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode, (String)"initExpression");
                    JsExpression it = jsExpression;
                    boolean bl2 = false;
                    this.accept((JsNode)it);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name2 = nameRef.getName();
                if (name2 != null && nameRef.getQualifier() == null) {
                    TemporaryAssignmentElimination.access$use(this.this$0, name2);
                    return;
                }
                super.visitNameRef(nameRef);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                TemporaryAssignmentElimination temporaryAssignmentElimination = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsName it = (JsName)element$iv;
                    boolean bl = false;
                    TemporaryAssignmentElimination.access$use(temporaryAssignmentElimination, it);
                    TemporaryAssignmentElimination.access$use(temporaryAssignmentElimination, it);
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitFor(@NotNull JsFor x) {
                block5: {
                    JsNode it;
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    JsVars jsVars = x.getInitVars();
                    if (jsVars != null) {
                        it = jsVars;
                        boolean bl = false;
                        List<JsVars.JsVar> list2 = it.getVars();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"it.vars");
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsExpression jsExpression;
                            JsVars.JsVar it2 = (JsVars.JsVar)element$iv;
                            boolean bl2 = false;
                            JsExpression jsExpression2 = jsExpression = it2.getInitExpression();
                            if (jsExpression2 == null) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"initExpression");
                            JsExpression it3 = jsExpression;
                            boolean bl3 = false;
                            this.accept((JsNode)it3);
                        }
                    }
                    JsExpression jsExpression = x.getInitExpression();
                    if (jsExpression != null) {
                        it = jsExpression;
                        boolean bl = false;
                        this.accept((JsNode)it);
                    }
                    JsExpression jsExpression3 = x.getCondition();
                    if (jsExpression3 != null) {
                        it = jsExpression3;
                        boolean bl = false;
                        this.accept((JsNode)it);
                    }
                    JsStatement jsStatement = x.getBody();
                    if (jsStatement != null) {
                        it = jsStatement;
                        boolean bl = false;
                        this.accept((JsNode)it);
                    }
                    JsExpression jsExpression4 = x.getIncrementExpression();
                    if (jsExpression4 == null) break block5;
                    it = jsExpression4;
                    boolean bl = false;
                    this.accept((JsNode)it);
                }
            }
        }.accept((JsNode)this.root);
        this.usages.keySet().retainAll((Collection)this.syntheticNames);
    }

    private final UsageSequence getUsageSequence(JsName name2) {
        UsageSequence usageSequence;
        Map<JsName, UsageSequence> $this$getOrPut$iv = this.usageSequences;
        boolean $i$f$getOrPut = false;
        UsageSequence value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            UsageSequence mappedUsage;
            boolean bl = false;
            Integer n = this.referenceCount.get(name2);
            int n2 = 1;
            if (n == null || n != n2) {
                return null;
            }
            Usage usage = this.usages.get(name2);
            Usage usage2 = usage;
            UsageSequence answer$iv = mappedUsage = usage2 instanceof Usage.VariableAssignment ? new UsageSequence(usage, this.getUsageSequence(((Usage.VariableAssignment)usage).getTarget())) : (usage2 instanceof Usage.VariableDeclaration ? new UsageSequence(usage, this.getUsageSequence(((Usage.VariableDeclaration)usage).getTarget())) : (usage2 == null ? null : new UsageSequence(usage, null)));
            $this$getOrPut$iv.put(name2, answer$iv);
            usageSequence = answer$iv;
        } else {
            usageSequence = value$iv;
        }
        return usageSequence;
    }

    private final void calculateDeclarations() {
        Iterable $this$forEach$iv = this.usages.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            this.getUsageSequence(it);
        }
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    Usage usage;
                    Object object = assignment.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assignment.first");
                    UsageSequence usageSequence = TemporaryAssignmentElimination.access$getUsageSequence(this.this$0, (JsName)object);
                    Usage usage2 = usage = usageSequence != null ? usageSequence.lastUsage() : null;
                    if (usage instanceof Usage.VariableDeclaration) {
                        Usage.VariableDeclaration variableDeclaration = (Usage.VariableDeclaration)usage;
                        int n = variableDeclaration.getCount();
                        variableDeclaration.setCount(n + 1);
                    }
                }
                super.visitExpressionStatement(x);
            }
        }.accept((JsNode)this.root);
    }

    private final void process() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    JsName name2 = (JsName)assignment.component1();
                    JsExpression value2 = (JsExpression)assignment.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                    UsageSequence usageSequence = TemporaryAssignmentElimination.access$getUsageSequence(this.this$0, name2);
                    if (usageSequence != null) {
                        JsStatement jsStatement;
                        Usage usage = usageSequence.lastUsage();
                        Usage usage2 = usage;
                        if (usage2 instanceof Usage.Return) {
                            JsReturn jsReturn;
                            JsReturn $this$visit_u24lambda_u240 = jsReturn = new JsReturn(value2);
                            boolean bl = false;
                            $this$visit_u24lambda_u240.source(x.getExpression().getSource());
                            jsStatement = jsReturn;
                        } else if (usage2 instanceof Usage.VariableAssignment) {
                            JsExpression expr = JsAstUtils.assignment(((Usage.VariableAssignment)usage).getTarget().makeRef(), value2).source(x.getExpression().getSource());
                            JsExpressionStatement statement2 = new JsExpressionStatement(expr);
                            MetadataProperties.setSynthetic(statement2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableAssignment)usage).getTarget()));
                            jsStatement = statement2;
                        } else if (usage2 instanceof Usage.VariableDeclaration) {
                            JsStatement statement3;
                            JsStatement jsStatement2;
                            if (((Usage.VariableDeclaration)usage).getCount() > 1) {
                                JsExpression expr = JsAstUtils.assignment(((Usage.VariableDeclaration)usage).getTarget().makeRef(), value2).source(x.getExpression().getSource());
                                JsExpressionStatement result2 = new JsExpressionStatement(expr);
                                MetadataProperties.setSynthetic(result2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = result2;
                            } else {
                                JsVars jsVars = JsAstUtils.newVar(((Usage.VariableDeclaration)usage).getTarget(), value2);
                                Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"newVar(usage.target, value)");
                                JsVars declaration = jsVars;
                                declaration.source(x.getExpression().getSource());
                                MetadataProperties.setSynthetic(declaration, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = declaration;
                            }
                            jsStatement = statement3 = jsStatement2;
                        } else if (usage2 instanceof Usage.PropertyMutation) {
                            jsStatement = new JsExpressionStatement(JsAstUtils.assignment(((Usage.PropertyMutation)usage).getTarget(), value2).source(x.getExpression().getSource()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        JsStatement replacement = jsStatement;
                        TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                        ctx.replaceMe((JsNode)replacement);
                        CollectionsKt.addAll((Collection)TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0), usageSequence.collectStatements());
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsReturn x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsVars x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }
        }.accept((JsNode)this.root);
    }

    private final void generateDeclarations() {
        int index2 = 0;
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.usages.values()), (Function1)generateDeclarations.1.INSTANCE), (Function1)generateDeclarations.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars statement2;
            Usage.VariableDeclaration it = (Usage.VariableDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)JsAstUtils.newVar(it.getTarget(), null), (String)"newVar(it.target, null)");
            MetadataProperties.setSynthetic(statement2, this.syntheticNames.contains(it.getTarget()));
            int n = index2;
            index2 = n + 1;
            this.root.getStatements().add(n, statement2);
        }
    }

    private final boolean tryRecord(JsExpression expr, Usage usage) {
        if (!(expr instanceof JsNameRef)) {
            return false;
        }
        JsName jsName = ((JsNameRef)expr).getName();
        if (jsName == null) {
            return false;
        }
        JsName name2 = jsName;
        if (!this.namesToProcess.contains(name2)) {
            return false;
        }
        this.usages.put(name2, usage);
        return true;
    }

    private final void use(JsName name2) {
        Map<JsName, Integer> map = this.referenceCount;
        Integer n = this.referenceCount.get(name2);
        Integer n2 = 1 + (n != null ? n : 0);
        map.put(name2, n2);
    }

    public static final /* synthetic */ boolean access$tryRecord(TemporaryAssignmentElimination $this, JsExpression expr, Usage usage) {
        return $this.tryRecord(expr, usage);
    }

    public static final /* synthetic */ Set access$getSyntheticNames$p(TemporaryAssignmentElimination $this) {
        return $this.syntheticNames;
    }

    public static final /* synthetic */ Set access$getNamesToProcess$p(TemporaryAssignmentElimination $this) {
        return $this.namesToProcess;
    }

    public static final /* synthetic */ void access$use(TemporaryAssignmentElimination $this, JsName name2) {
        $this.use(name2);
    }

    public static final /* synthetic */ UsageSequence access$getUsageSequence(TemporaryAssignmentElimination $this, JsName name2) {
        return $this.getUsageSequence(name2);
    }

    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryAssignmentElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryAssignmentElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "getStatement", "()Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "PropertyMutation", "Return", "VariableAssignment", "VariableDeclaration", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "js.translator"})
    private static abstract class Usage {
        @NotNull
        private final JsStatement statement;

        private Usage(JsStatement statement2) {
            this.statement = statement2;
        }

        @NotNull
        public final JsStatement getStatement() {
            return this.statement;
        }

        public /* synthetic */ Usage(JsStatement statement2, DefaultConstructorMarker $constructor_marker) {
            this(statement2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
        public static final class PropertyMutation
        extends Usage {
            @NotNull
            private final JsExpression target;

            public PropertyMutation(@NotNull JsStatement statement2, @NotNull JsExpression target) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }

            @NotNull
            public final JsExpression getTarget() {
                return this.target;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "js.translator"})
        public static final class Return
        extends Usage {
            public Return(@NotNull JsStatement statement2) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                super(statement2, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
        public static final class VariableAssignment
        extends Usage {
            @NotNull
            private final JsName target;

            public VariableAssignment(@NotNull JsStatement statement2, @NotNull JsName target) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
        public static final class VariableDeclaration
        extends Usage {
            @NotNull
            private final JsName target;
            private int count;

            public VariableDeclaration(@NotNull JsStatement statement2, @NotNull JsName target) {
                Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "", "value", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "next", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;)V", "getNext", "()Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "getValue", "()Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "collectStatements", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "lastUsage", "js.translator"})
    private static final class UsageSequence {
        @NotNull
        private final Usage value;
        @Nullable
        private final UsageSequence next;

        public UsageSequence(@NotNull Usage value2, @Nullable UsageSequence next) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.value = value2;
            this.next = next;
        }

        @NotNull
        public final Usage getValue() {
            return this.value;
        }

        @Nullable
        public final UsageSequence getNext() {
            return this.next;
        }

        @NotNull
        public final Sequence<JsStatement> collectStatements() {
            return SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)this, (Function1)collectStatements.1.INSTANCE), (Function1)collectStatements.2.INSTANCE);
        }

        @NotNull
        public final Usage lastUsage() {
            return ((UsageSequence)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)this, (Function1)((Function1)lastUsage.1.INSTANCE)))).value;
        }
    }
}

