/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtPsiSourceFile;
import org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.EnumClassUtilsKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirGenerationKt;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTarget;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.MutableOrEmptyList;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.BaseFirBuilder;
import org.jetbrains.kotlin.fir.builder.BodyBuildingMode;
import org.jetbrains.kotlin.fir.builder.CalleeAndReceiver;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirFileAnnotationsContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirFunctionTypeParameterBuilder;
import org.jetbrains.kotlin.fir.builder.FirLabelBuilder;
import org.jetbrains.kotlin.fir.builder.FirPackageDirectiveBuilder;
import org.jetbrains.kotlin.fir.builder.FirScriptConfiguratorExtension;
import org.jetbrains.kotlin.fir.builder.FirScriptConfiguratorExtensionKt;
import org.jetbrains.kotlin.fir.builder.PsiConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.DelegateFieldsMapKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousInitializerBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirBackingFieldBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirContextReceiverBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirDanglingModifierListBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirDefaultSetterValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirEnumEntryBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirFieldBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirFileBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirImportBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPrimaryConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirScriptBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeAliasBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterRefsOwnerBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParametersOwnerBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPropertyAccessorImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.DanglingTypeConstraint;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationBuildingUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDanglingModifierOnTopLevel;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeNotAnnotationContainer;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnderscoreUsageWithoutBackticks;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAbstractFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnonymousFunctionExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnonymousObjectExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayOfCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBreakExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCatchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckNotNullCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirContinueExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirDelegatedConstructorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirDoWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirElseIfTrueConditionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirEmptyExpressionBlockBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirEqualityOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirGetClassCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirImplicitInvokeCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLambdaArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLazyDelegatedConstructorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLazyExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedErrorAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThrowExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTryExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTypeOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirUnitExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenBranchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitSuperReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirPropertyFromParameterResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDanglingModifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeArgumentList;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirDynamicTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirFunctionTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirIntersectionTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirPlaceholderProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirStarProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirUserTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImplWithoutSource;
import org.jetbrains.kotlin.fir.types.impl.FirQualifierPartImpl;
import org.jetbrains.kotlin.fir.types.impl.FirTypeArgumentListImpl;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtContractEffect;
import org.jetbrains.kotlin.psi.KtContractEffectKt;
import org.jetbrains.kotlin.psi.KtContractEffectList;
import org.jetbrains.kotlin.psi.KtContractEffectListKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001SB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\"\u0010A\u001a\u0002HB\"\u0004\b\u0000\u0010B2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002HB0DH\u0082\b\u00a2\u0006\u0002\u0010EJ$\u0010F\u001a\u0002HB\"\u0004\b\u0000\u0010B2\u000e\b\u0004\u0010C\u001a\b\u0012\u0004\u0012\u0002HB0DH\u0082\b\u00a2\u0006\u0002\u0010EJ\u000e\u0010G\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0016J\u0016\u0010H\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010I\u001a\u00020\u0018H\u0016J\u000e\u0010J\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0016J\u000e\u0010K\u001a\u0004\u0018\u00010\u0014*\u00020\u0002H\u0016J\u000e\u0010L\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0016J\f\u0010M\u001a\u00020N*\u00020\u0002H\u0016J\u0016\u0010O\u001a\u00020P*\u00020\u00022\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001c*\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u001c\u0010&\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0012R\u0018\u0010(\u001a\u00020\u0014*\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u0018\u0010*\u001a\u00020+*\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/fir/builder/RawFirBuilder;", "Lorg/jetbrains/kotlin/fir/builder/BaseFirBuilder;", "Lcom/intellij/psi/PsiElement;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "baseScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "bodyBuildingMode", "Lorg/jetbrains/kotlin/fir/builder/BodyBuildingMode;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;Lorg/jetbrains/kotlin/fir/builder/BodyBuildingMode;)V", "getBaseScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "<set-?>", "mode", "getMode", "()Lorg/jetbrains/kotlin/fir/builder/BodyBuildingMode;", "arrayExpression", "getArrayExpression", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "asText", "", "getAsText", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/String;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getElementType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/tree/IElementType;", "indexExpressions", "", "getIndexExpressions", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getModality", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/descriptors/Modality;", "receiverExpression", "getReceiverExpression", "selectorExpression", "getSelectorExpression", "unescapedValue", "getUnescapedValue", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "getVisibility", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "bindFunctionTarget", "", "target", "Lorg/jetbrains/kotlin/fir/FirFunctionTarget;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "buildAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "buildTypeReference", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "reference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "disabledLazyMode", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "runOnStubs", "getAnnotatedExpression", "getChildNodeByType", "type", "getExpressionInParentheses", "getLabelName", "getLabeledExpression", "getReferencedNameAsName", "Lorg/jetbrains/kotlin/name/Name;", "toFirSourceElement", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "kind", "Lorg/jetbrains/kotlin/KtFakeSourceElementKind;", "Visitor", "psi2fir"})
@SourceDebugExtension(value={"SMAP\nRawFirBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/RawFirBuilder\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,2799:1\n508#2,4:2800\n1282#3,2:2804\n*S KotlinDebug\n*F\n+ 1 RawFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/RawFirBuilder\n*L\n97#1:2800,4\n110#1:2804,2\n*E\n"})
public class RawFirBuilder
extends BaseFirBuilder<PsiElement> {
    @NotNull
    private final FirScopeProvider baseScopeProvider;
    @NotNull
    private BodyBuildingMode mode;

    public RawFirBuilder(@NotNull FirSession session, @NotNull FirScopeProvider baseScopeProvider, @NotNull BodyBuildingMode bodyBuildingMode) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)baseScopeProvider, (String)"baseScopeProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)bodyBuildingMode), (String)"bodyBuildingMode");
        super(session, null, 2, null);
        this.baseScopeProvider = baseScopeProvider;
        this.mode = bodyBuildingMode;
    }

    public /* synthetic */ RawFirBuilder(FirSession firSession, FirScopeProvider firScopeProvider, BodyBuildingMode bodyBuildingMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bodyBuildingMode = BodyBuildingMode.NORMAL;
        }
        this(firSession, firScopeProvider, bodyBuildingMode);
    }

    @NotNull
    public final FirScopeProvider getBaseScopeProvider() {
        return this.baseScopeProvider;
    }

    protected void bindFunctionTarget(@NotNull FirFunctionTarget target, @NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        target.bind((FirTargetElement)function2);
    }

    @NotNull
    public final BodyBuildingMode getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T disabledLazyMode(Function0<? extends T> body2) {
        Object object;
        boolean $i$f$disabledLazyMode = false;
        if (this.getMode() != BodyBuildingMode.LAZY_BODIES) {
            return (T)body2.invoke();
        }
        try {
            this.mode = BodyBuildingMode.NORMAL;
            object = body2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.mode = BodyBuildingMode.LAZY_BODIES;
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    private final <T> T runOnStubs(Function0<? extends T> body2) {
        Object object;
        boolean $i$f$runOnStubs = false;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getMode().ordinal()]) {
            case 1: {
                object = body2.invoke();
                break;
            }
            case 2: {
                object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new ThrowableComputable(body2){
                    final /* synthetic */ Function0<T> $body;
                    {
                        this.$body = $body;
                    }

                    public final T compute() {
                        return (T)this.$body.invoke();
                    }
                });
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (T)object;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object r = file2.accept(new Visitor(), Unit.INSTANCE);
        Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
        return (FirFile)r;
    }

    @NotNull
    public final FirAnnotationCall buildAnnotationCall(@NotNull KtAnnotationEntry annotation2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        FirElement firElement = new Visitor().visitAnnotationEntry(annotation2, Unit.INSTANCE);
        Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotationCall");
        return (FirAnnotationCall)firElement;
    }

    @NotNull
    public final FirTypeRef buildTypeReference(@NotNull KtTypeReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Object r = reference.accept(new Visitor(), Unit.INSTANCE);
        Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeRef");
        return (FirTypeRef)r;
    }

    @NotNull
    public KtPsiSourceElement toFirSourceElement(@NotNull PsiElement $this$toFirSourceElement, @Nullable KtFakeSourceElementKind kind) {
        KtPsiSourceElement ktPsiSourceElement;
        KtSourceElementKind ktSourceElementKind;
        Intrinsics.checkNotNullParameter((Object)$this$toFirSourceElement, (String)"<this>");
        KtFakeSourceElementKind ktFakeSourceElementKind = kind;
        if (ktFakeSourceElementKind != null) {
            ktSourceElementKind = ktFakeSourceElementKind;
        } else {
            ktSourceElementKind = this.getContext().getForcedElementSourceKind();
            if (ktSourceElementKind == null) {
                ktSourceElementKind = KtRealSourceElementKind.INSTANCE;
            }
        }
        KtSourceElementKind actualKind = ktSourceElementKind;
        PsiElement $this$toKtPsiSourceElement$iv = $this$toFirSourceElement;
        boolean $i$f$toKtPsiSourceElement = false;
        KtSourceElementKind ktSourceElementKind2 = actualKind;
        if (ktSourceElementKind2 instanceof KtRealSourceElementKind) {
            ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement$iv);
        } else if (ktSourceElementKind2 instanceof KtFakeSourceElementKind) {
            ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement$iv, (KtFakeSourceElementKind)actualKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ktPsiSourceElement;
    }

    @Override
    @NotNull
    public IElementType getElementType(@NotNull PsiElement $this$elementType) {
        Intrinsics.checkNotNullParameter((Object)$this$elementType, (String)"<this>");
        IElementType iElementType = $this$elementType.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        return iElementType;
    }

    @Override
    @NotNull
    public String getAsText(@NotNull PsiElement $this$asText) {
        Intrinsics.checkNotNullParameter((Object)$this$asText, (String)"<this>");
        String string2 = $this$asText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
        return string2;
    }

    @Override
    @NotNull
    public String getUnescapedValue(@NotNull PsiElement $this$unescapedValue) {
        Intrinsics.checkNotNullParameter((Object)$this$unescapedValue, (String)"<this>");
        String string2 = ((KtEscapeStringTemplateEntry)$this$unescapedValue).getUnescapedValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as KtEscapeStringTe\u2026lateEntry).unescapedValue");
        return string2;
    }

    @Override
    @Nullable
    public PsiElement getChildNodeByType(@NotNull PsiElement $this$getChildNodeByType, @NotNull IElementType type2) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getChildNodeByType, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            PsiElement[] psiElementArray = $this$getChildNodeByType.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"children");
            Object[] $this$firstOrNull$iv = psiElementArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)type2)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    @Override
    @NotNull
    public Name getReferencedNameAsName(@NotNull PsiElement $this$getReferencedNameAsName) {
        Intrinsics.checkNotNullParameter((Object)$this$getReferencedNameAsName, (String)"<this>");
        return ((KtSimpleNameExpression)$this$getReferencedNameAsName).getReferencedNameAsName();
    }

    @Override
    @Nullable
    public String getLabelName(@NotNull PsiElement $this$getLabelName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getLabelName, (String)"<this>");
        PsiElement psiElement = $this$getLabelName;
        if (psiElement instanceof KtExpressionWithLabel) {
            string2 = ((KtExpressionWithLabel)$this$getLabelName).getLabelName();
        } else if (psiElement instanceof KtNamedFunction) {
            PsiElement psiElement2 = ((KtNamedFunction)$this$getLabelName).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
            string2 = this.getLabelName(psiElement2);
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    @Nullable
    public PsiElement getExpressionInParentheses(@NotNull PsiElement $this$getExpressionInParentheses) {
        Intrinsics.checkNotNullParameter((Object)$this$getExpressionInParentheses, (String)"<this>");
        return (PsiElement)((KtParenthesizedExpression)$this$getExpressionInParentheses).getExpression();
    }

    @Override
    @Nullable
    public PsiElement getAnnotatedExpression(@NotNull PsiElement $this$getAnnotatedExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotatedExpression, (String)"<this>");
        return (PsiElement)((KtAnnotatedExpression)$this$getAnnotatedExpression).getBaseExpression();
    }

    @Override
    @Nullable
    public PsiElement getLabeledExpression(@NotNull PsiElement $this$getLabeledExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getLabeledExpression, (String)"<this>");
        return (PsiElement)((KtLabeledExpression)$this$getLabeledExpression).getBaseExpression();
    }

    @Override
    @Nullable
    public PsiElement getReceiverExpression(@Nullable PsiElement $this$receiverExpression) {
        KtQualifiedExpression ktQualifiedExpression = $this$receiverExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$receiverExpression : null;
        return (PsiElement)(ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null);
    }

    @Override
    @Nullable
    public PsiElement getSelectorExpression(@Nullable PsiElement $this$selectorExpression) {
        KtQualifiedExpression ktQualifiedExpression = $this$selectorExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$selectorExpression : null;
        return (PsiElement)(ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null);
    }

    @Override
    @Nullable
    public PsiElement getArrayExpression(@Nullable PsiElement $this$arrayExpression) {
        KtArrayAccessExpression ktArrayAccessExpression = $this$arrayExpression instanceof KtArrayAccessExpression ? (KtArrayAccessExpression)$this$arrayExpression : null;
        return (PsiElement)(ktArrayAccessExpression != null ? ktArrayAccessExpression.getArrayExpression() : null);
    }

    @Override
    @Nullable
    public List<PsiElement> getIndexExpressions(@Nullable PsiElement $this$indexExpressions) {
        KtArrayAccessExpression ktArrayAccessExpression = $this$indexExpressions instanceof KtArrayAccessExpression ? (KtArrayAccessExpression)$this$indexExpressions : null;
        return ktArrayAccessExpression != null ? ktArrayAccessExpression.getIndexExpressions() : null;
    }

    private final Visibility getVisibility(KtModifierListOwner $this$visibility) {
        KtModifierList $this$_get_visibility__u24lambda_u241 = $this$visibility.getModifierList();
        boolean bl = false;
        return $this$_get_visibility__u24lambda_u241 == null ? (Visibility)Visibilities.Unknown.INSTANCE : ($this$_get_visibility__u24lambda_u241.hasModifier(KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : ($this$_get_visibility__u24lambda_u241.hasModifier(KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : ($this$_get_visibility__u24lambda_u241.hasModifier(KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : ($this$_get_visibility__u24lambda_u241.hasModifier(KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : (Visibility)Visibilities.Unknown.INSTANCE))));
    }

    private final Modality getModality(KtDeclaration $this$modality) {
        KtModifierList $this$_get_modality__u24lambda_u242 = $this$modality.getModifierList();
        boolean bl = false;
        return $this$_get_modality__u24lambda_u242 == null ? null : ($this$_get_modality__u24lambda_u242.hasModifier(KtTokens.FINAL_KEYWORD) ? Modality.FINAL : ($this$_get_modality__u24lambda_u242.hasModifier(KtTokens.SEALED_KEYWORD) ? ($this$modality instanceof KtClassOrObject ? Modality.SEALED : null) : ($this$_get_modality__u24lambda_u242.hasModifier(KtTokens.ABSTRACT_KEYWORD) ? Modality.ABSTRACT : ($this$_get_modality__u24lambda_u242.hasModifier(KtTokens.OPEN_KEYWORD) ? Modality.OPEN : null))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u000e\b\b\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0082\b\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0082\bJ'\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011H\u0082\bJ!\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011H\u0082\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0'H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020-H\u0016J-\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106J3\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0019\b\u0002\u0010=\u001a\u0013\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00030>\u00a2\u0006\u0002\b@H\u0002J@\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\n\u0010E\u001a\u0006\u0012\u0002\b\u00030F2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u001b2\u0006\u0010H\u001a\u00020I2\u000e\b\u0002\u0010J\u001a\b\u0012\u0004\u0012\u00020K0'H\u0016J\u001c\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\n\u0010P\u001a\u0006\u0012\u0002\b\u00030QH\u0002J\"\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\b\u0010V\u001a\u0004\u0018\u00010W2\u0006\u00100\u001a\u000201H\u0002J\u001a\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010\u00072\u0006\u0010[\u001a\u00020\\H\u0002J\u001d\u0010]\u001a\u00020\u00022\u0006\u0010$\u001a\u00020^2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010`J\u001d\u0010a\u001a\u00020\u00022\u0006\u0010b\u001a\u00020c2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010dJ\u001d\u0010e\u001a\u00020\u00022\u0006\u0010f\u001a\u00020g2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010hJ\u001d\u0010i\u001a\u00020\u00022\u0006\u0010$\u001a\u00020j2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010kJ\u001d\u0010l\u001a\u00020\u00022\u0006\u0010$\u001a\u00020m2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010nJ\u001d\u0010o\u001a\u00020\u00022\u0006\u0010$\u001a\u00020p2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010qJ\u001d\u0010r\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010sJ\u001d\u0010t\u001a\u00020\u00022\u0006\u0010$\u001a\u00020u2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010vJ\u001d\u0010w\u001a\u00020\u00022\u0006\u0010$\u001a\u00020x2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010yJ\u001d\u0010z\u001a\u00020\u00022\u0006\u0010$\u001a\u00020{2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010|J\u001d\u0010}\u001a\u00020\u00022\u0006\u0010$\u001a\u00020~2\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u007fJ!\u0010\u0080\u0001\u001a\u00020\u00022\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0083\u0001J \u0010\u0084\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u0085\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0086\u0001J \u0010\u0087\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u0088\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0089\u0001J \u0010\u008a\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u008b\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001J!\u0010\u008d\u0001\u001a\u00020\u00022\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0090\u0001J \u0010\u0091\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u0092\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J\u001f\u0010\u0094\u0001\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00072\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u0095\u0001J\"\u0010\u0096\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u0097\u00012\b\u0010_\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0098\u0001J \u0010\u0099\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u009a\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u009b\u0001J \u0010\u009c\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u009d\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u009e\u0001J!\u0010\u009f\u0001\u001a\u00020\u00022\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00a2\u0001J \u0010\u00a3\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00a4\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00a5\u0001J \u0010\u00a6\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00a7\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00a8\u0001J!\u0010\u00a9\u0001\u001a\u00020\u00022\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00ac\u0001J \u0010\u00ad\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00ae\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00af\u0001J \u0010\u00b0\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00b1\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00b2\u0001J\u001f\u0010\u00b3\u0001\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00b4\u0001J \u0010\u00b5\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00b6\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00b7\u0001J \u0010\u00b8\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00b9\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00ba\u0001J!\u0010\u00bb\u0001\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\b\u0010_\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u00bc\u0001J \u0010\u00bd\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00be\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00bf\u0001J \u0010\u00c0\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00c1\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00c2\u0001J \u0010\u00c3\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00c4\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00c5\u0001J \u0010\u00c6\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00c7\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00c8\u0001J \u0010\u00c9\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00ca\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00cb\u0001J \u0010\u00cc\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00cd\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00ce\u0001J!\u0010\u00cf\u0001\u001a\u00020\u00022\b\u0010\u00d0\u0001\u001a\u00030\u00d1\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00d2\u0001J!\u0010\u00d3\u0001\u001a\u00020\u00022\u0006\u0010N\u001a\u00020O2\b\u0010_\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u00d4\u0001J!\u0010\u00d5\u0001\u001a\u00020\u00022\b\u0010\u00d6\u0001\u001a\u00030\u00d7\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00d8\u0001J!\u0010\u00d9\u0001\u001a\u00020\u00022\b\u0010\u00da\u0001\u001a\u00030\u00db\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00dc\u0001J \u0010\u00dd\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00de\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00df\u0001J \u0010\u00e0\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00e1\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00e2\u0001J \u0010\u00e3\u0001\u001a\u00020\u00022\u0007\u0010$\u001a\u00030\u00e4\u00012\u0006\u0010_\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u00e5\u0001J%\u0010\u00e6\u0001\u001a\u00020\u0003*\n\u0012\u0005\u0012\u00030\u00e8\u00010\u00e7\u00012\u000e\u0010\u00e9\u0001\u001a\t\u0012\u0005\u0012\u00030\u00d7\u00010'H\u0002J \u0010\u00ea\u0001\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0007\u0012\u0005\u0018\u00010\u00ec\u00010\u00eb\u0001*\u00030\u00ed\u0001H\u0002J\u0017\u0010\u00ee\u0001\u001a\u00020\u0018*\u00030\u00ef\u00012\u0007\u0010\u00f0\u0001\u001a\u00020\u001bH\u0002J\"\u0010\u00ee\u0001\u001a\u0003H\u00f1\u0001\"\u000b\b\u0000\u0010\u00f1\u0001\u0018\u0001*\u00020\u0002*\u00020-H\u0082\b\u00a2\u0006\u0003\u0010\u00f2\u0001J&\u0010\u00f3\u0001\u001a\u0005\u0018\u0001H\u00f1\u0001\"\u000b\b\u0000\u0010\u00f1\u0001\u0018\u0001*\u00020\u0002*\u0004\u0018\u00010-H\u0082\b\u00a2\u0006\u0003\u0010\u00f2\u0001J\u0018\u0010\u00f4\u0001\u001a\u00020\u0003*\u00030\u00f5\u00012\b\u0010\u00f6\u0001\u001a\u00030\u00f7\u0001H\u0002J\u0018\u0010\u00f8\u0001\u001a\u00020\u0003*\u00030\u00f7\u00012\b\u0010\u00f9\u0001\u001a\u00030\u00fa\u0001H\u0002J\u0018\u0010\u00f8\u0001\u001a\u00020\u0003*\u00030\u00f7\u00012\b\u0010\u00f9\u0001\u001a\u00030\u00fb\u0001H\u0002J\u0018\u0010\u00fc\u0001\u001a\u00020\u0003*\u00030\u00fd\u00012\b\u0010\u00f9\u0001\u001a\u00030\u00fe\u0001H\u0002J\u001e\u0010\u00ff\u0001\u001a\u00020\u0003*\u00030\u0080\u00022\u000e\u0010\u0081\u0002\u001a\t\u0012\u0004\u0012\u00020\u001e0\u00e7\u0001H\u0002Jn\u0010\u0082\u0002\u001a\u001f\u0012\u0004\u0012\u00020\u001b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u000205\u0012\u0005\u0012\u00030\u0084\u0002\u0018\u00010\u0083\u00020\u00eb\u0001*\u00030\u0082\u00012\b\u0010\u00f9\u0001\u001a\u00030\u0085\u00022\t\u0010\u0086\u0002\u001a\u0004\u0018\u00010\u001b2\t\u0010\u0087\u0002\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0088\u0002\u001a\u00030\u0089\u00022\u000e\u0010\u008a\u0002\u001a\t\u0012\u0005\u0012\u00030\u008b\u00020'2\u0007\u0010\u008c\u0002\u001a\u00020\u0006H\u0002J$\u0010\u008d\u0002\u001a\u00020\u0003*\u00030\u008e\u00022\b\u0010\u00f9\u0001\u001a\u00030\u008f\u00022\n\u0010P\u001a\u0006\u0012\u0002\b\u00030QH\u0002J$\u0010\u008d\u0002\u001a\u00020\u0003*\u00030\u008e\u00022\b\u0010\u00f9\u0001\u001a\u00030\u0090\u00022\n\u0010P\u001a\u0006\u0012\u0002\b\u00030QH\u0002JH\u0010\u0091\u0002\u001a\u00020\u0003*\u00030\u00ed\u00012\b\u0010\u00f9\u0001\u001a\u00030\u0092\u00022\n\u0010E\u001a\u0006\u0012\u0002\b\u00030F2\u0006\u0010H\u001a\u00020I2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u001b2\u000e\b\u0002\u0010J\u001a\b\u0012\u0004\u0012\u00020K0'H\u0002J-\u0010\u0093\u0002\u001a\u00020\u0003\"\u000e\b\u0000\u0010\u000f*\u00030\u0094\u0002*\u00030\u0095\u0002*\u00030\u008e\u00022\u0007\u0010\u0096\u0002\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0003\u0010\u0097\u0002J\u0011\u0010\u0098\u0002\u001a\u0005\u0018\u00010\u00ec\u0001*\u00030\u00ed\u0001H\u0002J\u0011\u0010\u0099\u0002\u001a\u0005\u0018\u00010\u009a\u0002*\u00030\u0082\u0001H\u0002J,\u0010\u009b\u0002\u001a\u00030\u009c\u0002*\u0005\u0018\u00010\u009d\u00022\u0006\u00100\u001a\u0002012\b\u0010\u009e\u0002\u001a\u00030\u009f\u00022\u0007\u0010\u00a0\u0002\u001a\u00020\u001bH\u0002J\u000f\u0010\u00a1\u0002\u001a\u00020\u0015*\u0004\u0018\u00010\u0007H\u0002J]\u0010\u00a2\u0002\u001a\u00030\u00a3\u0002*\u0005\u0018\u00010\u00a4\u00022\n\u0010\u00a5\u0002\u001a\u0005\u0018\u00010\u00a6\u00022\t\u0010\u00a7\u0002\u001a\u0004\u0018\u00010\u001b2\u0007\u0010\u0086\u0002\u001a\u00020\u001b2\b\u0010\u00a8\u0002\u001a\u00030\u0082\u00012\u000e\u0010\u00a9\u0002\u001a\t\u0012\u0005\u0012\u00030\u008b\u00020'2\u0007\u0010\u008c\u0002\u001a\u00020\u00062\u0007\u0010\u00aa\u0002\u001a\u00020\u0006H\u0004J;\u0010\u00a2\u0002\u001a\u00030\u00a3\u0002*\u00030\u00ab\u00022\u0007\u0010\u00ac\u0002\u001a\u00020\u001b2\u0007\u0010\u00ad\u0002\u001a\u00020\u001b2\b\u0010\u00a8\u0002\u001a\u00030\u0082\u00012\u000e\u0010\u00a9\u0002\u001a\t\u0012\u0005\u0012\u00030\u008b\u00020'H\u0004JE\u0010\u00ae\u0002\u001a\u00030\u0094\u0002*\u00020W2\u0007\u0010\u00af\u0002\u001a\u00020\u001b2\b\u0010\u00b0\u0002\u001a\u00030\u00b1\u00022\b\u0010\u00a8\u0002\u001a\u00030\u0082\u00012\b\u0010\u00b2\u0002\u001a\u00030\u0085\u00022\u000e\u0010\u00a9\u0002\u001a\t\u0012\u0005\u0012\u00030\u008b\u00020'H\u0002J\"\u0010\u00b3\u0002\u001a\u00030\u0094\u0002*\u00030\u00b4\u00022\b\u0010\u00b5\u0002\u001a\u00030\u00b1\u00022\u0007\u0010\u00b6\u0002\u001a\u00020\u0006H\u0004J\u001e\u0010\u00b7\u0002\u001a\u00020\u001e*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00112\u0007\u0010\u00b8\u0002\u001a\u00020<H\u0002J$\u0010\u00b7\u0002\u001a\u00020\u001e*\u0004\u0018\u00010-2\u0007\u0010\u00b8\u0002\u001a\u00020<2\n\b\u0002\u0010\u00b9\u0002\u001a\u00030\u00ba\u0002H\u0002J\u0010\u0010\u00b7\u0002\u001a\u00020\u001e*\u0005\u0018\u00010\u00bb\u0002H\u0002J\u0010\u0010\u00bc\u0002\u001a\u00020\u001b*\u0005\u0018\u00010\u00db\u0001H\u0002J\u0010\u0010\u00bd\u0002\u001a\u00020\u001b*\u0005\u0018\u00010\u00db\u0001H\u0002J\u0010\u0010\u00be\u0002\u001a\u00020\u001b*\u0005\u0018\u00010\u00db\u0001H\u0002J\u0016\u0010\u00bf\u0002\u001a\u00020/*\u00020D2\u0007\u0010\u00c0\u0002\u001a\u00020BH\u0002J1\u0010\u00bf\u0002\u001a\u00020/\"\u0004\b\u0000\u0010\u000f*\u0002012\f\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u0001032\u000e\u0010\u00c1\u0002\u001a\t\u0012\u0004\u0012\u0002H\u000f0\u00c2\u0002H\u0002JU\u0010\u00c3\u0002\u001a\u0005\u0018\u00010\u00c4\u0002*\u0005\u0018\u00010\u00c5\u00022\u0006\u00100\u001a\u0002012\u0007\u0010\u00c6\u0002\u001a\u00020\u001b2\b\u0010\u009e\u0002\u001a\u00030\u009f\u00022\u0007\u0010\u00c7\u0002\u001a\u00020\u00062\r\u0010\u00c8\u0002\u001a\b\u0012\u0004\u0012\u00020K0'2\r\u0010\u00c9\u0002\u001a\b\u0012\u0004\u0012\u00020K0'H\u0002J\u000e\u0010\u00ca\u0002\u001a\u00030\u00cb\u0002*\u00020\u0007H\u0002J\u001e\u0010\u00ca\u0002\u001a\u00030\u00cb\u0002*\u00020\u00072\r\u0010\u00cc\u0002\u001a\b\u0012\u0004\u0012\u00020<0\u0011H\u0082\bJ9\u0010\u00cd\u0002\u001a\u00020B*\u00020D2\b\u0010G\u001a\u0004\u0018\u00010\u001b2\n\u0010E\u001a\u0006\u0012\u0002\b\u00030F2\u0006\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K0'H\u0002J\u0010\u0010\u00ce\u0002\u001a\u0004\u0018\u00010\u001e*\u00030\u00cf\u0002H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u00d0\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/builder/RawFirBuilder$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/fir/FirElement;", "", "(Lorg/jetbrains/kotlin/fir/builder/RawFirBuilder;)V", "usedAsExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getUsedAsExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "buildErrorTopLevelDeclarationForDanglingModifierList", "Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "buildOrLazy", "T", "build", "Lkotlin/Function0;", "lazy", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "buildOrLazyBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "buildBlock", "buildOrLazyDelegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "isThis", "constructedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "buildCall", "buildOrLazyExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "sourceElement", "Lorg/jetbrains/kotlin/KtSourceElement;", "buildExpression", "configureBlockWithoutBuilding", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirBlockBuilder;", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "convertContextReceivers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirContextReceiver;", "receivers", "Lorg/jetbrains/kotlin/psi/KtContextReceiver;", "convertElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "convertProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "ownerRegularClassTypeParametersCount", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "convertScript", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "fileName", "", "setup", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirScriptBuilder;", "Lkotlin/ExtensionFunctionType;", "convertValueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "valueParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "functionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "defaultTypeRef", "valueParameterDeclaration", "Lorg/jetbrains/kotlin/fir/builder/BaseFirBuilder$ValueParameterDeclaration;", "additionalAnnotations", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "extractTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "declarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "obtainPropertyComponentStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "componentVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "splitToCalleeAndReceiver", "Lorg/jetbrains/kotlin/fir/builder/CalleeAndReceiver;", "calleeExpression", "defaultSource", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "visitAnnotatedExpression", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "data", "(Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitAnonymousInitializer", "initializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "(Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitBlockExpression", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "(Lorg/jetbrains/kotlin/psi/KtBreakExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "(Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "(Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitCollectionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "(Lorg/jetbrains/kotlin/psi/KtContinueExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitDestructuringDeclaration", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "(Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "(Lorg/jetbrains/kotlin/psi/KtLabeledExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "(Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitProperty", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitScript", "(Lorg/jetbrains/kotlin/psi/KtScript;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitSuperExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "(Lorg/jetbrains/kotlin/psi/KtSuperExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "(Lorg/jetbrains/kotlin/psi/KtThisExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "(Lorg/jetbrains/kotlin/psi/KtThrowExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "(Lorg/jetbrains/kotlin/psi/KtTryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitTypeParameter", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "(Lorg/jetbrains/kotlin/psi/KtTypeProjection;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "(Lorg/jetbrains/kotlin/psi/KtWhileExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/fir/FirElement;", "appendTypeArguments", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "args", "buildFirBody", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "convert", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "delegatedType", "R", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/fir/FirElement;", "convertSafe", "extractAnnotationsFrom", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirDefaultPropertyAccessor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "extractAnnotationsTo", "container", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "Lorg/jetbrains/kotlin/fir/builder/FirAnnotationContainerBuilder;", "extractArgumentsTo", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "extractRawEffects", "Lorg/jetbrains/kotlin/psi/KtContractEffectList;", "destination", "extractSuperTypeListEntriesTo", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "delegatedSelfTypeRef", "delegatedEnumSuperTypeRef", "classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "containerTypeParameters", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "containingClassIsExpectClass", "extractTypeParametersTo", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirTypeParameterRefsOwnerBuilder;", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirTypeParametersOwnerBuilder;", "extractValueParametersTo", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirFunctionBuilder;", "fillDanglingConstraintsTo", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "to", "(Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "obtainContractDescription", "obtainDispatchReceiverForConstructor", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "toFirBackingField", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "Lorg/jetbrains/kotlin/psi/KtBackingField;", "propertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "propertyReturnType", "toFirBlock", "toFirConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "superTypeCallEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "delegatedSuperTypeRef", "owner", "ownerTypeParameters", "copyConstructedTypeRefWithImplicitSource", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "delegatedTypeRef", "selfTypeRef", "toFirDeclaration", "delegatedSuperType", "delegatedSelfType", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "ownerClassBuilder", "toFirEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "delegatedEnumSelfTypeRef", "ownerClassHasDefaultConstructor", "toFirExpression", "errorReason", "kind", "Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "toFirOrErrorType", "toFirOrImplicitType", "toFirOrUnitType", "toFirProperty", "firParameter", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "toFirPropertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "propertyTypeRef", "isGetter", "accessorAnnotationsFromProperty", "parameterAnnotationsFromProperty", "toFirStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "errorReasonLazy", "toFirValueParameter", "toInitializerExpression", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithInitializer;", "psi2fir"})
    @SourceDebugExtension(value={"SMAP\nRawFirBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/RawFirBuilder$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RawFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/RawFirBuilder\n+ 4 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n+ 5 FirErrorExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirErrorExpressionBuilderKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 8 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n+ 9 FirPropertyAccessorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyAccessorBuilderKt\n+ 10 FirDefaultSetterValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirDefaultSetterValueParameterBuilderKt\n+ 11 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 12 FirBackingFieldBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirBackingFieldBuilderKt\n+ 13 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 14 FirPropertyBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilderKt\n+ 15 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 16 FirPropertyFromParameterResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirPropertyFromParameterResolvedNamedReferenceBuilderKt\n+ 17 FirTypeParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirTypeParameterBuilderKt\n+ 18 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 19 FirErrorAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirErrorAnnotationCallBuilderKt\n+ 20 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 21 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 22 FirLambdaArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirLambdaArgumentExpressionBuilderKt\n+ 23 FirFieldBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirFieldBuilderKt\n+ 24 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 25 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 26 FirDelegatedConstructorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirDelegatedConstructorCallBuilderKt\n+ 27 FirExplicitSuperReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirExplicitSuperReferenceBuilderKt\n+ 28 FirPrimaryConstructorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPrimaryConstructorBuilderKt\n+ 29 FirFileBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirFileBuilderKt\n+ 30 FirPackageDirectiveBuilder.kt\norg/jetbrains/kotlin/fir/builder/FirPackageDirectiveBuilderKt\n+ 31 FirFileAnnotationsContainerBuilder.kt\norg/jetbrains/kotlin/fir/builder/FirFileAnnotationsContainerBuilderKt\n+ 32 FirImportBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirImportBuilderKt\n+ 33 FirScriptBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirScriptBuilderKt\n+ 34 FirEnumEntryBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirEnumEntryBuilderKt\n+ 35 BaseFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/BaseFirBuilder\n+ 36 FirAnonymousObjectExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnonymousObjectExpressionBuilderKt\n+ 37 FirAnonymousObjectBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirAnonymousObjectBuilderKt\n+ 38 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 39 FirContextReceiverBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirContextReceiverBuilderKt\n+ 40 FirRegularClassBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirRegularClassBuilderKt\n+ 41 FirTypeAliasBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirTypeAliasBuilderKt\n+ 42 FirAnonymousFunctionExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnonymousFunctionExpressionBuilderKt\n+ 43 FirRawContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirRawContractDescriptionBuilderKt\n+ 44 FirImplicitTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirImplicitTypeRefBuilderKt\n+ 45 FirAnonymousFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirAnonymousFunctionBuilderKt\n+ 46 FirLabelBuilder.kt\norg/jetbrains/kotlin/fir/builder/FirLabelBuilderKt\n+ 47 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 48 FirUnitExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirUnitExpressionBuilderKt\n+ 49 FirConstructorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirConstructorBuilderKt\n+ 50 FirExplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirExplicitThisReferenceBuilderKt\n+ 51 FirAnonymousInitializerBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirAnonymousInitializerBuilderKt\n+ 52 FirFunctionTypeParameterBuilder.kt\norg/jetbrains/kotlin/fir/builder/FirFunctionTypeParameterBuilderKt\n+ 53 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 54 FirStarProjectionBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirStarProjectionBuilderKt\n+ 55 FirPlaceholderProjectionBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirPlaceholderProjectionBuilderKt\n+ 56 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n+ 57 FirTryExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirTryExpressionBuilderKt\n+ 58 FirCatchBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCatchBuilderKt\n+ 59 FirWhenExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenExpressionBuilderKt\n+ 60 FirWhenBranchBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenBranchBuilderKt\n+ 61 FirElseIfTrueConditionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElseIfTrueConditionBuilderKt\n+ 62 FirElseIfTrueConditionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElseIfTrueConditionBuilderKt$buildElseIfTrueCondition$1\n+ 63 FirBlockBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBlockBuilderKt\n+ 64 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 65 FirEqualityOperatorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirEqualityOperatorCallBuilderKt\n+ 66 FirTypeOperatorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirTypeOperatorCallBuilderKt\n+ 67 FirCheckNotNullCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckNotNullCallBuilderKt\n+ 68 FirErrorNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirErrorNamedReferenceBuilderKt\n+ 69 FirQualifiedErrorAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirQualifiedErrorAccessExpressionBuilderKt\n+ 70 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 71 Context.kt\norg/jetbrains/kotlin/fir/builder/Context\n+ 72 FirThrowExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThrowExpressionBuilderKt\n+ 73 FirGetClassCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirGetClassCallBuilderKt\n+ 74 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 75 FirArrayOfCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayOfCallBuilderKt\n+ 76 FirExpressionStubBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirExpressionStubBuilderKt\n+ 77 FirDanglingModifierListBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirDanglingModifierListBuilderKt\n*L\n1#1,2799:1\n179#1,3:2805\n179#1,3:2812\n179#1,3:2819\n173#1:2826\n173#1:2828\n176#1:2846\n176#1:2850\n176#1:2851\n197#1:2852\n179#1,3:2853\n173#1:2872\n189#1:2890\n179#1,3:2891\n176#1:2898\n173#1:2899\n176#1:2901\n176#1:2917\n176#1:2918\n176#1:2923\n189#1:2963\n179#1,3:2964\n205#1:3001\n179#1,2:3002\n181#1:3019\n176#1:3048\n176#1:3053\n189#1:3062\n179#1,2:3063\n181#1:3131\n173#1:3143\n173#1:3252\n189#1:3271\n179#1,3:3272\n173#1:3296\n173#1:3302\n205#1:3332\n179#1,3:3333\n189#1:3360\n179#1,3:3361\n173#1:3372\n176#1:3374\n197#1:3388\n179#1,3:3389\n173#1:3403\n173#1:3419\n176#1:3424\n302#1,3:3445\n305#1,4:3452\n176#1:3468\n176#1:3667\n176#1:3672\n189#1:3673\n179#1,2:3674\n181#1:3680\n1#2:2800\n1#2:2827\n1#2:2829\n1#2:2873\n1#2:2900\n1#2:2943\n1#2:2956\n1#2:3144\n1#2:3253\n1#2:3297\n1#2:3303\n1#2:3373\n1#2:3404\n1#2:3420\n1#2:3421\n75#3,4:2801\n75#3,4:2808\n75#3,4:2815\n75#3,4:2822\n75#3,4:2856\n75#3,4:2894\n75#3,4:2967\n65#3,7:2977\n65#3,7:3012\n75#3,4:3020\n75#3,4:3132\n75#3,4:3275\n75#3,4:3336\n65#3,7:3352\n75#3,4:3364\n75#3,4:3392\n75#3,4:3681\n57#4,4:2830\n61#5,4:2834\n61#5,4:2838\n61#5,4:2842\n61#5,4:3448\n61#5,4:3605\n61#5,4:3676\n1747#6,3:2847\n766#6:2914\n857#6,2:2915\n1603#6,9:2933\n1855#6:2942\n1856#6:2944\n1612#6:2945\n1603#6,9:2946\n1855#6:2955\n1856#6:2957\n1612#6:2958\n1864#6,2:2975\n1866#6:2988\n1620#6,3:2994\n1549#6:3136\n1620#6,2:3137\n1622#6:3145\n288#6,2:3162\n1855#6,2:3164\n766#6:3166\n857#6,2:3167\n800#6,11:3169\n1620#6,2:3269\n1622#6:3279\n766#6:3381\n857#6,2:3382\n1747#6,3:3400\n1603#6,9:3409\n1855#6:3418\n1856#6:3422\n1612#6:3423\n58#7,4:2860\n53#8,4:2864\n99#9,4:2868\n108#10,4:2874\n508#11,4:2878\n508#11,4:2997\n508#11,4:3036\n508#11,4:3044\n508#11,4:3324\n508#11,4:3396\n508#11,4:3485\n508#11,4:3521\n508#11,4:3629\n105#12,4:2882\n96#13,4:2886\n96#13,4:3292\n111#14,4:2902\n111#14,4:3368\n111#14,4:3464\n111#14,4:3495\n68#15,4:2906\n68#15,4:3621\n44#16,4:2910\n70#17,4:2919\n142#18:2924\n142#18:3146\n76#19,4:2925\n41#20,4:2929\n41#20,4:3429\n41#20,4:3533\n41#20,4:3541\n41#20,4:3549\n41#20,4:3573\n41#20,4:3577\n41#20,4:3589\n41#20,4:3597\n41#20,4:3651\n33#21,4:2959\n33#21,4:3601\n33#21,4:3659\n53#22,4:2971\n123#23,4:2984\n51#24,4:2989\n51#24,4:3087\n51#24,4:3094\n26#25:2993\n26#25:3091\n62#26,4:3004\n62#26,4:3340\n41#27,4:3008\n41#27,4:3348\n41#27,4:3625\n105#28,4:3024\n77#29,4:3028\n39#30,4:3032\n50#31,4:3040\n47#32,4:3049\n68#33,4:3054\n89#34,4:3058\n70#35,14:3065\n76#35,21:3098\n85#35,12:3119\n76#35,8:3147\n109#35,3:3155\n113#35,2:3180\n85#35,12:3182\n76#35,8:3194\n85#35,12:3210\n70#35,14:3222\n85#35,12:3240\n109#35,6:3255\n109#35,6:3375\n42#36,4:3079\n42#36,4:3202\n81#37,4:3083\n81#37,4:3206\n20#38,2:3092\n216#38:3254\n216#38:3359\n44#39,4:3139\n89#40,4:3158\n74#41,4:3236\n47#42,4:3261\n47#42,4:3320\n39#43,4:3265\n38#44,4:3280\n38#44,4:3284\n38#44,4:3298\n38#44,4:3304\n122#45,4:3288\n38#46,4:3308\n60#47,4:3312\n47#48,4:3316\n47#48,4:3456\n103#49,4:3328\n41#50,4:3344\n41#50,4:3617\n65#51,4:3384\n42#52,4:3405\n75#53,4:3425\n36#54,4:3433\n36#55,4:3437\n42#56,4:3441\n58#57,4:3460\n42#58,4:3469\n64#59,4:3473\n64#59,4:3499\n42#60,4:3477\n42#60,4:3481\n42#60,4:3503\n42#60,4:3507\n42#60,4:3511\n46#61,5:3489\n46#61,5:3515\n46#62:3494\n46#62:3520\n54#63,4:3525\n73#64,4:3529\n73#64,4:3537\n73#64,4:3545\n73#64,4:3569\n73#64,4:3593\n57#65,4:3553\n61#66,4:3557\n61#66,4:3561\n53#67,4:3565\n40#68,4:3581\n40#68,4:3585\n61#69,4:3609\n82#70,4:3613\n103#71,6:3633\n56#72,4:3639\n51#73,4:3643\n67#74,4:3647\n50#75,4:3655\n47#76,4:3663\n59#77,4:3668\n*S KotlinDebug\n*F\n+ 1 RawFirBuilder.kt\norg/jetbrains/kotlin/fir/builder/RawFirBuilder$Visitor\n*L\n189#1:2805,3\n197#1:2812,3\n205#1:2819,3\n247#1:2826\n250#1:2828\n313#1:2846\n346#1:2850\n365#1:2851\n371#1:2852\n371#1:2853,3\n451#1:2872\n594#1:2890\n594#1:2891,3\n602#1:2898\n617#1:2899\n628#1:2901\n706#1:2917\n714#1:2918\n750#1:2923\n823#1:2963\n823#1:2964,3\n960#1:3001\n960#1:3002,2\n960#1:3019\n1035#1:3048\n1059#1:3053\n1118#1:3062\n1118#1:3063,2\n1118#1:3131\n1185#1:3143\n1420#1:3252\n1528#1:3271\n1528#1:3272,3\n1566#1:3296\n1584#1:3302\n1661#1:3332\n1661#1:3333,3\n1716#1:3360\n1716#1:3361,3\n1740#1:3372\n1745#1:3374\n1862#1:3388\n1862#1:3389,3\n1949#1:3403\n1965#1:3419\n1985#1:3424\n2042#1:3445,3\n2042#1:3452,4\n2129#1:3468\n2765#1:3667\n2776#1:3672\n1820#1:3673\n1820#1:3674,2\n1820#1:3680\n247#1:2827\n250#1:2829\n451#1:2873\n617#1:2900\n788#1:2943\n789#1:2956\n1185#1:3144\n1420#1:3253\n1566#1:3297\n1584#1:3303\n1740#1:3373\n1949#1:3404\n1965#1:3420\n1964#1:3421\n181#1:2801,4\n189#1:2808,4\n197#1:2815,4\n205#1:2822,4\n371#1:2856,4\n594#1:2894,4\n823#1:2967,4\n860#1:2977,7\n971#1:3012,7\n960#1:3020,4\n1118#1:3132,4\n1528#1:3275,4\n1661#1:3336,4\n1710#1:3352,7\n1716#1:3364,4\n1862#1:3392,4\n1820#1:3681,4\n250#1:2830,4\n272#1:2834,4\n290#1:2838,4\n304#1:2842,4\n2042#1:3448,4\n2602#1:3605,4\n1823#1:3676,4\n335#1:2847,3\n681#1:2914\n681#1:2915,2\n788#1:2933,9\n788#1:2942\n788#1:2944\n788#1:2945\n789#1:2946,9\n789#1:2955\n789#1:2957\n789#1:2958\n847#1:2975,2\n847#1:2988\n935#1:2994,3\n1179#1:3136\n1179#1:3137,2\n1179#1:3145\n1260#1:3162,2\n1264#1:3164,2\n1292#1:3166\n1292#1:3167,2\n1292#1:3169,11\n1527#1:3269,2\n1527#1:3279\n1844#1:3381\n1844#1:3382,2\n1948#1:3400,3\n1964#1:3409,9\n1964#1:3418\n1964#1:3422\n1964#1:3423\n407#1:2860,4\n413#1:2864,4\n446#1:2868,4\n465#1:2874,4\n491#1:2878,4\n953#1:2997,4\n1028#1:3036,4\n1033#1:3044,4\n1633#1:3324,4\n1925#1:3396,4\n2162#1:3485,4\n2297#1:3521,4\n2673#1:3629,4\n548#1:2882,4\n581#1:2886,4\n1561#1:3292,4\n630#1:2902,4\n1732#1:3368,4\n2115#1:3464,4\n2184#1:3495,4\n636#1:2906,4\n2648#1:3621,4\n638#1:2910,4\n738#1:2919,4\n752#1:2924\n1194#1:3146\n761#1:2925,4\n770#1:2929,4\n1998#1:3429,4\n2307#1:3533,4\n2319#1:3541,4\n2418#1:3549,4\n2493#1:3573,4\n2512#1:3577,4\n2537#1:3589,4\n2581#1:3597,4\n2737#1:3651,4\n819#1:2959,4\n2586#1:3601,4\n2749#1:3659,4\n825#1:2971,4\n864#1:2984,4\n889#1:2989,4\n1132#1:3087,4\n1144#1:3094,4\n892#1:2993\n1136#1:3091\n961#1:3004,4\n1692#1:3340,4\n965#1:3008,4\n1705#1:3348,4\n2650#1:3625,4\n991#1:3024,4\n1018#1:3028,4\n1026#1:3032,4\n1030#1:3040,4\n1040#1:3049,4\n1070#1:3054,4\n1101#1:3058,4\n1119#1:3065,14\n1158#1:3098,21\n1119#1:3119,12\n1196#1:3147,8\n1225#1:3155,3\n1225#1:3180,2\n1196#1:3182,12\n1344#1:3194,8\n1344#1:3210,12\n1395#1:3222,14\n1395#1:3240,12\n1486#1:3255,6\n1785#1:3375,6\n1120#1:3079,4\n1346#1:3202,4\n1123#1:3083,4\n1348#1:3206,4\n1143#1:3092,2\n1439#1:3254\n1715#1:3359\n1180#1:3139,4\n1227#1:3158,4\n1396#1:3236,4\n1507#1:3261,4\n1632#1:3320,4\n1519#1:3265,4\n1538#1:3280,4\n1541#1:3284,4\n1566#1:3298,4\n1584#1:3304,4\n1546#1:3288,4\n1593#1:3308,4\n1616#1:3312,4\n1619#1:3316,4\n2099#1:3456,4\n1645#1:3328,4\n1701#1:3344,4\n2638#1:3617,4\n1858#1:3384,4\n1953#1:3405,4\n1992#1:3425,4\n2010#1:3433,4\n2017#1:3437,4\n2022#1:3441,4\n2104#1:3460,4\n2135#1:3469,4\n2145#1:3473,4\n2204#1:3499,4\n2151#1:3477,4\n2161#1:3481,4\n2215#1:3503,4\n2226#1:3507,4\n2238#1:3511,4\n2163#1:3489,5\n2240#1:3515,5\n2163#1:3494\n2240#1:3520\n2300#1:3525,4\n2305#1:3529,4\n2317#1:3537,4\n2416#1:3545,4\n2491#1:3569,4\n2578#1:3593,4\n2440#1:3553,4\n2450#1:3557,4\n2459#1:3561,4\n2473#1:3565,4\n2522#1:3581,4\n2528#1:3585,4\n2624#1:3609,4\n2635#1:3613,4\n2675#1:3633,6\n2699#1:3639,4\n2728#1:3643,4\n2735#1:3647,4\n2747#1:3655,4\n2758#1:3663,4\n2769#1:3668,4\n*E\n"})
    protected class Visitor
    extends KtVisitor<FirElement, Unit> {
        private final /* synthetic */ <R extends FirElement> R convertSafe(KtElement $this$convertSafe) {
            FirElement firElement;
            boolean $i$f$convertSafe = false;
            KtElement ktElement = $this$convertSafe;
            if (ktElement != null) {
                KtElement p0 = ktElement;
                boolean bl = false;
                firElement = this.convertElement(p0);
            } else {
                firElement = null;
            }
            Intrinsics.reifiedOperationMarker((int)2, (String)"R");
            return (R)firElement;
        }

        private final /* synthetic */ <R extends FirElement> R convert(KtElement $this$convert) {
            boolean $i$f$convert = false;
            FirElement firElement = this.convertElement($this$convert);
            Intrinsics.reifiedOperationMarker((int)1, (String)"R");
            return (R)firElement;
        }

        private final <T> T buildOrLazy(Function0<? extends T> build2, Function0<? extends T> lazy) {
            Object object;
            boolean $i$f$buildOrLazy = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    object = build2.invoke();
                    break;
                }
                case 2: {
                    RawFirBuilder this_$iv = RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy.invoke();
                            break block0;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return (T)object;
        }

        /*
         * WARNING - void declaration
         */
        private final FirExpression buildOrLazyExpression(KtSourceElement sourceElement, Function0<? extends FirExpression> buildExpression2) {
            Object object;
            void this_$iv;
            boolean $i$f$buildOrLazyExpression = false;
            Visitor visitor2 = this;
            Function0 lazy$iv = (Function0)new Function0<FirExpression>(sourceElement){
                final /* synthetic */ KtSourceElement $sourceElement;
                {
                    this.$sourceElement = $sourceElement;
                    super(0);
                }

                @NotNull
                public final FirExpression invoke() {
                    FirLazyExpressionBuilder firLazyExpressionBuilder;
                    KtSourceElement ktSourceElement = this.$sourceElement;
                    boolean $i$f$buildLazyExpression = false;
                    FirLazyExpressionBuilder $this$invoke_u24lambda_u240 = firLazyExpressionBuilder = new FirLazyExpressionBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setSource(ktSourceElement);
                    return firLazyExpressionBuilder.build();
                }
            };
            boolean $i$f$buildOrLazy = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv.RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    object = buildExpression2.invoke();
                    break;
                }
                case 2: {
                    RawFirBuilder this_$iv$iv = this_$iv.RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy$iv.invoke();
                            break block0;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return (FirExpression)object;
        }

        /*
         * WARNING - void declaration
         */
        private final FirBlock buildOrLazyBlock(Function0<? extends FirBlock> buildBlock2) {
            Object object;
            void this_$iv;
            boolean $i$f$buildOrLazyBlock = false;
            Visitor visitor2 = this;
            Function0 lazy$iv = buildOrLazyBlock.1.INSTANCE;
            boolean $i$f$buildOrLazy = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv.RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    object = buildBlock2.invoke();
                    break;
                }
                case 2: {
                    RawFirBuilder this_$iv$iv = this_$iv.RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy$iv.invoke();
                            break block0;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return (FirBlock)object;
        }

        /*
         * WARNING - void declaration
         */
        private final FirDelegatedConstructorCall buildOrLazyDelegatedConstructorCall(boolean isThis, FirTypeRef constructedTypeRef, Function0<? extends FirDelegatedConstructorCall> buildCall) {
            Object object;
            void this_$iv;
            boolean $i$f$buildOrLazyDelegatedConstructorCall = false;
            Visitor visitor2 = this;
            Function0 lazy$iv = (Function0)new Function0<FirDelegatedConstructorCall>(isThis, constructedTypeRef){
                final /* synthetic */ boolean $isThis;
                final /* synthetic */ FirTypeRef $constructedTypeRef;
                {
                    this.$isThis = $isThis;
                    this.$constructedTypeRef = $constructedTypeRef;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final FirDelegatedConstructorCall invoke() {
                    FirReference firReference;
                    FirLazyDelegatedConstructorCallBuilder firLazyDelegatedConstructorCallBuilder;
                    FirLazyDelegatedConstructorCallBuilder firLazyDelegatedConstructorCallBuilder2;
                    boolean bl = this.$isThis;
                    FirTypeRef firTypeRef = this.$constructedTypeRef;
                    boolean $i$f$buildLazyDelegatedConstructorCall = false;
                    FirLazyDelegatedConstructorCallBuilder $this$invoke_u24lambda_u242 = firLazyDelegatedConstructorCallBuilder2 = new FirLazyDelegatedConstructorCallBuilder();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u242.setThis(bl);
                    $this$invoke_u24lambda_u242.setConstructedTypeRef(firTypeRef);
                    FirLazyDelegatedConstructorCallBuilder firLazyDelegatedConstructorCallBuilder3 = $this$invoke_u24lambda_u242;
                    if (bl) {
                        void $this$invoke_u24lambda_u242_u24lambda_u240;
                        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder;
                        boolean $i$f$buildExplicitThisReference = false;
                        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder2 = firExplicitThisReferenceBuilder = new FirExplicitThisReferenceBuilder();
                        FirLazyDelegatedConstructorCallBuilder firLazyDelegatedConstructorCallBuilder4 = firLazyDelegatedConstructorCallBuilder3;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u242_u24lambda_u240.setSource(null);
                        firLazyDelegatedConstructorCallBuilder = firLazyDelegatedConstructorCallBuilder4;
                        firReference = firExplicitThisReferenceBuilder.build();
                    } else {
                        void $this$invoke_u24lambda_u242_u24lambda_u241;
                        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder;
                        boolean $i$f$buildExplicitSuperReference = false;
                        FirExplicitSuperReferenceBuilder $this$invoke_u24lambda_u242_u24lambda_u240 = firExplicitSuperReferenceBuilder = new FirExplicitSuperReferenceBuilder();
                        FirLazyDelegatedConstructorCallBuilder firLazyDelegatedConstructorCallBuilder5 = firLazyDelegatedConstructorCallBuilder3;
                        boolean bl4 = false;
                        $this$invoke_u24lambda_u242_u24lambda_u241.setSource(null);
                        $this$invoke_u24lambda_u242_u24lambda_u241.setSuperTypeRef(firTypeRef);
                        firLazyDelegatedConstructorCallBuilder = firLazyDelegatedConstructorCallBuilder5;
                        firReference = firExplicitSuperReferenceBuilder.build();
                    }
                    firLazyDelegatedConstructorCallBuilder.setCalleeReference(firReference);
                    return firLazyDelegatedConstructorCallBuilder2.build();
                }
            };
            boolean $i$f$buildOrLazy = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv.RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    object = buildCall.invoke();
                    break;
                }
                case 2: {
                    RawFirBuilder this_$iv$iv = this_$iv.RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy$iv.invoke();
                            break block0;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return (FirDelegatedConstructorCall)object;
        }

        @Nullable
        public FirElement convertElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (FirElement)element.accept(this, Unit.INSTANCE);
        }

        @NotNull
        public FirProperty convertProperty(@NotNull KtProperty property, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @Nullable Integer ownerRegularClassTypeParametersCount) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return this.toFirProperty(property, ownerRegularOrAnonymousObjectSymbol, RawFirBuilder.this.getContext());
        }

        @NotNull
        public FirValueParameter convertValueParameter(@NotNull KtParameter valueParameter2, @NotNull FirFunctionSymbol<?> functionSymbol, @Nullable FirTypeRef defaultTypeRef, @NotNull BaseFirBuilder.ValueParameterDeclaration valueParameterDeclaration2, @NotNull List<? extends FirAnnotation> additionalAnnotations) {
            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
            Intrinsics.checkNotNullParameter(functionSymbol, (String)"functionSymbol");
            Intrinsics.checkNotNullParameter((Object)((Object)valueParameterDeclaration2), (String)"valueParameterDeclaration");
            Intrinsics.checkNotNullParameter(additionalAnnotations, (String)"additionalAnnotations");
            return this.toFirValueParameter(valueParameter2, defaultTypeRef, functionSymbol, valueParameterDeclaration2, additionalAnnotations);
        }

        public static /* synthetic */ FirValueParameter convertValueParameter$default(Visitor visitor2, KtParameter ktParameter, FirFunctionSymbol firFunctionSymbol, FirTypeRef firTypeRef, BaseFirBuilder.ValueParameterDeclaration valueParameterDeclaration2, List list2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertValueParameter");
            }
            if ((n & 4) != 0) {
                firTypeRef = null;
            }
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            return visitor2.convertValueParameter(ktParameter, firFunctionSymbol, firTypeRef, valueParameterDeclaration2, list2);
        }

        private final FirTypeRef toFirOrImplicitType(KtTypeReference $this$toFirOrImplicitType) {
            Object object = $this$toFirOrImplicitType;
            if (object == null || (object = this.toFirOrErrorType((KtTypeReference)object)) == null) {
                object = FirImplicitTypeRefImplWithoutSource.INSTANCE;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final FirTypeRef toFirOrUnitType(KtTypeReference $this$toFirOrUnitType) {
            FirTypeRef firTypeRef;
            FirElement firElement;
            FirElement firElement2;
            Visitor visitor2 = this;
            KtElement $this$convertSafe$iv = $this$toFirOrUnitType;
            boolean $i$f$convertSafe = false;
            KtElement ktElement = $this$convertSafe$iv;
            if (ktElement != null) {
                void this_$iv;
                KtElement p0$iv = ktElement;
                boolean bl = false;
                firElement2 = this_$iv.convertElement(p0$iv);
            } else {
                firElement2 = firElement = null;
            }
            if (!(firElement2 instanceof FirTypeRef)) {
                firElement = null;
            }
            if ((firTypeRef = (FirTypeRef)((FirElement)((FirTypeRef)firElement))) == null) {
                firTypeRef = RawFirBuilder.this.getImplicitUnitType();
            }
            return firTypeRef;
        }

        /*
         * WARNING - void declaration
         */
        private final FirTypeRef toFirOrErrorType(KtTypeReference $this$toFirOrErrorType) {
            FirTypeRef firTypeRef;
            FirElement firElement;
            FirElement firElement2;
            Object object = this;
            KtElement $this$convertSafe$iv = $this$toFirOrErrorType;
            boolean $i$f$convertSafe = false;
            KtElement ktElement = $this$convertSafe$iv;
            if (ktElement != null) {
                void this_$iv;
                KtElement p0$iv = ktElement;
                boolean bl = false;
                firElement2 = this_$iv.convertElement(p0$iv);
            } else {
                firElement2 = firElement = null;
            }
            if (!(firElement2 instanceof FirTypeRef)) {
                firElement = null;
            }
            if ((firTypeRef = (FirTypeRef)((FirElement)((FirTypeRef)firElement))) == null) {
                FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                object = RawFirBuilder.this;
                boolean $i$f$buildErrorTypeRef = false;
                FirErrorTypeRefBuilder $this$toFirOrErrorType_u24lambda_u240 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl = false;
                $this$toFirOrErrorType_u24lambda_u240.setSource($this$toFirOrErrorType != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)object, $this$toFirOrErrorType, null, 1, null) : null);
                $this$toFirOrErrorType_u24lambda_u240.setDiagnostic(new ConeSimpleDiagnostic($this$toFirOrErrorType == null ? "Incomplete code" : "Conversion failed", DiagnosticKind.Syntax));
                firTypeRef = firErrorTypeRefBuilder.build();
            }
            return firTypeRef;
        }

        private final FirExpression toFirExpression(Function0<? extends KtExpression> $this$toFirExpression, String errorReason) {
            return Visitor.toFirExpression$default(this, (KtElement)$this$toFirExpression.invoke(), errorReason, null, 2, null);
        }

        private final FirExpression toFirExpression(KtElement $this$toFirExpression, String errorReason, DiagnosticKind kind) {
            KtSourceElement ktSourceElement;
            FirErrorExpressionBuilder firErrorExpressionBuilder;
            PsiElement callExpressionCallee;
            if ($this$toFirExpression == null) {
                return FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic(errorReason, kind), null, 4, null);
            }
            FirElement fir = this.convertElement($this$toFirExpression);
            if (!(fir instanceof FirExpression)) {
                FirErrorExpressionBuilder firErrorExpressionBuilder2;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildErrorExpression = false;
                FirErrorExpressionBuilder $this$toFirExpression_u24lambda_u241 = firErrorExpressionBuilder2 = new FirErrorExpressionBuilder();
                boolean bl = false;
                $this$toFirExpression_u24lambda_u241.setNonExpressionElement(fir);
                $this$toFirExpression_u24lambda_u241.setDiagnostic(new ConeSimpleDiagnostic(errorReason, kind));
                $this$toFirExpression_u24lambda_u241.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, $this$toFirExpression, null, 1, null));
                return firErrorExpressionBuilder2.build();
            }
            FirExpression result2 = (FirExpression)fir;
            KtExpression ktExpression = $this$toFirExpression instanceof KtCallExpression ? (KtCallExpression)$this$toFirExpression : null;
            PsiElement psiElement = ktExpression != null && (ktExpression = ktExpression.getCalleeExpression()) != null ? PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations((PsiElement)ktExpression) : (callExpressionCallee = null);
            if ($this$toFirExpression instanceof KtNameReferenceExpression || $this$toFirExpression instanceof KtCallExpression && !(callExpressionCallee instanceof KtLambdaExpression) || KtPsiUtilKt.getQualifiedExpressionForSelector($this$toFirExpression) == null) {
                return result2;
            }
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildErrorExpression = false;
            FirErrorExpressionBuilder $this$toFirExpression_u24lambda_u242 = firErrorExpressionBuilder = new FirErrorExpressionBuilder();
            boolean bl = false;
            $this$toFirExpression_u24lambda_u242.setSource(callExpressionCallee != null && (ktSourceElement = BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, callExpressionCallee, null, 1, null)) != null ? ktSourceElement : BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, $this$toFirExpression, null, 1, null));
            $this$toFirExpression_u24lambda_u242.setDiagnostic(new ConeSimpleDiagnostic("The expression cannot be a selector (occur after a dot)", callExpressionCallee == null ? DiagnosticKind.IllegalSelector : DiagnosticKind.NoReceiverAllowed));
            $this$toFirExpression_u24lambda_u242.setExpression(result2);
            return firErrorExpressionBuilder.build();
        }

        static /* synthetic */ FirExpression toFirExpression$default(Visitor visitor2, KtElement ktElement, String string2, DiagnosticKind diagnosticKind, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toFirExpression");
            }
            if ((n & 2) != 0) {
                diagnosticKind = DiagnosticKind.ExpressionExpected;
            }
            return visitor2.toFirExpression(ktElement, string2, diagnosticKind);
        }

        private final FirStatement toFirStatement(KtExpression $this$toFirStatement, Function0<String> errorReasonLazy) {
            FirStatement firStatement;
            boolean $i$f$toFirStatement = false;
            FirElement fir = this.convertElement($this$toFirStatement);
            if (fir instanceof FirStatement) {
                firStatement = (FirStatement)fir;
            } else {
                FirErrorExpressionBuilder firErrorExpressionBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildErrorExpression = false;
                FirErrorExpressionBuilder $this$toFirStatement_u24lambda_u243 = firErrorExpressionBuilder = new FirErrorExpressionBuilder();
                boolean bl = false;
                $this$toFirStatement_u24lambda_u243.setNonExpressionElement(fir);
                $this$toFirStatement_u24lambda_u243.setDiagnostic(new ConeSimpleDiagnostic((String)errorReasonLazy.invoke(), DiagnosticKind.Syntax));
                $this$toFirStatement_u24lambda_u243.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, $this$toFirStatement, null, 1, null));
                firStatement = firErrorExpressionBuilder.build();
            }
            return firStatement;
        }

        /*
         * WARNING - void declaration
         */
        private final FirStatement toFirStatement(KtExpression $this$toFirStatement) {
            void this_$iv;
            Visitor visitor2 = this;
            KtElement $this$convert$iv = $this$toFirStatement;
            boolean $i$f$convert = false;
            FirElement firElement = this_$iv.convertElement($this$convert$iv);
            if (firElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            }
            return (FirStatement)((FirElement)((FirStatement)firElement));
        }

        /*
         * Unable to fully structure code
         */
        private final FirDeclaration toFirDeclaration(KtDeclaration $this$toFirDeclaration, FirTypeRef delegatedSuperType, FirResolvedTypeRef delegatedSelfType, KtClassOrObject owner, FirClassBuilder ownerClassBuilder, List<? extends FirTypeParameterRef> ownerTypeParameters) {
            block10: {
                block11: {
                    block13: {
                        block8: {
                            block12: {
                                block9: {
                                    var7_7 = $this$toFirDeclaration;
                                    if (!(var7_7 instanceof KtSecondaryConstructor)) break block9;
                                    v0 = this.toFirConstructor((KtSecondaryConstructor)$this$toFirDeclaration, ((KtSecondaryConstructor)$this$toFirDeclaration).isDelegatedCallToThis() != false ? (FirTypeRef)delegatedSelfType : delegatedSuperType, delegatedSelfType, owner, ownerTypeParameters);
                                    break block10;
                                }
                                if (!(var7_7 instanceof KtEnumEntry)) break block11;
                                primaryConstructor = owner.getPrimaryConstructor();
                                v1 = primaryConstructor;
                                if (v1 == null || (v1 = v1.getValueParameters()) == null) break block12;
                                v2 = v1.isEmpty();
                                break block13;
                            }
                            constructors = owner.getSecondaryConstructors();
                            $i$a$-let-RawFirBuilder$Visitor$toFirDeclaration$ownerClassHasDefaultConstructor$1 = false;
                            if (constructors.isEmpty()) ** GOTO lbl-1000
                            $this$any$iv = constructors;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v3 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (KtSecondaryConstructor)element$iv;
                                    $i$a$-any-RawFirBuilder$Visitor$toFirDeclaration$ownerClassHasDefaultConstructor$1$1 = false;
                                    if (!it.getValueParameters().isEmpty()) continue;
                                    v3 = true;
                                    break block8;
                                }
                                v3 = false;
                            }
                        }
                        if (v3) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                    }
                    ownerClassHasDefaultConstructor = v2;
                    v0 = this.toFirEnumEntry((KtEnumEntry)$this$toFirDeclaration, delegatedSelfType, ownerClassHasDefaultConstructor);
                    break block10;
                }
                if (var7_7 instanceof KtProperty) {
                    v0 = this.convertProperty((KtProperty)$this$toFirDeclaration, ConversionUtilsKt.getOwnerRegularOrAnonymousObjectSymbol(ownerClassBuilder), ConversionUtilsKt.getOwnerRegularClassTypeParametersCount(ownerClassBuilder));
                } else {
                    primaryConstructor = this;
                    $this$convert$iv = $this$toFirDeclaration;
                    $i$f$convert = false;
                    v4 = this_$iv.convertElement($this$convert$iv);
                    if (v4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
                    }
                    v0 = (FirDeclaration)((FirElement)((FirDeclaration)v4));
                }
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        private final FirBlock toFirBlock(KtExpression $this$toFirBlock) {
            FirBlock firBlock;
            KtExpression ktExpression = $this$toFirBlock;
            if (ktExpression instanceof KtBlockExpression) {
                Object r = $this$toFirBlock.accept(this, Unit.INSTANCE);
                Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirBlock");
                firBlock = (FirBlock)r;
            } else if (ktExpression == null) {
                firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
            } else {
                FirBlock firBlock2 = null;
                if ($this$toFirBlock instanceof KtAnnotatedExpression) {
                    PsiElement[] psiElementArray = ((KtAnnotatedExpression)$this$toFirBlock).getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"children");
                    PsiElement lastChild = (PsiElement)ArraysKt.lastOrNull((Object[])psiElementArray);
                    if (lastChild instanceof KtBlockExpression) {
                        firBlock2 = this.toFirBlock((KtExpression)lastChild);
                        this.extractAnnotationsTo((KtAnnotated)((Object)$this$toFirBlock), firBlock2);
                    }
                }
                if ((firBlock = firBlock2) == null) {
                    void this_$iv;
                    Visitor visitor2 = this;
                    KtElement $this$convert$iv = $this$toFirBlock;
                    boolean $i$f$convert = false;
                    FirElement firElement = this_$iv.convertElement($this$convert$iv);
                    if (firElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                    }
                    firBlock = new FirSingleExpressionBlock((FirStatement)((FirElement)((FirStatement)firElement)));
                }
            }
            return firBlock;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<FirBlock, FirContractDescription> buildFirBody(KtDeclarationWithBody $this$buildFirBody) {
            Pair pair;
            if ($this$buildFirBody.hasBody()) {
                Object object;
                void this_$iv$iv;
                void this_$iv;
                Visitor visitor2 = this;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildOrLazyBlock = false;
                void var5_5 = this_$iv;
                Function0 lazy$iv$iv = buildOrLazyBlock.1.INSTANCE;
                boolean $i$f$buildOrLazy = false;
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        boolean bl = false;
                        if ($this$buildFirBody.hasBlockBody()) {
                            FirContractDescription firContractDescription;
                            KtBlockExpression ktBlockExpression = $this$buildFirBody.getBodyBlockExpression();
                            FirElement firElement = ktBlockExpression != null ? (FirElement)ktBlockExpression.accept(this, Unit.INSTANCE) : null;
                            FirBlock block = firElement instanceof FirBlock ? (FirBlock)firElement : null;
                            if (!$this$buildFirBody.hasContractEffectList()) {
                                FirBlock firBlock = block;
                                if (firBlock != null) {
                                    FirBlock p0 = firBlock;
                                    boolean bl2 = false;
                                    firContractDescription = ConversionUtilsKt.processLegacyContractDescription(p0);
                                } else {
                                    firContractDescription = null;
                                }
                            } else {
                                firContractDescription = null;
                            }
                            FirContractDescription contractDescription = firContractDescription;
                            return TuplesKt.to((Object)block, contractDescription);
                        }
                        FirExpression result2 = this.toFirExpression((Function0<? extends KtExpression>)((Function0)new Function0<KtExpression>($this$buildFirBody){
                            final /* synthetic */ KtDeclarationWithBody $this_buildFirBody;
                            {
                                this.$this_buildFirBody = $receiver;
                                super(0);
                            }

                            @Nullable
                            public final KtExpression invoke() {
                                return this.$this_buildFirBody.getBodyExpression();
                            }
                        }), "Function has no body (but should)");
                        object = new FirSingleExpressionBlock(BaseFirBuilder.toReturn$default(rawFirBuilder, result2, result2.getSource(), null, false, 6, null));
                        break;
                    }
                    case 2: {
                        RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        boolean $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                object = lazy$iv$iv.invoke();
                                break block0;
                            }
                            case 2: {
                                object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                pair = TuplesKt.to((Object)((FirBlock)object), null);
            } else {
                pair = TuplesKt.to(null, null);
            }
            return pair;
        }

        private final FirExpression toFirExpression(ValueArgument $this$toFirExpression) {
            FirExpression firExpression2;
            FirExpression firExpression3;
            if ($this$toFirExpression == null) {
                return FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No argument given", DiagnosticKind.Syntax), null, 4, null);
            }
            ValueArgumentName valueArgumentName = $this$toFirExpression.getArgumentName();
            Name name2 = valueArgumentName != null ? valueArgumentName.getAsName() : null;
            KtExpression expression2 = $this$toFirExpression.getArgumentExpression();
            if (expression2 instanceof KtConstantExpression ? true : expression2 instanceof KtStringTemplateExpression) {
                Object r = expression2.accept(this, Unit.INSTANCE);
                Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                firExpression3 = (FirExpression)r;
            } else {
                firExpression3 = this.toFirExpression((Function0<? extends KtExpression>)((Function0)new Function0<KtExpression>(expression2){
                    final /* synthetic */ KtExpression $expression;
                    {
                        this.$expression = $expression;
                        super(0);
                    }

                    @Nullable
                    public final KtExpression invoke() {
                        return this.$expression;
                    }
                }), "Argument is absent");
            }
            FirExpression firExpression4 = firExpression3;
            boolean isSpread = $this$toFirExpression.getSpreadElement() != null;
            if (name2 != null) {
                FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildNamedArgumentExpression = false;
                FirNamedArgumentExpressionBuilder $this$toFirExpression_u24lambda_u248 = firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
                boolean bl = false;
                PsiElement psiElement = $this$toFirExpression instanceof PsiElement ? (PsiElement)$this$toFirExpression : null;
                $this$toFirExpression_u24lambda_u248.setSource(psiElement != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, psiElement, null, 1, null) : null);
                $this$toFirExpression_u24lambda_u248.setExpression(firExpression4);
                $this$toFirExpression_u24lambda_u248.setSpread(isSpread);
                $this$toFirExpression_u24lambda_u248.setName(name2);
                firExpression2 = firNamedArgumentExpressionBuilder.build();
            } else if (isSpread) {
                FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildSpreadArgumentExpression = false;
                FirSpreadArgumentExpressionBuilder $this$toFirExpression_u24lambda_u249 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
                boolean bl = false;
                PsiElement psiElement = $this$toFirExpression instanceof PsiElement ? (PsiElement)$this$toFirExpression : null;
                $this$toFirExpression_u24lambda_u249.setSource(psiElement != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, psiElement, null, 1, null) : null);
                $this$toFirExpression_u24lambda_u249.setExpression(firExpression4);
                firExpression2 = firSpreadArgumentExpressionBuilder.build();
            } else {
                firExpression2 = firExpression4;
            }
            return firExpression2;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final FirPropertyAccessor toFirPropertyAccessor(KtPropertyAccessor $this$toFirPropertyAccessor, KtProperty property, FirTypeRef propertyTypeRef, FirPropertySymbol propertySymbol, boolean isGetter, List<? extends FirAnnotation> accessorAnnotationsFromProperty, List<? extends FirAnnotation> parameterAnnotationsFromProperty) {
            block22: {
                block19: {
                    block21: {
                        block20: {
                            accessorVisibility = ($this$toFirPropertyAccessor != null ? RawFirBuilder.access$getVisibility(RawFirBuilder.this, $this$toFirPropertyAccessor) : null) != null && Intrinsics.areEqual((Object)RawFirBuilder.access$getVisibility(RawFirBuilder.this, $this$toFirPropertyAccessor), (Object)Visibilities.Unknown.INSTANCE) == false ? RawFirBuilder.access$getVisibility(RawFirBuilder.this, $this$toFirPropertyAccessor) : RawFirBuilder.access$getVisibility(RawFirBuilder.this, property);
                            $this$toFirPropertyAccessor_u24lambda_u2410 = var10_9 = new FirDeclarationStatusImpl(accessorVisibility, $this$toFirPropertyAccessor != null ? RawFirBuilder.access$getModality(RawFirBuilder.this, $this$toFirPropertyAccessor) : null);
                            $i$a$-apply-RawFirBuilder$Visitor$toFirPropertyAccessor$status$1 = false;
                            if (property.hasModifier(KtTokens.INLINE_KEYWORD)) ** GOTO lbl-1000
                            v0 = $this$toFirPropertyAccessor;
                            v1 = v0 != null ? v0.hasModifier(KtTokens.INLINE_KEYWORD) : false;
                            if (v1) lbl-1000:
                            // 2 sources

                            {
                                v2 = true;
                            } else {
                                v2 = false;
                            }
                            $this$toFirPropertyAccessor_u24lambda_u2410.setInline(v2);
                            if (property.hasModifier(KtTokens.EXTERNAL_KEYWORD)) ** GOTO lbl-1000
                            v3 = $this$toFirPropertyAccessor;
                            v4 = v3 != null ? v3.hasModifier(KtTokens.EXTERNAL_KEYWORD) : false;
                            if (v4) lbl-1000:
                            // 2 sources

                            {
                                v5 = true;
                            } else {
                                v5 = false;
                            }
                            $this$toFirPropertyAccessor_u24lambda_u2410.setExternal(v5);
                            status = var10_9;
                            propertyTypeRefToUse = UtilsKt.copyWithNewSourceKind(propertyTypeRef, KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE);
                            if ($this$toFirPropertyAccessor == null || !$this$toFirPropertyAccessor.hasBody()) break block19;
                            source = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $this$toFirPropertyAccessor, null, 1, null);
                            accessorTarget = new FirFunctionTarget(null, false);
                            var13_16 = RawFirBuilder.this;
                            $i$f$buildPropertyAccessor = false;
                            $this$toFirPropertyAccessor_u24lambda_u2413 = var15_21 = new FirPropertyAccessorBuilder();
                            $i$a$-buildPropertyAccessor-RawFirBuilder$Visitor$toFirPropertyAccessor$1 = false;
                            $this$toFirPropertyAccessor_u24lambda_u2413.setSource(source);
                            $this$toFirPropertyAccessor_u24lambda_u2413.setModuleData(var13_16.getBaseModuleData());
                            $this$toFirPropertyAccessor_u24lambda_u2413.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                            if (!isGetter) break block20;
                            var18_27 = $this$toFirPropertyAccessor.getReturnTypeReference();
                            if (var18_27 == null) ** GOTO lbl-1000
                            var19_28 = this;
                            $this$convertSafe$iv = (KtElement)var18_27;
                            $i$f$convertSafe = false;
                            p0$iv = $this$convertSafe$iv;
                            $i$a$-let-RawFirBuilder$Visitor$convertSafe$1$iv = false;
                            v6 = this_$iv.convertElement(p0$iv);
                            if (!(v6 instanceof FirTypeRef)) {
                                v6 = null;
                            }
                            if ((var24_35 /* !! */  = (Pair<FirBlock, FirContractDescription>)((FirTypeRef)v6)) != null) {
                                v7 = var24_35 /* !! */ ;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v7 = propertyTypeRefToUse;
                            }
                            break block21;
                        }
                        v7 = this.toFirOrUnitType($this$toFirPropertyAccessor.getReturnTypeReference());
                    }
                    $this$toFirPropertyAccessor_u24lambda_u2413.setReturnTypeRef(v7);
                    $this$toFirPropertyAccessor_u24lambda_u2413.setGetter(isGetter);
                    $this$toFirPropertyAccessor_u24lambda_u2413.setStatus(status);
                    this.extractAnnotationsTo((KtAnnotated)$this$toFirPropertyAccessor, $this$toFirPropertyAccessor_u24lambda_u2413);
                    CollectionsKt.addAll((Collection)$this$toFirPropertyAccessor_u24lambda_u2413.getAnnotations(), (Iterable)accessorAnnotationsFromProperty);
                    ((Collection)var13_16.getContext().getFirFunctionTargets()).add(accessorTarget);
                    $this$toFirPropertyAccessor_u24lambda_u2413.setSymbol(new FirPropertyAccessorSymbol());
                    this.extractValueParametersTo($this$toFirPropertyAccessor, $this$toFirPropertyAccessor_u24lambda_u2413, $this$toFirPropertyAccessor_u24lambda_u2413.getSymbol(), BaseFirBuilder.ValueParameterDeclaration.SETTER, propertyTypeRefToUse, parameterAnnotationsFromProperty);
                    if (!isGetter && $this$toFirPropertyAccessor_u24lambda_u2413.getValueParameters().isEmpty()) {
                        var18_27 = $this$toFirPropertyAccessor_u24lambda_u2413.getValueParameters();
                        $i$f$buildDefaultSetterValueParameter = false;
                        $this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411 = this_$iv = new FirDefaultSetterValueParameterBuilder();
                        $i$a$-buildDefaultSetterValueParameter-RawFirBuilder$Visitor$toFirPropertyAccessor$1$1 = false;
                        $this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411.setSource(KtSourceElementKt.fakeElement(source, KtFakeSourceElementKind.DefaultAccessor.INSTANCE));
                        $this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411.setModuleData(var13_16.getBaseModuleData());
                        $this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                        $this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411.setReturnTypeRef(propertyTypeRefToUse);
                        $this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411.setSymbol(new FirValueParameterSymbol(StandardNames.DEFAULT_VALUE_PARAMETER));
                        CollectionsKt.addAll((Collection)$this$toFirPropertyAccessor_u24lambda_u2413_u24lambda_u2411.getAnnotations(), (Iterable)parameterAnnotationsFromProperty);
                        var24_35 /* !! */  = this_$iv.build();
                        var18_27.add(var24_35 /* !! */ );
                    }
                    outerContractDescription = this.obtainContractDescription($this$toFirPropertyAccessor);
                    var24_35 /* !! */  = this.buildFirBody($this$toFirPropertyAccessor);
                    body = (FirBlock)var24_35 /* !! */ .component1();
                    innerContractDescription = (FirContractDescription)var24_35 /* !! */ .component2();
                    $this$toFirPropertyAccessor_u24lambda_u2413.setBody(body);
                    v8 = outerContractDescription;
                    if (v8 == null) {
                        v8 = innerContractDescription;
                    }
                    v9 = contractDescription = v8;
                    if (v9 != null) {
                        it = v9;
                        $i$a$-let-RawFirBuilder$Visitor$toFirPropertyAccessor$1$2 = false;
                        $this$toFirPropertyAccessor_u24lambda_u2413.setContractDescription(it);
                    }
                    $this$toFirPropertyAccessor_u24lambda_u2413.setPropertySymbol(propertySymbol);
                    var13_16 = var15_21.build();
                    $i$f$buildPropertyAccessor = RawFirBuilder.this;
                    it = var13_16;
                    $i$a$-also-RawFirBuilder$Visitor$toFirPropertyAccessor$2 = false;
                    $i$f$buildPropertyAccessor.initContainingClassAttr((FirCallableDeclaration)it);
                    $i$f$buildPropertyAccessor.bindFunctionTarget(accessorTarget, (FirFunction)it);
                    $i$f$buildPropertyAccessor.removeLast($i$f$buildPropertyAccessor.getContext().getFirFunctionTargets());
                    v10 = var13_16;
                    break block22;
                }
                if (isGetter || property.isVar()) {
                    if ($this$toFirPropertyAccessor != null && (var12_13 = BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $this$toFirPropertyAccessor, null, 1, null)) != null) {
                        v11 = (KtPsiSourceElement)var12_13;
                    } else {
                        var13_17 = property;
                        kind$iv = KtFakeSourceElementKind.DefaultAccessor.INSTANCE;
                        $i$f$toKtPsiSourceElement = false;
                        var16_25 = kind$iv;
                        if (var16_25 instanceof KtRealSourceElementKind) {
                            v11 = new KtRealPsiSourceElement((PsiElement)$this$toKtPsiSourceElement$iv);
                        } else if (var16_25 instanceof KtFakeSourceElementKind) {
                            v11 = new KtFakeSourceElement((PsiElement)$this$toKtPsiSourceElement$iv, (KtFakeSourceElementKind)kind$iv);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    propertySource = v11;
                    var12_14 = FirDefaultPropertyAccessor.Companion.createGetterOrSetter(propertySource, RawFirBuilder.this.getBaseModuleData(), FirDeclarationOrigin.Source.INSTANCE, propertyTypeRefToUse, accessorVisibility, propertySymbol, isGetter, parameterAnnotationsFromProperty);
                    var13_17 = RawFirBuilder.this;
                    it = var12_14;
                    $i$a$-also-RawFirBuilder$Visitor$toFirPropertyAccessor$3 = false;
                    if ($this$toFirPropertyAccessor != null) {
                        this.extractAnnotationsFrom(it, $this$toFirPropertyAccessor);
                    }
                    it.replaceAnnotations(UtilsKt.smartPlus(MutableOrEmptyList.box-impl(it.getAnnotations-5e3fPpI()), accessorAnnotationsFromProperty));
                    it.setStatus(status);
                    var13_17.initContainingClassAttr(it);
                    v10 = var12_14;
                } else {
                    v10 = null;
                }
            }
            return v10;
        }

        /*
         * Unable to fully structure code
         */
        private final FirDeclarationStatus obtainPropertyComponentStatus(Visibility componentVisibility, KtDeclaration declaration, KtProperty property) {
            $this$obtainPropertyComponentStatus_u24lambda_u2416 = var4_4 = new FirDeclarationStatusImpl(componentVisibility, declaration != null ? RawFirBuilder.access$getModality(RawFirBuilder.this, declaration) : null);
            $i$a$-apply-RawFirBuilder$Visitor$obtainPropertyComponentStatus$1 = false;
            if (property.hasModifier(KtTokens.INLINE_KEYWORD)) ** GOTO lbl-1000
            v0 = declaration;
            v1 = v0 != null ? v0.hasModifier(KtTokens.INLINE_KEYWORD) : false;
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            $this$obtainPropertyComponentStatus_u24lambda_u2416.setInline(v2);
            if (property.hasModifier(KtTokens.EXTERNAL_KEYWORD)) ** GOTO lbl-1000
            v3 = declaration;
            v4 = v3 != null ? v3.hasModifier(KtTokens.EXTERNAL_KEYWORD) : false;
            if (v4) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            $this$obtainPropertyComponentStatus_u24lambda_u2416.setExternal(v5);
            v6 = declaration;
            $this$obtainPropertyComponentStatus_u24lambda_u2416.setLateInit(v6 != null ? v6.hasModifier(KtTokens.LATEINIT_KEYWORD) : false);
            return var4_4;
        }

        private final FirBackingField toFirBackingField(KtBackingField $this$toFirBackingField, KtProperty property, FirPropertySymbol propertySymbol, FirTypeRef propertyReturnType) {
            FirBackingField firBackingField;
            KtPsiSourceElement source;
            Visibility componentVisibility = ($this$toFirBackingField != null ? RawFirBuilder.this.getVisibility($this$toFirBackingField) : null) != null && !Intrinsics.areEqual((Object)RawFirBuilder.this.getVisibility($this$toFirBackingField), (Object)Visibilities.Unknown.INSTANCE) ? RawFirBuilder.this.getVisibility($this$toFirBackingField) : (Visibility)Visibilities.Private.INSTANCE;
            FirDeclarationStatus status2 = this.obtainPropertyComponentStatus(componentVisibility, $this$toFirBackingField, property);
            KtBackingField ktBackingField = $this$toFirBackingField;
            FirExpression backingFieldInitializer = ktBackingField != null ? this.toInitializerExpression(ktBackingField) : null;
            KtBackingField ktBackingField2 = $this$toFirBackingField;
            FirTypeRef returnType2 = this.toFirOrImplicitType(ktBackingField2 != null ? ktBackingField2.getReturnTypeReference() : null);
            KtPsiSourceElement ktPsiSourceElement = source = $this$toFirBackingField != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $this$toFirBackingField, null, 1, null) : null;
            if ($this$toFirBackingField != null) {
                FirBackingFieldBuilder firBackingFieldBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildBackingField = false;
                FirBackingFieldBuilder $this$toFirBackingField_u24lambda_u2417 = firBackingFieldBuilder = new FirBackingFieldBuilder();
                boolean bl = false;
                $this$toFirBackingField_u24lambda_u2417.setSource(source);
                $this$toFirBackingField_u24lambda_u2417.setModuleData(rawFirBuilder.getBaseModuleData());
                $this$toFirBackingField_u24lambda_u2417.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$toFirBackingField_u24lambda_u2417.setReturnTypeRef(returnType2);
                $this$toFirBackingField_u24lambda_u2417.setStatus(status2);
                this.extractAnnotationsTo((KtAnnotated)$this$toFirBackingField, $this$toFirBackingField_u24lambda_u2417);
                $this$toFirBackingField_u24lambda_u2417.setName(StandardNames.BACKING_FIELD);
                $this$toFirBackingField_u24lambda_u2417.setSymbol(new FirBackingFieldSymbol(new CallableId($this$toFirBackingField_u24lambda_u2417.getName(), null, 2, null)));
                $this$toFirBackingField_u24lambda_u2417.setPropertySymbol(propertySymbol);
                $this$toFirBackingField_u24lambda_u2417.setInitializer(backingFieldInitializer);
                $this$toFirBackingField_u24lambda_u2417.setVar(property.isVar());
                $this$toFirBackingField_u24lambda_u2417.setVal(!property.isVar());
                firBackingField = firBackingFieldBuilder.build();
            } else {
                firBackingField = new FirDefaultPropertyBackingField(RawFirBuilder.this.getBaseModuleData(), new ArrayList(), UtilsKt.copyWithNewSourceKind(propertyReturnType, KtFakeSourceElementKind.DefaultAccessor.INSTANCE), property.isVar(), propertySymbol, status2);
            }
            return firBackingField;
        }

        /*
         * WARNING - void declaration
         */
        private final FirValueParameter toFirValueParameter(KtParameter $this$toFirValueParameter, FirTypeRef defaultTypeRef, FirFunctionSymbol<?> functionSymbol, BaseFirBuilder.ValueParameterDeclaration valueParameterDeclaration2, List<? extends FirAnnotation> additionalAnnotations) {
            FirExpression firExpression2;
            Object lazy$iv$iv;
            FirAnnotation firAnnotation;
            FirTypeRef firTypeRef;
            FirValueParameterBuilder firValueParameterBuilder;
            Name name2 = $this$toFirValueParameter.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"nameAsSafeName");
            Name name3 = RawFirBuilder.this.convertValueParameterName(name2, valueParameterDeclaration2, (Function0<String>)((Function0)new Function0<String>($this$toFirValueParameter){
                final /* synthetic */ KtParameter $this_toFirValueParameter;
                {
                    this.$this_toFirValueParameter = $receiver;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    PsiElement psiElement = this.$this_toFirValueParameter.getNameIdentifier();
                    return psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getText() : null;
                }
            }));
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildValueParameter = false;
            FirValueParameterBuilder $this$toFirValueParameter_u24lambda_u2421 = firValueParameterBuilder = new FirValueParameterBuilder();
            boolean bl = false;
            $this$toFirValueParameter_u24lambda_u2421.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, $this$toFirValueParameter, null, 1, null));
            $this$toFirValueParameter_u24lambda_u2421.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$toFirValueParameter_u24lambda_u2421.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            if ($this$toFirValueParameter.getTypeReference() != null) {
                firTypeRef = this.toFirOrErrorType($this$toFirValueParameter.getTypeReference());
            } else {
                firTypeRef = defaultTypeRef;
                if (firTypeRef == null) {
                    firTypeRef = valueParameterDeclaration2.getShouldExplicitParameterTypeBePresent() ? (FirTypeRef)rawFirBuilder.createNoTypeForParameterTypeRef() : this.toFirOrImplicitType(null);
                }
            }
            $this$toFirValueParameter_u24lambda_u2421.setReturnTypeRef(firTypeRef);
            $this$toFirValueParameter_u24lambda_u2421.setName(name3);
            $this$toFirValueParameter_u24lambda_u2421.setSymbol(new FirValueParameterSymbol(name3));
            FirValueParameterBuilder firValueParameterBuilder2 = $this$toFirValueParameter_u24lambda_u2421;
            if ($this$toFirValueParameter.hasDefaultValue()) {
                Object object;
                void this_$iv$iv;
                void this_$iv;
                Visitor visitor2 = this;
                KtSourceElement sourceElement$iv = null;
                boolean $i$f$buildOrLazyExpression = false;
                firAnnotation = this_$iv;
                lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
                boolean $i$f$buildOrLazy = false;
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        FirValueParameterBuilder firValueParameterBuilder3 = firValueParameterBuilder2;
                        boolean bl2 = false;
                        object = this.toFirExpression((Function0<? extends KtExpression>)((Function0)new Function0<KtExpression>($this$toFirValueParameter){
                            final /* synthetic */ KtParameter $this_toFirValueParameter;
                            {
                                this.$this_toFirValueParameter = $receiver;
                                super(0);
                            }

                            @Nullable
                            public final KtExpression invoke() {
                                return this.$this_toFirValueParameter.getDefaultValue();
                            }
                        }), "Should have default value");
                        firValueParameterBuilder2 = firValueParameterBuilder3;
                        break;
                    }
                    case 2: {
                        RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        boolean $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                object = lazy$iv$iv.invoke();
                                break block0;
                            }
                            case 2: {
                                object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                firExpression2 = (FirExpression)object;
            } else {
                firExpression2 = null;
            }
            firValueParameterBuilder2.setDefaultValue(firExpression2);
            $this$toFirValueParameter_u24lambda_u2421.setCrossinline($this$toFirValueParameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD));
            $this$toFirValueParameter_u24lambda_u2421.setNoinline($this$toFirValueParameter.hasModifier(KtTokens.NOINLINE_KEYWORD));
            $this$toFirValueParameter_u24lambda_u2421.setVararg($this$toFirValueParameter.isVarArg());
            $this$toFirValueParameter_u24lambda_u2421.setContainingFunctionSymbol(functionSymbol);
            boolean isFromPrimaryConstructor = valueParameterDeclaration2 == BaseFirBuilder.ValueParameterDeclaration.PRIMARY_CONSTRUCTOR;
            for (KtAnnotationEntry annotationEntry : $this$toFirValueParameter.getAnnotationEntries()) {
                void this_$iv;
                lazy$iv$iv = this;
                Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                KtElement $this$convert$iv = annotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement = this_$iv.convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                }
                FirElement firElement2 = (FirAnnotation)firElement;
                FirAnnotation it = (FirAnnotation)firElement2;
                boolean bl3 = false;
                firAnnotation = (FirAnnotation)(!isFromPrimaryConstructor || it.getUseSiteTarget() == null || it.getUseSiteTarget() == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER || it.getUseSiteTarget() == AnnotationUseSiteTarget.RECEIVER || it.getUseSiteTarget() == AnnotationUseSiteTarget.FILE ? firElement2 : null);
                if (firAnnotation == null) continue;
                it = firAnnotation;
                boolean bl4 = false;
                ((Collection)$this$toFirValueParameter_u24lambda_u2421.getAnnotations()).add(it);
            }
            CollectionsKt.addAll((Collection)$this$toFirValueParameter_u24lambda_u2421.getAnnotations(), (Iterable)additionalAnnotations);
            return firValueParameterBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        private final FirProperty toFirProperty(KtParameter $this$toFirProperty, FirValueParameter firParameter) {
            void $this$filterTo$iv$iv;
            FirPropertyAccessor firPropertyAccessor;
            Object getter2;
            void $this$toFirProperty_u24lambda_u2428_u24lambda_u2424_u24lambda_u2423;
            FirPropertyFromParameterResolvedNamedReferenceBuilder firPropertyFromParameterResolvedNamedReferenceBuilder;
            Object $this$toFirProperty_u24lambda_u2428_u24lambda_u2424;
            Object object;
            Object object2;
            FirTypeRef firTypeRef;
            FirElement firElement;
            FirElement firElement2;
            FirDeclarationStatusImpl this_$iv;
            if (!$this$toFirProperty.hasValOrVar()) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            Visitor visitor2 = this;
            Object $this$convertSafe$iv = $this$toFirProperty.getTypeReference();
            boolean $i$f$convertSafe = false;
            KtElement ktElement = $this$convertSafe$iv;
            if (ktElement != null) {
                KtElement p0$iv = ktElement;
                boolean bl = false;
                firElement2 = ((Visitor)((Object)this_$iv)).convertElement(p0$iv);
            } else {
                firElement2 = firElement = null;
            }
            if (!(firElement2 instanceof FirTypeRef)) {
                firElement = null;
            }
            if ((firTypeRef = (FirTypeRef)((FirElement)((FirTypeRef)firElement))) == null) {
                firTypeRef = RawFirBuilder.this.createNoTypeForParameterTypeRef();
            }
            FirTypeRef type2 = firTypeRef;
            this_$iv = new FirDeclarationStatusImpl(RawFirBuilder.this.getVisibility($this$toFirProperty), RawFirBuilder.this.getModality($this$toFirProperty));
            $this$convertSafe$iv = RawFirBuilder.this;
            FirDeclarationStatusImpl $this$toFirProperty_u24lambda_u2422 = this_$iv;
            boolean bl = false;
            $this$toFirProperty_u24lambda_u2422.setExpect(PsiUtilsKt.hasExpectModifier($this$toFirProperty) || ((BaseFirBuilder)$this$convertSafe$iv).getContext().getContainerIsExpect());
            $this$toFirProperty_u24lambda_u2422.setActual(PsiUtilsKt.hasActualModifier($this$toFirProperty));
            $this$toFirProperty_u24lambda_u2422.setOverride($this$toFirProperty.hasModifier(KtTokens.OVERRIDE_KEYWORD));
            $this$toFirProperty_u24lambda_u2422.setConst($this$toFirProperty.hasModifier(KtTokens.CONST_KEYWORD));
            FirDeclarationStatusImpl status2 = this_$iv;
            KtPsiSourceElement propertySource = RawFirBuilder.this.toFirSourceElement($this$toFirProperty, (KtFakeSourceElementKind)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
            Name name2 = $this$toFirProperty.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"nameAsSafeName");
            Name propertyName = name2;
            List parameterAnnotations = new ArrayList();
            for (KtAnnotationEntry annotationEntry : $this$toFirProperty.getAnnotationEntries()) {
                FirElement this_$iv2;
                object2 = parameterAnnotations;
                Visitor visitor3 = this;
                Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                KtElement $this$convert$iv = annotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement3 = ((Visitor)((Object)this_$iv2)).convertElement($this$convert$iv);
                if (firElement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotationCall");
                }
                this_$iv2 = (FirAnnotationCall)firElement3;
                object2.add(this_$iv2);
            }
            Object object3 = RawFirBuilder.this;
            boolean $i$f$buildProperty = false;
            Object $this$toFirProperty_u24lambda_u2428 = object2 = new FirPropertyBuilder();
            boolean bl2 = false;
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setSource(propertySource);
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setModuleData(((BaseFirBuilder)object3).getBaseModuleData());
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setReturnTypeRef(UtilsKt.copyWithNewSourceKind(type2, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE));
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setName(propertyName);
            boolean $i$f$buildPropertyAccessExpression = false;
            Object object4 = object = new FirPropertyAccessExpressionBuilder();
            Object object5 = $this$toFirProperty_u24lambda_u2428;
            boolean bl3 = false;
            ((FirPropertyAccessExpressionBuilder)$this$toFirProperty_u24lambda_u2428_u24lambda_u2424).setSource(propertySource);
            boolean $i$f$buildPropertyFromParameterResolvedNamedReference22 = false;
            FirPropertyFromParameterResolvedNamedReferenceBuilder firPropertyFromParameterResolvedNamedReferenceBuilder2 = firPropertyFromParameterResolvedNamedReferenceBuilder = new FirPropertyFromParameterResolvedNamedReferenceBuilder();
            Iterator iterator2 = $this$toFirProperty_u24lambda_u2428_u24lambda_u2424;
            boolean bl4 = false;
            $this$toFirProperty_u24lambda_u2428_u24lambda_u2424_u24lambda_u2423.setSource(propertySource);
            $this$toFirProperty_u24lambda_u2428_u24lambda_u2424_u24lambda_u2423.setName(propertyName);
            $this$toFirProperty_u24lambda_u2428_u24lambda_u2424_u24lambda_u2423.setResolvedSymbol(firParameter.getSymbol());
            ((FirPropertyAccessExpressionBuilder)((Object)iterator2)).setCalleeReference(firPropertyFromParameterResolvedNamedReferenceBuilder.build());
            ((FirPropertyBuilder)object5).setInitializer(((FirPropertyAccessExpressionBuilder)object).build());
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setVar($this$toFirProperty.isMutable());
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setSymbol(new FirPropertySymbol(((BaseFirBuilder)object3).callableIdForName(propertyName)));
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setLocal(false);
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setBackingField(new FirDefaultPropertyBackingField(((BaseFirBuilder)object3).getBaseModuleData(), new ArrayList(), UtilsKt.copyWithNewSourceKind(((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).getReturnTypeRef(), KtFakeSourceElementKind.DefaultAccessor.INSTANCE), ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).isVar(), ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).getSymbol(), UtilsKt.copy$default(status2, null, null, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0x1FFFFF, null)));
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setStatus(status2);
            KtSourceElement defaultAccessorSource = KtSourceElementKt.fakeElement(propertySource, KtFakeSourceElementKind.DefaultAccessor.INSTANCE);
            $this$toFirProperty_u24lambda_u2428_u24lambda_u2424 = object = new FirDefaultPropertyGetter(defaultAccessorSource, ((BaseFirBuilder)object3).getBaseModuleData(), (FirDeclarationOrigin)FirDeclarationOrigin.Source.INSTANCE, UtilsKt.copyWithNewSourceKind(type2, KtFakeSourceElementKind.DefaultAccessor.INSTANCE), ((RawFirBuilder)object3).getVisibility($this$toFirProperty), ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).getSymbol(), null, null, null, 448, null);
            object5 = $this$toFirProperty_u24lambda_u2428;
            boolean bl5 = false;
            ((BaseFirBuilder)object3).initContainingClassAttr((FirCallableDeclaration)getter2);
            ((FirPropertyAccessorImpl)getter2).replaceAnnotations(ConversionUtilsKt.filterUseSiteTarget(parameterAnnotations, AnnotationUseSiteTarget.PROPERTY_GETTER));
            ((FirPropertyBuilder)object5).setGetter((FirPropertyAccessor)object);
            Object object6 = $this$toFirProperty_u24lambda_u2428;
            if ($this$toFirProperty.isMutable()) {
                void setter2;
                getter2 = object = new FirDefaultPropertySetter(defaultAccessorSource, ((BaseFirBuilder)object3).getBaseModuleData(), FirDeclarationOrigin.Source.INSTANCE, UtilsKt.copyWithNewSourceKind(type2, KtFakeSourceElementKind.DefaultAccessor.INSTANCE), ((RawFirBuilder)object3).getVisibility($this$toFirProperty), ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).getSymbol(), null, null, null, ConversionUtilsKt.filterUseSiteTarget(parameterAnnotations, AnnotationUseSiteTarget.SETTER_PARAMETER), 448, null);
                object5 = object6;
                boolean bl6 = false;
                ((BaseFirBuilder)object3).initContainingClassAttr((FirCallableDeclaration)setter2);
                setter2.replaceAnnotations(ConversionUtilsKt.filterUseSiteTarget(parameterAnnotations, AnnotationUseSiteTarget.PROPERTY_SETTER));
                object6 = object5;
                firPropertyAccessor = (FirPropertyAccessor)object;
            } else {
                firPropertyAccessor = null;
            }
            ((FirPropertyBuilder)object6).setSetter(firPropertyAccessor);
            object = ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).getAnnotations();
            Iterable $this$filter$iv = parameterAnnotations;
            boolean $i$f$filter = false;
            Iterable $i$f$buildPropertyFromParameterResolvedNamedReference22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
                boolean bl7 = false;
                boolean bl8 = it.getUseSiteTarget() == null || it.getUseSiteTarget() == AnnotationUseSiteTarget.PROPERTY || it.getUseSiteTarget() == AnnotationUseSiteTarget.FIELD || it.getUseSiteTarget() == AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD;
                if (!bl8) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object4 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)object, (Iterable)object4);
            ((FirPropertyBuilder)$this$toFirProperty_u24lambda_u2428).setDispatchReceiverType(((BaseFirBuilder)object3).currentDispatchReceiverType());
            Object $this$toFirProperty_u24lambda_u2429 = object3 = ((FirPropertyBuilder)object2).build();
            boolean bl9 = false;
            if (firParameter.isVararg()) {
                DeclarationAttributesKt.setFromVararg((FirProperty)$this$toFirProperty_u24lambda_u2429, true);
            }
            ClassMembersKt.setCorrespondingProperty(firParameter, (FirProperty)$this$toFirProperty_u24lambda_u2429);
            DeclarationAttributesKt.setFromPrimaryConstructor((FirProperty)$this$toFirProperty_u24lambda_u2429, true);
            return object3;
        }

        private final void extractAnnotationsFrom(FirDefaultPropertyAccessor $this$extractAnnotationsFrom, KtAnnotated annotated) {
            this.extractAnnotationsTo(annotated, $this$extractAnnotationsFrom);
        }

        /*
         * WARNING - void declaration
         */
        private final void extractAnnotationsTo(KtAnnotated $this$extractAnnotationsTo, FirAnnotationContainer container) {
            List list2;
            if ($this$extractAnnotationsTo.getAnnotationEntries().isEmpty()) {
                return;
            }
            List $this$extractAnnotationsTo_u24lambda_u2430 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$extractAnnotationsTo_u24lambda_u2430.addAll((Collection)container.getAnnotations());
            for (KtAnnotationEntry annotationEntry : $this$extractAnnotationsTo.getAnnotationEntries()) {
                void this_$iv;
                Visitor visitor2 = this;
                Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                KtElement $this$convert$iv = annotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement = this_$iv.convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                }
                $this$extractAnnotationsTo_u24lambda_u2430.add((FirElement)((FirAnnotation)firElement));
            }
            List annotations2 = CollectionsKt.build((List)list2);
            container.replaceAnnotations(annotations2);
        }

        /*
         * WARNING - void declaration
         */
        private final void extractAnnotationsTo(KtAnnotated $this$extractAnnotationsTo, FirAnnotationContainerBuilder container) {
            for (KtAnnotationEntry annotationEntry : $this$extractAnnotationsTo.getAnnotationEntries()) {
                void this_$iv;
                Collection collection = container.getAnnotations();
                Object object = this;
                Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                KtElement $this$convert$iv = annotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement = this_$iv.convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                }
                object = (FirAnnotation)firElement;
                collection.add(object);
            }
        }

        private final void extractTypeParametersTo(KtTypeParameterListOwner $this$extractTypeParametersTo, FirTypeParameterRefsOwnerBuilder container, FirBasedSymbol<?> declarationSymbol) {
            for (KtTypeParameter typeParameter2 : $this$extractTypeParametersTo.getTypeParameters()) {
                Collection collection = container.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
                collection.add(this.extractTypeParameter(typeParameter2, declarationSymbol));
            }
        }

        private final void extractTypeParametersTo(KtTypeParameterListOwner $this$extractTypeParametersTo, FirTypeParametersOwnerBuilder container, FirBasedSymbol<?> declarationSymbol) {
            for (KtTypeParameter typeParameter2 : $this$extractTypeParametersTo.getTypeParameters()) {
                Collection collection = container.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
                collection.add(this.extractTypeParameter(typeParameter2, declarationSymbol));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final FirTypeParameter extractTypeParameter(KtTypeParameter parameter2, FirBasedSymbol<?> declarationSymbol) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            Name name2 = parameter2.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"parameter.nameAsSafeName");
            Name parameterName = name2;
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildTypeParameter = false;
            FirTypeParameterBuilder $this$extractTypeParameter_u24lambda_u2433 = firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl = false;
            $this$extractTypeParameter_u24lambda_u2433.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, parameter2, null, 1, null));
            $this$extractTypeParameter_u24lambda_u2433.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$extractTypeParameter_u24lambda_u2433.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$extractTypeParameter_u24lambda_u2433.setName(parameterName);
            $this$extractTypeParameter_u24lambda_u2433.setSymbol(new FirTypeParameterSymbol());
            $this$extractTypeParameter_u24lambda_u2433.setContainingDeclarationSymbol(declarationSymbol);
            Variance variance = parameter2.getVariance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"parameter.variance");
            $this$extractTypeParameter_u24lambda_u2433.setVariance(variance);
            $this$extractTypeParameter_u24lambda_u2433.setReified(parameter2.hasModifier(KtTokens.REIFIED_KEYWORD));
            this.extractAnnotationsTo((KtAnnotated)parameter2, $this$extractTypeParameter_u24lambda_u2433);
            KtTypeReference extendsBound = parameter2.getExtendsBound();
            if (extendsBound != null) {
                void this_$iv;
                Collection collection = $this$extractTypeParameter_u24lambda_u2433.getBounds();
                Object object = this;
                KtElement $this$convert$iv = extendsBound;
                boolean $i$f$convert = false;
                FirElement firElement = this_$iv.convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeRef");
                }
                object = (FirTypeRef)firElement;
                collection.add(object);
            }
            PsiElement $this$getStrictParentOfType$iv = parameter2;
            boolean $i$f$getStrictParentOfType = false;
            KtTypeParameterListOwner ktTypeParameterListOwner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeParameterListOwner.class, (boolean)true);
            if (ktTypeParameterListOwner != null) {
                KtTypeParameterListOwner owner = ktTypeParameterListOwner;
                for (KtTypeConstraint typeConstraint : owner.getTypeConstraints()) {
                    Name subjectName;
                    KtSimpleNameExpression ktSimpleNameExpression = typeConstraint.getSubjectTypeParameterName();
                    Name name3 = subjectName = ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
                    if (Intrinsics.areEqual((Object)subjectName, (Object)parameterName)) {
                        ((Collection)$this$extractTypeParameter_u24lambda_u2433.getBounds()).add(this.toFirOrErrorType(typeConstraint.getBoundTypeReference()));
                    }
                    for (KtAnnotationEntry entry : typeConstraint.getAnnotationEntries()) {
                        void $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
                        FirErrorAnnotationCallBuilder firErrorAnnotationCallBuilder;
                        Collection collection = $this$extractTypeParameter_u24lambda_u2433.getAnnotations();
                        boolean $i$f$buildErrorAnnotationCall = false;
                        FirErrorAnnotationCallBuilder $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432 = firErrorAnnotationCallBuilder = new FirErrorAnnotationCallBuilder();
                        boolean bl2 = false;
                        BaseFirBuilder baseFirBuilder = rawFirBuilder;
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                        $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, entry, null, 1, null));
                        KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = entry.getUseSiteTarget();
                        $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432.setUseSiteTarget(ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null);
                        $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432.setAnnotationTypeRef(this.toFirOrErrorType(entry.getTypeReference()));
                        $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432.setDiagnostic(new ConeSimpleDiagnostic("Type parameter annotations are not allowed inside where clauses", DiagnosticKind.AnnotationNotAllowed));
                        Object object = $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432.getAnnotationTypeRef();
                        Object object2 = object instanceof FirUserTypeRef ? (FirUserTypeRef)object : null;
                        if (object2 == null || (object2 = ((FirUserTypeRef)object2).getQualifier()) == null || (object2 = (FirQualifierPart)CollectionsKt.last((List)object2)) == null || (object2 = object2.getName()) == null) {
                            Name name4 = Name.special("<no-annotation-name>");
                            object2 = name4;
                            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"special(\"<no-annotation-name>\")");
                        }
                        Object name5 = object2;
                        boolean $i$f$buildSimpleNamedReference = false;
                        Object object3 = object = new FirSimpleNamedReferenceBuilder();
                        FirErrorAnnotationCallBuilder firErrorAnnotationCallBuilder2 = $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432;
                        boolean bl3 = false;
                        KtTypeReference ktTypeReference = entry.getTypeReference();
                        KtElement ktElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                        KtUserType ktUserType = ktElement instanceof KtUserType ? (KtUserType)ktElement : null;
                        $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setSource(ktUserType != null && (ktElement = ktUserType.getReferenceExpression()) != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, ktElement, null, 1, null) : null);
                        $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.setName((Name)name5);
                        firErrorAnnotationCallBuilder2.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
                        this.extractArgumentsTo(entry, $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432);
                        List<FirTypeProjection> list2 = $this$extractTypeParameter_u24lambda_u2433_u24lambda_u2432.getTypeArguments();
                        List<KtTypeProjection> list3 = entry.getTypeArguments();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"entry.typeArguments");
                        this.appendTypeArguments(list2, list3);
                        FirErrorAnnotationCall firErrorAnnotationCall = firErrorAnnotationCallBuilder.build();
                        collection.add(firErrorAnnotationCall);
                    }
                }
                FirDeclarationBuildingUtilsKt.addDefaultBoundIfNecessary($this$extractTypeParameter_u24lambda_u2433);
            }
            return firTypeParameterBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitTypeParameter(@NotNull KtTypeParameter parameter2, @Nullable Unit data2) {
            Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
            throw new AssertionError((Object)"KtTypeParameter should be process via extractTypeParameter");
        }

        /*
         * WARNING - void declaration
         */
        private final <T extends FirDeclaration> void fillDanglingConstraintsTo(KtTypeParameterListOwner $this$fillDanglingConstraintsTo, T to) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapNotNullTo$iv$iv2;
            List<KtTypeParameter> list2 = $this$fillDanglingConstraintsTo.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"typeParameters");
            Iterable $this$mapNotNull$iv2 = list2;
            boolean $i$f$mapNotNull22 = false;
            Object object = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtTypeParameter it = (KtTypeParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getNameAsName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set typeParamNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List<KtTypeConstraint> list3 = $this$fillDanglingConstraintsTo.getTypeConstraints();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"typeConstraints");
            Iterable $i$f$mapNotNull22 = list3;
            object = RawFirBuilder.this;
            boolean $i$f$mapNotNull = false;
            void $i$f$mapNotNullTo22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                DanglingTypeConstraint danglingTypeConstraint;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                KtTypeConstraint constraint = (KtTypeConstraint)element$iv$iv;
                boolean bl4 = false;
                Object object2 = constraint.getSubjectTypeParameterName();
                if (object2 != null && (object2 = object2.getReferencedNameAsName()) != null) {
                    Object name2 = object2;
                    boolean bl5 = false;
                    if (!typeParamNames.contains(name2)) {
                        BaseFirBuilder baseFirBuilder = (BaseFirBuilder)object;
                        KtSimpleNameExpression ktSimpleNameExpression = constraint.getSubjectTypeParameterName();
                        Intrinsics.checkNotNull((Object)ktSimpleNameExpression);
                        danglingTypeConstraint = new DanglingTypeConstraint((Name)name2, BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktSimpleNameExpression, null, 1, null));
                    } else {
                        danglingTypeConstraint = null;
                    }
                } else {
                    danglingTypeConstraint = null;
                }
                if (danglingTypeConstraint == null) continue;
                DanglingTypeConstraint it$iv$iv = danglingTypeConstraint;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv2;
            if (!((Collection)result2).isEmpty()) {
                DeclarationAttributesKt.setDanglingTypeConstraints(to, result2);
            }
        }

        private final void extractValueParametersTo(KtDeclarationWithBody $this$extractValueParametersTo, FirFunctionBuilder container, FirFunctionSymbol<?> functionSymbol, BaseFirBuilder.ValueParameterDeclaration valueParameterDeclaration2, FirTypeRef defaultTypeRef, List<? extends FirAnnotation> additionalAnnotations) {
            for (KtParameter valueParameter2 : $this$extractValueParametersTo.getValueParameters()) {
                Collection collection = container.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
                collection.add(this.convertValueParameter(valueParameter2, functionSymbol, defaultTypeRef, valueParameterDeclaration2, additionalAnnotations));
            }
        }

        static /* synthetic */ void extractValueParametersTo$default(Visitor visitor2, KtDeclarationWithBody ktDeclarationWithBody, FirFunctionBuilder firFunctionBuilder, FirFunctionSymbol firFunctionSymbol, BaseFirBuilder.ValueParameterDeclaration valueParameterDeclaration2, FirTypeRef firTypeRef, List list2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extractValueParametersTo");
            }
            if ((n & 8) != 0) {
                firTypeRef = null;
            }
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            visitor2.extractValueParametersTo(ktDeclarationWithBody, firFunctionBuilder, firFunctionSymbol, valueParameterDeclaration2, firTypeRef, list2);
        }

        /*
         * WARNING - void declaration
         */
        private final void extractArgumentsTo(KtCallElement $this$extractArgumentsTo, FirCallBuilder container) {
            FirArgumentListBuilder firArgumentListBuilder;
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildArgumentList = false;
            FirArgumentListBuilder $this$extractArgumentsTo_u24lambda_u2439 = firArgumentListBuilder = new FirArgumentListBuilder();
            boolean bl = false;
            KtValueArgumentList ktValueArgumentList = $this$extractArgumentsTo.getValueArgumentList();
            $this$extractArgumentsTo_u24lambda_u2439.setSource(ktValueArgumentList != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, ktValueArgumentList, null, 1, null) : null);
            for (ValueArgument valueArgument : $this$extractArgumentsTo.getValueArguments()) {
                FirExpression firExpression2;
                Object object;
                void this_$iv$iv;
                void this_$iv;
                Object object2 = this;
                Object object3 = valueArgument instanceof PsiElement ? (PsiElement)valueArgument : null;
                KtSourceElement sourceElement$iv = object3 != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, object3, null, 1, null) : null;
                boolean $i$f$buildOrLazyExpression = false;
                FirLambdaArgumentExpressionBuilder firLambdaArgumentExpressionBuilder = this_$iv;
                Function0 lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
                boolean $i$f$buildOrLazy = false;
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        boolean bl2 = false;
                        object = this.toFirExpression(valueArgument);
                        break;
                    }
                    case 2: {
                        RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        boolean $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                object = lazy$iv$iv.invoke();
                                break block0;
                            }
                            case 2: {
                                object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                FirExpression argumentExpression = object;
                object2 = $this$extractArgumentsTo_u24lambda_u2439.getArguments();
                if (valueArgument instanceof KtLambdaArgument) {
                    boolean $i$f$buildLambdaArgumentExpression = false;
                    FirLambdaArgumentExpressionBuilder $this$extractArgumentsTo_u24lambda_u2439_u24lambda_u2438 = firLambdaArgumentExpressionBuilder = new FirLambdaArgumentExpressionBuilder();
                    boolean bl3 = false;
                    BaseFirBuilder baseFirBuilder = rawFirBuilder;
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"argument");
                    $this$extractArgumentsTo_u24lambda_u2439_u24lambda_u2438.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, valueArgument, null, 1, null));
                    $this$extractArgumentsTo_u24lambda_u2439_u24lambda_u2438.setExpression(argumentExpression);
                    firExpression2 = firLambdaArgumentExpressionBuilder.build();
                } else {
                    firExpression2 = argumentExpression;
                }
                object3 = firExpression2;
                object2.add(object3);
            }
            FirArgumentList argumentList2 = firArgumentListBuilder.build();
            container.setArgumentList(argumentList2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Pair<FirTypeRef, Map<Integer, FirFieldSymbol>> extractSuperTypeListEntriesTo(KtClassOrObject $this$extractSuperTypeListEntriesTo, FirClassBuilder container, FirTypeRef delegatedSelfTypeRef, FirTypeRef delegatedEnumSuperTypeRef, ClassKind classKind, List<? extends FirTypeParameterRef> containerTypeParameters, boolean containingClassIsExpectClass) {
            void it;
            Object object;
            void $this$mapTo$iv;
            boolean shouldGenerateImplicitPrimaryConstructor;
            FirTypeRef firTypeRef;
            FirTypeRef defaultDelegatedSuperTypeRef;
            FirTypeRef firTypeRef2;
            Object object2;
            Object superTypeListEntry;
            RawFirBuilder $this$forEachIndexed$iv;
            ConeClassLikeLookupTag superTypeCallEntry = null;
            FirTypeRef delegatedSuperTypeRef = null;
            Map delegateFieldsMap = new LinkedHashMap();
            Iterable iterable = $this$extractSuperTypeListEntriesTo.getSuperTypeListEntries();
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator2 = $this$forEachIndexed$iv.iterator();
            while (iterator2.hasNext()) {
                KtPsiSourceElement ktPsiSourceElement;
                Object object3;
                FirExpression firExpression2;
                boolean bl;
                int n;
                Object item$iv = iterator2.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)item$iv;
                int index2 = n;
                boolean bl2 = false;
                object2 = superTypeListEntry;
                if (object2 instanceof KtSuperTypeEntry) {
                    ((Collection)container.getSuperTypeRefs()).add(this.toFirOrErrorType(((KtSuperTypeEntry)superTypeListEntry).getTypeReference()));
                    continue;
                }
                if (object2 instanceof KtSuperTypeCallEntry) {
                    delegatedSuperTypeRef = this.toFirOrErrorType(((KtSuperTypeCallEntry)superTypeListEntry).getCalleeExpression().getTypeReference());
                    Collection collection = container.getSuperTypeRefs();
                    FirTypeRef firTypeRef3 = delegatedSuperTypeRef;
                    Intrinsics.checkNotNull((Object)firTypeRef3);
                    collection.add(firTypeRef3);
                    superTypeCallEntry = superTypeListEntry;
                    continue;
                }
                if (!(object2 instanceof KtDelegatedSuperTypeEntry)) continue;
                FirTypeRef type2 = this.toFirOrErrorType(((KtDelegatedSuperTypeEntry)superTypeListEntry).getTypeReference());
                RawFirBuilder this_$iv = rawFirBuilder;
                boolean $i$f$disabledLazyMode = false;
                if (this_$iv.getMode() != BodyBuildingMode.LAZY_BODIES) {
                    bl = false;
                    firExpression2 = this.toFirExpression((Function0<? extends KtExpression>)((Function0)new Function0<KtExpression>((KtSuperTypeListEntry)superTypeListEntry){
                        final /* synthetic */ KtSuperTypeListEntry $superTypeListEntry;
                        {
                            this.$superTypeListEntry = $superTypeListEntry;
                            super(0);
                        }

                        @Nullable
                        public final KtExpression invoke() {
                            return ((KtDelegatedSuperTypeEntry)this.$superTypeListEntry).getDelegateExpression();
                        }
                    }), "Should have delegate");
                } else {
                    try {
                        this_$iv.mode = BodyBuildingMode.NORMAL;
                        bl = false;
                        object3 = this.toFirExpression((Function0<? extends KtExpression>)((Function0)new /* invalid duplicate definition of identical inner class */), "Should have delegate");
                    }
                    finally {
                        this_$iv.mode = BodyBuildingMode.LAZY_BODIES;
                    }
                    firExpression2 = object3;
                }
                FirExpression delegateExpression2 = firExpression2;
                ((Collection)container.getSuperTypeRefs()).add(type2);
                KtExpression ktExpression = $i$f$disabledLazyMode = ((KtDelegatedSuperTypeEntry)superTypeListEntry).getDelegateExpression();
                if (ktExpression != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"delegateExpression");
                    ktPsiSourceElement = rawFirBuilder.toFirSourceElement((PsiElement)$i$f$disabledLazyMode, (KtFakeSourceElementKind)KtFakeSourceElementKind.ClassDelegationField.INSTANCE);
                } else {
                    ktPsiSourceElement = null;
                }
                KtPsiSourceElement delegateSource = ktPsiSourceElement;
                boolean $i$f$buildField = false;
                Object $this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441 = object3 = new FirFieldBuilder();
                boolean bl3 = false;
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setSource(delegateSource);
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setModuleData(rawFirBuilder.getBaseModuleData());
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setName(NameUtils.delegateFieldName(delegateFieldsMap.size()));
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setReturnTypeRef(type2);
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setSymbol(new FirFieldSymbol(new CallableId(rawFirBuilder.getContext().getCurrentClassId(), ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).getName())));
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setVar(false);
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setStatus(new FirDeclarationStatusImpl(Visibilities.Private.INSTANCE, Modality.FINAL));
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setInitializer(delegateExpression2);
                ((FirFieldBuilder)$this$extractSuperTypeListEntriesTo_u24lambda_u2442_u24lambda_u2441).setDispatchReceiverType(rawFirBuilder.currentDispatchReceiverType());
                FirField delegateField = ((FirFieldBuilder)object3).build();
                object3 = index2;
                delegateFieldsMap.put(object3, delegateField.getSymbol());
            }
            if ($this$extractSuperTypeListEntriesTo instanceof KtClass && classKind == ClassKind.ENUM_CLASS && superTypeCallEntry == null) {
                ConeTypeProjection[] coneTypeProjectionArray;
                $this$forEachIndexed$iv = RawFirBuilder.this;
                boolean $i$f$buildResolvedTypeRef = false;
                FirResolvedTypeRefBuilder $this$extractSuperTypeListEntriesTo_u24lambda_u2444 = $i$f$forEachIndexed = new FirResolvedTypeRefBuilder();
                boolean bl = false;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = $this$extractSuperTypeListEntriesTo_u24lambda_u2444;
                ConeClassLikeLookupTag coneClassLikeLookupTag = $this$forEachIndexed$iv.getImplicitEnumType().getType().getLookupTag();
                Object object4 = delegatedSelfTypeRef;
                if (object4 != null && (object4 = FirTypeUtilsKt.getConeType((FirTypeRef)object4)) != null) {
                    void it2;
                    Object object5 = object4;
                    superTypeListEntry = coneClassLikeLookupTag;
                    object2 = firResolvedTypeRefBuilder;
                    boolean bl4 = false;
                    ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{it2};
                    ConeKotlinType[] coneKotlinTypeArray2 = coneKotlinTypeArray;
                    firResolvedTypeRefBuilder = object2;
                    coneClassLikeLookupTag = superTypeListEntry;
                    coneTypeProjectionArray = coneKotlinTypeArray2;
                } else {
                    boolean $i$f$emptyArray = false;
                    coneTypeProjectionArray = new ConeTypeProjection[]{};
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 8;
                ConeAttributes coneAttributes = null;
                boolean bl5 = false;
                ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
                ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
                firResolvedTypeRefBuilder.setType(new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneTypeProjectionArray2, bl5, coneAttributes, n, defaultConstructorMarker));
                delegatedSuperTypeRef = $i$f$forEachIndexed.build();
                Collection collection = container.getSuperTypeRefs();
                FirTypeRef firTypeRef4 = delegatedSuperTypeRef;
                Intrinsics.checkNotNull((Object)firTypeRef4);
                collection.add(firTypeRef4);
            } else if ($this$extractSuperTypeListEntriesTo instanceof KtClass && classKind == ClassKind.ANNOTATION_CLASS) {
                ((Collection)container.getSuperTypeRefs()).add(RawFirBuilder.this.getImplicitAnnotationType());
                delegatedSuperTypeRef = RawFirBuilder.this.getImplicitAnyType();
            }
            if (classKind == ClassKind.ENUM_ENTRY && $this$extractSuperTypeListEntriesTo instanceof KtClass) {
                firTypeRef2 = delegatedEnumSuperTypeRef;
                if (firTypeRef2 == null) {
                    firTypeRef2 = RawFirBuilder.this.getImplicitAnyType();
                }
            } else {
                firTypeRef2 = defaultDelegatedSuperTypeRef = container.getSuperTypeRefs().isEmpty() ? (FirTypeRef)RawFirBuilder.this.getImplicitAnyType() : (FirTypeRef)FirImplicitTypeRefImplWithoutSource.INSTANCE;
            }
            if (container.getSuperTypeRefs().isEmpty()) {
                ((Collection)container.getSuperTypeRefs()).add(RawFirBuilder.this.getImplicitAnyType());
                delegatedSuperTypeRef = RawFirBuilder.this.getImplicitAnyType();
            }
            if ((firTypeRef = (FirTypeRef)delegatedSuperTypeRef) == null) {
                firTypeRef = defaultDelegatedSuperTypeRef;
            }
            delegatedSuperTypeRef = firTypeRef;
            boolean bl = shouldGenerateImplicitPrimaryConstructor = !$this$extractSuperTypeListEntriesTo.hasExplicitPrimaryConstructor() && !$this$extractSuperTypeListEntriesTo.hasSecondaryConstructors() && (!containingClassIsExpectClass || classKind == ClassKind.ENUM_CLASS);
            if ($this$extractSuperTypeListEntriesTo.getPrimaryConstructor() != null || (!($this$extractSuperTypeListEntriesTo instanceof KtClass) || !((KtClass)$this$extractSuperTypeListEntriesTo).isInterface()) && shouldGenerateImplicitPrimaryConstructor) {
                KtPrimaryConstructor ktPrimaryConstructor = $this$extractSuperTypeListEntriesTo.getPrimaryConstructor();
                KtSuperTypeCallEntry ktSuperTypeCallEntry = (KtSuperTypeCallEntry)((Object)superTypeCallEntry);
                FirTypeRef firTypeRef5 = delegatedSelfTypeRef;
                if (firTypeRef5 == null) {
                    FirTypeRef firTypeRef6 = delegatedSuperTypeRef;
                    firTypeRef5 = firTypeRef6;
                    Intrinsics.checkNotNull((Object)firTypeRef6);
                }
                FirConstructor firPrimaryConstructor = this.toFirConstructor(ktPrimaryConstructor, ktSuperTypeCallEntry, delegatedSuperTypeRef, firTypeRef5, $this$extractSuperTypeListEntriesTo, containerTypeParameters, containingClassIsExpectClass, true);
                ((Collection)container.getDeclarations()).add(firPrimaryConstructor);
            }
            Iterable firPrimaryConstructor = delegateFieldsMap.values();
            Object destination$iv = container.getDeclarations();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                superTypeListEntry = (FirFieldSymbol)item$iv;
                object = destination$iv;
                boolean bl6 = false;
                object.add((FirField)it3.getFir());
            }
            FirTypeRef firTypeRef7 = delegatedSuperTypeRef;
            Intrinsics.checkNotNull((Object)firTypeRef7);
            Map map = delegateFieldsMap;
            destination$iv = map;
            object = firTypeRef7;
            boolean bl7 = false;
            boolean bl8 = !it.isEmpty();
            return TuplesKt.to((Object)object, (Object)(bl8 ? map : null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        protected final FirConstructor toFirConstructor(@Nullable KtPrimaryConstructor $this$toFirConstructor, @Nullable KtSuperTypeCallEntry superTypeCallEntry, @Nullable FirTypeRef delegatedSuperTypeRef, @NotNull FirTypeRef delegatedSelfTypeRef, @NotNull KtClassOrObject owner, @NotNull List<? extends FirTypeParameterRef> ownerTypeParameters, boolean containingClassIsExpectClass, boolean copyConstructedTypeRefWithImplicitSource) {
            block29: {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)delegatedSelfTypeRef, (String)"delegatedSelfTypeRef");
                    Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                    Intrinsics.checkNotNullParameter(ownerTypeParameters, (String)"ownerTypeParameters");
                    v0 = constructorCall = superTypeCallEntry != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, superTypeCallEntry, null, 1, null) : null;
                    if ($this$toFirConstructor != null && (var11_10 = BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $this$toFirConstructor, null, 1, null)) != null) {
                        v1 = (KtPsiSourceElement)var11_10;
                    } else {
                        var12_11 = owner;
                        kind$iv /* !! */  = KtFakeSourceElementKind.ImplicitConstructor.INSTANCE;
                        $i$f$toKtPsiSourceElement = false;
                        var15_16 = kind$iv /* !! */ ;
                        if (var15_16 instanceof KtRealSourceElementKind) {
                            v1 = new KtRealPsiSourceElement((PsiElement)$this$toKtPsiSourceElement$iv);
                        } else if (var15_16 instanceof KtFakeSourceElementKind) {
                            v1 = new KtFakeSourceElement((PsiElement)$this$toKtPsiSourceElement$iv, (KtFakeSourceElementKind)kind$iv /* !! */ );
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    constructorSource = v1;
                    if (!containingClassIsExpectClass) break block28;
                    v2 = null;
                    break block29;
                }
                if (copyConstructedTypeRefWithImplicitSource) {
                    v3 = delegatedSuperTypeRef;
                    Intrinsics.checkNotNull((Object)v3);
                    v4 = UtilsKt.copyWithNewSourceKind(v3, KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE);
                } else {
                    v5 = delegatedSuperTypeRef;
                    v4 = v5;
                    Intrinsics.checkNotNull((Object)v5);
                }
                constructedTypeRef = v4;
                kind$iv /* !! */  = this;
                $i$f$toKtPsiSourceElement = false;
                var15_16 = RawFirBuilder.this;
                $i$f$buildOrLazyDelegatedConstructorCall = false;
                var17_22 = this_$iv;
                lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
                $i$f$buildOrLazy = false;
                block1 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        $i$a$-buildOrLazyDelegatedConstructorCall-RawFirBuilder$Visitor$toFirConstructor$firDelegatedCall$1 = false;
                        $i$f$buildDelegatedConstructorCall = false;
                        $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449 = var22_31 = new FirDelegatedConstructorCallBuilder();
                        $i$a$-buildDelegatedConstructorCall-RawFirBuilder$Visitor$toFirConstructor$firDelegatedCall$1$1 = false;
                        v6 = constructorCall;
                        $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449.setSource(v6 != null ? (KtSourceElement)v6 : KtSourceElementKt.fakeElement(constructorSource, KtFakeSourceElementKind.DelegatingConstructorCall.INSTANCE));
                        $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449.setConstructedTypeRef(constructedTypeRef);
                        $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449.setThis(false);
                        $i$f$buildExplicitSuperReference = false;
                        var27_38 = var26_36 = new FirExplicitSuperReferenceBuilder();
                        var28_41 = $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449;
                        $i$a$-buildExplicitSuperReference-RawFirBuilder$Visitor$toFirConstructor$firDelegatedCall$1$1$1 = false;
                        v7 = superTypeCallEntry;
                        if (v7 != null && (v7 = v7.getCalleeExpression()) != null && (v7 = var15_16.toFirSourceElement((PsiElement)v7, (KtFakeSourceElementKind)KtFakeSourceElementKind.DelegatingConstructorCall.INSTANCE)) != null) {
                            v8 = (KtSourceElement)v7;
                        } else {
                            v9 = $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449.getSource();
                            v8 = v9 != null ? KtSourceElementKt.fakeElement(v9, KtFakeSourceElementKind.DelegatingConstructorCall.INSTANCE) : null;
                        }
                        $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449_u24lambda_u2447.setSource(v8);
                        $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449_u24lambda_u2447.setSuperTypeRef($this$toFirConstructor_u24lambda_u2450_u24lambda_u2449.getConstructedTypeRef());
                        var28_41.setCalleeReference(var26_36.build());
                        this_$iv = var15_16;
                        $i$f$disabledLazyMode = false;
                        if (this_$iv.getMode() == BodyBuildingMode.LAZY_BODIES) ** GOTO lbl74
                        $i$a$-disabledLazyMode-RawFirBuilder$Visitor$toFirConstructor$firDelegatedCall$1$1$2 = false;
                        v10 = superTypeCallEntry;
                        if (v10 != null) {
                            this.extractArgumentsTo(v10, $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449);
                        }
                        ** GOTO lbl86
lbl74:
                        // 1 sources

                        try {
                            RawFirBuilder.access$setMode$p((RawFirBuilder)this_$iv, BodyBuildingMode.NORMAL);
                            $i$a$-disabledLazyMode-RawFirBuilder$Visitor$toFirConstructor$firDelegatedCall$1$1$2 = false;
                            v11 = superTypeCallEntry;
                            if (v11 != null) {
                                this.extractArgumentsTo(v11, $this$toFirConstructor_u24lambda_u2450_u24lambda_u2449);
                            }
                            var29_43 = Unit.INSTANCE;
                        }
                        finally {
                            RawFirBuilder.access$setMode$p((RawFirBuilder)this_$iv, BodyBuildingMode.LAZY_BODIES);
                        }
lbl86:
                        // 2 sources

                        v12 = var22_31.build();
                        break;
                    }
                    case 2: {
                        this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                v12 = lazy$iv$iv.invoke();
                                break block1;
                            }
                            case 2: {
                                v12 = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block1;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                v2 = (FirDelegatedConstructorCall)v12;
            }
            firDelegatedCall = v2;
            if ($this$toFirConstructor != null && (this_$iv = RawFirBuilder.access$getVisibility(RawFirBuilder.this, $this$toFirConstructor)) != null) {
                var14_14 = this_$iv;
                it = var14_14;
                $i$a$-takeUnless-RawFirBuilder$Visitor$toFirConstructor$explicitVisibility$1 = false;
                v13 = !Intrinsics.areEqual((Object)it, (Object)Visibilities.Unknown.INSTANCE) ? var14_14 : null;
            } else {
                v13 = null;
            }
            if ((v14 = (explicitVisibility = v13)) == null) {
                v14 = Visitor.toFirConstructor$defaultVisibility(owner);
            }
            var14_15 = new FirDeclarationStatusImpl(v14, Modality.FINAL);
            it = RawFirBuilder.this;
            $this$toFirConstructor_u24lambda_u2452 = var14_15;
            $i$a$-apply-RawFirBuilder$Visitor$toFirConstructor$status$1 = false;
            v15 = $this$toFirConstructor;
            $this$toFirConstructor_u24lambda_u2452.setExpect((v15 != null ? PsiUtilsKt.hasExpectModifier(v15) : false) != false || it.getContext().getContainerIsExpect() != false);
            v16 = $this$toFirConstructor;
            $this$toFirConstructor_u24lambda_u2452.setActual(v16 != null ? PsiUtilsKt.hasActualModifier(v16) : false);
            $this$toFirConstructor_u24lambda_u2452.setInner(owner.hasModifier(KtTokens.INNER_KEYWORD));
            $this$toFirConstructor_u24lambda_u2452.setFromSealedClass(owner.hasModifier(KtTokens.SEALED_KEYWORD) != false && explicitVisibility != Visibilities.Private.INSTANCE);
            $this$toFirConstructor_u24lambda_u2452.setFromEnumClass(owner.hasModifier(KtTokens.ENUM_KEYWORD));
            status = var14_15;
            var14_15 = RawFirBuilder.this;
            $i$f$buildPrimaryConstructor = false;
            $this$toFirConstructor_u24lambda_u2453 = $this$toFirConstructor_u24lambda_u2452 = new FirPrimaryConstructorBuilder();
            $i$a$-buildPrimaryConstructor-RawFirBuilder$Visitor$toFirConstructor$1 = false;
            $this$toFirConstructor_u24lambda_u2453.setSource(constructorSource);
            $this$toFirConstructor_u24lambda_u2453.setModuleData(var14_15.getBaseModuleData());
            $this$toFirConstructor_u24lambda_u2453.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$toFirConstructor_u24lambda_u2453.setReturnTypeRef(delegatedSelfTypeRef);
            $this$toFirConstructor_u24lambda_u2453.setStatus(status);
            $this$toFirConstructor_u24lambda_u2453.setDispatchReceiverType(this.obtainDispatchReceiverForConstructor(owner));
            $this$toFirConstructor_u24lambda_u2453.setSymbol(new FirConstructorSymbol(var14_15.callableIdForClassConstructor()));
            $this$toFirConstructor_u24lambda_u2453.setDelegatedConstructor(firDelegatedCall);
            CollectionsKt.addAll((Collection)$this$toFirConstructor_u24lambda_u2453.getTypeParameters(), (Iterable)var14_15.constructorTypeParametersFromConstructedClass(ownerTypeParameters));
            $this$toFirConstructor_u24lambda_u2453.getContextReceivers().addAll((Collection<FirContextReceiver>)this.convertContextReceivers(owner.getContextReceivers()));
            v17 = $this$toFirConstructor;
            if (v17 != null) {
                this.extractAnnotationsTo((KtAnnotated)v17, (FirAnnotationContainerBuilder)$this$toFirConstructor_u24lambda_u2453);
            }
            v18 = $this$toFirConstructor;
            if (v18 != null) {
                Visitor.extractValueParametersTo$default(this, v18, (FirFunctionBuilder)$this$toFirConstructor_u24lambda_u2453, $this$toFirConstructor_u24lambda_u2453.getSymbol(), BaseFirBuilder.ValueParameterDeclaration.PRIMARY_CONSTRUCTOR, null, null, 24, null);
            }
            $this$toFirConstructor_u24lambda_u2453.setBody(null);
            var14_15 = $this$toFirConstructor_u24lambda_u2452.build();
            var15_18 = RawFirBuilder.this;
            $this$toFirConstructor_u24lambda_u2454 = var14_15;
            $i$a$-apply-RawFirBuilder$Visitor$toFirConstructor$2 = false;
            v19 = (FirCallableDeclaration)$this$toFirConstructor_u24lambda_u2454;
            v20 = var15_18.currentDispatchReceiverType();
            Intrinsics.checkNotNull((Object)v20);
            ClassMembersKt.setContainingClassForStaticMemberAttr(v19, v20.getLookupTag());
            return var14_15;
        }

        private final ConeClassLikeType obtainDispatchReceiverForConstructor(KtClassOrObject $this$obtainDispatchReceiverForConstructor) {
            return $this$obtainDispatchReceiverForConstructor.hasModifier(KtTokens.INNER_KEYWORD) ? RawFirBuilder.this.dispatchReceiverForInnerClassConstructor() : null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public FirElement visitKtFile(@NotNull KtFile file2, @NotNull Unit data2) {
            KtPsiSourceElement ktPsiSourceElement;
            void $this$visitKtFile_u24lambda_u2460_u24lambda_u2456;
            KtPsiSourceElement ktPsiSourceElement2;
            Object object;
            boolean $i$f$toKtPsiSourceElement;
            Object kind$iv;
            Object $this$visitKtFile_u24lambda_u2460_u24lambda_u2455;
            Object object2;
            FirFileBuilder firFileBuilder;
            FqName fqName2;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Context context = RawFirBuilder.this.getContext();
            switch (WhenMappings.$EnumSwitchMapping$0[RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    fqName2 = file2.getPackageFqNameByTree();
                    break;
                }
                case 2: {
                    fqName2 = file2.getPackageFqName();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            context.setPackageFqName(fqName2);
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildFile = false;
            FirFileBuilder $this$visitKtFile_u24lambda_u2460 = firFileBuilder = new FirFileBuilder();
            boolean bl = false;
            $this$visitKtFile_u24lambda_u2460.setSymbol(new FirFileSymbol());
            $this$visitKtFile_u24lambda_u2460.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, file2, null, 1, null));
            $this$visitKtFile_u24lambda_u2460.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$visitKtFile_u24lambda_u2460.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            $this$visitKtFile_u24lambda_u2460.setName(string2);
            $this$visitKtFile_u24lambda_u2460.setSourceFile(new KtPsiSourceFile((PsiFile)file2));
            $this$visitKtFile_u24lambda_u2460.setSourceFileLinesMapping(new KtPsiSourceFileLinesMapping((PsiFile)file2));
            boolean $i$f$buildPackageDirective = false;
            Object object3 = object2 = new FirPackageDirectiveBuilder();
            FirFileBuilder firFileBuilder2 = $this$visitKtFile_u24lambda_u2460;
            boolean bl2 = false;
            ((FirPackageDirectiveBuilder)$this$visitKtFile_u24lambda_u2460_u24lambda_u2455).setPackageFqName(rawFirBuilder.getContext().getPackageFqName());
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            if (ktPackageDirective != null) {
                PsiElement psiElement = ktPackageDirective;
                kind$iv = KtRealSourceElementKind.INSTANCE;
                $i$f$toKtPsiSourceElement = false;
                object = kind$iv;
                if (object instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement2 = new KtRealPsiSourceElement(psiElement);
                } else {
                    if (!(object instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement2 = new KtFakeSourceElement(psiElement, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement2 = null;
            }
            ((FirPackageDirectiveBuilder)$this$visitKtFile_u24lambda_u2460_u24lambda_u2455).setSource(ktPsiSourceElement2);
            firFileBuilder2.setPackageDirective(((FirPackageDirectiveBuilder)object2).build());
            boolean $i$f$buildFileAnnotationsContainer = false;
            $this$visitKtFile_u24lambda_u2460_u24lambda_u2455 = object2 = new FirFileAnnotationsContainerBuilder();
            firFileBuilder2 = $this$visitKtFile_u24lambda_u2460;
            boolean bl3 = false;
            $this$visitKtFile_u24lambda_u2460_u24lambda_u2456.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$visitKtFile_u24lambda_u2460_u24lambda_u2456.setContainingFileSymbol($this$visitKtFile_u24lambda_u2460.getSymbol());
            KtFileAnnotationList ktFileAnnotationList = file2.getFileAnnotationList();
            if (ktFileAnnotationList != null) {
                PsiElement psiElement = (PsiElement)ktFileAnnotationList;
                kind$iv = KtRealSourceElementKind.INSTANCE;
                $i$f$toKtPsiSourceElement = false;
                object = kind$iv;
                if (object instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement(psiElement);
                } else {
                    if (!(object instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement = new KtFakeSourceElement(psiElement, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement = null;
            }
            $this$visitKtFile_u24lambda_u2460_u24lambda_u2456.setSource(ktPsiSourceElement);
            for (KtAnnotationEntry ktAnnotationEntry : file2.getAnnotationEntries()) {
                FirElement this_$iv;
                kind$iv = $this$visitKtFile_u24lambda_u2460_u24lambda_u2456.getAnnotations();
                Visitor $i$f$toKtPsiSourceElement2 = this;
                KtElement $this$convert$iv = ktAnnotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement = ((Visitor)((Object)this_$iv)).convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                }
                this_$iv = (FirAnnotation)firElement;
                kind$iv.add(this_$iv);
            }
            firFileBuilder2.setAnnotationsContainer(((FirFileAnnotationsContainerBuilder)object2).build());
            for (KtImportDirective importDirective : file2.getImportDirectives()) {
                PsiElement psiElement;
                Name name2;
                FirImportBuilder firImportBuilder;
                object3 = $this$visitKtFile_u24lambda_u2460.getImports();
                boolean bl4 = false;
                FirImportBuilder $this$visitKtFile_u24lambda_u2460_u24lambda_u2458 = firImportBuilder = new FirImportBuilder();
                boolean bl5 = false;
                $this$visitKtFile_u24lambda_u2460_u24lambda_u2458.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, importDirective, null, 1, null));
                $this$visitKtFile_u24lambda_u2460_u24lambda_u2458.setImportedFqName(importDirective.getImportedFqName());
                $this$visitKtFile_u24lambda_u2460_u24lambda_u2458.setAllUnder(importDirective.isAllUnder());
                Object object4 = $this$visitKtFile_u24lambda_u2460_u24lambda_u2458;
                if (importDirective.getAliasName() != null) {
                    void it;
                    Object object5 = object4;
                    boolean bl6 = false;
                    name2 = Name.identifier((String)it);
                    object4 = object5;
                } else {
                    name2 = null;
                }
                ((FirImportBuilder)object4).setAliasName(name2);
                KtImportAlias ktImportAlias = importDirective.getAlias();
                $this$visitKtFile_u24lambda_u2460_u24lambda_u2458.setAliasSource(ktImportAlias != null && (psiElement = ktImportAlias.getNameIdentifier()) != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, psiElement, null, 1, null) : null);
                FirImport firImport = firImportBuilder.build();
                object3.add(firImport);
            }
            for (KtDeclaration declaration : file2.getDeclarations()) {
                FirDeclaration firDeclaration;
                object3 = $this$visitKtFile_u24lambda_u2460.getDeclarations();
                KtDeclaration ktDeclaration = declaration;
                if (ktDeclaration instanceof KtScript) {
                    if (!(file2.getDeclarations().size() == 1)) {
                        boolean $i$a$-require-RawFirBuilder$Visitor$visitKtFile$1$52 = false;
                        String $i$a$-require-RawFirBuilder$Visitor$visitKtFile$1$52 = "Expect the script to be the only declaration in the file " + $this$visitKtFile_u24lambda_u2460.getName();
                        throw new IllegalArgumentException($i$a$-require-RawFirBuilder$Visitor$visitKtFile$1$52.toString());
                    }
                    firDeclaration = this.convertScript((KtScript)declaration, $this$visitKtFile_u24lambda_u2460.getName(), (Function1<? super FirScriptBuilder, Unit>)((Function1)new Function1<FirScriptBuilder, Unit>(rawFirBuilder, $this$visitKtFile_u24lambda_u2460){
                        final /* synthetic */ RawFirBuilder this$0;
                        final /* synthetic */ FirFileBuilder $this_buildFile;
                        {
                            this.this$0 = $receiver;
                            this.$this_buildFile = $receiver2;
                            super(1);
                        }

                        public final void invoke(@NotNull FirScriptBuilder $this$convertScript) {
                            Intrinsics.checkNotNullParameter((Object)$this$convertScript, (String)"$this$convertScript");
                            for (FirScriptConfiguratorExtension configurator : FirScriptConfiguratorExtensionKt.getScriptConfigurators(FirExtensionServiceKt.getExtensionService(this.this$0.getBaseSession()))) {
                                FirFileBuilder firFileBuilder = this.$this_buildFile;
                                FirScriptConfiguratorExtension $this$invoke_u24lambda_u240 = configurator;
                                boolean bl = false;
                                $this$invoke_u24lambda_u240.configure($this$convertScript, firFileBuilder);
                            }
                        }
                    }));
                } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
                    firDeclaration = rawFirBuilder.buildErrorTopLevelDestructuringDeclaration(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, declaration, null, 1, null));
                } else {
                    Visitor visitor2 = this;
                    KtElement $this$convert$iv = declaration;
                    boolean $i$f$convert = false;
                    FirElement firElement = visitor2.convertElement($this$convert$iv);
                    if (firElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
                    }
                    firDeclaration = (FirDeclaration)((FirElement)((FirDeclaration)firElement));
                }
                FirDeclaration firDeclaration2 = firDeclaration;
                object3.add(firDeclaration2);
            }
            for (Iterator<KtElement> iterator2 : file2.getDanglingModifierLists()) {
                ((Collection)$this$visitKtFile_u24lambda_u2460.getDeclarations()).add(this.buildErrorTopLevelDeclarationForDanglingModifierList((KtModifierList)((Object)iterator2)));
            }
            return firFileBuilder.build();
        }

        private final FirScript convertScript(KtScript script, String fileName, Function1<? super FirScriptBuilder, Unit> setup) {
            FirScriptBuilder firScriptBuilder;
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildScript = false;
            FirScriptBuilder $this$convertScript_u24lambda_u2462 = firScriptBuilder = new FirScriptBuilder();
            boolean bl = false;
            $this$convertScript_u24lambda_u2462.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, script, null, 1, null));
            $this$convertScript_u24lambda_u2462.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$convertScript_u24lambda_u2462.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            Name name2 = Name.special("<script-" + fileName + '>');
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<script-$fileName>\")");
            $this$convertScript_u24lambda_u2462.setName(name2);
            FqName fqName2 = rawFirBuilder.getContext().getPackageFqName().child($this$convertScript_u24lambda_u2462.getName());
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"context.packageFqName.child(name)");
            $this$convertScript_u24lambda_u2462.setSymbol(new FirScriptSymbol(fqName2));
            for (KtDeclaration declaration : script.getDeclarations()) {
                if (declaration instanceof KtScriptInitializer) {
                    if (((KtScriptInitializer)declaration).getBody() != null) {
                        KtExpression it;
                        boolean bl2 = false;
                        $this$convertScript_u24lambda_u2462.getStatements().add(this.toFirStatement(it));
                    }
                    continue;
                }
                List<FirStatement> list2 = $this$convertScript_u24lambda_u2462.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"declaration");
                list2.add(this.toFirStatement(declaration));
            }
            setup.invoke((Object)$this$convertScript_u24lambda_u2462);
            return firScriptBuilder.build();
        }

        static /* synthetic */ FirScript convertScript$default(Visitor visitor2, KtScript ktScript, String string2, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertScript");
            }
            if ((n & 4) != 0) {
                function1 = convertScript.1.INSTANCE;
            }
            return visitor2.convertScript(ktScript, string2, (Function1<? super FirScriptBuilder, Unit>)function1);
        }

        @Override
        @NotNull
        public FirElement visitScript(@NotNull KtScript script, @Nullable Unit data2) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            String string2 = script.getContainingKtFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"script.containingKtFile.name");
            String fileName = string2;
            return Visitor.convertScript$default(this, script, fileName, null, 4, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        protected final FirDeclaration toFirEnumEntry(@NotNull KtEnumEntry $this$toFirEnumEntry, @NotNull FirResolvedTypeRef delegatedEnumSelfTypeRef, boolean ownerClassHasDefaultConstructor) {
            block20: {
                Intrinsics.checkNotNullParameter((Object)$this$toFirEnumEntry, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)delegatedEnumSelfTypeRef, (String)"delegatedEnumSelfTypeRef");
                ktEnumEntry = $this$toFirEnumEntry;
                containingClassIsExpectClass = PsiUtilsKt.hasExpectModifier($this$toFirEnumEntry) != false || RawFirBuilder.this.getContext().getContainerIsExpect() != false;
                var6_6 = RawFirBuilder.this;
                $i$f$buildEnumEntry = false;
                $this$toFirEnumEntry_u24lambda_u2471 = var8_9 = new FirEnumEntryBuilder();
                $i$a$-buildEnumEntry-RawFirBuilder$Visitor$toFirEnumEntry$1 = false;
                $this$toFirEnumEntry_u24lambda_u2471.setSource(BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)var6_6, $this$toFirEnumEntry, null, 1, null));
                $this$toFirEnumEntry_u24lambda_u2471.setModuleData(var6_6.getBaseModuleData());
                $this$toFirEnumEntry_u24lambda_u2471.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$toFirEnumEntry_u24lambda_u2471.setReturnTypeRef(delegatedEnumSelfTypeRef);
                v0 = $this$toFirEnumEntry.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"nameAsSafeName");
                $this$toFirEnumEntry_u24lambda_u2471.setName(v0);
                var12_14 = var11_13 /* !! */  = new FirDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL);
                var13_15 = $this$toFirEnumEntry_u24lambda_u2471;
                $i$a$-apply-RawFirBuilder$Visitor$toFirEnumEntry$1$1 = false;
                $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2463.setStatic(true);
                $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2463.setExpect(containingClassIsExpectClass);
                var13_15.setStatus(var11_13 /* !! */ );
                v1 = $this$toFirEnumEntry.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"nameAsSafeName");
                $this$toFirEnumEntry_u24lambda_u2471.setSymbol(new FirEnumEntrySymbol(var6_6.callableIdForName(v1)));
                if (ownerClassHasDefaultConstructor && ktEnumEntry.getInitializerList() == null && ktEnumEntry.getAnnotationEntries().isEmpty() && ktEnumEntry.getBody() == null) break block20;
                this.extractAnnotationsTo((KtAnnotated)$this$toFirEnumEntry, $this$toFirEnumEntry_u24lambda_u2471);
                v2 = $this$toFirEnumEntry_u24lambda_u2471;
                var11_13 /* !! */  = this;
                sourceElement$iv = var6_6.toFirSourceElement($this$toFirEnumEntry, (KtFakeSourceElementKind)KtFakeSourceElementKind.EnumInitializer.INSTANCE);
                $i$f$buildOrLazyExpression = false;
                var15_17 = this_$iv;
                lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
                $i$f$buildOrLazy = false;
                block2 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        var13_15 = v2;
                        $i$a$-buildOrLazyExpression-RawFirBuilder$Visitor$toFirEnumEntry$1$2 = false;
                        v3 = $this$toFirEnumEntry.getNameAsSafeName();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"nameAsSafeName");
                        var19_21 = v3;
                        isExpect$iv = false;
                        forceLocalContext$iv = false;
                        $i$f$withChildClassName = false;
                        v4 = ((BaseFirBuilder)var6_6).getContext();
                        v5 = ((BaseFirBuilder)var6_6).getContext().getClassName().child((Name)name$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"context.className.child(name)");
                        v4.setClassName(v5);
                        oldForcedLocalContext$iv = ((BaseFirBuilder)var6_6).getContext().getForcedLocalContext();
                        ((BaseFirBuilder)var6_6).getContext().setForcedLocalContext(((BaseFirBuilder)var6_6).getContext().getForcedLocalContext() != false);
                        previousIsExpect$iv = ((BaseFirBuilder)var6_6).getContext().getContainerIsExpect();
                        ((BaseFirBuilder)var6_6).getContext().setContainerIsExpect(previousIsExpect$iv != false);
                        dispatchReceiversNumber$iv = ((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size();
                        try {
                            $i$a$-withChildClassName$default-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1 = false;
                            $i$f$buildAnonymousObjectExpression = false;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468 = var28_30 = new FirAnonymousObjectExpressionBuilder();
                            $i$a$-buildAnonymousObjectExpression-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1 = false;
                            enumEntrySource = var6_6.toFirSourceElement($this$toFirEnumEntry, (KtFakeSourceElementKind)KtFakeSourceElementKind.EnumInitializer.INSTANCE);
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468.setSource(enumEntrySource);
                            $i$f$buildAnonymousObject = false;
                            var34_36 = var33_35 = new FirAnonymousObjectBuilder();
                            var35_37 = $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468;
                            $i$a$-buildAnonymousObject-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1 = false;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setSource(enumEntrySource);
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setModuleData(var6_6.getBaseModuleData());
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setClassKind(ClassKind.ENUM_ENTRY);
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setScopeProvider(var6_6.getBaseScopeProvider());
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setSymbol(new FirAnonymousObjectSymbol());
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
                            $i$f$buildResolvedTypeRef = false;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467_u24lambda_u2464 = var38_41 = new FirResolvedTypeRefBuilder();
                            $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1 = false;
                            $i$f$emptyArray = false;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467_u24lambda_u2464.setType(new ConeClassLikeTypeImpl($this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.getSymbol().toLookupTag(), new ConeTypeProjection[0], false, null, 8, null));
                            delegatedEntrySelfType = var38_41.build();
                            var6_6.registerSelfType(delegatedEntrySelfType);
                            ((Collection)$this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.getSuperTypeRefs()).add(delegatedEnumSelfTypeRef);
                            v6 = $this$toFirEnumEntry.getSuperTypeListEntries();
                            Intrinsics.checkNotNullExpressionValue(v6, (String)"superTypeListEntries");
                            $this$firstIsInstanceOrNull$iv = v6;
                            $i$f$firstIsInstanceOrNull = false;
                            $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1 = $this$firstIsInstanceOrNull$iv.iterator();
                            while ($i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1.hasNext()) {
                                element$iv = $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1.next();
                                if (!(element$iv instanceof KtSuperTypeCallEntry)) continue;
                                v7 = element$iv;
                                ** GOTO lbl98
                            }
                            v7 = null;
lbl98:
                            // 2 sources

                            superTypeCallEntry = v7;
                            $i$f$buildResolvedTypeRef = false;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467_u24lambda_u2465 = $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1 = new FirResolvedTypeRefBuilder();
                            $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$correctedEnumSelfTypeRef$1 = false;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467_u24lambda_u2465.setSource(superTypeCallEntry != null && (var44_53 = superTypeCallEntry.getCalleeExpression()) != null && (var45_55 = var44_53.getTypeReference()) != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)var6_6, var45_55, null, 1, null) : null);
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467_u24lambda_u2465.setType(delegatedEnumSelfTypeRef.getType());
                            correctedEnumSelfTypeRef = $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1.build();
                            ((Collection)$this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.getDeclarations()).add(this.toFirConstructor($this$toFirEnumEntry.getPrimaryConstructor(), superTypeCallEntry, correctedEnumSelfTypeRef, delegatedEntrySelfType, ktEnumEntry, $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.getTypeParameters(), containingClassIsExpectClass, true));
                            var39_44 = SpecialNames.ANONYMOUS;
                            $i$a$-buildResolvedTypeRef-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$delegatedEntrySelfType$1 = (BaseFirBuilder)var6_6;
                            $this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467_u24lambda_u2465 = false;
                            forceLocalContext$iv = true;
                            $i$f$withChildClassName = false;
                            v8 = this_$iv.getContext();
                            v9 = this_$iv.getContext().getClassName().child(var39_44);
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"context.className.child(name)");
                            v8.setClassName(v9);
                            oldForcedLocalContext$iv = this_$iv.getContext().getForcedLocalContext();
                            this_$iv.getContext().setForcedLocalContext(true);
                            previousIsExpect$iv = this_$iv.getContext().getContainerIsExpect();
                            this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv != false);
                            dispatchReceiversNumber$iv = this_$iv.getContext().getDispatchReceiverTypesStack().size();
                            try {
                                $i$a$-withChildClassName-RawFirBuilder$Visitor$toFirEnumEntry$1$2$1$1$1$1 = false;
                                for (KtDeclaration declaration : ktEnumEntry.getDeclarations()) {
                                    ((Collection)$this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467.getDeclarations()).add(this.toFirDeclaration(declaration, correctedEnumSelfTypeRef, delegatedEntrySelfType, ktEnumEntry, (FirClassBuilder)$this$toFirEnumEntry_u24lambda_u2471_u24lambda_u2470_u24lambda_u2469_u24lambda_u2468_u24lambda_u2467, CollectionsKt.emptyList()));
                                }
                                var51_62 = Unit.INSTANCE;
                                if (this_$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1) ** GOTO lbl150
                            }
                            catch (Throwable var53_65) {
                                if (!(this_$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1)) {
                                    $i$a$-require-BaseFirBuilder$withChildClassName$1$iv = false;
                                    var54_67 = "Wrong number of " + this_$iv.getContext().getDispatchReceiverTypesStack().size();
                                    throw new IllegalArgumentException(var54_67.toString());
                                }
                                if (this_$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                                    this_$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(this_$iv.getContext().getDispatchReceiverTypesStack()));
                                }
                                v10 = this_$iv.getContext();
                                v11 = this_$iv.getContext().getClassName().parent();
                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"context.className.parent()");
                                v10.setClassName(v11);
                                this_$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                                this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
                                throw var53_65;
                            }
                            $i$a$-require-BaseFirBuilder$withChildClassName$1$iv = false;
                            var52_64 = "Wrong number of " + this_$iv.getContext().getDispatchReceiverTypesStack().size();
                            throw new IllegalArgumentException(var52_64.toString());
lbl150:
                            // 1 sources

                            if (this_$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                                this_$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(this_$iv.getContext().getDispatchReceiverTypesStack()));
                            }
                            v12 = this_$iv.getContext();
                            v13 = this_$iv.getContext().getClassName().parent();
                            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"context.className.parent()");
                            v12.setClassName(v13);
                            this_$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                            this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
                            var35_37.setAnonymousObject(var33_35.build());
                            var55_68 = var28_30.build();
                            if (((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1) ** GOTO lbl186
                        }
                        catch (Throwable var57_71) {
                            if (!(((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1)) {
                                $i$a$-require-BaseFirBuilder$withChildClassName$1$iv = false;
                                var58_73 = "Wrong number of " + ((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size();
                                throw new IllegalArgumentException(var58_73.toString());
                            }
                            if (((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                                ((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack()));
                            }
                            v14 = ((BaseFirBuilder)var6_6).getContext();
                            v15 = ((BaseFirBuilder)var6_6).getContext().getClassName().parent();
                            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"context.className.parent()");
                            v14.setClassName(v15);
                            ((BaseFirBuilder)var6_6).getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                            ((BaseFirBuilder)var6_6).getContext().setContainerIsExpect(previousIsExpect$iv);
                            throw var57_71;
                        }
                        $i$a$-require-BaseFirBuilder$withChildClassName$1$iv = false;
                        var56_70 = "Wrong number of " + ((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size();
                        throw new IllegalArgumentException(var56_70.toString());
lbl186:
                        // 1 sources

                        if (((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                            ((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(((BaseFirBuilder)var6_6).getContext().getDispatchReceiverTypesStack()));
                        }
                        v16 = ((BaseFirBuilder)var6_6).getContext();
                        v17 = ((BaseFirBuilder)var6_6).getContext().getClassName().parent();
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"context.className.parent()");
                        v16.setClassName(v17);
                        ((BaseFirBuilder)var6_6).getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                        ((BaseFirBuilder)var6_6).getContext().setContainerIsExpect(previousIsExpect$iv);
                        v18 = var55_68;
                        v2 = var13_15;
                        break;
                    }
                    case 2: {
                        this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                v18 = lazy$iv$iv.invoke();
                                break block2;
                            }
                            case 2: {
                                v18 = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block2;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                v2.setInitializer((FirExpression)v18);
            }
            var6_6 = var8_9.build();
            var7_8 = RawFirBuilder.this;
            $this$toFirEnumEntry_u24lambda_u2472 = var6_6;
            $i$a$-apply-RawFirBuilder$Visitor$toFirEnumEntry$2 = false;
            v19 = (FirCallableDeclaration)$this$toFirEnumEntry_u24lambda_u2472;
            v20 = var7_8.currentDispatchReceiverType();
            Intrinsics.checkNotNull((Object)v20);
            ClassMembersKt.setContainingClassForStaticMemberAttr(v19, v20.getLookupTag());
            return (FirDeclaration)var6_6;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirContextReceiver> convertContextReceivers(List<KtContextReceiver> receivers) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = receivers;
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                FirElement firElement2;
                Name name2;
                void contextReceiverElement;
                FirContextReceiverBuilder firContextReceiverBuilder;
                KtContextReceiver ktContextReceiver = (KtContextReceiver)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                boolean $i$f$buildContextReceiver = false;
                FirContextReceiverBuilder $this$convertContextReceivers_u24lambda_u2476_u24lambda_u2475 = firContextReceiverBuilder = new FirContextReceiverBuilder();
                boolean bl2 = false;
                $this$convertContextReceivers_u24lambda_u2476_u24lambda_u2475.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, contextReceiverElement, null, 1, null));
                $this$convertContextReceivers_u24lambda_u2476_u24lambda_u2475.setCustomLabelName(contextReceiverElement.labelNameAsName());
                FirContextReceiverBuilder firContextReceiverBuilder2 = $this$convertContextReceivers_u24lambda_u2476_u24lambda_u2475;
                Object object = contextReceiverElement.typeReference();
                if (object != null && (object = ((KtTypeReference)object).nameForReceiverLabel()) != null) {
                    void p0;
                    Object object2 = object;
                    FirContextReceiverBuilder firContextReceiverBuilder3 = firContextReceiverBuilder2;
                    boolean bl3 = false;
                    name2 = Name.identifier((String)p0);
                    firContextReceiverBuilder2 = firContextReceiverBuilder3;
                } else {
                    name2 = null;
                }
                firContextReceiverBuilder2.setLabelNameFromTypeRef(name2);
                Visitor visitor2 = this;
                KtElement $this$convertSafe$iv = contextReceiverElement.typeReference();
                boolean $i$f$convertSafe = false;
                if ($this$convertSafe$iv != null) {
                    KtElement p0$iv;
                    void this_$iv;
                    boolean bl4 = false;
                    firElement2 = this_$iv.convertElement(p0$iv);
                } else {
                    firElement2 = firElement = null;
                }
                if (!(firElement2 instanceof FirTypeRef)) {
                    firElement = null;
                }
                if ((FirTypeRef)((FirElement)((FirTypeRef)firElement)) != null) {
                    FirTypeRef it;
                    boolean bl5 = false;
                    $this$convertContextReceivers_u24lambda_u2476_u24lambda_u2475.setTypeRef(it);
                }
                collection.add(firContextReceiverBuilder.build());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @NotNull
        public FirElement visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull Unit data) {
            block27: {
                Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (classOrObject.isLocal()) ** GOTO lbl-1000
                $this$getStrictParentOfType$iv = classOrObject;
                $i$f$getStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtEnumEntry.class, (boolean)true) != null) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                isLocal = v0;
                classIsExpect = PsiUtilsKt.hasExpectModifier(classOrObject) != false || RawFirBuilder.this.getContext().getContainerIsExpect() != false;
                $i$f$getStrictParentOfType = RawFirBuilder.this;
                v1 = classOrObject.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"classOrObject.nameAsSafeName");
                var6_8 = v1;
                var7_9 = RawFirBuilder.this;
                $i$f$withChildClassName = false;
                v2 = this_$iv.getContext();
                v3 = this_$iv.getContext().getClassName().child((Name)name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"context.className.child(name)");
                v2.setClassName(v3);
                oldForcedLocalContext$iv = this_$iv.getContext().getForcedLocalContext();
                this_$iv.getContext().setForcedLocalContext(isLocal != false || this_$iv.getContext().getForcedLocalContext() != false);
                previousIsExpect$iv = this_$iv.getContext().getContainerIsExpect();
                this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv != false || classIsExpect != false);
                dispatchReceiversNumber$iv = this_$iv.getContext().getDispatchReceiverTypesStack().size();
                try {
                    $i$a$-withChildClassName-RawFirBuilder$Visitor$visitClassOrObject$1 = false;
                    var13_15 = classOrObject;
                    if (var13_15 instanceof KtObjectDeclaration) {
                        v4 = ClassKind.OBJECT;
                    } else if (var13_15 instanceof KtClass) {
                        v4 = ((KtClass)classOrObject).isInterface() ? ClassKind.INTERFACE : (((KtClass)classOrObject).isEnum() ? ClassKind.ENUM_CLASS : (classOrObject.isAnnotation() ? ClassKind.ANNOTATION_CLASS : ClassKind.CLASS));
                    } else {
                        throw new AssertionError((Object)("Unexpected class or object: " + classOrObject.getText()));
                    }
                    classKind = v4;
                    var15_17 = new FirDeclarationStatusImpl(isLocal != false ? (Visibility)Visibilities.Local.INSTANCE : RawFirBuilder.access$getVisibility(var7_9, classOrObject), RawFirBuilder.access$getModality(var7_9, classOrObject));
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477 = var15_17;
                    $i$a$-apply-RawFirBuilder$Visitor$visitClassOrObject$1$status$1 = false;
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setExpect(classIsExpect);
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setActual(PsiUtilsKt.hasActualModifier(classOrObject));
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setInner(classOrObject.hasModifier(KtTokens.INNER_KEYWORD));
                    v5 = classOrObject instanceof KtObjectDeclaration != false ? (KtObjectDeclaration)classOrObject : null;
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setCompanion(v5 != null ? v5.isCompanion() : false);
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setData(classOrObject.hasModifier(KtTokens.DATA_KEYWORD));
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setInline(classOrObject.hasModifier(KtTokens.INLINE_KEYWORD) != false || classOrObject.hasModifier(KtTokens.VALUE_KEYWORD) != false);
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setFun(classOrObject.hasModifier(KtTokens.FUN_KEYWORD));
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477.setExternal(classOrObject.hasModifier(KtTokens.EXTERNAL_KEYWORD));
                    status = var15_17;
                    var15_17 = var7_9;
                    $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2477 = status.isInner() != false || isLocal != false;
                    $i$a$-apply-RawFirBuilder$Visitor$visitClassOrObject$1$status$1 = BaseFirBuilder.toFirSourceElement$default(var7_9, classOrObject, null, 1, null);
                    var18_22 = CollectionsKt.emptyList();
                    $i$f$withCapturedTypeParameters = false;
                    BaseFirBuilder.access$addCapturedTypeParameters((BaseFirBuilder)this_$iv, (boolean)status$iv, (KtSourceElement)declarationSource$iv, (List)currentFirTypeParameters$iv);
                    try {
                        block25: {
                            $i$a$-withCapturedTypeParameters-RawFirBuilder$Visitor$visitClassOrObject$1$1 = false;
                            delegatedFieldsMap = null;
                            $i$f$buildRegularClass = false;
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482 = var23_28 = new FirRegularClassBuilder();
                            $i$a$-buildRegularClass-RawFirBuilder$Visitor$visitClassOrObject$1$1$1 = false;
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setSource(BaseFirBuilder.toFirSourceElement$default(var7_9, classOrObject, null, 1, null));
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setModuleData(var7_9.getBaseModuleData());
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                            v6 = classOrObject.getNameAsSafeName();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"classOrObject.nameAsSafeName");
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setName(v6);
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setStatus(status);
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setClassKind(classKind);
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setScopeProvider(var7_9.getBaseScopeProvider());
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.setSymbol(new FirRegularClassSymbol(var7_9.getContext().getCurrentClassId()));
                            this.extractAnnotationsTo((KtAnnotated)classOrObject, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482);
                            this.extractTypeParametersTo((KtTypeParameterListOwner)classOrObject, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, (FirBasedSymbol)$this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getSymbol());
                            var7_9.getContext().appendOuterTypeParameters(true, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getTypeParameters());
                            var7_9.getContext().pushFirTypeParameters(status.isInner() != false || isLocal != false, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getTypeParameters().subList(0, classOrObject.getTypeParameters().size()));
                            delegatedSelfType = var7_9.toDelegatedSelfType(classOrObject, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482);
                            var7_9.registerSelfType(delegatedSelfType);
                            var27_33 = this.extractSuperTypeListEntriesTo(classOrObject, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, delegatedSelfType, null, classKind, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getTypeParameters(), classIsExpect);
                            delegatedSuperType = (FirTypeRef)var27_33.component1();
                            delegatedFieldsMap = extractedDelegatedFieldsMap = (Map)var27_33.component2();
                            primaryConstructor = classOrObject.getPrimaryConstructor();
                            $this$firstOrNull$iv = $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getDeclarations();
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (FirDeclaration)element$iv /* !! */ ;
                                $i$a$-firstOrNull-RawFirBuilder$Visitor$visitClassOrObject$1$1$1$firPrimaryConstructor$1 = false;
                                if (!(it instanceof FirConstructor)) continue;
                                v7 = (Iterable)element$iv /* !! */ ;
                                break block25;
                            }
                            v7 = null;
                        }
                        var37_51 = v7;
                        v8 = firPrimaryConstructor = var37_51 instanceof FirConstructor != false ? (FirConstructor)var37_51 : null;
                        if (primaryConstructor != null && firPrimaryConstructor != null) {
                            var37_51 = CollectionsKt.zip((Iterable)primaryConstructor.getValueParameters(), (Iterable)firPrimaryConstructor.getValueParameters());
                            $i$f$forEach = false;
                            $i$f$firstOrNull = $this$forEach$iv.iterator();
                            while ($i$f$firstOrNull.hasNext()) {
                                element$iv /* !! */  = $i$f$firstOrNull.next();
                                element$iv /* !! */  = (Pair)element$iv /* !! */ ;
                                $i$a$-forEach-RawFirBuilder$Visitor$visitClassOrObject$1$1$1$1 = false;
                                ktParameter = (KtParameter)element$iv /* !! */ .component1();
                                firParameter = (FirValueParameter)element$iv /* !! */ .component2();
                                if (!ktParameter.hasValOrVar()) continue;
                                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"ktParameter");
                                FirDeclarationBuildingUtilsKt.addDeclaration($this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, this.toFirProperty(ktParameter, firParameter));
                            }
                        }
                        for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                            FirDeclarationBuildingUtilsKt.addDeclaration($this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, this.toFirDeclaration(declaration, delegatedSuperType, delegatedSelfType, classOrObject, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getTypeParameters()));
                        }
                        v9 = classOrObject.getBody();
                        if (v9 == null || (v9 = v9.getDanglingModifierLists()) == null) {
                            v9 = CollectionsKt.emptyList();
                        }
                        $this$forEach$iv = v9.iterator();
                        while ($this$forEach$iv.hasNext()) {
                            danglingModifier = (KtModifierList)$this$forEach$iv.next();
                            $i$f$firstOrNull = this.buildErrorTopLevelDeclarationForDanglingModifierList(danglingModifier);
                            element$iv /* !! */  = $i$f$firstOrNull;
                            var40_54 = $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482;
                            $i$a$-apply-RawFirBuilder$Visitor$visitClassOrObject$1$1$1$2 = false;
                            v10 = var7_9.currentDispatchReceiverType();
                            ClassMembersKt.setContainingClassAttr((FirDanglingModifierList)$this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482_u24lambda_u2480, v10 != null ? v10.getLookupTag() : null);
                            FirDeclarationBuildingUtilsKt.addDeclaration((FirRegularClassBuilder)var40_54, $i$f$firstOrNull);
                        }
                        if (classOrObject.hasModifier(KtTokens.DATA_KEYWORD) && firPrimaryConstructor != null) {
                            $this$filter$iv = classOrObject.getPrimaryConstructorParameters();
                            $i$f$filter = false;
                            $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482_u24lambda_u2480 = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (KtParameter)element$iv$iv;
                                $i$a$-filter-RawFirBuilder$Visitor$visitClassOrObject$1$1$1$zippedParameters$1 = false;
                                if (!it.hasValOrVar()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getDeclarations();
                            var40_54 = (List)destination$iv$iv;
                            $i$f$filterIsInstance = false;
                            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof FirProperty)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            zippedParameters = CollectionsKt.zip((Iterable)var40_54, (Iterable)((List)destination$iv$iv));
                            var7_9.new BaseFirBuilder.DataClassMembersGenerator(classOrObject, $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, zippedParameters, var7_9.getContext().getPackageFqName(), var7_9.getContext().getClassName(), (Function1<? super KtFakeSourceElementKind, ? extends FirTypeRef>)((Function1)new Function1<KtFakeSourceElementKind, FirTypeRef>(firPrimaryConstructor){
                                final /* synthetic */ FirConstructor $firPrimaryConstructor;
                                {
                                    this.$firPrimaryConstructor = $firPrimaryConstructor;
                                    super(1);
                                }

                                @NotNull
                                public final FirTypeRef invoke(@NotNull KtFakeSourceElementKind it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return UtilsKt.copyWithNewSourceKind(this.$firPrimaryConstructor.getReturnTypeRef(), it);
                                }
                            }), (Function2<? super FirProperty, ? super KtFakeSourceElementKind, ? extends FirTypeRef>)((Function2)new Function2<FirProperty, KtFakeSourceElementKind, FirTypeRef>(var7_9, this){
                                final /* synthetic */ RawFirBuilder this$0;
                                final /* synthetic */ Visitor this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                    super(2);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final FirTypeRef invoke(@NotNull FirProperty property, @NotNull KtFakeSourceElementKind newKind) {
                                    FirTypeRef firTypeRef;
                                    void this_$iv;
                                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                                    Intrinsics.checkNotNullParameter((Object)newKind, (String)"newKind");
                                    BaseFirBuilder baseFirBuilder = this.this$0;
                                    Visitor visitor2 = this.this$1;
                                    boolean $i$f$withDefaultSourceElementKind = false;
                                    KtSourceElementKind currentForced$iv = this_$iv.getContext().getForcedElementSourceKind();
                                    this_$iv.getContext().setForcedElementSourceKind(newKind);
                                    try {
                                        boolean bl = false;
                                        firTypeRef = Visitor.access$toFirOrImplicitType(visitor2, (KtTypeReference)UtilsKt.getPsi(property.getReturnTypeRef()));
                                    }
                                    finally {
                                        this_$iv.getContext().setForcedElementSourceKind(currentForced$iv);
                                    }
                                    return firTypeRef;
                                }
                            })).generate();
                        }
                        if (classOrObject.hasModifier(KtTokens.ENUM_KEYWORD)) {
                            EnumClassUtilsKt.generateValuesFunction($this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, var7_9.getBaseModuleData(), var7_9.getContext().getPackageFqName(), var7_9.getContext().getClassName(), classIsExpect);
                            EnumClassUtilsKt.generateValueOfFunction($this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, var7_9.getBaseModuleData(), var7_9.getContext().getPackageFqName(), var7_9.getContext().getClassName(), classIsExpect);
                            EnumClassUtilsKt.generateEntriesGetter($this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482, var7_9.getBaseModuleData(), var7_9.getContext().getPackageFqName(), var7_9.getContext().getClassName(), classIsExpect);
                        }
                        var7_9.initCompanionObjectSymbolAttr($this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482);
                        var7_9.getContext().popFirTypeParameters();
                        $this$visitClassOrObject_u24lambda_u2485_u24lambda_u2484_u24lambda_u2482.getContextReceivers().addAll((Collection<FirContextReceiver>)this.convertContextReceivers(classOrObject.getContextReceivers()));
                        it = var22_27 = var23_28.build();
                        $i$a$-also-RawFirBuilder$Visitor$visitClassOrObject$1$1$2 = false;
                        DelegateFieldsMapKt.setDelegateFieldsMap(it, delegatedFieldsMap);
                        var43_57 = var22_27;
                    }
                    finally {
                        this_$iv.getContext().popFirTypeParameters();
                    }
                    var45_59 = var43_57;
                    if (this_$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1) break block27;
                }
                catch (Throwable var47_62) {
                    if (!(this_$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1)) {
                        $i$a$-require-BaseFirBuilder$withChildClassName$1$iv = false;
                        var48_64 = "Wrong number of " + this_$iv.getContext().getDispatchReceiverTypesStack().size();
                        throw new IllegalArgumentException(var48_64.toString());
                    }
                    if (this_$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                        this_$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(this_$iv.getContext().getDispatchReceiverTypesStack()));
                    }
                    v11 = this_$iv.getContext();
                    v12 = this_$iv.getContext().getClassName().parent();
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"context.className.parent()");
                    v11.setClassName(v12);
                    this_$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                    this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
                    throw var47_62;
                }
                $i$a$-require-BaseFirBuilder$withChildClassName$1$iv = false;
                var46_61 = "Wrong number of " + this_$iv.getContext().getDispatchReceiverTypesStack().size();
                throw new IllegalArgumentException(var46_61.toString());
            }
            if (this_$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                this_$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(this_$iv.getContext().getDispatchReceiverTypesStack()));
            }
            v13 = this_$iv.getContext();
            v14 = this_$iv.getContext().getClassName().parent();
            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"context.className.parent()");
            v13.setClassName(v14);
            this_$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
            this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
            var5_6 = var45_59;
            var6_8 = RawFirBuilder.this;
            it = var5_6;
            $i$a$-also-RawFirBuilder$Visitor$visitClassOrObject$2 = false;
            if (classOrObject.getParent() instanceof KtClassBody) {
                var6_8.initContainingClassForLocalAttr(it);
            }
            this.fillDanglingConstraintsTo(classOrObject, (FirDeclaration)it);
            return var5_6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, @NotNull Unit data2) {
            FirAnonymousObjectExpression firAnonymousObjectExpression;
            int dispatchReceiversNumber$iv;
            boolean previousIsExpect$iv;
            boolean oldForcedLocalContext$iv;
            void this_$iv;
            block8: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                Name name2 = SpecialNames.ANONYMOUS;
                BaseFirBuilder baseFirBuilder = RawFirBuilder.this;
                boolean bl = false;
                boolean bl2 = true;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$withChildClassName = false;
                Context context = this_$iv.getContext();
                FqName fqName2 = this_$iv.getContext().getClassName().child(name2);
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"context.className.child(name)");
                context.setClassName(fqName2);
                oldForcedLocalContext$iv = this_$iv.getContext().getForcedLocalContext();
                this_$iv.getContext().setForcedLocalContext(true);
                previousIsExpect$iv = this_$iv.getContext().getContainerIsExpect();
                this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
                dispatchReceiversNumber$iv = this_$iv.getContext().getDispatchReceiverTypesStack().size();
                try {
                    void it;
                    Map extractedDelegatedFieldsMap;
                    void $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488;
                    FirAnonymousObjectExpressionBuilder firAnonymousObjectExpressionBuilder;
                    boolean bl3 = false;
                    Map delegatedFieldsMap = null;
                    boolean $i$f$buildAnonymousObjectExpression = false;
                    FirAnonymousObjectExpressionBuilder $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490 = firAnonymousObjectExpressionBuilder = new FirAnonymousObjectExpressionBuilder();
                    boolean bl4 = false;
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
                    boolean $i$f$buildAnonymousObject = false;
                    Object object = new FirAnonymousObjectBuilder();
                    FirAnonymousObjectBuilder firAnonymousObjectBuilder = object;
                    FirAnonymousObjectExpressionBuilder firAnonymousObjectExpressionBuilder2 = $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490;
                    boolean bl5 = false;
                    KtObjectDeclaration ktObjectDeclaration = expression2.getObjectDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"expression.objectDeclaration");
                    KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, objectDeclaration, null, 1, null));
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setModuleData(rawFirBuilder.getBaseModuleData());
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setClassKind(ClassKind.OBJECT);
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setScopeProvider(rawFirBuilder.getBaseScopeProvider());
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setSymbol(new FirAnonymousObjectSymbol());
                    $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
                    rawFirBuilder.getContext().appendOuterTypeParameters(false, $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.getTypeParameters());
                    FirResolvedTypeRef delegatedSelfType = rawFirBuilder.toDelegatedSelfType(objectDeclaration, (FirAnonymousObjectBuilder)$this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488);
                    rawFirBuilder.registerSelfType(delegatedSelfType);
                    this.extractAnnotationsTo((KtAnnotated)objectDeclaration, (FirAnnotationContainerBuilder)$this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488);
                    Pair<FirTypeRef, Map<Integer, FirFieldSymbol>> pair = this.extractSuperTypeListEntriesTo(objectDeclaration, (FirClassBuilder)$this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488, delegatedSelfType, null, ClassKind.CLASS, CollectionsKt.emptyList(), false);
                    FirTypeRef delegatedSuperType = (FirTypeRef)pair.component1();
                    delegatedFieldsMap = extractedDelegatedFieldsMap = (Map)pair.component2();
                    for (KtDeclaration declaration : objectDeclaration.getDeclarations()) {
                        ((Collection)$this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.getDeclarations()).add(this.toFirDeclaration(declaration, delegatedSuperType, delegatedSelfType, objectDeclaration, (FirClassBuilder)$this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488, CollectionsKt.emptyList()));
                    }
                    Object object2 = objectDeclaration.getBody();
                    if (object2 == null || (object2 = ((KtClassBody)object2).getDanglingModifierLists()) == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    Iterator<KtDeclaration> iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        FirDanglingModifierList firDanglingModifierList;
                        KtModifierList danglingModifier = (KtModifierList)((Object)iterator2.next());
                        Collection collection = $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488.getDeclarations();
                        FirDanglingModifierList $this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488_u24lambda_u2487 = firDanglingModifierList = this.buildErrorTopLevelDeclarationForDanglingModifierList(danglingModifier);
                        boolean bl6 = false;
                        ConeClassLikeType coneClassLikeType = rawFirBuilder.currentDispatchReceiverType();
                        ClassMembersKt.setContainingClassAttr($this$visitObjectLiteralExpression_u24lambda_u2491_u24lambda_u2490_u24lambda_u2488_u24lambda_u2487, coneClassLikeType != null ? coneClassLikeType.getLookupTag() : null);
                        collection.add(firDanglingModifierList);
                    }
                    FirAnonymousObject firAnonymousObject = ((FirAnonymousObjectBuilder)object).build();
                    object = firAnonymousObject;
                    boolean bl7 = false;
                    DelegateFieldsMapKt.setDelegateFieldsMap((FirClass)it, delegatedFieldsMap);
                    firAnonymousObjectExpressionBuilder2.setAnonymousObject(firAnonymousObject);
                    firAnonymousObjectExpression = firAnonymousObjectExpressionBuilder.build();
                    if (this_$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1) break block8;
                }
                catch (Throwable throwable) {
                    if (!(this_$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1)) {
                        boolean bl8 = false;
                        String string2 = "Wrong number of " + this_$iv.getContext().getDispatchReceiverTypesStack().size();
                        throw new IllegalArgumentException(string2.toString());
                    }
                    if (this_$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                        this_$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(this_$iv.getContext().getDispatchReceiverTypesStack()));
                    }
                    Context context2 = this_$iv.getContext();
                    FqName fqName3 = this_$iv.getContext().getClassName().parent();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"context.className.parent()");
                    context2.setClassName(fqName3);
                    this_$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                    this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
                    throw throwable;
                }
                boolean bl9 = false;
                String string3 = "Wrong number of " + this_$iv.getContext().getDispatchReceiverTypesStack().size();
                throw new IllegalArgumentException(string3.toString());
            }
            if (this_$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                this_$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex(this_$iv.getContext().getDispatchReceiverTypesStack()));
            }
            Context context = this_$iv.getContext();
            FqName fqName4 = this_$iv.getContext().getClassName().parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"context.className.parent()");
            context.setClassName(fqName4);
            this_$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
            this_$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
            return firAnonymousObjectExpression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull Unit data2) {
            FirTypeAlias firTypeAlias;
            int dispatchReceiversNumber$iv;
            boolean previousIsExpect$iv;
            boolean oldForcedLocalContext$iv;
            void $this$iv;
            block5: {
                void name$iv;
                Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                boolean typeAliasIsExpect = PsiUtilsKt.hasExpectModifier(typeAlias) || RawFirBuilder.this.getContext().getContainerIsExpect();
                BaseFirBuilder baseFirBuilder = RawFirBuilder.this;
                Name name2 = typeAlias.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"typeAlias.nameAsSafeName");
                Name name3 = name2;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean forceLocalContext$iv = false;
                boolean $i$f$withChildClassName = false;
                Context context = $this$iv.getContext();
                FqName fqName2 = $this$iv.getContext().getClassName().child((Name)name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"context.className.child(name)");
                context.setClassName(fqName2);
                oldForcedLocalContext$iv = $this$iv.getContext().getForcedLocalContext();
                $this$iv.getContext().setForcedLocalContext($this$iv.getContext().getForcedLocalContext());
                previousIsExpect$iv = $this$iv.getContext().getContainerIsExpect();
                $this$iv.getContext().setContainerIsExpect(previousIsExpect$iv || typeAliasIsExpect);
                dispatchReceiversNumber$iv = $this$iv.getContext().getDispatchReceiverTypesStack().size();
                try {
                    void $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492;
                    FirDeclarationStatusImpl firDeclarationStatusImpl;
                    FirTypeAliasBuilder firTypeAliasBuilder;
                    boolean bl = false;
                    boolean $i$f$buildTypeAlias = false;
                    FirTypeAliasBuilder $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493 = firTypeAliasBuilder = new FirTypeAliasBuilder();
                    boolean bl2 = false;
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, typeAlias, null, 1, null));
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.setModuleData(rawFirBuilder.getBaseModuleData());
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                    Name name4 = typeAlias.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"typeAlias.nameAsSafeName");
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.setName(name4);
                    FirDeclarationStatusImpl firDeclarationStatusImpl2 = firDeclarationStatusImpl = new FirDeclarationStatusImpl(rawFirBuilder.getVisibility(typeAlias), Modality.FINAL);
                    FirTypeAliasBuilder firTypeAliasBuilder2 = $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493;
                    boolean bl3 = false;
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492.setExpect(typeAliasIsExpect);
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493_u24lambda_u2492.setActual(PsiUtilsKt.hasActualModifier(typeAlias));
                    firTypeAliasBuilder2.setStatus(firDeclarationStatusImpl);
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.setSymbol(new FirTypeAliasSymbol(rawFirBuilder.getContext().getCurrentClassId()));
                    $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.setExpandedTypeRef(this.toFirOrErrorType(typeAlias.getTypeReference()));
                    this.extractAnnotationsTo((KtAnnotated)typeAlias, $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493);
                    this.extractTypeParametersTo((KtTypeParameterListOwner)typeAlias, $this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493, (FirBasedSymbol)$this$visitTypeAlias_u24lambda_u2494_u24lambda_u2493.getSymbol());
                    firTypeAlias = firTypeAliasBuilder.build();
                    if ($this$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1) break block5;
                }
                catch (Throwable throwable) {
                    if (!($this$iv.getContext().getDispatchReceiverTypesStack().size() <= dispatchReceiversNumber$iv + 1)) {
                        boolean bl = false;
                        String string2 = "Wrong number of " + $this$iv.getContext().getDispatchReceiverTypesStack().size();
                        throw new IllegalArgumentException(string2.toString());
                    }
                    if ($this$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                        $this$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex($this$iv.getContext().getDispatchReceiverTypesStack()));
                    }
                    Context context2 = $this$iv.getContext();
                    FqName fqName3 = $this$iv.getContext().getClassName().parent();
                    Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"context.className.parent()");
                    context2.setClassName(fqName3);
                    $this$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
                    $this$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
                    throw throwable;
                }
                boolean bl = false;
                String string3 = "Wrong number of " + $this$iv.getContext().getDispatchReceiverTypesStack().size();
                throw new IllegalArgumentException(string3.toString());
            }
            if ($this$iv.getContext().getDispatchReceiverTypesStack().size() > dispatchReceiversNumber$iv) {
                $this$iv.getContext().getDispatchReceiverTypesStack().remove(CollectionsKt.getLastIndex($this$iv.getContext().getDispatchReceiverTypesStack()));
            }
            Context context = $this$iv.getContext();
            FqName fqName4 = $this$iv.getContext().getClassName().parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"context.className.parent()");
            context.setClassName(fqName4);
            $this$iv.getContext().setForcedLocalContext(oldForcedLocalContext$iv);
            $this$iv.getContext().setContainerIsExpect(previousIsExpect$iv);
            return firTypeAlias;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull Unit data2) {
            FirElement firElement;
            FirFunctionBuilder firFunctionBuilder;
            Object it;
            FirFunctionBuilder firFunctionBuilder2;
            Object object;
            boolean bl;
            RawFirBuilder rawFirBuilder;
            FirFunctionBuilder firFunctionBuilder3;
            FirElement firElement2;
            FirElement firElement3;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtTypeReference typeReference = function2.getTypeReference();
            FirTypeRef returnType2 = function2.hasBlockBody() ? this.toFirOrUnitType(typeReference) : this.toFirOrImplicitType(typeReference);
            Visitor visitor2 = this;
            KtElement $this$convertSafe$iv = function2.getReceiverTypeReference();
            boolean $i$f$convertSafe = false;
            KtElement ktElement = $this$convertSafe$iv;
            if (ktElement != null) {
                void this_$iv2;
                KtElement p0$iv = ktElement;
                boolean bl2 = false;
                firElement3 = this_$iv2.convertElement(p0$iv);
            } else {
                firElement3 = firElement2 = null;
            }
            if (!(firElement3 instanceof FirTypeRef)) {
                firElement2 = null;
            }
            FirTypeRef receiverType = (FirTypeRef)((FirElement)((FirTypeRef)firElement2));
            Ref.ObjectRef labelName = new Ref.ObjectRef();
            boolean isAnonymousFunction = function2.isAnonymous();
            boolean isLocalFunction = function2.isLocal();
            Object functionSymbol = null;
            if (isAnonymousFunction) {
                firFunctionBuilder3 = new FirAnonymousFunctionBuilder();
                rawFirBuilder = RawFirBuilder.this;
                FirFunctionBuilder $this$visitNamedFunction_u24lambda_u2496 = firFunctionBuilder3;
                bl = false;
                FirTypeRef firTypeRef = receiverType;
                ((FirAnonymousFunctionBuilder)$this$visitNamedFunction_u24lambda_u2496).setReceiverParameter(firTypeRef != null ? ConversionUtilsKt.convertToReceiverParameter(firTypeRef) : null);
                object = new FirAnonymousFunctionSymbol();
                FirAnonymousFunctionSymbol firAnonymousFunctionSymbol = object;
                firFunctionBuilder2 = $this$visitNamedFunction_u24lambda_u2496;
                boolean bl2 = false;
                functionSymbol = it;
                ((FirAnonymousFunctionBuilder)firFunctionBuilder2).setSymbol((FirAnonymousFunctionSymbol)object);
                ((FirAnonymousFunctionBuilder)$this$visitNamedFunction_u24lambda_u2496).setLambda(false);
                ((FirAnonymousFunctionBuilder)$this$visitNamedFunction_u24lambda_u2496).setHasExplicitParameterList(true);
                ((FirAnonymousFunctionBuilder)$this$visitNamedFunction_u24lambda_u2496).setLabel(rawFirBuilder.getContext().getLastLabel(function2));
                Object object2 = ((FirAnonymousFunctionBuilder)$this$visitNamedFunction_u24lambda_u2496).getLabel();
                if (object2 == null || (object2 = ((FirLabel)object2).getName()) == null) {
                    Name name2 = (Name)CollectionsKt.lastOrNull(rawFirBuilder.getContext().getCalleeNamesForLambda());
                    object2 = name2 != null ? name2.getIdentifier() : null;
                }
                labelName.element = object2;
                firFunctionBuilder = firFunctionBuilder3;
            } else {
                void $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499;
                FirDeclarationStatusImpl firDeclarationStatusImpl;
                FirDeclarationStatusImpl it2;
                FirNamedFunctionSymbol object5;
                firFunctionBuilder3 = new FirSimpleFunctionBuilder();
                rawFirBuilder = RawFirBuilder.this;
                FirFunctionBuilder $this$visitNamedFunction_u24lambda_u24100 = firFunctionBuilder3;
                bl = false;
                FirTypeRef firTypeRef = receiverType;
                ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24100).setReceiverParameter(firTypeRef != null ? ConversionUtilsKt.convertToReceiverParameter(firTypeRef) : null);
                Name name3 = function2.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"function.nameAsSafeName");
                ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24100).setName(name3);
                Object object3 = labelName;
                Object object4 = rawFirBuilder.getContext().getLastLabel(function2);
                if (object4 == null || (object4 = ((FirLabel)object4).getName()) == null) {
                    boolean condition$iv = !((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24100).getName().isSpecial();
                    boolean $i$f$runIf = false;
                    if (condition$iv) {
                        firFunctionBuilder2 = object3;
                        boolean bl3 = false;
                        object4 = ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24100).getName().getIdentifier();
                        object3 = firFunctionBuilder2;
                    } else {
                        object4 = null;
                    }
                }
                object3.element = object4;
                Name name4 = function2.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"function.nameAsSafeName");
                FirNamedFunctionSymbol firNamedFunctionSymbol = object5 = new FirNamedFunctionSymbol(rawFirBuilder.callableIdForName(name4));
                firFunctionBuilder2 = $this$visitNamedFunction_u24lambda_u24100;
                boolean bl4 = false;
                functionSymbol = it2;
                ((FirSimpleFunctionBuilder)firFunctionBuilder2).setSymbol(object5);
                ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24100).setDispatchReceiverType(rawFirBuilder.currentDispatchReceiverType());
                it2 = firDeclarationStatusImpl = new FirDeclarationStatusImpl(isLocalFunction ? (Visibility)Visibilities.Local.INSTANCE : rawFirBuilder.getVisibility(function2), rawFirBuilder.getModality(function2));
                firFunctionBuilder2 = $this$visitNamedFunction_u24lambda_u24100;
                boolean bl5 = false;
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setExpect(PsiUtilsKt.hasExpectModifier(function2) || rawFirBuilder.getContext().getContainerIsExpect());
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setActual(PsiUtilsKt.hasActualModifier(function2));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setOverride(function2.hasModifier(KtTokens.OVERRIDE_KEYWORD));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setTailRec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
                $this$visitNamedFunction_u24lambda_u24100_u24lambda_u2499.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
                ((FirSimpleFunctionBuilder)firFunctionBuilder2).setStatus(firDeclarationStatusImpl);
                List<FirContextReceiver> list2 = ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24100).getContextReceivers();
                List<KtContextReceiver> list3 = function2.getContextReceivers();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"function.contextReceivers");
                list2.addAll((Collection<FirContextReceiver>)this.convertContextReceivers(list3));
                firFunctionBuilder = firFunctionBuilder3;
            }
            FirFunctionBuilder functionBuilder = firFunctionBuilder;
            FirFunctionTarget target = new FirFunctionTarget((String)labelName.element, false);
            KtPsiSourceElement functionSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, function2, null, 1, null);
            Object bl3 = functionBuilder;
            object = RawFirBuilder.this;
            FirFunctionBuilder $this$visitNamedFunction_u24lambda_u24103 = bl3;
            boolean bl6 = false;
            $this$visitNamedFunction_u24lambda_u24103.setSource(functionSource);
            $this$visitNamedFunction_u24lambda_u24103.setModuleData(((BaseFirBuilder)object).getBaseModuleData());
            $this$visitNamedFunction_u24lambda_u24103.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$visitNamedFunction_u24lambda_u24103.setReturnTypeRef(returnType2);
            ((Collection)((BaseFirBuilder)object).getContext().getFirFunctionTargets()).add(target);
            this.extractAnnotationsTo((KtAnnotated)function2, $this$visitNamedFunction_u24lambda_u24103);
            if ($this$visitNamedFunction_u24lambda_u24103 instanceof FirSimpleFunctionBuilder) {
                this.extractTypeParametersTo((KtTypeParameterListOwner)function2, (FirTypeParametersOwnerBuilder)((Object)$this$visitNamedFunction_u24lambda_u24103), (FirBasedSymbol)((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24103).getSymbol());
            }
            for (KtParameter ktParameter : function2.getValueParameters()) {
                Collection collection = $this$visitNamedFunction_u24lambda_u24103.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"valueParameter");
                collection.add(Visitor.convertValueParameter$default(this, ktParameter, functionSymbol, null, isAnonymousFunction ? BaseFirBuilder.ValueParameterDeclaration.LAMBDA : BaseFirBuilder.ValueParameterDeclaration.FUNCTION, null, 16, null));
            }
            List<FirTypeParameter> actualTypeParameters = $this$visitNamedFunction_u24lambda_u24103 instanceof FirSimpleFunctionBuilder ? ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24103).getTypeParameters() : CollectionsKt.emptyList();
            BaseFirBuilder baseFirBuilder = (BaseFirBuilder)object;
            boolean status$iv = true;
            boolean $i$f$withCapturedTypeParameters = false;
            BaseFirBuilder.access$addCapturedTypeParameters(baseFirBuilder, status$iv, functionSource, actualTypeParameters);
            try {
                Unit unit2;
                FirContractDescription contractDescription;
                boolean bl7 = false;
                FirContractDescription outerContractDescription = this.obtainContractDescription(function2);
                Pair<FirBlock, FirContractDescription> pair = this.buildFirBody(function2);
                FirBlock body2 = (FirBlock)pair.component1();
                FirContractDescription innerContractDescription = (FirContractDescription)pair.component2();
                $this$visitNamedFunction_u24lambda_u24103.setBody(body2);
                FirContractDescription firContractDescription = outerContractDescription;
                if (firContractDescription == null) {
                    firContractDescription = innerContractDescription;
                }
                FirContractDescription firContractDescription2 = contractDescription = firContractDescription;
                if (firContractDescription2 != null) {
                    FirContractDescription it3 = firContractDescription2;
                    boolean bl8 = false;
                    if ($this$visitNamedFunction_u24lambda_u24103 instanceof FirSimpleFunctionBuilder) {
                        ((FirSimpleFunctionBuilder)$this$visitNamedFunction_u24lambda_u24103).setContractDescription(it3);
                    } else if ($this$visitNamedFunction_u24lambda_u24103 instanceof FirAnonymousFunctionBuilder) {
                        ((FirAnonymousFunctionBuilder)$this$visitNamedFunction_u24lambda_u24103).setContractDescription(it3);
                    }
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Unit unit3 = unit2;
            }
            finally {
                baseFirBuilder.getContext().popFirTypeParameters();
            }
            ((BaseFirBuilder)object).removeLast(((BaseFirBuilder)object).getContext().getFirFunctionTargets());
            bl3 = bl3.build();
            object = RawFirBuilder.this;
            it = bl3;
            boolean bl9 = false;
            ((RawFirBuilder)object).bindFunctionTarget(target, (FirFunction)it);
            if (it instanceof FirSimpleFunction) {
                this.fillDanglingConstraintsTo(function2, (FirDeclaration)it);
            }
            Object firFunction = bl3;
            if (firFunction instanceof FirAnonymousFunction) {
                boolean $i$f$buildAnonymousFunctionExpression = false;
                Object $this$visitNamedFunction_u24lambda_u24105 = object = new FirAnonymousFunctionExpressionBuilder();
                boolean bl10 = false;
                ((FirAnonymousFunctionExpressionBuilder)$this$visitNamedFunction_u24lambda_u24105).setSource(functionSource);
                ((FirAnonymousFunctionExpressionBuilder)$this$visitNamedFunction_u24lambda_u24105).setAnonymousFunction((FirAnonymousFunction)firFunction);
                firElement = ((FirAnonymousFunctionExpressionBuilder)object).build();
            } else {
                firElement = (FirElement)firFunction;
            }
            return firElement;
        }

        private final FirContractDescription obtainContractDescription(KtDeclarationWithBody $this$obtainContractDescription) {
            FirContractDescription firContractDescription;
            KtContractEffectList description2 = $this$obtainContractDescription.getContractDescription();
            if (description2 != null) {
                FirRawContractDescriptionBuilder firRawContractDescriptionBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildRawContractDescription = false;
                FirRawContractDescriptionBuilder $this$obtainContractDescription_u24lambda_u24106 = firRawContractDescriptionBuilder = new FirRawContractDescriptionBuilder();
                boolean bl = false;
                $this$obtainContractDescription_u24lambda_u24106.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, description2, null, 1, null));
                this.extractRawEffects(description2, $this$obtainContractDescription_u24lambda_u24106.getRawEffects());
                firContractDescription = firRawContractDescriptionBuilder.build();
            } else {
                firContractDescription = null;
            }
            return firContractDescription;
        }

        /*
         * WARNING - void declaration
         */
        private final void extractRawEffects(KtContractEffectList $this$extractRawEffects, List<FirExpression> destination) {
            void $this$mapTo$iv;
            Iterable iterable = KtContractEffectListKt.getContractEffects($this$extractRawEffects);
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                Object object;
                void this_$iv$iv;
                void this_$iv;
                void effect;
                KtContractEffect ktContractEffect = (KtContractEffect)item$iv;
                Collection collection = destination;
                boolean bl = false;
                Visitor visitor2 = this;
                KtSourceElement sourceElement$iv = BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, effect, null, 1, null);
                boolean $i$f$buildOrLazyExpression = false;
                void var13_13 = this_$iv;
                Function0 lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
                boolean $i$f$buildOrLazy = false;
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        boolean bl2 = false;
                        Object r = KtContractEffectKt.getExpression((KtContractEffect)effect).accept(this, Unit.INSTANCE);
                        Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                        object = (FirExpression)r;
                        break;
                    }
                    case 2: {
                        RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        boolean $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                object = lazy$iv$iv.invoke();
                                break block0;
                            }
                            case 2: {
                                object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                collection.add((FirExpression)object);
            }
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public FirElement visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            v0 = expression.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"expression.functionLiteral");
            literal = v0;
            literalSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, literal, null, 1, null);
            implicitTypeRefSource = RawFirBuilder.this.toFirSourceElement(literal, (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE);
            $i$f$buildImplicitTypeRef = false;
            $this$visitLambdaExpression_u24lambda_u24109 = var8_8 = new FirImplicitTypeRefBuilder();
            $i$a$-buildImplicitTypeRef-RawFirBuilder$Visitor$visitLambdaExpression$returnType$1 = false;
            $this$visitLambdaExpression_u24lambda_u24109.setSource(implicitTypeRefSource);
            returnType = var8_8.build();
            $i$f$buildImplicitTypeRef = false;
            $this$visitLambdaExpression_u24lambda_u24109 = new FirImplicitTypeRefBuilder();
            $this$visitLambdaExpression_u24lambda_u24110 = $this$visitLambdaExpression_u24lambda_u24109;
            $i$a$-buildImplicitTypeRef-RawFirBuilder$Visitor$visitLambdaExpression$receiverType$1 = false;
            $this$visitLambdaExpression_u24lambda_u24110.setSource(implicitTypeRefSource);
            receiverType = $this$visitLambdaExpression_u24lambda_u24109.build();
            target = new Ref.ObjectRef();
            $this$visitLambdaExpression_u24lambda_u24110 = RawFirBuilder.this;
            $i$f$buildAnonymousFunction = false;
            $this$visitLambdaExpression_u24lambda_u24121 = var12_18 = new FirAnonymousFunctionBuilder();
            $i$a$-buildAnonymousFunction-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1 = false;
            $this$visitLambdaExpression_u24lambda_u24121.setSource(literalSource);
            $this$visitLambdaExpression_u24lambda_u24121.setModuleData($this$visitLambdaExpression_u24lambda_u24110.getBaseModuleData());
            $this$visitLambdaExpression_u24lambda_u24121.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$visitLambdaExpression_u24lambda_u24121.setReturnTypeRef(returnType);
            $this$visitLambdaExpression_u24lambda_u24121.setReceiverParameter(ConversionUtilsKt.asReceiverParameter(receiverType));
            $this$visitLambdaExpression_u24lambda_u24121.setSymbol(new FirAnonymousFunctionSymbol());
            $this$visitLambdaExpression_u24lambda_u24121.setLambda(true);
            $this$visitLambdaExpression_u24lambda_u24121.setHasExplicitParameterList(expression.getFunctionLiteral().getArrow() != null);
            destructuringStatements = new ArrayList<E>();
            for (Object valueParameter : literal.getValueParameters()) {
                block20: {
                    block19: {
                        multiDeclaration = valueParameter.getDestructuringDeclaration();
                        var19_28 = $this$visitLambdaExpression_u24lambda_u24121.getValueParameters();
                        if (multiDeclaration == null) break block19;
                        name = SpecialNames.DESTRUCT;
                        $i$f$buildValueParameter = false;
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112 = var22_35 = new FirValueParameterBuilder();
                        $i$a$-buildValueParameter-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$multiParameter$1 = false;
                        v1 = (BaseFirBuilder)$this$visitLambdaExpression_u24lambda_u24110;
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameter, (String)"valueParameter");
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setSource(BaseFirBuilder.toFirSourceElement$default(v1, valueParameter, null, 1, null));
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setContainingFunctionSymbol($this$visitLambdaExpression_u24lambda_u24121.getSymbol());
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setModuleData($this$visitLambdaExpression_u24lambda_u24110.getBaseModuleData());
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                        v2 = $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112;
                        var25_42 = valueParameter.getTypeReference();
                        if (var25_42 == null) ** GOTO lbl-1000
                        var26_45 = this;
                        $this$convertSafe$iv /* !! */  = var25_42;
                        $i$f$convertSafe = false;
                        p0$iv = $this$convertSafe$iv /* !! */ ;
                        $i$a$-let-RawFirBuilder$Visitor$convertSafe$1$iv = false;
                        v3 = this_$iv.convertElement((KtElement)p0$iv);
                        if (!(v3 instanceof FirTypeRef)) {
                            v3 = null;
                        }
                        if ((var31_56 = (FirTypeRef)((FirElement)((FirTypeRef)v3))) != null) {
                            v4 = var31_56;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $i$f$buildImplicitTypeRef = false;
                            $i$f$convertSafe = $this$convertSafe$iv /* !! */  = new FirImplicitTypeRefBuilder();
                            var32_57 = v2;
                            $i$a$-buildImplicitTypeRef-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$multiParameter$1$1 = false;
                            $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112_u24lambda_u24111.setSource($this$visitLambdaExpression_u24lambda_u24110.toFirSourceElement((PsiElement)multiDeclaration, (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE));
                            v2 = var32_57;
                            v4 = $this$convertSafe$iv /* !! */ .build();
                        }
                        v2.setReturnTypeRef(v4);
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setName(name);
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setSymbol(new FirValueParameterSymbol(name));
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setCrossinline(false);
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setNoinline(false);
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24112.setVararg(false);
                        multiParameter = var22_35.build();
                        CollectionsKt.addAll((Collection)destructuringStatements, (Iterable)PsiConversionUtilsKt.generateDestructuringBlock($this$visitLambdaExpression_u24lambda_u24110.getBaseModuleData(), (KtDestructuringDeclaration)multiDeclaration, (FirVariable)multiParameter, false, (Function2<? super KtAnnotated, ? super FirAnnotationContainerBuilder, Unit>)((Function2)new Function2<KtAnnotated, FirAnnotationContainerBuilder, Unit>(this){
                            final /* synthetic */ Visitor this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            public final void invoke(@NotNull KtAnnotated $this$generateDestructuringBlock, @NotNull FirAnnotationContainerBuilder it) {
                                Intrinsics.checkNotNullParameter((Object)$this$generateDestructuringBlock, (String)"$this$generateDestructuringBlock");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                Visitor.access$extractAnnotationsTo(this.this$0, $this$generateDestructuringBlock, it);
                            }
                        }), (Function1<? super KtTypeReference, ? extends FirTypeRef>)((Function1)new Function1<KtTypeReference, FirTypeRef>(this){
                            final /* synthetic */ Visitor this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final FirTypeRef invoke(@Nullable KtTypeReference $this$generateDestructuringBlock) {
                                return Visitor.access$toFirOrImplicitType(this.this$0, $this$generateDestructuringBlock);
                            }
                        })).getStatements());
                        v5 = multiParameter;
                        break block20;
                    }
                    multiParameter = valueParameter.getTypeReference();
                    if (multiParameter == null) ** GOTO lbl-1000
                    var22_35 = this;
                    $this$convertSafe$iv = (KtElement)multiParameter;
                    $i$f$convertSafe = false;
                    p0$iv = $this$convertSafe$iv;
                    $i$a$-let-RawFirBuilder$Visitor$convertSafe$1$iv = false;
                    v6 = this_$iv.convertElement((KtElement)p0$iv);
                    if (!(v6 instanceof FirImplicitTypeRef)) {
                        v6 = null;
                    }
                    if (($i$f$buildValueParameter = (FirImplicitTypeRef)((FirElement)((FirImplicitTypeRef)v6))) != null) {
                        v7 = $i$f$buildValueParameter;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $i$f$buildImplicitTypeRef = false;
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24113 = $this$convertSafe$iv = new FirImplicitTypeRefBuilder();
                        $i$a$-buildImplicitTypeRef-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$typeRef$1 = false;
                        v8 = (BaseFirBuilder)$this$visitLambdaExpression_u24lambda_u24110;
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameter, (String)"valueParameter");
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24113.setSource(KtSourceElementKt.fakeElement(BaseFirBuilder.toFirSourceElement$default(v8, valueParameter, null, 1, null), KtFakeSourceElementKind.ImplicitReturnTypeOfLambdaValueParameter.INSTANCE));
                        v7 = $this$convertSafe$iv.build();
                    }
                    typeRef = v7;
                    Intrinsics.checkNotNullExpressionValue((Object)valueParameter, (String)"valueParameter");
                    v5 = Visitor.convertValueParameter$default(this, (KtParameter)valueParameter, $this$visitLambdaExpression_u24lambda_u24121.getSymbol(), (FirTypeRef)typeRef, BaseFirBuilder.ValueParameterDeclaration.LAMBDA, null, 16, null);
                }
                typeRef = v5;
                var19_28.add(typeRef);
            }
            expressionSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)$this$visitLambdaExpression_u24lambda_u24110, expression, null, 1, null);
            v9 = $this$visitLambdaExpression_u24lambda_u24121;
            v10 = $this$visitLambdaExpression_u24lambda_u24110.getContext().getLastLabel(expression);
            if (v10 == null) {
                v11 = (Name)CollectionsKt.lastOrNull($this$visitLambdaExpression_u24lambda_u24110.getContext().getCalleeNamesForLambda());
                if (v11 != null) {
                    typeRef = v11;
                    var34_63 = v9;
                    $i$a$-let-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$3 = false;
                    $i$f$buildLabel = false;
                    $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24115_u24lambda_u24114 = $i$f$buildImplicitTypeRef = new FirLabelBuilder();
                    $i$a$-buildLabel-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$3$1 = false;
                    $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24115_u24lambda_u24114.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.GeneratedLambdaLabel.INSTANCE));
                    v12 = it.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"it.asString()");
                    $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24115_u24lambda_u24114.setName(v12);
                    v10 = $i$f$buildImplicitTypeRef.build();
                    v9 = var34_63;
                } else {
                    v10 = null;
                }
            }
            v9.setLabel(v10);
            v13 = $this$visitLambdaExpression_u24lambda_u24121.getLabel();
            multiDeclaration = valueParameter = new FirFunctionTarget(v13 != null ? v13.getName() : null, true);
            var34_63 = target;
            $i$a$-also-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$4 = false;
            ((Collection)$this$visitLambdaExpression_u24lambda_u24110.getContext().getFirFunctionTargets()).add(it);
            var34_63.element = valueParameter;
            ktBody = literal.getBodyExpression();
            v14 = $this$visitLambdaExpression_u24lambda_u24121;
            if (ktBody == null) {
                errorExpression = FirExpressionUtilKt.buildErrorExpression$default($this$visitLambdaExpression_u24lambda_u24121.getSource(), new ConeSimpleDiagnostic("Lambda has no body", DiagnosticKind.Syntax), null, 4, null);
                v15 = new FirSingleExpressionBlock(BaseFirBuilder.toReturn$default((BaseFirBuilder)$this$visitLambdaExpression_u24lambda_u24110, errorExpression, null, null, false, 7, null));
            } else {
                $i$a$-also-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$4 = var18_27 = this.configureBlockWithoutBuilding(ktBody);
                var34_63 = v14;
                $i$a$-apply-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$5 = false;
                v16 = (FirStatement)CollectionsKt.firstOrNull($this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120.getStatements());
                if (v16 != null) {
                    it = v16;
                    $i$a$-let-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$5$1 = false;
                    if (ConversionUtilsKt.isContractBlockFirCheck(it)) {
                        $this$visitLambdaExpression_u24lambda_u24121.setContractDescription(ConversionUtilsKt.toLegacyRawContractDescription((FirFunctionCall)it));
                        $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120.getStatements().set(0, new FirContractCallBlock((FirFunctionCall)it));
                    }
                }
                if ($this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120.getStatements().isEmpty()) {
                    $i$f$buildReturnExpression = false;
                    it = var23_38 = new FirReturnExpressionBuilder();
                    var24_41 = $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120.getStatements();
                    $i$a$-buildReturnExpression-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$5$2 = false;
                    $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120_u24lambda_u24119.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.ImplicitReturn.FromExpressionBody.INSTANCE));
                    $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120_u24lambda_u24119.setTarget((FirTarget)target.element);
                    $i$f$buildUnitExpression = false;
                    $this$convertSafe$iv /* !! */  = var26_45 = new FirUnitExpressionBuilder();
                    var28_51 = $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120_u24lambda_u24119;
                    $i$a$-buildUnitExpression-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$1$5$2$1 = false;
                    $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120_u24lambda_u24119_u24lambda_u24118.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.ImplicitUnit.INSTANCE));
                    var28_51.setResult(var26_45.build());
                    var24_41.add(var23_38.build());
                }
                $this$visitLambdaExpression_u24lambda_u24121_u24lambda_u24120.getStatements().addAll(0, destructuringStatements);
                v14 = var34_63;
                v15 = var18_27.build();
            }
            v14.setBody(v15);
            $this$visitLambdaExpression_u24lambda_u24110.removeLast($this$visitLambdaExpression_u24lambda_u24110.getContext().getFirFunctionTargets());
            $this$visitLambdaExpression_u24lambda_u24110 = var12_18.build();
            var11_17 = RawFirBuilder.this;
            it = $this$visitLambdaExpression_u24lambda_u24110;
            $i$a$-also-RawFirBuilder$Visitor$visitLambdaExpression$anonymousFunction$2 = false;
            var11_17.bindFunctionTarget((FirFunctionTarget)target.element, (FirFunction)it);
            anonymousFunction = $this$visitLambdaExpression_u24lambda_u24110;
            $i$f$buildAnonymousFunctionExpression = false;
            $this$visitLambdaExpression_u24lambda_u24123 = var11_17 = new FirAnonymousFunctionExpressionBuilder();
            $i$a$-buildAnonymousFunctionExpression-RawFirBuilder$Visitor$visitLambdaExpression$1 = false;
            $this$toKtPsiSourceElement_u24default$iv = (PsiElement)expression;
            kind$iv = KtRealSourceElementKind.INSTANCE;
            $i$f$toKtPsiSourceElement = false;
            var17_26 = kind$iv;
            if (var17_26 instanceof KtRealSourceElementKind) {
                v17 = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
            } else if (var17_26 instanceof KtFakeSourceElementKind) {
                v17 = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$visitLambdaExpression_u24lambda_u24123.setSource(v17);
            $this$visitLambdaExpression_u24lambda_u24123.setAnonymousFunction((FirAnonymousFunction)anonymousFunction);
            return var11_17.build();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final FirConstructor toFirConstructor(@NotNull KtSecondaryConstructor $this$toFirConstructor, @NotNull FirTypeRef delegatedTypeRef, @NotNull FirTypeRef selfTypeRef, @NotNull KtClassOrObject owner, @NotNull List<? extends FirTypeParameterRef> ownerTypeParameters) {
            FirContractDescription contractDescription;
            Object object;
            void this_$iv$iv;
            void isThis$iv;
            void this_$iv;
            void $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252;
            FirConstructorBuilder firConstructorBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$toFirConstructor, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)delegatedTypeRef, (String)"delegatedTypeRef");
            Intrinsics.checkNotNullParameter((Object)selfTypeRef, (String)"selfTypeRef");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(ownerTypeParameters, (String)"ownerTypeParameters");
            FirFunctionTarget target = new FirFunctionTarget(null, false);
            Object object2 = RawFirBuilder.this;
            boolean $i$f$buildConstructor = false;
            FirConstructorBuilder $this$toFirConstructor_u24lambda_u24127 = firConstructorBuilder = new FirConstructorBuilder();
            boolean bl = false;
            $this$toFirConstructor_u24lambda_u24127.setSource(BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)object2, $this$toFirConstructor, null, 1, null));
            $this$toFirConstructor_u24lambda_u24127.setModuleData(((BaseFirBuilder)object2).getBaseModuleData());
            $this$toFirConstructor_u24lambda_u24127.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$toFirConstructor_u24lambda_u24127.setReturnTypeRef(selfTypeRef);
            Visibility explicitVisibility = ((RawFirBuilder)object2).getVisibility($this$toFirConstructor);
            Pair<FirBlock, FirContractDescription> pair = new FirDeclarationStatusImpl(explicitVisibility, Modality.FINAL);
            FirDeclarationStatusImpl firDeclarationStatusImpl = pair;
            FirConstructorBuilder firConstructorBuilder2 = $this$toFirConstructor_u24lambda_u24127;
            boolean bl2 = false;
            $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252.setExpect(PsiUtilsKt.hasExpectModifier($this$toFirConstructor) || ((BaseFirBuilder)object2).getContext().getContainerIsExpect());
            $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252.setActual(PsiUtilsKt.hasActualModifier($this$toFirConstructor));
            $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252.setInner(owner.hasModifier(KtTokens.INNER_KEYWORD));
            $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252.setFromSealedClass(owner.hasModifier(KtTokens.SEALED_KEYWORD) && explicitVisibility != Visibilities.Private.INSTANCE);
            $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252.setFromEnumClass(owner.hasModifier(KtTokens.ENUM_KEYWORD));
            firConstructorBuilder2.setStatus((FirDeclarationStatus)pair);
            $this$toFirConstructor_u24lambda_u24127.setDispatchReceiverType(this.obtainDispatchReceiverForConstructor(owner));
            $this$toFirConstructor_u24lambda_u24127.getContextReceivers().addAll((Collection<FirContextReceiver>)this.convertContextReceivers(owner.getContextReceivers()));
            $this$toFirConstructor_u24lambda_u24127.setSymbol(new FirConstructorSymbol(((BaseFirBuilder)object2).callableIdForClassConstructor()));
            FirConstructorBuilder firConstructorBuilder3 = $this$toFirConstructor_u24lambda_u24127;
            pair = this;
            boolean $this$toFirConstructor_u24lambda_u24127_u24lambda_u241252 = $this$toFirConstructor.isDelegatedCallToThis();
            boolean $i$f$buildOrLazyDelegatedConstructorCall = false;
            void var17_22 = this_$iv;
            Function0 lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
            boolean $i$f$buildOrLazy = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    firConstructorBuilder2 = firConstructorBuilder3;
                    boolean bl3 = false;
                    object = this.convert($this$toFirConstructor.getDelegationCall(), delegatedTypeRef);
                    firConstructorBuilder3 = firConstructorBuilder2;
                    break;
                }
                case 2: {
                    RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy$iv$iv.invoke();
                            break block0;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            firConstructorBuilder3.setDelegatedConstructor((FirDelegatedConstructorCall)object);
            ((Collection)((BaseFirBuilder)object2).getContext().getFirFunctionTargets()).add(target);
            this.extractAnnotationsTo((KtAnnotated)$this$toFirConstructor, $this$toFirConstructor_u24lambda_u24127);
            CollectionsKt.addAll((Collection)$this$toFirConstructor_u24lambda_u24127.getTypeParameters(), (Iterable)((BaseFirBuilder)object2).constructorTypeParametersFromConstructedClass(ownerTypeParameters));
            Visitor.extractValueParametersTo$default(this, $this$toFirConstructor, $this$toFirConstructor_u24lambda_u24127, $this$toFirConstructor_u24lambda_u24127.getSymbol(), BaseFirBuilder.ValueParameterDeclaration.FUNCTION, null, null, 24, null);
            pair = this.buildFirBody($this$toFirConstructor);
            FirBlock body2 = (FirBlock)pair.component1();
            FirContractDescription firContractDescription = contractDescription = (FirContractDescription)pair.component2();
            if (firContractDescription != null) {
                FirContractDescription it = firContractDescription;
                boolean bl4 = false;
                $this$toFirConstructor_u24lambda_u24127.setContractDescription(it);
            }
            $this$toFirConstructor_u24lambda_u24127.setBody(body2);
            ((BaseFirBuilder)object2).removeLast(((BaseFirBuilder)object2).getContext().getFirFunctionTargets());
            object2 = firConstructorBuilder.build();
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            Object it = object2;
            boolean bl5 = false;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)it;
            ConeClassLikeType coneClassLikeType = rawFirBuilder.currentDispatchReceiverType();
            Intrinsics.checkNotNull((Object)coneClassLikeType);
            ClassMembersKt.setContainingClassForStaticMemberAttr(firCallableDeclaration, coneClassLikeType.getLookupTag());
            rawFirBuilder.bindFunctionTarget(target, (FirFunction)it);
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final FirDelegatedConstructorCall convert(KtConstructorDelegationCall $this$convert, FirTypeRef delegatedType) {
            isThis = $this$convert.isCallToThis();
            source = $this$convert.isImplicit() != false ? RawFirBuilder.this.toFirSourceElement((PsiElement)$this$convert, (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE) : (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $this$convert, null, 1, null);
            var5_5 = RawFirBuilder.this;
            $i$f$buildDelegatedConstructorCall = false;
            $this$convert_u24lambda_u24132 = var7_7 = new FirDelegatedConstructorCallBuilder();
            $i$a$-buildDelegatedConstructorCall-RawFirBuilder$Visitor$convert$1 = false;
            $this$convert_u24lambda_u24132.setSource(source);
            $this$convert_u24lambda_u24132.setConstructedTypeRef(UtilsKt.copyWithNewSourceKind(delegatedType, KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE));
            $this$convert_u24lambda_u24132.setThis(isThis);
            calleeKind = $this$convert.isImplicit() != false ? (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE : (KtFakeSourceElementKind)KtFakeSourceElementKind.DelegatingConstructorCall.INSTANCE;
            var11_11 = $this$convert.getCalleeExpression();
            v0 = var11_11;
            if (v0 == null) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"calleeExpression");
            v0 = var5_5.toFirSourceElement((PsiElement)var11_11, calleeKind);
            if (v0 != null) {
                v1 = (KtSourceElement)v0;
            } else lbl-1000:
            // 2 sources

            {
                v1 = KtSourceElementKt.fakeElement(source, calleeKind);
            }
            calleeSource = v1;
            v2 = $this$convert_u24lambda_u24132;
            if (isThis) {
                $i$f$buildExplicitThisReference = false;
                var14_18 = var13_15 = new FirExplicitThisReferenceBuilder();
                var15_22 = v2;
                $i$a$-buildExplicitThisReference-RawFirBuilder$Visitor$convert$1$1 = false;
                $this$convert_u24lambda_u24132_u24lambda_u24129.setSource(calleeSource);
                v3 = var15_22;
                v4 = var13_15.build();
            } else {
                $i$f$buildExplicitSuperReference = false;
                $this$convert_u24lambda_u24132_u24lambda_u24129 = var13_16 = new FirExplicitSuperReferenceBuilder();
                var15_23 = v2;
                $i$a$-buildExplicitSuperReference-RawFirBuilder$Visitor$convert$1$2 = false;
                $this$convert_u24lambda_u24132_u24lambda_u24130.setSource(calleeSource);
                $this$convert_u24lambda_u24132_u24lambda_u24130.setSuperTypeRef($this$convert_u24lambda_u24132.getConstructedTypeRef());
                v3 = var15_23;
                v4 = var13_16.build();
            }
            v3.setCalleeReference(v4);
            this_$iv = var5_5;
            $i$f$disabledLazyMode = false;
            if (this_$iv.getMode() != BodyBuildingMode.LAZY_BODIES) {
                $i$a$-disabledLazyMode-RawFirBuilder$Visitor$convert$1$3 = false;
                this.extractArgumentsTo($this$convert, $this$convert_u24lambda_u24132);
            } else {
                try {
                    RawFirBuilder.access$setMode$p(this_$iv, BodyBuildingMode.NORMAL);
                    $i$a$-disabledLazyMode-RawFirBuilder$Visitor$convert$1$3 = false;
                    this.extractArgumentsTo($this$convert, $this$convert_u24lambda_u24132);
                    var16_26 = Unit.INSTANCE;
                }
                finally {
                    RawFirBuilder.access$setMode$p(this_$iv, BodyBuildingMode.LAZY_BODIES);
                }
            }
            return var7_7.build();
        }

        /*
         * WARNING - void declaration
         */
        private final FirExpression toInitializerExpression(KtDeclarationWithInitializer $this$toInitializerExpression) {
            FirExpression firExpression2;
            boolean condition$iv = $this$toInitializerExpression.hasInitializer();
            boolean $i$f$runIf = false;
            if (condition$iv) {
                Object object;
                void this_$iv$iv;
                void this_$iv;
                boolean bl = false;
                Visitor visitor2 = this;
                KtSourceElement sourceElement$iv = null;
                boolean $i$f$buildOrLazyExpression = false;
                void var8_8 = this_$iv;
                Function0 lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
                boolean $i$f$buildOrLazy = false;
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                    case 1: {
                        boolean bl2 = false;
                        object = Visitor.toFirExpression$default(this, $this$toInitializerExpression.getInitializer(), "Should have initializer", null, 2, null);
                        break;
                    }
                    case 2: {
                        RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                        boolean $i$f$runOnStubs = false;
                        switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                            case 1: {
                                object = lazy$iv$iv.invoke();
                                break block0;
                            }
                            case 2: {
                                object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                firExpression2 = object;
            } else {
                firExpression2 = null;
            }
            return firExpression2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final <T> FirProperty toFirProperty(KtProperty $this$toFirProperty, FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, Context<T> context) {
            List list2;
            Object delegateBuilder;
            Object annotationEntry;
            FirElement firElement;
            FirElement firElement2;
            Object this_$iv;
            Object p0$iv;
            FirPropertyBuilder firPropertyBuilder;
            FirTypeRef propertyType = this.toFirOrImplicitType($this$toFirProperty.getTypeReference());
            Name name2 = $this$toFirProperty.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"nameAsSafeName");
            Name propertyName = name2;
            boolean isVar = $this$toFirProperty.isVar();
            FirExpression propertyInitializer = this.toInitializerExpression($this$toFirProperty);
            KtPsiSourceElement propertySource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $this$toFirProperty, null, 1, null);
            Object object = RawFirBuilder.this;
            boolean $i$f$buildProperty = false;
            FirPropertyBuilder $this$toFirProperty_u24lambda_u24145 = firPropertyBuilder = new FirPropertyBuilder();
            boolean bl = false;
            $this$toFirProperty_u24lambda_u24145.setSource(propertySource);
            $this$toFirProperty_u24lambda_u24145.setModuleData(((BaseFirBuilder)object).getBaseModuleData());
            $this$toFirProperty_u24lambda_u24145.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$toFirProperty_u24lambda_u24145.setReturnTypeRef(propertyType);
            $this$toFirProperty_u24lambda_u24145.setName(propertyName);
            $this$toFirProperty_u24lambda_u24145.setVar(isVar);
            Object object2 = this;
            KtElement $this$convertSafe$iv = $this$toFirProperty.getReceiverTypeReference();
            boolean $i$f$convertSafe2 = false;
            KtElement ktElement = $this$convertSafe$iv;
            if (ktElement != null) {
                p0$iv = ktElement;
                boolean bl2 = false;
                firElement2 = ((Visitor)((Object)this_$iv)).convertElement((KtElement)p0$iv);
            } else {
                firElement2 = firElement = null;
            }
            if (!(firElement2 instanceof FirTypeRef)) {
                firElement = null;
            }
            FirTypeRef firTypeRef = (FirTypeRef)((FirElement)((FirTypeRef)firElement));
            $this$toFirProperty_u24lambda_u24145.setReceiverParameter(firTypeRef != null ? ConversionUtilsKt.convertToReceiverParameter(firTypeRef) : null);
            $this$toFirProperty_u24lambda_u24145.setInitializer(propertyInitializer);
            List propertyAnnotations = new ArrayList();
            this_$iv = $this$toFirProperty.getAnnotationEntries().iterator();
            while (this_$iv.hasNext()) {
                FirElement this_$iv2;
                annotationEntry = this_$iv.next();
                Collection $i$f$convertSafe2 = propertyAnnotations;
                p0$iv = this;
                Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                KtElement $this$convert$iv = (KtElement)annotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement3 = ((Visitor)((Object)this_$iv2)).convertElement($this$convert$iv);
                if (firElement3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotationCall");
                }
                this_$iv2 = (FirAnnotationCall)firElement3;
                $i$f$convertSafe2.add(this_$iv2);
            }
            if ($this$toFirProperty.isLocal()) {
                FirWrappedDelegateExpressionBuilder $this$toFirProperty_u24lambda_u24145_u24lambda_u24135;
                $this$toFirProperty_u24lambda_u24145.setLocal(true);
                $this$toFirProperty_u24lambda_u24145.setSymbol(new FirPropertySymbol(propertyName));
                this.extractTypeParametersTo((KtTypeParameterListOwner)$this$toFirProperty, $this$toFirProperty_u24lambda_u24145, (FirBasedSymbol)$this$toFirProperty_u24lambda_u24145.getSymbol());
                $this$toFirProperty_u24lambda_u24145.setBackingField(this.toFirBackingField($this$toFirProperty.getFieldDeclaration(), $this$toFirProperty, $this$toFirProperty_u24lambda_u24145.getSymbol(), propertyType));
                annotationEntry = this_$iv = new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL);
                FirPropertyBuilder firPropertyBuilder2 = $this$toFirProperty_u24lambda_u24145;
                boolean bl3 = false;
                ((FirDeclarationStatusImpl)((Object)$this$toFirProperty_u24lambda_u24145_u24lambda_u24135)).setLateInit($this$toFirProperty.hasModifier(KtTokens.LATEINIT_KEYWORD));
                firPropertyBuilder2.setStatus((FirDeclarationStatus)this_$iv);
                if ($this$toFirProperty.hasDelegate()) {
                    FirWrappedDelegateExpressionBuilder $this$toFirProperty_u24lambda_u24145_u24lambda_u24136 = $this$toFirProperty_u24lambda_u24145_u24lambda_u24135 = new FirWrappedDelegateExpressionBuilder();
                    boolean bl4 = false;
                    FirExpression delegateFirExpression = Visitor.toFirProperty$lambda$145$extractDelegateExpression(this, $this$toFirProperty);
                    KtSourceElement ktSourceElement = delegateFirExpression.getSource();
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24136.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.WrappedDelegate.INSTANCE) : null);
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24136.setExpression(delegateFirExpression);
                    delegateBuilder = $this$toFirProperty_u24lambda_u24145_u24lambda_u24135;
                    ConversionUtilsKt.generateAccessorsByDelegate($this$toFirProperty_u24lambda_u24145, (FirWrappedDelegateExpressionBuilder)delegateBuilder, ((BaseFirBuilder)object).getBaseModuleData(), null, context, false);
                }
            } else {
                void status$iv;
                $this$toFirProperty_u24lambda_u24145.setLocal(false);
                $this$toFirProperty_u24lambda_u24145.setSymbol(new FirPropertySymbol(((BaseFirBuilder)object).callableIdForName(propertyName)));
                $this$toFirProperty_u24lambda_u24145.setDispatchReceiverType(((BaseFirBuilder)object).currentDispatchReceiverType());
                this.extractTypeParametersTo((KtTypeParameterListOwner)$this$toFirProperty, $this$toFirProperty_u24lambda_u24145, (FirBasedSymbol)$this$toFirProperty_u24lambda_u24145.getSymbol());
                delegateBuilder = (BaseFirBuilder)object;
                boolean $this$toFirProperty_u24lambda_u24145_u24lambda_u24135 = true;
                List<FirTypeParameter> currentFirTypeParameters$iv = $this$toFirProperty_u24lambda_u24145.getTypeParameters();
                boolean $i$f$withCapturedTypeParameters = false;
                BaseFirBuilder.access$addCapturedTypeParameters((BaseFirBuilder)this_$iv, (boolean)status$iv, propertySource, currentFirTypeParameters$iv);
                try {
                    void $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137;
                    boolean bl5 = false;
                    $this$toFirProperty_u24lambda_u24145.setBackingField(this.toFirBackingField($this$toFirProperty.getFieldDeclaration(), $this$toFirProperty, $this$toFirProperty_u24lambda_u24145.getSymbol(), propertyType));
                    $this$toFirProperty_u24lambda_u24145.setGetter(this.toFirPropertyAccessor($this$toFirProperty.getGetter(), $this$toFirProperty, propertyType, $this$toFirProperty_u24lambda_u24145.getSymbol(), true, ConversionUtilsKt.filterUseSiteTarget(propertyAnnotations, AnnotationUseSiteTarget.PROPERTY_GETTER), CollectionsKt.emptyList()));
                    $this$toFirProperty_u24lambda_u24145.setSetter(this.toFirPropertyAccessor($this$toFirProperty.getSetter(), $this$toFirProperty, propertyType, $this$toFirProperty_u24lambda_u24145.getSymbol(), false, ConversionUtilsKt.filterUseSiteTarget(propertyAnnotations, AnnotationUseSiteTarget.PROPERTY_SETTER), ConversionUtilsKt.filterUseSiteTarget(propertyAnnotations, AnnotationUseSiteTarget.SETTER_PARAMETER)));
                    FirDeclarationStatusImpl $i$f$convert = new FirDeclarationStatusImpl(((RawFirBuilder)object).getVisibility($this$toFirProperty), ((RawFirBuilder)object).getModality($this$toFirProperty));
                    Object object3 = $i$f$convert;
                    FirPropertyBuilder firPropertyBuilder3 = $this$toFirProperty_u24lambda_u24145;
                    boolean bl6 = false;
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137.setExpect(PsiUtilsKt.hasExpectModifier($this$toFirProperty) || ((BaseFirBuilder)object).getContext().getContainerIsExpect());
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137.setActual(PsiUtilsKt.hasActualModifier($this$toFirProperty));
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137.setOverride($this$toFirProperty.hasModifier(KtTokens.OVERRIDE_KEYWORD));
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137.setConst($this$toFirProperty.hasModifier(KtTokens.CONST_KEYWORD));
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137.setLateInit($this$toFirProperty.hasModifier(KtTokens.LATEINIT_KEYWORD));
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24137.setExternal($this$toFirProperty.hasModifier(KtTokens.EXTERNAL_KEYWORD));
                    firPropertyBuilder3.setStatus($i$f$convert);
                    if ($this$toFirProperty.hasDelegate()) {
                        Object $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24142 = object3 = new FirWrappedDelegateExpressionBuilder();
                        boolean bl7 = false;
                        FirExpression delegateExpression2 = Visitor.toFirProperty$lambda$145$lambda$143$extractDelegateExpression$141(this, (RawFirBuilder)object, $this$toFirProperty);
                        KtSourceElement ktSourceElement = delegateExpression2.getSource();
                        ((FirWrappedDelegateExpressionBuilder)$this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24142).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.WrappedDelegate.INSTANCE) : null);
                        ((FirWrappedDelegateExpressionBuilder)$this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24lambda_u24142).setExpression(delegateExpression2);
                        Object delegateBuilder2 = object3;
                        ConversionUtilsKt.generateAccessorsByDelegate($this$toFirProperty_u24lambda_u24145, (FirWrappedDelegateExpressionBuilder)delegateBuilder2, ((BaseFirBuilder)object).getBaseModuleData(), ownerRegularOrAnonymousObjectSymbol, context, $this$toFirProperty.getReceiverTypeReference() != null);
                    }
                    Unit unit2 = Unit.INSTANCE;
                }
                finally {
                    ((BaseFirBuilder)this_$iv).getContext().popFirTypeParameters();
                }
            }
            object2 = $this$toFirProperty_u24lambda_u24145.getAnnotations();
            if ($this$toFirProperty_u24lambda_u24145.isLocal()) {
                list2 = propertyAnnotations;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = propertyAnnotations;
                boolean $i$f$filter = false;
                Iterable $i$f$withCapturedTypeParameters = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
                    boolean bl8 = false;
                    boolean bl9 = it.getUseSiteTarget() != AnnotationUseSiteTarget.PROPERTY_GETTER && (!isVar || it.getUseSiteTarget() != AnnotationUseSiteTarget.SETTER_PARAMETER && it.getUseSiteTarget() != AnnotationUseSiteTarget.PROPERTY_SETTER);
                    if (!bl9) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            Iterable iterable = list2;
            CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
            List<FirContextReceiver> list3 = $this$toFirProperty_u24lambda_u24145.getContextReceivers();
            List<KtContextReceiver> list4 = $this$toFirProperty.getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"this@toFirProperty.contextReceivers");
            list3.addAll((Collection<FirContextReceiver>)this.convertContextReceivers(list4));
            Object it = object = firPropertyBuilder.build();
            boolean bl10 = false;
            if (!$this$toFirProperty.isLocal()) {
                this.fillDanglingConstraintsTo($this$toFirProperty, (FirDeclaration)it);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @NotNull Unit data2) {
            Object object;
            void this_$iv$iv;
            FirAnonymousInitializerBuilder firAnonymousInitializerBuilder;
            Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildAnonymousInitializer = false;
            FirAnonymousInitializerBuilder $this$visitAnonymousInitializer_u24lambda_u24148 = firAnonymousInitializerBuilder = new FirAnonymousInitializerBuilder();
            boolean bl = false;
            $this$visitAnonymousInitializer_u24lambda_u24148.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, initializer2, null, 1, null));
            $this$visitAnonymousInitializer_u24lambda_u24148.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$visitAnonymousInitializer_u24lambda_u24148.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            FirAnonymousInitializerBuilder firAnonymousInitializerBuilder2 = $this$visitAnonymousInitializer_u24lambda_u24148;
            Visitor this_$iv = this;
            boolean $i$f$buildOrLazyBlock = false;
            Visitor visitor2 = this_$iv;
            Function0 lazy$iv$iv = buildOrLazyBlock.1.INSTANCE;
            boolean $i$f$buildOrLazy = false;
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    FirAnonymousInitializerBuilder firAnonymousInitializerBuilder3 = firAnonymousInitializerBuilder2;
                    boolean bl2 = false;
                    object = this.toFirBlock(initializer2.getBody());
                    firAnonymousInitializerBuilder2 = firAnonymousInitializerBuilder3;
                    break;
                }
                case 2: {
                    RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy$iv$iv.invoke();
                            break block0;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            firAnonymousInitializerBuilder2.setBody((FirBlock)object);
            $this$visitAnonymousInitializer_u24lambda_u24148.setDispatchReceiverType((ConeClassLikeType)CollectionsKt.lastOrNull(rawFirBuilder.getContext().getDispatchReceiverTypesStack()));
            return firAnonymousInitializerBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitProperty(@NotNull KtProperty property, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.toFirProperty(property, null, RawFirBuilder.this.getContext());
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public FirElement visitTypeReference(@NotNull KtTypeReference typeReference, @NotNull Unit data2) {
            Object object;
            Object ktQualifier;
            Object referenceExpression2;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            Object $this$visitTypeReference_u24lambda_u24149;
            Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtTypeElement typeElement = typeReference.getTypeElement();
            KtPsiSourceElement source = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, typeReference, null, 1, null);
            boolean isNullable = typeElement instanceof KtNullableType;
            KtDeclarationModifierList[] ktDeclarationModifierListArray = Visitor.visitTypeReference$getAllModifierLists(typeReference);
            List allModifierLists = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(ktDeclarationModifierListArray, ktDeclarationModifierListArray.length));
            KtTypeElement unwrappedElement = Visitor.visitTypeReference$unwrapNullable(typeElement, allModifierLists);
            if (unwrappedElement instanceof KtDynamicType) {
                FirDynamicTypeRefBuilder firDynamicTypeRefBuilder = new FirDynamicTypeRefBuilder();
                $this$visitTypeReference_u24lambda_u24149 = firDynamicTypeRefBuilder;
                boolean bl = false;
                ((FirDynamicTypeRefBuilder)$this$visitTypeReference_u24lambda_u24149).setSource(source);
                ((FirDynamicTypeRefBuilder)$this$visitTypeReference_u24lambda_u24149).setMarkedNullable(isNullable);
                firAnnotationContainerBuilder = firDynamicTypeRefBuilder;
            } else if (unwrappedElement instanceof KtUserType) {
                referenceExpression2 = null;
                referenceExpression2 = ((KtUserType)unwrappedElement).getReferenceExpression();
                if (referenceExpression2 != null) {
                    Object object2;
                    $this$visitTypeReference_u24lambda_u24149 = new FirUserTypeRefBuilder();
                    RawFirBuilder bl = RawFirBuilder.this;
                    Object $this$visitTypeReference_u24lambda_u24151 = $this$visitTypeReference_u24lambda_u24149;
                    boolean bl2 = false;
                    ((FirUserTypeRefBuilder)$this$visitTypeReference_u24lambda_u24151).setSource(source);
                    ((FirUserTypeRefBuilder)$this$visitTypeReference_u24lambda_u24151).setMarkedNullable(isNullable);
                    ktQualifier = null;
                    ktQualifier = unwrappedElement;
                    do {
                        void $this$visitTypeReference_u24lambda_u24151_u24lambda_u24150;
                        KtPsiSourceElement ktPsiSourceElement;
                        Object object3;
                        KtSourceElement ktSourceElement = BaseFirBuilder.toFirSourceElement$default(bl, referenceExpression2, null, 1, null);
                        Name name2 = referenceExpression2.getReferencedNameAsName();
                        KtElementImplStub ktElementImplStub = (KtUserType)ktQualifier;
                        if (ktElementImplStub != null && (ktElementImplStub = (object3 = ktElementImplStub.getTypeArgumentList())) != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)ktElementImplStub, (String)"typeArgumentList");
                            PsiElement $this$toKtPsiSourceElement_u24default$iv = (PsiElement)object3;
                            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                            boolean $i$f$toKtPsiSourceElement = false;
                            KtSourceElementKind ktSourceElementKind = kind$iv;
                            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                            } else {
                                if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                                ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                            }
                        } else {
                            ktPsiSourceElement = source;
                        }
                        FirTypeArgumentListImpl firTypeArgumentListImpl = new FirTypeArgumentListImpl(ktPsiSourceElement);
                        object3 = firTypeArgumentListImpl;
                        Name name3 = name2;
                        object = ktSourceElement;
                        boolean bl3 = false;
                        List<FirTypeProjection> list2 = $this$visitTypeReference_u24lambda_u24151_u24lambda_u24150.getTypeArguments();
                        List<FirTypeRef> list3 = ktQualifier;
                        Intrinsics.checkNotNull((Object)list3);
                        List<KtTypeProjection> list4 = ((KtUserType)((Object)list3)).getTypeArguments();
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"ktQualifier!!.typeArguments");
                        this.appendTypeArguments(list2, list4);
                        Unit unit2 = Unit.INSTANCE;
                        FirTypeArgumentList firTypeArgumentList = firTypeArgumentListImpl;
                        Name name4 = name3;
                        KtSourceElement ktSourceElement2 = object;
                        FirQualifierPartImpl firQualifier = new FirQualifierPartImpl(ktSourceElement2, name4, firTypeArgumentList);
                        ((FirUserTypeRefBuilder)$this$visitTypeReference_u24lambda_u24151).getQualifier().add(firQualifier);
                        object2 = ktQualifier = ((KtUserType)ktQualifier).getQualifier();
                    } while ((referenceExpression2 = object2 != null ? ((KtUserType)object2).getReferenceExpression() : null) != null);
                    CollectionsKt.reverse(((FirUserTypeRefBuilder)$this$visitTypeReference_u24lambda_u24151).getQualifier());
                    firAnnotationContainerBuilder = (FirAnnotationContainerBuilder)$this$visitTypeReference_u24lambda_u24149;
                } else {
                    Object $this$visitTypeReference_u24lambda_u24152 = $this$visitTypeReference_u24lambda_u24149 = new FirErrorTypeRefBuilder();
                    boolean bl = false;
                    ((FirErrorTypeRefBuilder)$this$visitTypeReference_u24lambda_u24152).setSource(source);
                    ((FirErrorTypeRefBuilder)$this$visitTypeReference_u24lambda_u24152).setDiagnostic(new ConeSimpleDiagnostic("Incomplete user type", DiagnosticKind.Syntax));
                    firAnnotationContainerBuilder = (FirAnnotationContainerBuilder)$this$visitTypeReference_u24lambda_u24149;
                }
            } else if (unwrappedElement instanceof KtFunctionType) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                FirElement firElement;
                FirElement firElement2;
                Iterable this_$iv;
                boolean bl;
                Visitor $this$any$iv;
                List<FirTypeRef> $this$visitTypeReference_u24lambda_u24156;
                block29: {
                    referenceExpression2 = new FirFunctionTypeRefBuilder();
                    $this$visitTypeReference_u24lambda_u24149 = RawFirBuilder.this;
                    $this$visitTypeReference_u24lambda_u24156 = referenceExpression2;
                    boolean bl4 = false;
                    ((FirFunctionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24156)).setSource(source);
                    ((FirFunctionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24156)).setMarkedNullable(isNullable);
                    Iterable bl2 = allModifierLists;
                    ktQualifier = $this$visitTypeReference_u24lambda_u24156;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator $this$toKtPsiSourceElement_u24default$iv = $this$any$iv.iterator();
                        while ($this$toKtPsiSourceElement_u24default$iv.hasNext()) {
                            Object element$iv = $this$toKtPsiSourceElement_u24default$iv.next();
                            KtModifierList it = (KtModifierList)element$iv;
                            boolean bl5 = false;
                            if (!PsiUtilsKt.hasSuspendModifier(it)) continue;
                            bl = true;
                            break block29;
                        }
                        bl = false;
                    }
                }
                boolean bl6 = bl;
                ((FirFunctionTypeRefBuilder)ktQualifier).setSuspend(bl6);
                $this$any$iv = this;
                KtElement $this$convertSafe$iv = ((KtFunctionType)unwrappedElement).getReceiverTypeReference();
                boolean $i$f$convertSafe2 = false;
                KtElement ktElement = $this$convertSafe$iv;
                if (ktElement != null) {
                    KtElement p0$iv = ktElement;
                    boolean bl7 = false;
                    firElement2 = ((Visitor)((Object)this_$iv)).convertElement(p0$iv);
                } else {
                    firElement2 = firElement = null;
                }
                if (!(firElement2 instanceof FirTypeRef)) {
                    firElement = null;
                }
                ((FirFunctionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24156)).setReceiverTypeRef((FirTypeRef)((FirElement)((FirTypeRef)firElement)));
                ((FirFunctionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24156)).setReturnTypeRef(this.toFirOrErrorType(((KtFunctionType)unwrappedElement).getReturnTypeReference()));
                for (KtParameter valueParameter2 : ((KtFunctionType)unwrappedElement).getParameters()) {
                    FirFunctionTypeParameterBuilder bl7;
                    Collection $i$f$convertSafe2 = ((FirFunctionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24156)).getParameters();
                    boolean $i$f$buildFunctionTypeParameter22 = false;
                    FirFunctionTypeParameterBuilder $this$visitTypeReference_u24lambda_u24156_u24lambda_u24154 = bl7 = new FirFunctionTypeParameterBuilder();
                    boolean bl8 = false;
                    BaseFirBuilder baseFirBuilder = (BaseFirBuilder)$this$visitTypeReference_u24lambda_u24149;
                    Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
                    $this$visitTypeReference_u24lambda_u24156_u24lambda_u24154.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, valueParameter2, null, 1, null));
                    $this$visitTypeReference_u24lambda_u24156_u24lambda_u24154.setName(valueParameter2.getNameAsName());
                    $this$visitTypeReference_u24lambda_u24156_u24lambda_u24154.setReturnTypeRef(valueParameter2.getTypeReference() != null ? this.toFirOrErrorType(valueParameter2.getTypeReference()) : (FirTypeRef)((BaseFirBuilder)$this$visitTypeReference_u24lambda_u24149).createNoTypeForParameterTypeRef());
                    FirFunctionTypeParameter $i$f$buildFunctionTypeParameter22 = bl7.build();
                    $i$f$convertSafe2.add($i$f$buildFunctionTypeParameter22);
                }
                List<FirTypeRef> list5 = ((FirFunctionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24156)).getContextReceiverTypeRefs();
                List<KtTypeReference> list6 = ((KtFunctionType)unwrappedElement).getContextReceiversTypeReferences();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"unwrappedElement.contextReceiversTypeReferences");
                this_$iv = list6;
                ktQualifier = list5;
                boolean $i$f$mapNotNull = false;
                void $i$f$convertSafe2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    FirTypeRef it$iv$iv;
                    FirElement firElement3;
                    FirElement firElement4;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl9 = false;
                    KtTypeReference it = (KtTypeReference)element$iv$iv;
                    boolean bl10 = false;
                    Visitor visitor2 = this;
                    KtElement $this$convertSafe$iv2 = it;
                    boolean $i$f$convertSafe3 = false;
                    if ($this$convertSafe$iv2 != null) {
                        KtElement p0$iv;
                        void this_$iv2;
                        boolean bl11 = false;
                        firElement4 = this_$iv2.convertElement(p0$iv);
                    } else {
                        firElement4 = firElement3 = null;
                    }
                    if (!(firElement4 instanceof FirTypeRef)) {
                        firElement3 = null;
                    }
                    if ((FirTypeRef)((FirElement)((FirTypeRef)firElement3)) == null) continue;
                    boolean bl12 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                ktQualifier.addAll((List)destination$iv$iv);
                firAnnotationContainerBuilder = (FirAnnotationContainerBuilder)referenceExpression2;
            } else if (unwrappedElement instanceof KtIntersectionType) {
                referenceExpression2 = new FirIntersectionTypeRefBuilder();
                List<FirTypeRef> $this$visitTypeReference_u24lambda_u24157 = referenceExpression2;
                boolean bl = false;
                ((FirIntersectionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24157)).setSource(source);
                ((FirIntersectionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24157)).setMarkedNullable(isNullable);
                ((FirIntersectionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24157)).setLeftType(this.toFirOrErrorType(((KtIntersectionType)unwrappedElement).getLeftTypeRef()));
                ((FirIntersectionTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24157)).setRightType(this.toFirOrErrorType(((KtIntersectionType)unwrappedElement).getRightTypeRef()));
                firAnnotationContainerBuilder = (FirAnnotationContainerBuilder)referenceExpression2;
            } else {
                if (unwrappedElement != null) throw new AssertionError((Object)("Unexpected type element: " + unwrappedElement.getText()));
                referenceExpression2 = new FirErrorTypeRefBuilder();
                List<FirTypeRef> $this$visitTypeReference_u24lambda_u24158 = referenceExpression2;
                boolean bl = false;
                ((FirErrorTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24158)).setSource(source);
                ((FirErrorTypeRefBuilder)((Object)$this$visitTypeReference_u24lambda_u24158)).setDiagnostic(new ConeSimpleDiagnostic("Incomplete code", DiagnosticKind.Syntax));
                firAnnotationContainerBuilder = (FirAnnotationContainerBuilder)referenceExpression2;
            }
            FirAnnotationContainerBuilder firTypeBuilder = firAnnotationContainerBuilder;
            for (KtModifierList modifierList2 : allModifierLists) {
                for (KtAnnotationEntry annotationEntry : modifierList2.getAnnotationEntries()) {
                    void this_$iv;
                    Collection collection = firTypeBuilder.getAnnotations();
                    Visitor $this$mapNotNull$iv = this;
                    Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                    KtElement $this$convert$iv = annotationEntry;
                    boolean $i$f$convert = false;
                    FirElement firElement = this_$iv.convertElement($this$convert$iv);
                    if (firElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                    }
                    FirElement firElement5 = (FirAnnotation)firElement;
                    collection.add(firElement5);
                }
            }
            return firTypeBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry, @NotNull Unit data2) {
            void $this$visitAnnotationEntry_u24lambda_u24160_u24lambda_u24159;
            FirAnnotationCallBuilder firAnnotationCallBuilder;
            Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildAnnotationCall = false;
            FirAnnotationCallBuilder $this$visitAnnotationEntry_u24lambda_u24160 = firAnnotationCallBuilder = new FirAnnotationCallBuilder();
            boolean bl = false;
            $this$visitAnnotationEntry_u24lambda_u24160.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, annotationEntry, null, 1, null));
            KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = annotationEntry.getUseSiteTarget();
            $this$visitAnnotationEntry_u24lambda_u24160.setUseSiteTarget(ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null);
            $this$visitAnnotationEntry_u24lambda_u24160.setAnnotationTypeRef(this.toFirOrErrorType(annotationEntry.getTypeReference()));
            this.extractArgumentsTo(annotationEntry, $this$visitAnnotationEntry_u24lambda_u24160);
            Object object = $this$visitAnnotationEntry_u24lambda_u24160.getAnnotationTypeRef();
            Object object2 = object instanceof FirUserTypeRef ? (FirUserTypeRef)object : null;
            if (object2 == null || (object2 = ((FirUserTypeRef)object2).getQualifier()) == null || (object2 = (FirQualifierPart)CollectionsKt.last((List)object2)) == null || (object2 = object2.getName()) == null) {
                Name name2 = Name.special("<no-annotation-name>");
                object2 = name2;
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<no-annotation-name>\")");
            }
            Object name3 = object2;
            boolean $i$f$buildSimpleNamedReference = false;
            Object object3 = object = new FirSimpleNamedReferenceBuilder();
            FirAnnotationCallBuilder firAnnotationCallBuilder2 = $this$visitAnnotationEntry_u24lambda_u24160;
            boolean bl2 = false;
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            KtElement ktElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            KtUserType ktUserType = ktElement instanceof KtUserType ? (KtUserType)ktElement : null;
            $this$visitAnnotationEntry_u24lambda_u24160_u24lambda_u24159.setSource(ktUserType != null && (ktElement = ktUserType.getReferenceExpression()) != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, ktElement, null, 1, null) : null);
            $this$visitAnnotationEntry_u24lambda_u24160_u24lambda_u24159.setName((Name)name3);
            firAnnotationCallBuilder2.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
            List<FirTypeProjection> list2 = $this$visitAnnotationEntry_u24lambda_u24160.getTypeArguments();
            List<KtTypeProjection> list3 = annotationEntry.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"annotationEntry.typeArguments");
            this.appendTypeArguments(list2, list3);
            return firAnnotationCallBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitTypeProjection(@NotNull KtTypeProjection typeProjection, @NotNull Unit data2) {
            Variance variance;
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"typeProjection");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtProjectionKind ktProjectionKind = typeProjection.getProjectionKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)ktProjectionKind), (String)"typeProjection.projectionKind");
            KtProjectionKind projectionKind = ktProjectionKind;
            KtPsiSourceElement projectionSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, typeProjection, null, 1, null);
            if (projectionKind == KtProjectionKind.STAR) {
                FirStarProjectionBuilder firStarProjectionBuilder;
                boolean $i$f$buildStarProjection = false;
                FirStarProjectionBuilder $this$visitTypeProjection_u24lambda_u24161 = firStarProjectionBuilder = new FirStarProjectionBuilder();
                boolean bl2 = false;
                $this$visitTypeProjection_u24lambda_u24161.setSource(projectionSource);
                return firStarProjectionBuilder.build();
            }
            PsiElement psiElement = typeProjection.getParent();
            KtTypeArgumentList argumentList2 = psiElement instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement : null;
            KtTypeReference typeReference = typeProjection.getTypeReference();
            KtTypeArgumentList ktTypeArgumentList = argumentList2;
            if ((ktTypeArgumentList != null ? ktTypeArgumentList.getParent() : null) instanceof KtCallExpression) {
                KtTypeReference ktTypeReference = typeReference;
                boolean bl = ktTypeReference != null ? ktTypeReference.isPlaceholder() : false;
                if (bl) {
                    FirPlaceholderProjectionBuilder bl2;
                    boolean $i$f$buildPlaceholderProjection = false;
                    FirPlaceholderProjectionBuilder $this$visitTypeProjection_u24lambda_u24162 = bl2 = new FirPlaceholderProjectionBuilder();
                    boolean bl3 = false;
                    $this$visitTypeProjection_u24lambda_u24162.setSource(projectionSource);
                    return bl2.build();
                }
            }
            FirTypeRef firType = this.toFirOrErrorType(typeReference);
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$visitTypeProjection_u24lambda_u24163 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl = false;
            $this$visitTypeProjection_u24lambda_u24163.setSource(projectionSource);
            $this$visitTypeProjection_u24lambda_u24163.setTypeRef(firType);
            switch (WhenMappings.$EnumSwitchMapping$1[projectionKind.ordinal()]) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                case 4: {
                    AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                    throw null;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            $this$visitTypeProjection_u24lambda_u24163.setVariance(variance);
            return firTypeProjectionWithVarianceBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitBlockExpression(@NotNull KtBlockExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.configureBlockWithoutBuilding(expression2).build();
        }

        /*
         * Unable to fully structure code
         */
        private final FirBlockBuilder configureBlockWithoutBuilding(KtBlockExpression expression) {
            var2_2 = new FirBlockBuilder();
            var3_3 = RawFirBuilder.this;
            $this$configureBlockWithoutBuilding_u24lambda_u24165 = var2_2;
            $i$a$-apply-RawFirBuilder$Visitor$configureBlockWithoutBuilding$1 = false;
            $this$configureBlockWithoutBuilding_u24lambda_u24165.setSource(BaseFirBuilder.toFirSourceElement$default(var3_3, expression, null, 1, null));
            for (KtExpression statement : expression.getStatements()) {
                var8_9 = this;
                Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"statement");
                $this$toFirStatement$iv = statement;
                $i$f$toFirStatement = false;
                fir$iv = this_$iv.convertElement($this$toFirStatement$iv);
                if (fir$iv instanceof FirStatement) {
                    v0 = (FirStatement)fir$iv;
                } else {
                    var12_13 = this_$iv.RawFirBuilder.this;
                    $i$f$buildErrorExpression = false;
                    $this$toFirStatement_u24lambda_u243$iv = var14_15 = new FirErrorExpressionBuilder();
                    $i$a$-buildErrorExpression-RawFirBuilder$Visitor$toFirStatement$1$iv = false;
                    $this$toFirStatement_u24lambda_u243$iv.setNonExpressionElement(fir$iv);
                    var17_18 = $this$toFirStatement_u24lambda_u243$iv;
                    $i$a$-toFirStatement-RawFirBuilder$Visitor$configureBlockWithoutBuilding$1$firStatement$1 = false;
                    var20_21 = DiagnosticKind.Syntax;
                    var21_22 = "Statement expected: " + statement.getText();
                    var17_18.setDiagnostic(new ConeSimpleDiagnostic(var21_22, var20_21));
                    $this$toFirStatement_u24lambda_u243$iv.setSource(BaseFirBuilder.toFirSourceElement$default(var12_13, $this$toFirStatement$iv, null, 1, null));
                    v0 = var14_15.build();
                }
                firStatement = v0;
                if (!(firStatement instanceof FirBlock)) ** GOTO lbl-1000
                v1 = firStatement.getSource();
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = isForLoopBlock = false;
                }
                if (!(firStatement instanceof FirBlock) || isForLoopBlock || ((Collection)firStatement.getAnnotations()).isEmpty() == false) {
                    ((Collection)$this$configureBlockWithoutBuilding_u24lambda_u24165.getStatements()).add(firStatement);
                    continue;
                }
                CollectionsKt.addAll((Collection)$this$configureBlockWithoutBuilding_u24lambda_u24165.getStatements(), (Iterable)((FirBlock)firStatement).getStatements());
            }
            return var2_2;
        }

        @Override
        @NotNull
        public FirElement visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            BaseFirBuilder baseFirBuilder = RawFirBuilder.this;
            PsiElement psiElement = KtPsiUtilKt.getQualifiedExpressionForSelector(expression2) != null ? expression2.getParent() : (PsiElement)expression2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"when {\n                e\u2026 expression\n            }");
            KtPsiSourceElement qualifiedSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, psiElement, null, 1, null);
            KtPsiSourceElement expressionSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null);
            ConeDiagnostic diagnostic = null;
            String string2 = expression2.getReferencedNameElement().getNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expression.getReferencedNameElement().node.text");
            String rawText = string2;
            if (ConversionUtilsKt.isUnderscore(rawText)) {
                diagnostic = new ConeUnderscoreUsageWithoutBackticks(expressionSource);
            }
            return ConversionUtilsKt.generateAccessExpression(qualifiedSource, expressionSource, expression2.getReferencedNameAsName(), diagnostic);
        }

        @Override
        @NotNull
        public FirElement visitConstantExpression(@NotNull KtConstantExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return RawFirBuilder.this.generateConstantExpressionByLiteral(expression2);
        }

        @Override
        @NotNull
        public FirElement visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"expression.entries");
            return RawFirBuilder.this.toInterpolatingCall((Object[])ktStringTemplateEntryArray, expression2, visitStringTemplateExpression.1.INSTANCE, (Function2)new Function2<PsiElement, String, FirExpression>(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final FirExpression invoke(@Nullable PsiElement $this$toInterpolatingCall, @NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Intrinsics.checkNotNull((Object)$this$toInterpolatingCall, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
                    return Visitor.toFirExpression$default(this.this$0, ((KtStringTemplateEntryWithExpression)$this$toInterpolatingCall).getExpression(), it, null, 2, null);
                }
            });
        }

        @Override
        @NotNull
        public FirElement visitReturnExpression(@NotNull KtReturnExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtPsiSourceElement source = RawFirBuilder.this.toFirSourceElement((PsiElement)expression2, (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitUnit.INSTANCE);
            Object object = expression2.getReturnedExpression();
            if (object == null || (object = Visitor.toFirExpression$default(this, (KtElement)object, "Incorrect return expression", null, 2, null)) == null) {
                FirUnitExpressionBuilder firUnitExpressionBuilder;
                boolean $i$f$buildUnitExpression = false;
                FirUnitExpressionBuilder $this$visitReturnExpression_u24lambda_u24166 = firUnitExpressionBuilder = new FirUnitExpressionBuilder();
                boolean bl = false;
                $this$visitReturnExpression_u24lambda_u24166.setSource(source);
                object = firUnitExpressionBuilder.build();
            }
            Object result2 = object;
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
            return RawFirBuilder.this.toReturn((FirExpression)result2, source, ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitTryExpression(@NotNull KtTryExpression expression2, @NotNull Unit data2) {
            FirTryExpressionBuilder firTryExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildTryExpression = false;
            FirTryExpressionBuilder $this$visitTryExpression_u24lambda_u24171 = firTryExpressionBuilder = new FirTryExpressionBuilder();
            boolean bl = false;
            $this$visitTryExpression_u24lambda_u24171.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            $this$visitTryExpression_u24lambda_u24171.setTryBlock(this.toFirBlock(expression2.getTryBlock()));
            KtElement ktElement = expression2.getFinallyBlock();
            $this$visitTryExpression_u24lambda_u24171.setFinallyBlock(ktElement != null && (ktElement = ktElement.getFinalExpression()) != null ? this.toFirBlock((KtExpression)ktElement) : null);
            for (KtCatchClause clause : expression2.getCatchClauses()) {
                FirCatchBuilder firCatchBuilder;
                FirProperty firProperty;
                FirPropertyBuilder firPropertyBuilder;
                Object object = clause.getCatchParameter();
                if (object == null) continue;
                KtParameter ktParameter = object;
                boolean bl2 = false;
                Name name2 = ktParameter.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"ktParameter.nameAsSafeName");
                Name name3 = rawFirBuilder.convertValueParameterName(name2, BaseFirBuilder.ValueParameterDeclaration.CATCH, (Function0<String>)((Function0)new Function0<String>(ktParameter){
                    final /* synthetic */ KtParameter $ktParameter;
                    {
                        this.$ktParameter = $ktParameter;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        PsiElement psiElement = this.$ktParameter.getNameIdentifier();
                        return psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getText() : null;
                    }
                }));
                boolean $i$f$buildProperty = false;
                FirPropertyBuilder $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167 = firPropertyBuilder = new FirPropertyBuilder();
                boolean bl3 = false;
                BaseFirBuilder baseFirBuilder = rawFirBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"ktParameter");
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktParameter, null, 1, null));
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setModuleData(rawFirBuilder.getBaseModuleData());
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setReturnTypeRef(ktParameter.getTypeReference() != null ? this.toFirOrErrorType(ktParameter.getTypeReference()) : (FirTypeRef)rawFirBuilder.createNoTypeForParameterTypeRef());
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setVar(false);
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setStatus(new FirResolvedDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL, EffectiveVisibility.Local.INSTANCE));
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setLocal(true);
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setName(name3);
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.setSymbol(new FirPropertySymbol(new CallableId(name3, null, 2, null)));
                for (KtAnnotationEntry annotationEntry : ktParameter.getAnnotationEntries()) {
                    void this_$iv;
                    Collection collection = $this$visitTryExpression_u24lambda_u24171_u24lambda_u24169_u24lambda_u24167.getAnnotations();
                    Object object2 = this;
                    Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                    KtElement $this$convert$iv = annotationEntry;
                    boolean $i$f$convert = false;
                    FirElement firElement = this_$iv.convertElement($this$convert$iv);
                    if (firElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                    }
                    object2 = (FirAnnotation)firElement;
                    collection.add(object2);
                }
                FirProperty it = firProperty = firPropertyBuilder.build();
                boolean bl4 = false;
                ClassMembersKt.setCatchParameter(it, true);
                FirProperty firProperty2 = firProperty;
                object = firProperty2;
                if (firProperty2 == null) {
                    continue;
                }
                Object parameter2 = object;
                Collection collection = $this$visitTryExpression_u24lambda_u24171.getCatches();
                boolean $i$f$buildCatch = false;
                FirCatchBuilder $this$visitTryExpression_u24lambda_u24171_u24lambda_u24170 = firCatchBuilder = new FirCatchBuilder();
                boolean bl5 = false;
                BaseFirBuilder baseFirBuilder2 = rawFirBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)clause, (String)"clause");
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24170.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder2, clause, null, 1, null));
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24170.setParameter((FirProperty)parameter2);
                $this$visitTryExpression_u24lambda_u24171_u24lambda_u24170.setBlock(this.toFirBlock(clause.getCatchBody()));
                FirCatch firCatch = firCatchBuilder.build();
                collection.add(firCatch);
            }
            return firTryExpressionBuilder.build();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public FirElement visitIfExpression(@NotNull KtIfExpression expression2, @NotNull Unit data2) {
            FirWhenExpressionBuilder $this$visitIfExpression_u24lambda_u24174;
            FirWhenExpressionBuilder firWhenExpressionBuilder;
            block5: {
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder;
                KtPsiSourceElement ktPsiSourceElement;
                PsiElement psiElement;
                FirWhenBranchBuilder firWhenBranchBuilder;
                Object object;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildWhenExpression = false;
                $this$visitIfExpression_u24lambda_u24174 = firWhenExpressionBuilder = new FirWhenExpressionBuilder();
                boolean bl = false;
                $this$visitIfExpression_u24lambda_u24174.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
                KtExpression ktLastIf = null;
                ktLastIf = expression2;
                while (true) {
                    FirWhenBranchBuilder firWhenBranchBuilder2;
                    KtExpression ktCondition = ((KtIfExpression)ktLastIf).getCondition();
                    Collection collection = $this$visitIfExpression_u24lambda_u24174.getBranches();
                    boolean $i$f$buildWhenBranch = false;
                    FirWhenBranchBuilder $this$visitIfExpression_u24lambda_u24174_u24lambda_u24172 = firWhenBranchBuilder2 = new FirWhenBranchBuilder();
                    boolean bl2 = false;
                    KtExpression ktExpression = ktCondition;
                    $this$visitIfExpression_u24lambda_u24174_u24lambda_u24172.setSource(ktExpression != null ? rawFirBuilder.toFirSourceElement((PsiElement)ktExpression, (KtFakeSourceElementKind)KtFakeSourceElementKind.WhenCondition.INSTANCE) : null);
                    $this$visitIfExpression_u24lambda_u24174_u24lambda_u24172.setCondition(Visitor.toFirExpression$default(this, ktCondition, "If statement should have condition", null, 2, null));
                    $this$visitIfExpression_u24lambda_u24174_u24lambda_u24172.setResult(this.toFirBlock(((KtIfExpression)ktLastIf).getThen()));
                    object = firWhenBranchBuilder2.build();
                    collection.add(object);
                    KtExpression ktElse = ((KtIfExpression)ktLastIf).getElse();
                    if (ktElse == null) break block5;
                    if (!(ktElse instanceof KtIfExpression)) break;
                    ktLastIf = ktElse;
                }
                object = $this$visitIfExpression_u24lambda_u24174.getBranches();
                boolean $i$f$buildWhenBranch = false;
                FirWhenBranchBuilder $this$visitIfExpression_u24lambda_u24174_u24lambda_u24173 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl3 = false;
                PsiElement psiElement2 = psiElement = ((KtIfExpression)ktLastIf).getElseKeyword();
                if (psiElement2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"elseKeyword");
                    PsiElement $this$toKtPsiSourceElement_u24default$iv = psiElement;
                    KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                    boolean $i$f$toKtPsiSourceElement = false;
                    KtSourceElementKind ktSourceElementKind = kind$iv;
                    if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                        ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                    } else {
                        if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                        ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                    }
                } else {
                    ktPsiSourceElement = null;
                }
                $this$visitIfExpression_u24lambda_u24174_u24lambda_u24173.setSource(ktPsiSourceElement);
                boolean $i$f$buildElseIfTrueCondition = false;
                FirElseIfTrueConditionBuilder $i$f$toKtPsiSourceElement = firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
                FirWhenBranchBuilder firWhenBranchBuilder3 = $this$visitIfExpression_u24lambda_u24174_u24lambda_u24173;
                boolean bl4 = false;
                FirElseIfTrueConditionBuilder $this$null = $i$f$toKtPsiSourceElement;
                firWhenBranchBuilder3.setCondition(firElseIfTrueConditionBuilder.build());
                $this$visitIfExpression_u24lambda_u24174_u24lambda_u24173.setResult(this.toFirBlock(((KtIfExpression)ktLastIf).getElse()));
                FirWhenBranch firWhenBranch = firWhenBranchBuilder.build();
                object.add(firWhenBranch);
            }
            $this$visitIfExpression_u24lambda_u24174.setUsedAsExpression(this.getUsedAsExpression(expression2));
            return firWhenExpressionBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull Unit data2) {
            FirProperty firProperty;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            Object object;
            FirExpression subjectExpression;
            FirExpression firExpression2;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtExpression ktSubjectExpression = expression2.getSubjectExpression();
            KtExpression ktExpression2 = ktExpression = ktSubjectExpression instanceof KtVariableDeclaration ? ((KtVariableDeclaration)ktSubjectExpression).getInitializer() : ktSubjectExpression;
            if (ktExpression != null) {
                KtExpression ktExpression3 = ktSubjectExpression;
                firExpression2 = Visitor.toFirExpression$default(this, ktExpression, "Incorrect when subject expression: " + (ktExpression3 != null ? ktExpression3.getText() : null), null, 2, null);
            } else {
                firExpression2 = subjectExpression = null;
            }
            if (ktSubjectExpression instanceof KtVariableDeclaration) {
                Name name2 = ((KtVariableDeclaration)ktSubjectExpression).getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"ktSubjectExpression.nameAsSafeName");
                Name name3 = name2;
                object = RawFirBuilder.this;
                boolean $i$f$buildProperty = false;
                firAnnotationContainerBuilder = new FirPropertyBuilder();
                FirPropertyBuilder $this$visitWhenExpression_u24lambda_u24175 = firAnnotationContainerBuilder;
                boolean bl = false;
                $this$visitWhenExpression_u24lambda_u24175.setSource(BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)object, ktSubjectExpression, null, 1, null));
                $this$visitWhenExpression_u24lambda_u24175.setModuleData(((BaseFirBuilder)object).getBaseModuleData());
                $this$visitWhenExpression_u24lambda_u24175.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$visitWhenExpression_u24lambda_u24175.setReturnTypeRef(this.toFirOrImplicitType(((KtVariableDeclaration)ktSubjectExpression).getTypeReference()));
                $this$visitWhenExpression_u24lambda_u24175.setName(name3);
                $this$visitWhenExpression_u24lambda_u24175.setInitializer(subjectExpression);
                $this$visitWhenExpression_u24lambda_u24175.setDelegate(null);
                $this$visitWhenExpression_u24lambda_u24175.setVar(false);
                $this$visitWhenExpression_u24lambda_u24175.setSymbol(new FirPropertySymbol(name3));
                $this$visitWhenExpression_u24lambda_u24175.setLocal(true);
                $this$visitWhenExpression_u24lambda_u24175.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
                firProperty = ((FirPropertyBuilder)firAnnotationContainerBuilder).build();
            } else {
                firProperty = null;
            }
            FirProperty subjectVariable = firProperty;
            boolean hasSubject = subjectExpression != null;
            FirExpressionRef<FirWhenExpression> ref = new FirExpressionRef<FirWhenExpression>();
            object = RawFirBuilder.this;
            boolean $i$f$buildWhenExpression = false;
            FirAnnotationContainerBuilder $this$visitWhenExpression_u24lambda_u24179 = firAnnotationContainerBuilder = new FirWhenExpressionBuilder();
            boolean bl = false;
            ((FirWhenExpressionBuilder)$this$visitWhenExpression_u24lambda_u24179).setSource(BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)object, expression2, null, 1, null));
            ((FirWhenExpressionBuilder)$this$visitWhenExpression_u24lambda_u24179).setSubject(subjectExpression);
            ((FirWhenExpressionBuilder)$this$visitWhenExpression_u24lambda_u24179).setSubjectVariable(subjectVariable);
            ((FirWhenExpressionBuilder)$this$visitWhenExpression_u24lambda_u24179).setUsedAsExpression(this.getUsedAsExpression(expression2));
            for (KtWhenEntry entry : expression2.getEntries()) {
                FirWhenBranch firWhenBranch;
                FirWhenBranchBuilder firWhenBranchBuilder;
                BaseFirBuilder baseFirBuilder = (BaseFirBuilder)object;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                KtPsiSourceElement entrySource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, entry, null, 1, null);
                FirBlock branchBody = this.toFirBlock(entry.getExpression());
                Collection collection = ((FirWhenExpressionBuilder)$this$visitWhenExpression_u24lambda_u24179).getBranches();
                if (!entry.isElse()) {
                    FirWhenBranchBuilder $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176;
                    if (hasSubject) {
                        boolean $i$f$buildWhenBranch = false;
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                        boolean bl2 = false;
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176.setSource(entrySource);
                        KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
                        Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"entry.conditions");
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176.setCondition(PsiConversionUtilsKt.toFirWhenCondition(ktWhenConditionArray, ref, (Function2<? super KtExpression, ? super String, ? extends FirExpression>)((Function2)new Function2<KtExpression, String, FirExpression>(this){
                            final /* synthetic */ Visitor this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @NotNull
                            public final FirExpression invoke(@Nullable KtExpression $this$toFirWhenCondition, @NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Visitor.toFirExpression$default(this.this$0, $this$toFirWhenCondition, it, null, 2, null);
                            }
                        }), (Function1<? super KtTypeReference, ? extends FirTypeRef>)((Function1)new Function1<KtTypeReference, FirTypeRef>(this){
                            final /* synthetic */ Visitor this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final FirTypeRef invoke(@Nullable KtTypeReference $this$toFirWhenCondition) {
                                return Visitor.access$toFirOrErrorType(this.this$0, $this$toFirWhenCondition);
                            }
                        })));
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176.setResult(branchBody);
                        firWhenBranch = firWhenBranchBuilder.build();
                    } else {
                        KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
                        Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"entry.conditions");
                        KtWhenCondition ktCondition = (KtWhenCondition)ArraysKt.first((Object[])ktWhenConditionArray);
                        boolean $i$f$buildWhenBranch = false;
                        FirWhenBranchBuilder $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24177 = $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176 = new FirWhenBranchBuilder();
                        boolean bl3 = false;
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24177.setSource(entrySource);
                        KtElement ktElement = ktCondition instanceof KtWhenConditionWithExpression ? (KtWhenConditionWithExpression)ktCondition : null;
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24177.setCondition(this.toFirExpression(ktElement != null && (ktElement = ktElement.getExpression()) != null ? (KtElement)ktElement : (KtElement)ktCondition, "No expression in condition with expression", DiagnosticKind.ExpressionExpected));
                        $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24177.setResult(branchBody);
                        firWhenBranch = $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24176.build();
                    }
                } else {
                    FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder;
                    boolean $i$f$buildWhenBranch = false;
                    FirWhenBranchBuilder $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24178 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                    boolean bl4 = false;
                    $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24178.setSource(entrySource);
                    boolean $i$f$buildElseIfTrueCondition = false;
                    FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder2 = firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
                    FirWhenBranchBuilder firWhenBranchBuilder2 = $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24178;
                    boolean bl5 = false;
                    FirElseIfTrueConditionBuilder $this$null = firElseIfTrueConditionBuilder2;
                    firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
                    $this$visitWhenExpression_u24lambda_u24179_u24lambda_u24178.setResult(branchBody);
                    firWhenBranch = firWhenBranchBuilder.build();
                }
                FirWhenBranch firWhenBranch2 = firWhenBranch;
                collection.add(firWhenBranch2);
            }
            Object it = object = ((FirWhenExpressionBuilder)firAnnotationContainerBuilder).build();
            boolean bl6 = false;
            if (hasSubject) {
                ref.bind((FirWhenExpression)((FirExpression)it));
            }
            return (FirElement)object;
        }

        private final boolean getUsedAsExpression(KtExpression $this$usedAsExpression) {
            PsiElement parent2 = $this$usedAsExpression.getParent();
            while (true) {
                PsiElement psiElement = parent2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent");
                if (!Intrinsics.areEqual((Object)RawFirBuilder.this.getElementType(psiElement), (Object)KtNodeTypes.ANNOTATED_EXPRESSION)) {
                    PsiElement psiElement2 = parent2;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
                    if (!Intrinsics.areEqual((Object)RawFirBuilder.this.getElementType(psiElement2), (Object)KtNodeTypes.LABELED_EXPRESSION)) break;
                }
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof KtBlockExpression) {
                return false;
            }
            PsiElement psiElement = parent2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent");
            IElementType iElementType = RawFirBuilder.this.getElementType(psiElement);
            if ((Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_ENTRY)) {
                PsiElement psiElement3 = parent2.getParent();
                KtExpression ktExpression = psiElement3 instanceof KtExpression ? (KtExpression)psiElement3 : null;
                return ktExpression != null ? this.getUsedAsExpression(ktExpression) : true;
            }
            if (parent2 instanceof KtScriptInitializer) {
                return false;
            }
            if (!(parent2 instanceof KtContainerNodeForControlStructureBody)) {
                return true;
            }
            PsiElement psiElement4 = ((KtContainerNodeForControlStructureBody)parent2).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"parent.parent");
            IElementType type2 = RawFirBuilder.this.getElementType(psiElement4);
            return !Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.FOR) && !Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.WHILE) && !Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.DO_WHILE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, @NotNull Unit data2) {
            void $this$visitDoWhileExpression_u24lambda_u24181;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirLoopTarget target = null;
            FirDoWhileLoopBuilder firDoWhileLoopBuilder = new FirDoWhileLoopBuilder();
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            FirDoWhileLoopBuilder firDoWhileLoopBuilder2 = firDoWhileLoopBuilder;
            RawFirBuilder rawFirBuilder2 = RawFirBuilder.this;
            boolean bl = false;
            $this$visitDoWhileExpression_u24lambda_u24181.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            target = rawFirBuilder.prepareTarget((FirLoopBuilder)$this$visitDoWhileExpression_u24lambda_u24181, expression2);
            $this$visitDoWhileExpression_u24lambda_u24181.setCondition(Visitor.toFirExpression$default(this, expression2.getCondition(), "No condition in do-while loop", null, 2, null));
            return rawFirBuilder2.configure(firDoWhileLoopBuilder, target, (Function0<FirBlock>)((Function0)new Function0<FirBlock>(this, expression2){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ KtDoWhileExpression $expression;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    super(0);
                }

                @NotNull
                public final FirBlock invoke() {
                    return Visitor.access$toFirBlock(this.this$0, this.$expression.getBody());
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitWhileExpression(@NotNull KtWhileExpression expression2, @NotNull Unit data2) {
            void $this$visitWhileExpression_u24lambda_u24182;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirLoopTarget target = null;
            FirWhileLoopBuilder firWhileLoopBuilder = new FirWhileLoopBuilder();
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            FirWhileLoopBuilder firWhileLoopBuilder2 = firWhileLoopBuilder;
            RawFirBuilder rawFirBuilder2 = RawFirBuilder.this;
            boolean bl = false;
            $this$visitWhileExpression_u24lambda_u24182.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            $this$visitWhileExpression_u24lambda_u24182.setCondition(Visitor.toFirExpression$default(this, expression2.getCondition(), "No condition in while loop", null, 2, null));
            target = rawFirBuilder.prepareTarget((FirLoopBuilder)$this$visitWhileExpression_u24lambda_u24182, expression2);
            return rawFirBuilder2.configure(firWhileLoopBuilder, target, (Function0<FirBlock>)((Function0)new Function0<FirBlock>(this, expression2){
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ KtWhileExpression $expression;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    super(0);
                }

                @NotNull
                public final FirBlock invoke() {
                    return Visitor.access$toFirBlock(this.this$0, this.$expression.getBody());
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitForExpression(@NotNull KtForExpression expression2, @Nullable Unit data2) {
            void $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186_u24lambda_u24185;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            void $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186;
            void $this$visitForExpression_u24lambda_u24188_u24lambda_u24187;
            Object $this$visitForExpression_u24lambda_u24188_u24lambda_u24184_u24lambda_u24183;
            FirAnnotationContainerBuilder $this$visitForExpression_u24lambda_u24188_u24lambda_u24184;
            KtPsiSourceElement ktPsiSourceElement;
            KtExpression ktExpression;
            KtPsiSourceElement ktPsiSourceElement2;
            void $this$toKtPsiSourceElement$iv;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            FirExpression rangeExpression = Visitor.toFirExpression$default(this, expression2.getLoopRange(), "No range in for loop", null, 2, null);
            KtParameter ktParameter = expression2.getLoopParameter();
            PsiElement psiElement = (PsiElement)expression2;
            KtSourceElementKind kind$iv = KtFakeSourceElementKind.DesugaredForLoop.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            Object object = kind$iv;
            if (object instanceof KtRealSourceElementKind) {
                ktPsiSourceElement2 = new KtRealPsiSourceElement((PsiElement)$this$toKtPsiSourceElement$iv);
            } else if (object instanceof KtFakeSourceElementKind) {
                ktPsiSourceElement2 = new KtFakeSourceElement((PsiElement)$this$toKtPsiSourceElement$iv, (KtFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            KtPsiSourceElement fakeSource = ktPsiSourceElement2;
            FirLoopTarget target = null;
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildBlock = false;
            Object $this$visitForExpression_u24lambda_u24188 = object = new FirBlockBuilder();
            boolean bl = false;
            ((FirBlockBuilder)$this$visitForExpression_u24lambda_u24188).setSource(fakeSource);
            KtExpression ktExpression2 = ktExpression = expression2.getLoopRange();
            if (ktExpression2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"loopRange");
                ktPsiSourceElement = rawFirBuilder.toFirSourceElement((PsiElement)ktExpression, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE);
            } else {
                ktPsiSourceElement = null;
            }
            KtPsiSourceElement rangeSource = ktPsiSourceElement;
            boolean $i$f$buildFunctionCall = false;
            Object object2 = new FirFunctionCallBuilder();
            FirFunctionCallBuilder firFunctionCallBuilder = object2;
            Name name2 = SpecialNames.ITERATOR;
            KtSourceElement ktSourceElement = rangeSource;
            Object object3 = rawFirBuilder.getBaseModuleData();
            boolean bl2 = false;
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24184.setSource(fakeSource);
            boolean $i$f$buildSimpleNamedReference = false;
            Object object4 = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = object4;
            void var24_25 = $this$visitForExpression_u24lambda_u24188_u24lambda_u24184;
            boolean bl3 = false;
            ((FirSimpleNamedReferenceBuilder)$this$visitForExpression_u24lambda_u24188_u24lambda_u24184_u24lambda_u24183).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)$this$visitForExpression_u24lambda_u24188_u24lambda_u24184_u24lambda_u24183).setName(OperatorNameConventions.ITERATOR);
            var24_25.setCalleeReference(((FirSimpleNamedReferenceBuilder)object4).build());
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24184.setExplicitReceiver(rangeExpression);
            Unit unit2 = Unit.INSTANCE;
            FirProperty iteratorVal = FirGenerationKt.generateTemporaryVariable$default((FirModuleData)object3, ktSourceElement, name2, ((FirFunctionCallBuilder)object2).build(), null, null, 48, null);
            ((Collection)((FirBlockBuilder)$this$visitForExpression_u24lambda_u24188).getStatements()).add(iteratorVal);
            Collection collection = ((FirBlockBuilder)$this$visitForExpression_u24lambda_u24188).getStatements();
            object2 = new FirWhileLoopBuilder();
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24184 = object2;
            object3 = rawFirBuilder;
            boolean bl4 = false;
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24187.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            boolean $i$f$buildFunctionCall2 = false;
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24184_u24lambda_u24183 = object4 = new FirFunctionCallBuilder();
            var24_25 = $this$visitForExpression_u24lambda_u24188_u24lambda_u24187;
            boolean bl5 = false;
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186.setSource(fakeSource);
            boolean $i$f$buildSimpleNamedReference2 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            void var30_31 = $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186;
            boolean bl6 = false;
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186_u24lambda_u24185.setSource(fakeSource);
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186_u24lambda_u24185.setName(OperatorNameConventions.HAS_NEXT);
            var30_31.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$visitForExpression_u24lambda_u24188_u24lambda_u24187_u24lambda_u24186.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(fakeSource, iteratorVal));
            var24_25.setCondition(((FirFunctionCallBuilder)object4).build());
            target = rawFirBuilder.prepareTarget((FirLoopBuilder)$this$visitForExpression_u24lambda_u24188_u24lambda_u24187, expression2);
            object2 = ((BaseFirBuilder)object3).configure((FirLoopBuilder)object2, target, (Function0<? extends FirBlock>)((Function0)new Function0<FirBlock>(expression2, this, ktParameter, rawFirBuilder, fakeSource, iteratorVal){
                final /* synthetic */ KtForExpression $expression;
                final /* synthetic */ Visitor this$0;
                final /* synthetic */ KtParameter $ktParameter;
                final /* synthetic */ RawFirBuilder this$1;
                final /* synthetic */ KtPsiSourceElement $fakeSource;
                final /* synthetic */ FirProperty $iteratorVal;
                {
                    this.$expression = $expression;
                    this.this$0 = $receiver;
                    this.$ktParameter = $ktParameter;
                    this.this$1 = $receiver2;
                    this.$fakeSource = $fakeSource;
                    this.$iteratorVal = $iteratorVal;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final FirBlock invoke() {
                    FirBlockBuilder blockBuilder;
                    Object object;
                    Object object2;
                    FirBlockBuilder firBlockBuilder;
                    KtExpression body2 = this.$expression.getBody();
                    if (body2 instanceof KtBlockExpression) {
                        firBlockBuilder = Visitor.access$configureBlockWithoutBuilding(this.this$0, (KtBlockExpression)body2);
                    } else if (body2 == null) {
                        firBlockBuilder = new FirBlockBuilder();
                    } else {
                        FirBlockBuilder firBlockBuilder2 = new FirBlockBuilder();
                        object2 = this.this$1;
                        object = this.this$0;
                        FirBlockBuilder $this$invoke_u24lambda_u240 = firBlockBuilder2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setSource(((RawFirBuilder)object2).toFirSourceElement((PsiElement)body2, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE));
                        ((Collection)$this$invoke_u24lambda_u240.getStatements()).add(Visitor.access$toFirStatement(object, body2));
                        firBlockBuilder = blockBuilder = firBlockBuilder2;
                    }
                    if (this.$ktParameter != null) {
                        void $this$invoke_u24lambda_u242_u24lambda_u241;
                        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                        void $this$invoke_u24lambda_u242;
                        FirFunctionCallBuilder firFunctionCallBuilder;
                        Name name2;
                        KtDestructuringDeclaration multiDeclaration = this.$ktParameter.getDestructuringDeclaration();
                        FirModuleData firModuleData = this.this$1.getBaseModuleData();
                        object2 = this.$expression.getLoopParameter();
                        KtSourceElement ktSourceElement = object2 != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(this.this$1, object2, null, 1, null) : null;
                        if (multiDeclaration != null) {
                            name2 = SpecialNames.DESTRUCT;
                        } else {
                            Name name3 = this.$ktParameter.getNameAsSafeName();
                            name2 = name3;
                            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"ktParameter.nameAsSafeName");
                        }
                        object2 = this.$fakeSource;
                        object = this.$iteratorVal;
                        boolean $i$f$buildFunctionCall = false;
                        FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder = new FirFunctionCallBuilder();
                        Name name4 = name2;
                        KtSourceElement ktSourceElement2 = ktSourceElement;
                        FirModuleData firModuleData2 = firModuleData;
                        boolean bl = false;
                        $this$invoke_u24lambda_u242.setSource((KtSourceElement)object2);
                        boolean $i$f$buildSimpleNamedReference = false;
                        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                        void var13_18 = $this$invoke_u24lambda_u242;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u242_u24lambda_u241.setSource((KtSourceElement)object2);
                        $this$invoke_u24lambda_u242_u24lambda_u241.setName(OperatorNameConventions.NEXT);
                        var13_18.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                        $this$invoke_u24lambda_u242.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression((KtSourceElement)object2, (FirVariable)object));
                        Unit unit2 = Unit.INSTANCE;
                        FirProperty firLoopParameter = FirGenerationKt.generateTemporaryVariable$default(firModuleData2, ktSourceElement2, name4, firFunctionCallBuilder.build(), Visitor.access$toFirOrImplicitType(this.this$0, this.$ktParameter.getTypeReference()), null, 32, null);
                        if (multiDeclaration != null) {
                            FirBlock destructuringBlock2 = PsiConversionUtilsKt.generateDestructuringBlock(this.this$1.getBaseModuleData(), multiDeclaration, firLoopParameter, true, (Function2<? super KtAnnotated, ? super FirAnnotationContainerBuilder, Unit>)((Function2)new Function2<KtAnnotated, FirAnnotationContainerBuilder, Unit>(this.this$0){
                                final /* synthetic */ Visitor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                public final void invoke(@NotNull KtAnnotated $this$generateDestructuringBlock, @NotNull FirAnnotationContainerBuilder it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$generateDestructuringBlock, (String)"$this$generateDestructuringBlock");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    Visitor.access$extractAnnotationsTo(this.this$0, $this$generateDestructuringBlock, it);
                                }
                            }), (Function1<? super KtTypeReference, ? extends FirTypeRef>)((Function1)new Function1<KtTypeReference, FirTypeRef>(this.this$0){
                                final /* synthetic */ Visitor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                @NotNull
                                public final FirTypeRef invoke(@Nullable KtTypeReference $this$generateDestructuringBlock) {
                                    return Visitor.access$toFirOrImplicitType(this.this$0, $this$generateDestructuringBlock);
                                }
                            }));
                            blockBuilder.getStatements().addAll(0, (Collection<FirStatement>)destructuringBlock2.getStatements());
                        } else {
                            blockBuilder.getStatements().add(0, firLoopParameter);
                        }
                    }
                    return blockBuilder.build();
                }
            }));
            collection.add(object2);
            return ((FirBlockBuilder)object).build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitBreakExpression(@NotNull KtBreakExpression expression2, @NotNull Unit data2) {
            void $this$visitBreakExpression_u24lambda_u24189;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirBreakExpressionBuilder firBreakExpressionBuilder = new FirBreakExpressionBuilder();
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            FirBreakExpressionBuilder firBreakExpressionBuilder2 = firBreakExpressionBuilder;
            RawFirBuilder rawFirBuilder2 = RawFirBuilder.this;
            boolean bl = false;
            $this$visitBreakExpression_u24lambda_u24189.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            return rawFirBuilder2.bindLabel(firBreakExpressionBuilder, expression2).build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitContinueExpression(@NotNull KtContinueExpression expression2, @NotNull Unit data2) {
            void $this$visitContinueExpression_u24lambda_u24190;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirContinueExpressionBuilder firContinueExpressionBuilder = new FirContinueExpressionBuilder();
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            FirContinueExpressionBuilder firContinueExpressionBuilder2 = firContinueExpressionBuilder;
            RawFirBuilder rawFirBuilder2 = RawFirBuilder.this;
            boolean bl = false;
            $this$visitContinueExpression_u24lambda_u24190.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            return rawFirBuilder2.bindLabel(firContinueExpressionBuilder, expression2).build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull Unit data2) {
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            IElementType iElementType = expression2.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.operationToken");
            IElementType operationToken = iElementType;
            if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IDENTIFIER))) {
                ((Collection)RawFirBuilder.this.getContext().getCalleeNamesForLambda()).add(expression2.getOperationReference().getReferencedNameAsName());
            }
            FirExpression leftArgument = Visitor.toFirExpression$default(this, expression2.getLeft(), "No left operand", null, 2, null);
            FirExpression rightArgument = Visitor.toFirExpression$default(this, expression2.getRight(), "No right operand", null, 2, null);
            if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IDENTIFIER))) {
                RawFirBuilder.this.removeLast(RawFirBuilder.this.getContext().getCalleeNamesForLambda());
            }
            KtPsiSourceElement source = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null);
            IElementType iElementType2 = operationToken;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.ELVIS))) {
                return ConversionUtilsKt.generateNotNullOrOther(leftArgument, rightArgument, source);
            }
            if (Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.ANDAND)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)((Object)KtTokens.OROR))) {
                return ConversionUtilsKt.generateLazyLogicalOperation(leftArgument, rightArgument, Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.ANDAND)), source);
            }
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"IN_OPERATIONS");
            if (CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)iElementType2)) {
                boolean bl = Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.NOT_IN));
                KtSourceElement ktSourceElement = source;
                BaseFirBuilder baseFirBuilder = RawFirBuilder.this;
                KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                return ConversionUtilsKt.generateContainsOperation(rightArgument, leftArgument, bl, ktSourceElement, BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktOperationReferenceExpression, null, 1, null));
            }
            ImmutableSet<KtSingleValueToken> immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet2, (String)"COMPARISON_OPERATIONS");
            if (CollectionsKt.contains((Iterable)((Iterable)immutableSet2), (Object)iElementType2)) {
                KtSourceElement ktSourceElement = source;
                BaseFirBuilder baseFirBuilder = RawFirBuilder.this;
                KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                return ConversionUtilsKt.generateComparisonExpression(leftArgument, rightArgument, operationToken, ktSourceElement, BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktOperationReferenceExpression, null, 1, null));
            }
            Name conventionCallName = ConversionUtilsKt.toBinaryName(operationToken);
            if (conventionCallName != null || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IDENTIFIER))) {
                void $this$visitBinaryExpression_u24lambda_u24192_u24lambda_u24191;
                FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                FirFunctionCallBuilder firFunctionCallBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildFunctionCall = false;
                FirFunctionCallBuilder $this$visitBinaryExpression_u24lambda_u24192 = firFunctionCallBuilder = new FirFunctionCallBuilder();
                boolean bl = false;
                $this$visitBinaryExpression_u24lambda_u24192.setSource(source);
                boolean $i$f$buildSimpleNamedReference = false;
                FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                FirFunctionCallBuilder firFunctionCallBuilder2 = $this$visitBinaryExpression_u24lambda_u24192;
                boolean bl2 = false;
                BaseFirBuilder baseFirBuilder = rawFirBuilder;
                KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                $this$visitBinaryExpression_u24lambda_u24192_u24lambda_u24191.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktOperationReferenceExpression, null, 1, null));
                Name name2 = conventionCallName;
                if (name2 == null) {
                    name2 = expression2.getOperationReference().getReferencedNameAsName();
                }
                $this$visitBinaryExpression_u24lambda_u24192_u24lambda_u24191.setName(name2);
                firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                $this$visitBinaryExpression_u24lambda_u24192.setExplicitReceiver(leftArgument);
                $this$visitBinaryExpression_u24lambda_u24192.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(rightArgument));
                $this$visitBinaryExpression_u24lambda_u24192.setOrigin(conventionCallName != null ? FirFunctionCallOrigin.Operator : FirFunctionCallOrigin.Infix);
                firElement = firFunctionCallBuilder.build();
            } else {
                FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder;
                FirOperation firOperation = ConversionUtilsKt.toFirOperation(operationToken);
                if (FirOperation.Companion.getASSIGNMENTS().contains((Object)firOperation)) {
                    KtExpression $i$f$buildFunctionCall;
                    return RawFirBuilder.this.generateAssignment(expression2.getLeft(), source, ($i$f$buildFunctionCall = expression2.getLeft()) != null ? (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, $i$f$buildFunctionCall, null, 1, null) : null, rightArgument, firOperation, leftArgument.getAnnotations(), expression2.getRight(), (Function1)new Function1<PsiElement, FirExpression>(this, expression2){
                        final /* synthetic */ Visitor this$0;
                        final /* synthetic */ KtBinaryExpression $expression;
                        {
                            this.this$0 = $receiver;
                            this.$expression = $expression;
                            super(1);
                        }

                        @NotNull
                        public final FirExpression invoke(@NotNull PsiElement $this$generateAssignment) {
                            Intrinsics.checkNotNullParameter((Object)$this$generateAssignment, (String)"$this$generateAssignment");
                            return Visitor.toFirExpression$default(this.this$0, (KtExpression)$this$generateAssignment, "Incorrect expression in assignment: " + this.$expression.getText(), null, 2, null);
                        }
                    });
                }
                boolean $i$f$buildEqualityOperatorCall = false;
                FirEqualityOperatorCallBuilder $this$visitBinaryExpression_u24lambda_u24193 = firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
                boolean bl = false;
                $this$visitBinaryExpression_u24lambda_u24193.setSource(source);
                $this$visitBinaryExpression_u24lambda_u24193.setOperation(firOperation);
                $this$visitBinaryExpression_u24lambda_u24193.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(leftArgument, rightArgument));
                firElement = firEqualityOperatorCallBuilder.build();
            }
            return firElement;
        }

        @Override
        @NotNull
        public FirElement visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull Unit data2) {
            FirTypeOperatorCallBuilder firTypeOperatorCallBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildTypeOperatorCall = false;
            FirTypeOperatorCallBuilder $this$visitBinaryWithTypeRHSExpression_u24lambda_u24194 = firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
            boolean bl = false;
            $this$visitBinaryWithTypeRHSExpression_u24lambda_u24194.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            $this$visitBinaryWithTypeRHSExpression_u24lambda_u24194.setOperation(ConversionUtilsKt.toFirOperation(expression2.getOperationReference().getReferencedNameElementType()));
            $this$visitBinaryWithTypeRHSExpression_u24lambda_u24194.setConversionTypeRef(this.toFirOrErrorType(expression2.getRight()));
            $this$visitBinaryWithTypeRHSExpression_u24lambda_u24194.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(Visitor.toFirExpression$default(this, expression2.getLeft(), "No left operand", null, 2, null)));
            return firTypeOperatorCallBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitIsExpression(@NotNull KtIsExpression expression2, @NotNull Unit data2) {
            FirTypeOperatorCallBuilder firTypeOperatorCallBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildTypeOperatorCall = false;
            FirTypeOperatorCallBuilder $this$visitIsExpression_u24lambda_u24195 = firTypeOperatorCallBuilder = new FirTypeOperatorCallBuilder();
            boolean bl = false;
            $this$visitIsExpression_u24lambda_u24195.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            $this$visitIsExpression_u24lambda_u24195.setOperation(expression2.isNegated() ? FirOperation.NOT_IS : FirOperation.IS);
            $this$visitIsExpression_u24lambda_u24195.setConversionTypeRef(this.toFirOrErrorType(expression2.getTypeReference()));
            $this$visitIsExpression_u24lambda_u24195.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(Visitor.toFirExpression$default(this, expression2.getLeftHandSide(), "No left operand", null, 2, null)));
            return firTypeOperatorCallBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull Unit data2) {
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            IElementType operationToken = expression2.getOperationToken();
            KtExpression argument2 = expression2.getBaseExpression();
            Intrinsics.checkNotNullExpressionValue((Object)operationToken, (String)"operationToken");
            Name conventionCallName = ConversionUtilsKt.toUnaryName(operationToken);
            if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.EXCLEXCL))) {
                FirCheckNotNullCallBuilder firCheckNotNullCallBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildCheckNotNullCall = false;
                FirCheckNotNullCallBuilder $this$visitUnaryExpression_u24lambda_u24196 = firCheckNotNullCallBuilder = new FirCheckNotNullCallBuilder();
                boolean bl = false;
                $this$visitUnaryExpression_u24lambda_u24196.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
                $this$visitUnaryExpression_u24lambda_u24196.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(Visitor.toFirExpression$default(this, argument2, "No operand", null, 2, null)));
                firElement = firCheckNotNullCallBuilder.build();
            } else if (conventionCallName != null) {
                void $this$visitUnaryExpression_u24lambda_u24199_u24lambda_u24198;
                FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                FirFunctionCallBuilder firFunctionCallBuilder;
                ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.INCREMENT_OPERATIONS;
                Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"INCREMENT_OPERATIONS");
                if (CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)operationToken)) {
                    return RawFirBuilder.this.generateIncrementOrDecrementBlock(expression2, expression2.getOperationReference(), argument2, conventionCallName, expression2 instanceof KtPrefixExpression, (Function1)new Function1<PsiElement, FirExpression>(this){
                        final /* synthetic */ Visitor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final FirExpression invoke(@NotNull PsiElement $this$generateIncrementOrDecrementBlock) {
                            Intrinsics.checkNotNullParameter((Object)$this$generateIncrementOrDecrementBlock, (String)"$this$generateIncrementOrDecrementBlock");
                            return Visitor.toFirExpression$default(this.this$0, (KtExpression)$this$generateIncrementOrDecrementBlock, "Incorrect expression inside inc/dec", null, 2, null);
                        }
                    });
                }
                FirExpression receiver = Visitor.toFirExpression$default(this, argument2, "No operand", null, 2, null);
                Object object = RawFirBuilder.this.convertUnaryPlusMinusCallOnIntegerLiteralIfNecessary(expression2, receiver, operationToken);
                if (object != null) {
                    FirExpression it = object;
                    boolean bl = false;
                    return it;
                }
                object = RawFirBuilder.this;
                boolean $i$f$buildFunctionCall = false;
                FirFunctionCallBuilder $this$visitUnaryExpression_u24lambda_u24199 = firFunctionCallBuilder = new FirFunctionCallBuilder();
                boolean bl = false;
                $this$visitUnaryExpression_u24lambda_u24199.setSource(BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)object, expression2, null, 1, null));
                boolean $i$f$buildSimpleNamedReference = false;
                FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                FirFunctionCallBuilder firFunctionCallBuilder2 = $this$visitUnaryExpression_u24lambda_u24199;
                boolean bl2 = false;
                BaseFirBuilder baseFirBuilder = (BaseFirBuilder)object;
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
                $this$visitUnaryExpression_u24lambda_u24199_u24lambda_u24198.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktSimpleNameExpression, null, 1, null));
                $this$visitUnaryExpression_u24lambda_u24199_u24lambda_u24198.setName(conventionCallName);
                firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                $this$visitUnaryExpression_u24lambda_u24199.setExplicitReceiver(receiver);
                $this$visitUnaryExpression_u24lambda_u24199.setOrigin(FirFunctionCallOrigin.Operator);
                firElement = firFunctionCallBuilder.build();
            } else {
                throw new IllegalStateException("Unexpected expression: " + expression2.getText());
            }
            return firElement;
        }

        private final CalleeAndReceiver splitToCalleeAndReceiver(KtExpression calleeExpression, KtPsiSourceElement defaultSource) {
            CalleeAndReceiver calleeAndReceiver;
            KtExpression ktExpression = calleeExpression;
            if (ktExpression instanceof KtSimpleNameExpression) {
                FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildSimpleNamedReference = false;
                FirSimpleNamedReferenceBuilder $this$splitToCalleeAndReceiver_u24lambda_u24200 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                boolean bl = false;
                $this$splitToCalleeAndReceiver_u24lambda_u24200.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, calleeExpression, null, 1, null));
                $this$splitToCalleeAndReceiver_u24lambda_u24200.setName(((KtSimpleNameExpression)calleeExpression).getReferencedNameAsName());
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 6;
                boolean bl2 = false;
                FirExpression firExpression2 = null;
                FirNamedReference firNamedReference = firSimpleNamedReferenceBuilder.build();
                calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression2, bl2, n, defaultConstructorMarker);
            } else if (ktExpression instanceof KtParenthesizedExpression) {
                calleeAndReceiver = this.splitToCalleeAndReceiver(((KtParenthesizedExpression)calleeExpression).getExpression(), defaultSource);
            } else if (ktExpression == null) {
                FirErrorNamedReferenceBuilder $i$f$buildSimpleNamedReference;
                boolean $i$f$buildErrorNamedReference = false;
                FirErrorNamedReferenceBuilder $this$splitToCalleeAndReceiver_u24lambda_u24201 = $i$f$buildSimpleNamedReference = new FirErrorNamedReferenceBuilder();
                boolean bl = false;
                $this$splitToCalleeAndReceiver_u24lambda_u24201.setDiagnostic(new ConeSimpleDiagnostic("Call has no callee", DiagnosticKind.Syntax));
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 6;
                boolean bl3 = false;
                FirExpression firExpression3 = null;
                FirNamedReference firNamedReference = $i$f$buildSimpleNamedReference.build();
                calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression3, bl3, n, defaultConstructorMarker);
            } else if (ktExpression instanceof KtSuperExpression) {
                FirErrorNamedReferenceBuilder $this$splitToCalleeAndReceiver_u24lambda_u24201;
                RawFirBuilder $i$f$buildErrorNamedReference = RawFirBuilder.this;
                boolean $i$f$buildErrorNamedReference2 = false;
                FirErrorNamedReferenceBuilder $this$splitToCalleeAndReceiver_u24lambda_u24202 = $this$splitToCalleeAndReceiver_u24lambda_u24201 = new FirErrorNamedReferenceBuilder();
                boolean bl = false;
                $this$splitToCalleeAndReceiver_u24lambda_u24202.setSource(BaseFirBuilder.toFirSourceElement$default($i$f$buildErrorNamedReference, calleeExpression, null, 1, null));
                $this$splitToCalleeAndReceiver_u24lambda_u24202.setDiagnostic(new ConeSimpleDiagnostic("Super cannot be a callee", DiagnosticKind.SuperNotAllowed));
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 6;
                boolean bl4 = false;
                FirExpression firExpression4 = null;
                FirNamedReference firNamedReference = $this$splitToCalleeAndReceiver_u24lambda_u24201.build();
                calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression4, bl4, n, defaultConstructorMarker);
            } else {
                FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                boolean $i$f$buildSimpleNamedReference = false;
                FirSimpleNamedReferenceBuilder $this$splitToCalleeAndReceiver_u24lambda_u24203 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                boolean bl = false;
                $this$splitToCalleeAndReceiver_u24lambda_u24203.setSource(KtSourceElementKt.fakeElement(defaultSource, KtFakeSourceElementKind.ImplicitInvokeCall.INSTANCE));
                $this$splitToCalleeAndReceiver_u24lambda_u24203.setName(OperatorNameConventions.INVOKE);
                boolean bl5 = true;
                FirExpression firExpression5 = Visitor.toFirExpression$default(this, calleeExpression, "Incorrect invoke receiver", null, 2, null);
                FirNamedReference firNamedReference = firSimpleNamedReferenceBuilder.build();
                calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression5, bl5);
            }
            return calleeAndReceiver;
        }

        @Override
        @NotNull
        public FirElement visitCallExpression(@NotNull KtCallExpression expression2, @NotNull Unit data2) {
            FirQualifiedAccessExpressionBuilder result2;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder;
            FirQualifiedAccessExpressionBuilder $this$visitCallExpression_u24lambda_u24204;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtPsiSourceElement source = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null);
            CalleeAndReceiver calleeAndReceiver = this.splitToCalleeAndReceiver(expression2.getCalleeExpression(), source);
            FirNamedReference calleeReference = calleeAndReceiver.component1();
            FirExpression explicitReceiver = calleeAndReceiver.component2();
            boolean isImplicitInvoke = calleeAndReceiver.component3();
            if (expression2.getValueArgumentList() == null && expression2.getLambdaArguments().isEmpty()) {
                $this$visitCallExpression_u24lambda_u24204 = firQualifiedAccessExpressionBuilder2 = new FirPropertyAccessExpressionBuilder();
                boolean bl = false;
                ((FirPropertyAccessExpressionBuilder)$this$visitCallExpression_u24lambda_u24204).setSource(source);
                ((FirPropertyAccessExpressionBuilder)$this$visitCallExpression_u24lambda_u24204).setCalleeReference(calleeReference);
                firQualifiedAccessExpressionBuilder = firQualifiedAccessExpressionBuilder2;
            } else {
                FirAnnotationContainerBuilder builder2 = isImplicitInvoke ? new FirImplicitInvokeCallBuilder() : new FirFunctionCallBuilder();
                $this$visitCallExpression_u24lambda_u24204 = builder2;
                RawFirBuilder bl = RawFirBuilder.this;
                FirQualifiedAccessExpressionBuilder $this$visitCallExpression_u24lambda_u24205 = $this$visitCallExpression_u24lambda_u24204;
                boolean bl2 = false;
                ((FirAbstractFunctionCallBuilder)$this$visitCallExpression_u24lambda_u24205).setSource(source);
                ((FirAbstractFunctionCallBuilder)$this$visitCallExpression_u24lambda_u24205).setCalleeReference(calleeReference);
                ((Collection)bl.getContext().getCalleeNamesForLambda()).add(calleeReference.getName());
                this.extractArgumentsTo(expression2, (FirCallBuilder)((Object)$this$visitCallExpression_u24lambda_u24205));
                bl.removeLast(bl.getContext().getCalleeNamesForLambda());
                firQualifiedAccessExpressionBuilder = $this$visitCallExpression_u24lambda_u24204;
            }
            FirQualifiedAccessExpressionBuilder $this$visitCallExpression_u24lambda_u24206 = firQualifiedAccessExpressionBuilder2 = (result2 = firQualifiedAccessExpressionBuilder);
            boolean bl = false;
            $this$visitCallExpression_u24lambda_u24206.setExplicitReceiver(explicitReceiver);
            List<FirTypeProjection> list2 = $this$visitCallExpression_u24lambda_u24206.getTypeArguments();
            List<KtTypeProjection> list3 = expression2.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"expression.typeArguments");
            this.appendTypeArguments(list2, list3);
            return firQualifiedAccessExpressionBuilder2.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, @NotNull Unit data2) {
            void $this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24208;
            Object $this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24207;
            FirFunctionCallBuilder firFunctionCallBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtExpression arrayExpression = expression2.getArrayExpression();
            FirExpression setArgument = RawFirBuilder.this.getContext().getArraySetArgument().remove(expression2);
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder $this$visitArrayAccessExpression_u24lambda_u24209 = firFunctionCallBuilder = new FirFunctionCallBuilder();
            boolean bl = false;
            boolean isGet = setArgument == null;
            BaseFirBuilder baseFirBuilder = rawFirBuilder;
            PsiElement psiElement = isGet ? (PsiElement)expression2 : expression2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"if (isGet) expression else expression.parent");
            $this$visitArrayAccessExpression_u24lambda_u24209.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, psiElement, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            Object object = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = object;
            FirFunctionCallBuilder firFunctionCallBuilder2 = $this$visitArrayAccessExpression_u24lambda_u24209;
            boolean bl2 = false;
            ((FirSimpleNamedReferenceBuilder)$this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24207).setSource(KtSourceElementKt.fakeElement(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null), KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE));
            ((FirSimpleNamedReferenceBuilder)$this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24207).setName(isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
            firFunctionCallBuilder2.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
            $this$visitArrayAccessExpression_u24lambda_u24209.setExplicitReceiver(Visitor.toFirExpression$default(this, arrayExpression, "No array expression", null, 2, null));
            boolean $i$f$buildArgumentList = false;
            $this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24207 = object = new FirArgumentListBuilder();
            firFunctionCallBuilder2 = $this$visitArrayAccessExpression_u24lambda_u24209;
            boolean bl3 = false;
            for (KtExpression indexExpression : expression2.getIndexExpressions()) {
                ((Collection)$this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24208.getArguments()).add(Visitor.toFirExpression$default(this, indexExpression, "Incorrect index expression", null, 2, null));
            }
            if (setArgument != null) {
                ((Collection)$this$visitArrayAccessExpression_u24lambda_u24209_u24lambda_u24208.getArguments()).add(setArgument);
            }
            firFunctionCallBuilder2.setArgumentList(((FirArgumentListBuilder)object).build());
            $this$visitArrayAccessExpression_u24lambda_u24209.setOrigin(FirFunctionCallOrigin.Operator);
            return ConversionUtilsKt.pullUpSafeCallIfNecessary(firFunctionCallBuilder.build());
        }

        @Override
        @NotNull
        public FirElement visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirExpression receiver = Visitor.toFirExpression$default(this, expression2.getReceiverExpression(), "Incorrect receiver expression", null, 2, null);
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression == null) {
                FirErrorExpressionBuilder firErrorExpressionBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildErrorExpression = false;
                FirErrorExpressionBuilder $this$visitQualifiedExpression_u24lambda_u24210 = firErrorExpressionBuilder = new FirErrorExpressionBuilder();
                boolean bl = false;
                $this$visitQualifiedExpression_u24lambda_u24210.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
                $this$visitQualifiedExpression_u24lambda_u24210.setDiagnostic(new ConeSimpleDiagnostic("Qualified expression without selector", DiagnosticKind.Syntax));
                $this$visitQualifiedExpression_u24lambda_u24210.setExpression(receiver);
                return firErrorExpressionBuilder.build();
            }
            KtExpression selector = ktExpression;
            FirExpression firSelector = Visitor.toFirExpression$default(this, selector, "Incorrect selector expression", null, 2, null);
            if (firSelector instanceof FirQualifiedAccessExpression) {
                if (expression2 instanceof KtSafeQualifiedExpression) {
                    ((FirQualifiedAccessExpression)firSelector).replaceSource(RawFirBuilder.this.toFirSourceElement((PsiElement)expression2, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredSafeCallExpression.INSTANCE));
                    return ConversionUtilsKt.createSafeCall((FirQualifiedAccessExpression)firSelector, receiver, BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null));
                }
                return RawFirBuilder.this.convertFirSelector((FirQualifiedAccessExpression)firSelector, BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null), receiver);
            }
            if (firSelector instanceof FirErrorExpression) {
                FirQualifiedErrorAccessExpressionBuilder firQualifiedErrorAccessExpressionBuilder;
                RawFirBuilder rawFirBuilder = RawFirBuilder.this;
                boolean $i$f$buildQualifiedErrorAccessExpression = false;
                FirQualifiedErrorAccessExpressionBuilder $this$visitQualifiedExpression_u24lambda_u24211 = firQualifiedErrorAccessExpressionBuilder = new FirQualifiedErrorAccessExpressionBuilder();
                boolean bl = false;
                $this$visitQualifiedExpression_u24lambda_u24211.setReceiver(receiver);
                $this$visitQualifiedExpression_u24lambda_u24211.setSelector((FirErrorExpression)firSelector);
                $this$visitQualifiedExpression_u24lambda_u24211.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
                $this$visitQualifiedExpression_u24lambda_u24211.setDiagnostic(new ConeSimpleDiagnostic("Qualified expression with unexpected selector", DiagnosticKind.Syntax));
                return firQualifiedErrorAccessExpressionBuilder.build();
            }
            return firSelector;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitThisExpression(@NotNull KtThisExpression expression2, @NotNull Unit data2) {
            void $this$visitThisExpression_u24lambda_u24213_u24lambda_u24212;
            FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$visitThisExpression_u24lambda_u24213 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            KtPsiSourceElement sourceElement = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null);
            $this$visitThisExpression_u24lambda_u24213.setSource(sourceElement);
            boolean $i$f$buildExplicitThisReference = false;
            FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder2 = firExplicitThisReferenceBuilder = new FirExplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$visitThisExpression_u24lambda_u24213;
            boolean bl2 = false;
            $this$visitThisExpression_u24lambda_u24213_u24lambda_u24212.setSource(KtSourceElementKt.fakeElement(sourceElement, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE));
            $this$visitThisExpression_u24lambda_u24213_u24lambda_u24212.setLabelName(expression2.getLabelName());
            firThisReceiverExpressionBuilder2.setCalleeReference(firExplicitThisReferenceBuilder.build());
            return firThisReceiverExpressionBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitSuperExpression(@NotNull KtSuperExpression expression2, @NotNull Unit data2) {
            void $this$visitSuperExpression_u24lambda_u24215_u24lambda_u24214;
            FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder;
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtTypeReference superType2 = expression2.getSuperTypeQualifier();
            KtPsiSourceElement theSource = (KtPsiSourceElement)BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null);
            boolean $i$f$buildPropertyAccessExpression = false;
            FirPropertyAccessExpressionBuilder $this$visitSuperExpression_u24lambda_u24215 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            boolean bl = false;
            $this$visitSuperExpression_u24lambda_u24215.setSource(theSource);
            boolean $i$f$buildExplicitSuperReference = false;
            FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder2 = firExplicitSuperReferenceBuilder = new FirExplicitSuperReferenceBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$visitSuperExpression_u24lambda_u24215;
            boolean bl2 = false;
            $this$visitSuperExpression_u24lambda_u24215_u24lambda_u24214.setSource(KtSourceElementKt.fakeElement(theSource, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE));
            $this$visitSuperExpression_u24lambda_u24215_u24lambda_u24214.setLabelName(expression2.getLabelName());
            $this$visitSuperExpression_u24lambda_u24215_u24lambda_u24214.setSuperTypeRef(this.toFirOrImplicitType(superType2));
            firPropertyAccessExpressionBuilder2.setCalleeReference(firExplicitSuperReferenceBuilder.build());
            return firPropertyAccessExpressionBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder.this.getContext().forwardLabelUsagePermission(expression2, expression2.getExpression());
            KtExpression ktExpression = expression2.getExpression();
            FirElement firElement = ktExpression != null ? (FirElement)ktExpression.accept(this, data2) : null;
            return firElement == null ? (FirElement)FirExpressionUtilKt.buildErrorExpression$default(BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null), new ConeSimpleDiagnostic("Empty parentheses", DiagnosticKind.Syntax), null, 4, null) : firElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull Unit data2) {
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtSimpleNameExpression label = expression2.getTargetLabel();
            KtSourceElement errorLabelSource = null;
            if (label != null) {
                void label$iv;
                void this_$iv;
                KtPsiSourceElement ktPsiSourceElement;
                ASTNode aSTNode = label.getReferencedNameElement().getNode();
                Intrinsics.checkNotNull((Object)aSTNode);
                String string2 = aSTNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"label.getReferencedNameElement().node!!.text");
                String rawName = string2;
                Object $this$toKtPsiSourceElement_u24default$iv = (PsiElement)label;
                Object kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement((PsiElement)$this$toKtPsiSourceElement_u24default$iv);
                } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                    ktPsiSourceElement = new KtFakeSourceElement((PsiElement)$this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Pair<FirLabel, KtSourceElement> labelAndErrorSource = RawFirBuilder.this.buildLabelAndErrorSource(rawName, ktPsiSourceElement);
                errorLabelSource = (KtSourceElement)labelAndErrorSource.getSecond();
                $this$toKtPsiSourceElement_u24default$iv = RawFirBuilder.this.getContext();
                kind$iv = (FirLabel)labelAndErrorSource.getFirst();
                KtExpression userNode$iv = expression2.getBaseExpression();
                boolean $i$f$withNewLabel = false;
                this_$iv.addNewLabel((FirLabel)label$iv);
                this_$iv.setNewLabelUserNode(userNode$iv);
                try {
                    boolean bl = false;
                    KtExpression ktExpression = expression2.getBaseExpression();
                    FirElement firElement2 = ktExpression != null ? (FirElement)ktExpression.accept(this, data2) : null;
                    firElement = firElement2;
                }
                finally {
                    this_$iv.dropLastLabel();
                }
            } else {
                KtExpression ktExpression = expression2.getBaseExpression();
                firElement = ktExpression != null ? (FirElement)ktExpression.accept(this, data2) : null;
            }
            FirElement result2 = firElement;
            return RawFirBuilder.this.buildExpressionWithErrorLabel(result2, errorLabelSource, BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null));
        }

        @Override
        @NotNull
        public FirElement visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            KtExpression baseExpression = expression2.getBaseExpression();
            RawFirBuilder.this.getContext().forwardLabelUsagePermission(expression2, baseExpression);
            KtExpression ktExpression = baseExpression;
            FirElement rawResult = ktExpression != null ? (FirElement)ktExpression.accept(this, data2) : null;
            FirAnnotationContainer firAnnotationContainer = rawResult instanceof FirAnnotationContainer ? (FirAnnotationContainer)rawResult : null;
            if (firAnnotationContainer == null) {
                KtSourceElement ktSourceElement = BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, expression2, null, 1, null);
                Object object = rawResult;
                if (object == null || (object = UtilsKt.render((FirElement)object)) == null) {
                    object = "???";
                }
                firAnnotationContainer = FirExpressionUtilKt.buildErrorExpression$default(ktSourceElement, new ConeNotAnnotationContainer((String)object), null, 4, null);
            }
            FirAnnotationContainer result2 = firAnnotationContainer;
            this.extractAnnotationsTo((KtAnnotated)expression2, result2);
            return result2;
        }

        @Override
        @NotNull
        public FirElement visitThrowExpression(@NotNull KtThrowExpression expression2, @NotNull Unit data2) {
            FirThrowExpressionBuilder firThrowExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildThrowExpression = false;
            FirThrowExpressionBuilder $this$visitThrowExpression_u24lambda_u24217 = firThrowExpressionBuilder = new FirThrowExpressionBuilder();
            boolean bl = false;
            $this$visitThrowExpression_u24lambda_u24217.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            $this$visitThrowExpression_u24lambda_u24217.setException(Visitor.toFirExpression$default(this, expression2.getThrownExpression(), "Nothing to throw", null, 2, null));
            return firThrowExpressionBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull Unit data2) {
            Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirVariable baseVariable2 = PsiConversionUtilsKt.generateTemporaryVariable(RawFirBuilder.this.getBaseModuleData(), BaseFirBuilder.toFirSourceElement$default(RawFirBuilder.this, multiDeclaration, null, 1, null), "destruct", this.toFirExpression(multiDeclaration.getInitializer(), "Initializer required for destructuring declaration", DiagnosticKind.Syntax), (Function2<? super KtAnnotated, ? super FirAnnotationContainerBuilder, Unit>)((Function2)new Function2<KtAnnotated, FirAnnotationContainerBuilder, Unit>(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull KtAnnotated $this$generateTemporaryVariable, @NotNull FirAnnotationContainerBuilder it) {
                    Intrinsics.checkNotNullParameter((Object)$this$generateTemporaryVariable, (String)"$this$generateTemporaryVariable");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Visitor.access$extractAnnotationsTo(this.this$0, $this$generateTemporaryVariable, it);
                }
            }));
            return PsiConversionUtilsKt.generateDestructuringBlock(RawFirBuilder.this.getBaseModuleData(), multiDeclaration, baseVariable2, true, (Function2<? super KtAnnotated, ? super FirAnnotationContainerBuilder, Unit>)((Function2)new Function2<KtAnnotated, FirAnnotationContainerBuilder, Unit>(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull KtAnnotated $this$generateDestructuringBlock, @NotNull FirAnnotationContainerBuilder it) {
                    Intrinsics.checkNotNullParameter((Object)$this$generateDestructuringBlock, (String)"$this$generateDestructuringBlock");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Visitor.access$extractAnnotationsTo(this.this$0, $this$generateDestructuringBlock, it);
                }
            }), (Function1<? super KtTypeReference, ? extends FirTypeRef>)((Function1)new Function1<KtTypeReference, FirTypeRef>(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final FirTypeRef invoke(@Nullable KtTypeReference $this$generateDestructuringBlock) {
                    return Visitor.access$toFirOrImplicitType(this.this$0, $this$generateDestructuringBlock);
                }
            }));
        }

        @Override
        @NotNull
        public FirElement visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @NotNull Unit data2) {
            FirGetClassCallBuilder firGetClassCallBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildGetClassCall = false;
            FirGetClassCallBuilder $this$visitClassLiteralExpression_u24lambda_u24218 = firGetClassCallBuilder = new FirGetClassCallBuilder();
            boolean bl = false;
            $this$visitClassLiteralExpression_u24lambda_u24218.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            $this$visitClassLiteralExpression_u24lambda_u24218.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(Visitor.toFirExpression$default(this, expression2.getReceiverExpression(), "No receiver in class literal", null, 2, null)));
            return firGetClassCallBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @NotNull Unit data2) {
            void $this$visitCallableReferenceExpression_u24lambda_u24220_u24lambda_u24219;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildCallableReferenceAccess = false;
            FirCallableReferenceAccessBuilder $this$visitCallableReferenceExpression_u24lambda_u24220 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
            boolean bl = false;
            $this$visitCallableReferenceExpression_u24lambda_u24220.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder2 = $this$visitCallableReferenceExpression_u24lambda_u24220;
            boolean bl2 = false;
            BaseFirBuilder baseFirBuilder = rawFirBuilder;
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.callableReference");
            $this$visitCallableReferenceExpression_u24lambda_u24220_u24lambda_u24219.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, ktSimpleNameExpression, null, 1, null));
            $this$visitCallableReferenceExpression_u24lambda_u24220_u24lambda_u24219.setName(expression2.getCallableReference().getReferencedNameAsName());
            firCallableReferenceAccessBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            KtExpression ktExpression = expression2.getReceiverExpression();
            $this$visitCallableReferenceExpression_u24lambda_u24220.setExplicitReceiver(ktExpression != null ? Visitor.toFirExpression$default(this, ktExpression, "Incorrect receiver expression", null, 2, null) : null);
            $this$visitCallableReferenceExpression_u24lambda_u24220.setHasQuestionMarkAtLHS(expression2.getHasQuestionMarks());
            return firCallableReferenceAccessBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirElement visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, @NotNull Unit data2) {
            FirArgumentListBuilder firArgumentListBuilder;
            FirArrayOfCallBuilder firArrayOfCallBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildArrayOfCall = false;
            FirArrayOfCallBuilder $this$visitCollectionLiteralExpression_u24lambda_u24222 = firArrayOfCallBuilder = new FirArrayOfCallBuilder();
            boolean bl = false;
            $this$visitCollectionLiteralExpression_u24lambda_u24222.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            boolean $i$f$buildArgumentList = false;
            FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
            FirArrayOfCallBuilder firArrayOfCallBuilder2 = $this$visitCollectionLiteralExpression_u24lambda_u24222;
            boolean bl2 = false;
            for (KtExpression innerExpression : expression2.getInnerExpressions()) {
                void $this$visitCollectionLiteralExpression_u24lambda_u24222_u24lambda_u24221;
                ((Collection)$this$visitCollectionLiteralExpression_u24lambda_u24222_u24lambda_u24221.getArguments()).add(Visitor.toFirExpression$default(this, innerExpression, "Incorrect collection literal argument", null, 2, null));
            }
            firArrayOfCallBuilder2.setArgumentList(firArgumentListBuilder.build());
            return firArrayOfCallBuilder.build();
        }

        @Override
        @NotNull
        public FirElement visitExpression(@NotNull KtExpression expression2, @NotNull Unit data2) {
            FirExpressionStubBuilder firExpressionStubBuilder;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildExpressionStub = false;
            FirExpressionStubBuilder $this$visitExpression_u24lambda_u24223 = firExpressionStubBuilder = new FirExpressionStubBuilder();
            boolean bl = false;
            $this$visitExpression_u24lambda_u24223.setSource(BaseFirBuilder.toFirSourceElement$default(rawFirBuilder, expression2, null, 1, null));
            return firExpressionStubBuilder.build();
        }

        /*
         * WARNING - void declaration
         */
        private final void appendTypeArguments(List<FirTypeProjection> $this$appendTypeArguments, List<? extends KtTypeProjection> args) {
            for (KtTypeProjection ktTypeProjection : args) {
                void this_$iv;
                Collection collection = $this$appendTypeArguments;
                Object object = this;
                KtElement $this$convert$iv = ktTypeProjection;
                boolean $i$f$convert = false;
                FirElement firElement = this_$iv.convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeProjection");
                }
                object = (FirTypeProjection)firElement;
                collection.add(object);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final FirDanglingModifierList buildErrorTopLevelDeclarationForDanglingModifierList(KtModifierList modifierList2) {
            FirDanglingModifierListBuilder firDanglingModifierListBuilder;
            RawFirBuilder rawFirBuilder = RawFirBuilder.this;
            boolean $i$f$buildDanglingModifierList = false;
            FirDanglingModifierListBuilder $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224 = firDanglingModifierListBuilder = new FirDanglingModifierListBuilder();
            boolean bl = false;
            $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224.setSource(rawFirBuilder.toFirSourceElement((PsiElement)modifierList2, (KtFakeSourceElementKind)KtFakeSourceElementKind.DanglingModifierList.INSTANCE));
            $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224.setModuleData(rawFirBuilder.getBaseModuleData());
            $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224.setDiagnostic(ConeDanglingModifierOnTopLevel.INSTANCE);
            $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224.setSymbol(new FirDanglingModifierSymbol());
            for (KtAnnotationEntry annotationEntry : modifierList2.getAnnotationEntries()) {
                void this_$iv;
                Collection collection = $this$buildErrorTopLevelDeclarationForDanglingModifierList_u24lambda_u24224.getAnnotations();
                Object object = this;
                Intrinsics.checkNotNullExpressionValue((Object)annotationEntry, (String)"annotationEntry");
                KtElement $this$convert$iv = annotationEntry;
                boolean $i$f$convert = false;
                FirElement firElement = this_$iv.convertElement($this$convert$iv);
                if (firElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
                }
                object = (FirAnnotation)firElement;
                collection.add(object);
            }
            return firDanglingModifierListBuilder.build();
        }

        private static final Visibility toFirConstructor$defaultVisibility(KtClassOrObject $owner) {
            return $owner instanceof KtObjectDeclaration || $owner.hasModifier(KtTokens.ENUM_KEYWORD) || $owner instanceof KtEnumEntry ? (Visibility)Visibilities.Private.INSTANCE : ($owner.hasModifier(KtTokens.SEALED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Visibility)Visibilities.Unknown.INSTANCE);
        }

        private static final FirExpression toFirProperty$lambda$145$extractDelegateExpression(Visitor this$0, KtProperty $this_toFirProperty) {
            KtPropertyDelegate ktPropertyDelegate = $this_toFirProperty.getDelegate();
            return Visitor.toFirExpression$default(this$0, ktPropertyDelegate != null ? ktPropertyDelegate.getExpression() : null, "Incorrect delegate expression", null, 2, null);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final FirExpression toFirProperty$lambda$145$lambda$143$extractDelegateExpression$141(Visitor this$0, RawFirBuilder this$1, KtProperty $this_toFirProperty) {
            void this_$iv$iv;
            void this_$iv;
            Visitor visitor2 = this$0;
            KtSourceElement sourceElement$iv = this$1.toFirSourceElement($this_toFirProperty, (KtFakeSourceElementKind)KtFakeSourceElementKind.WrappedDelegate.INSTANCE);
            boolean $i$f$buildOrLazyExpression = false;
            void var6_6 = this_$iv;
            Function0 lazy$iv$iv = (Function0)new /* invalid duplicate definition of identical inner class */;
            boolean $i$f$buildOrLazy = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this_$iv$iv.RawFirBuilder.this.getMode().ordinal()]) {
                case 1: {
                    FirErrorExpressionBuilder firErrorExpressionBuilder;
                    boolean bl = false;
                    Object object = $this_toFirProperty.getDelegate();
                    if (object != null && (object = ((KtPropertyDelegate)object).getExpression()) != null) {
                        KtElement ktElement = object;
                        boolean bl2 = false;
                        FirExpression firExpression2 = Visitor.toFirExpression$default(this$0, ktElement, "Should have delegate", null, 2, null);
                        object = firExpression2;
                        if (firExpression2 != null) return (FirExpression)object;
                    }
                    boolean $i$f$buildErrorExpression = false;
                    FirErrorExpressionBuilder $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24extractDelegateExpression_u24141_u24lambda_u24140_u24lambda_u24139 = firErrorExpressionBuilder = new FirErrorExpressionBuilder();
                    boolean bl3 = false;
                    $this$toFirProperty_u24lambda_u24145_u24lambda_u24143_u24extractDelegateExpression_u24141_u24lambda_u24140_u24lambda_u24139.setDiagnostic(new ConeSimpleDiagnostic("Should have delegate", DiagnosticKind.ExpressionExpected));
                    object = firErrorExpressionBuilder.build();
                    return (FirExpression)object;
                }
                case 2: {
                    Object object;
                    RawFirBuilder this_$iv$iv$iv = this_$iv$iv.RawFirBuilder.this;
                    boolean $i$f$runOnStubs = false;
                    switch (org.jetbrains.kotlin.fir.builder.RawFirBuilder$WhenMappings.$EnumSwitchMapping$0[this_$iv$iv$iv.getMode().ordinal()]) {
                        case 1: {
                            object = lazy$iv$iv.invoke();
                            return (FirExpression)object;
                        }
                        case 2: {
                            object = AstLoadingFilter.disallowTreeLoading((ThrowableComputable)new /* invalid duplicate definition of identical inner class */);
                            return (FirExpression)object;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private static final KtDeclarationModifierList[] visitTypeReference$getAllModifierLists(KtElementImplStub<?> $this$visitTypeReference_u24getAllModifierLists) {
            PsiElement[] psiElementArray = $this$visitTypeReference_u24getAllModifierLists.getStubOrPsiChildren(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStubOrPsiChildren(KtS\u2026DIFIER_LIST.arrayFactory)");
            return (KtDeclarationModifierList[])psiElementArray;
        }

        private static final KtTypeElement visitTypeReference$unwrapNullable(KtTypeElement $this$visitTypeReference_u24unwrapNullable, List<KtModifierList> allModifierLists) {
            KtTypeElement ktTypeElement;
            if ($this$visitTypeReference_u24unwrapNullable instanceof KtNullableType) {
                CollectionsKt.addAll((Collection)allModifierLists, (Object[])Visitor.visitTypeReference$getAllModifierLists((KtElementImplStub)((Object)$this$visitTypeReference_u24unwrapNullable)));
                ktTypeElement = Visitor.visitTypeReference$unwrapNullable(((KtNullableType)$this$visitTypeReference_u24unwrapNullable).getInnerType(), allModifierLists);
            } else {
                ktTypeElement = $this$visitTypeReference_u24unwrapNullable;
            }
            return ktTypeElement;
        }

        public static final /* synthetic */ FirBlock access$toFirBlock(Visitor $this, KtExpression $receiver) {
            return $this.toFirBlock($receiver);
        }

        public static final /* synthetic */ void access$extractAnnotationsTo(Visitor $this, KtAnnotated $receiver, FirAnnotationContainerBuilder container) {
            $this.extractAnnotationsTo($receiver, container);
        }

        public static final /* synthetic */ FirTypeRef access$toFirOrImplicitType(Visitor $this, KtTypeReference $receiver) {
            return $this.toFirOrImplicitType($receiver);
        }

        public static final /* synthetic */ FirTypeRef access$toFirOrErrorType(Visitor $this, KtTypeReference $receiver) {
            return $this.toFirOrErrorType($receiver);
        }

        public static final /* synthetic */ FirBlockBuilder access$configureBlockWithoutBuilding(Visitor $this, KtBlockExpression expression2) {
            return $this.configureBlockWithoutBuilding(expression2);
        }

        public static final /* synthetic */ FirStatement access$toFirStatement(Visitor $this, KtExpression $receiver) {
            return $this.toFirStatement($receiver);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[BodyBuildingMode.values().length];
                try {
                    nArray[BodyBuildingMode.NORMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BodyBuildingMode.LAZY_BODIES.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[KtProjectionKind.values().length];
                try {
                    nArray[KtProjectionKind.IN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KtProjectionKind.OUT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KtProjectionKind.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KtProjectionKind.STAR.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BodyBuildingMode.values().length];
            try {
                nArray[BodyBuildingMode.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BodyBuildingMode.LAZY_BODIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

