/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.contracts.description.ConeUnresolvedEffect;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirStatement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "UNEXPECTED_CONSTRUCTION", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkContractNotAllowed", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "checkUnresolvedEffects", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,68:1\n12#2,2:69\n37#2:71\n38#2:72\n21#2:73\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n62#1:69,2\n62#1:71\n63#1:72\n64#1:73\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String UNEXPECTED_CONSTRUCTION = "unexpected construction in contract description";

    private FirContractChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription = ((FirContractDescriptionOwner)((Object)declaration)).getContractDescription();
        FirResolvedContractDescription firResolvedContractDescription = firContractDescription instanceof FirResolvedContractDescription ? (FirResolvedContractDescription)firContractDescription : null;
        if (firResolvedContractDescription == null) {
            return;
        }
        FirResolvedContractDescription contractDescription = firResolvedContractDescription;
        this.checkUnresolvedEffects(contractDescription, context, reporter);
        this.checkContractNotAllowed(declaration, contractDescription, context, reporter);
    }

    private final void checkUnresolvedEffects(FirResolvedContractDescription contractDescription, CheckerContext context, DiagnosticReporter reporter) {
        for (ConeUnresolvedEffect unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            FirStatement statement2 = unresolvedEffect.getStatement();
            if (statement2.getSource() == null) continue;
            KtSourceElement ktSourceElement = statement2.getSource();
            Intrinsics.checkNotNull((Object)ktSourceElement);
            if (ktSourceElement.getKind() instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)statement2.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)UNEXPECTED_CONSTRUCTION, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkContractNotAllowed(FirFunction declaration, FirResolvedContractDescription contractDescription, CheckerContext context, DiagnosticReporter reporter) {
        block5: {
            KtSourceElement source;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                KtSourceElement ktSourceElement = source = contractDescription.getSource();
                                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                                    return;
                                }
                                if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirAnonymousFunction)) break block4;
                                FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are only allowed for functions");
                                break block5;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block6;
                            FirMemberDeclaration $this$isOpen$iv = declaration;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block6;
                            FirMemberDeclaration $this$isOverride$iv = declaration;
                            boolean $i$f$isOverride = false;
                            if (!$this$isOverride$iv.getStatus().isOverride()) break block7;
                        }
                        FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for open or override functions");
                        break block5;
                    }
                    FirMemberDeclaration $this$isOperator$iv = declaration;
                    boolean $i$f$isOperator = false;
                    if (!$this$isOperator$iv.getStatus().isOperator()) break block8;
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for operator functions");
                    break block5;
                }
                if (declaration.getSymbol().getCallableId().isLocal()) break block9;
                FirMemberDeclaration $this$visibility$iv = declaration;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block5;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for local functions");
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, String message) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, (DiagnosticContext)$context, null, 16, null);
    }
}

