/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareSerializableStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirKLibSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.TypeApproximatorForMetadataSerializer;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"serializeSingleFirFile", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "serializerExtension", "Lorg/jetbrains/kotlin/fir/serialization/FirKLibSerializerExtension;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nfirKlibSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 firKlibSerialization.kt\norg/jetbrains/kotlin/fir/serialization/FirKlibSerializationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1747#2,3:70\n800#2,11:73\n1045#2:84\n1360#2:85\n1446#2,5:86\n*S KotlinDebug\n*F\n+ 1 firKlibSerialization.kt\norg/jetbrains/kotlin/fir/serialization/FirKlibSerializationKt\n*L\n47#1:70,3\n38#1:73,11\n38#1:84\n38#1:85\n38#1:86,5\n*E\n"})
public final class FirKlibSerializationKt {
    @NotNull
    public static final ProtoBuf.PackageFragment serializeSingleFirFile(@NotNull FirFile file2, @NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull FirKLibSerializerExtension serializerExtension, @NotNull LanguageVersionSettings languageVersionSettings2) {
        boolean bl;
        List<Pair<ProtoBuf.Class, Integer>> classesProto;
        ProtoBuf.Package packageProto;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter((Object)serializerExtension, (String)"serializerExtension");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
            TypeApproximatorForMetadataSerializer approximator = new TypeApproximatorForMetadataSerializer(session);
            FirElementSerializer packageSerializer = FirElementSerializer.Companion.createTopLevel(session, scopeSession, serializerExtension, approximator, languageVersionSettings2);
            packageProto = packageSerializer.packagePartProto(UtilsKt.getPackageFqName(file2), CollectionsKt.listOf((Object)file2)).build();
            classesProto = FirKlibSerializationKt.serializeSingleFirFile$makeClassesProtoWithNested(file2.getDeclarations(), session, scopeSession, serializerExtension, approximator, languageVersionSettings2);
            Iterable $this$any$iv = file2.getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirProperty || it instanceof FirSimpleFunction || it instanceof FirTypeAlias)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean hasTopLevelDeclarations = bl;
        Intrinsics.checkNotNullExpressionValue((Object)packageProto, (String)"packageProto");
        FqName fqName2 = UtilsKt.getPackageFqName(file2);
        boolean bl3 = hasTopLevelDeclarations && classesProto.isEmpty();
        FirElementAwareSerializableStringTable firElementAwareSerializableStringTable = serializerExtension.getStringTable();
        Intrinsics.checkNotNull((Object)firElementAwareSerializableStringTable, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.serialization.SerializableStringTable");
        return KlibMetadataSerializerKt.buildKlibPackageFragment(packageProto, classesProto, fqName2, bl3, firElementAwareSerializableStringTable);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<ProtoBuf.Class, Integer>> serializeSingleFirFile$makeClassesProtoWithNested(List<? extends FirDeclaration> $this$serializeSingleFirFile_u24makeClassesProtoWithNested, FirSession $session, ScopeSession $scopeSession, FirKLibSerializerExtension $serializerExtension, TypeApproximatorForMetadataSerializer approximator, LanguageVersionSettings $languageVersionSettings) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$serializeSingleFirFile_u24makeClassesProtoWithNested;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FirClass it = (FirClass)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)FirDeclarationUtilKt.getClassId(it).asFqNameString());
                it = (FirClass)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)FirDeclarationUtilKt.getClassId(it).asFqNameString())));
            }
        });
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirClass it = (FirClass)element$iv$iv;
            boolean bl = false;
            FirElementSerializer classSerializer = FirElementSerializer.Companion.create($session, $scopeSession, it, $serializerExtension, null, approximator, $languageVersionSettings);
            int index2 = classSerializer.getStringTable().getFqNameIndex(it);
            Iterable list$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)TuplesKt.to((Object)classSerializer.classProto(it).build(), (Object)index2)), (Iterable)FirKlibSerializationKt.serializeSingleFirFile$makeClassesProtoWithNested(it.getDeclarations(), $session, $scopeSession, $serializerExtension, approximator, $languageVersionSettings));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

