/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.InlineConstTransformer;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f*\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInlineConstTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/InlineConstTransformer;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;)V", "getInlineConstTracker", "()Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "constantInitializer", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getConstantInitializer", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "reportInlineConst", "", "field", "value", "shouldDropConstReceiver", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
final class JvmInlineConstTransformer
extends InlineConstTransformer {
    @NotNull
    private final IrFile irFile;
    @Nullable
    private final InlineConstTracker inlineConstTracker;

    public JvmInlineConstTransformer(@NotNull IrFile irFile, @Nullable InlineConstTracker inlineConstTracker) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.irFile = irFile;
        this.inlineConstTracker = inlineConstTracker;
    }

    @NotNull
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @Nullable
    public final InlineConstTracker getInlineConstTracker() {
        return this.inlineConstTracker;
    }

    @Override
    @Nullable
    public IrConst<?> getConstantInitializer(@NotNull IrField $this$constantInitializer) {
        Intrinsics.checkNotNullParameter((Object)$this$constantInitializer, (String)"<this>");
        return JvmIrUtilsKt.constantValue($this$constantInitializer);
    }

    @Override
    public void reportInlineConst(@NotNull IrField field2, @NotNull IrConst<?> value2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (this.inlineConstTracker == null) {
            return;
        }
        if (!Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE)) {
            return;
        }
        String path2 = IrDeclarationsKt.getPath(this.irFile);
        Object object = AdditionalIrUtilsKt.getClassId(IrUtilsKt.getParentAsClass(field2));
        if (object == null || (object = ((ClassId)object).asString()) == null || (object = StringsKt.replace$default((String)object, (String)".", (String)"$", (boolean)false, (int)4, null)) == null || (object = StringsKt.replace$default((String)object, (String)"/", (String)".", (boolean)false, (int)4, null)) == null) {
            return;
        }
        Object owner = object;
        String string2 = field2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name.asString()");
        String name2 = string2;
        String constType = value2.getKind().getAsString();
        this.inlineConstTracker.report(path2, (String)owner, name2, constType);
    }

    @Override
    public boolean shouldDropConstReceiver(@NotNull IrExpression $this$shouldDropConstReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldDropConstReceiver, (String)"<this>");
        return $this$shouldDropConstReceiver instanceof IrConst || $this$shouldDropConstReceiver instanceof IrGetValue || $this$shouldDropConstReceiver instanceof IrGetObjectValue;
    }
}

