/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.unlinked;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.unlinked.UsedClassifierSymbolStatus;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u000fJ\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UsedClassifierSymbols;", "", "()V", "patchedSymbols", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lkotlin/collections/HashSet;", "symbols", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "", "Lkotlin/collections/HashMap;", "forEachClassSymbolToPatch", "", "patchAction", "Lkotlin/Function1;", "get", "Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UsedClassifierSymbolStatus;", "symbol", "register", "status", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nUsedClassifierSymbols.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsedClassifierSymbols.kt\norg/jetbrains/kotlin/backend/common/serialization/unlinked/UsedClassifierSymbols\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,48:1\n215#2,2:49\n*S KotlinDebug\n*F\n+ 1 UsedClassifierSymbols.kt\norg/jetbrains/kotlin/backend/common/serialization/unlinked/UsedClassifierSymbols\n*L\n29#1:49,2\n*E\n"})
public final class UsedClassifierSymbols {
    @NotNull
    private final HashMap<IrClassifierSymbol, Boolean> symbols = new HashMap();
    @NotNull
    private final HashSet<IrClassSymbol> patchedSymbols = new HashSet();

    public final void forEachClassSymbolToPatch(@NotNull Function1<? super IrClassSymbol, Unit> patchAction) {
        Intrinsics.checkNotNullParameter(patchAction, (String)"patchAction");
        Map $this$forEach$iv = this.symbols;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            IrClassifierSymbol symbol2 = (IrClassifierSymbol)entry.getKey();
            boolean isUnlinked = (Boolean)entry.getValue();
            if (!isUnlinked || !symbol2.isBound() || !(symbol2 instanceof IrClassSymbol) || !this.patchedSymbols.add((IrClassSymbol)symbol2)) continue;
            patchAction.invoke((Object)symbol2);
        }
    }

    @Nullable
    public final UsedClassifierSymbolStatus get(@NotNull IrClassifierSymbol symbol2) {
        UsedClassifierSymbolStatus usedClassifierSymbolStatus;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Boolean bl = this.symbols.get(symbol2);
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            usedClassifierSymbolStatus = UsedClassifierSymbolStatus.UNLINKED;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            usedClassifierSymbolStatus = UsedClassifierSymbolStatus.LINKED;
        } else if (bl == null) {
            usedClassifierSymbolStatus = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return usedClassifierSymbolStatus;
    }

    public final boolean register(@NotNull IrClassifierSymbol symbol2, @NotNull UsedClassifierSymbolStatus status2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        ((Map)this.symbols).put(symbol2, status2.isUnlinked());
        return status2.isUnlinked();
    }
}

