/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010(\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b)R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010 \u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001cR\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0018\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "name", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)V", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "backingFieldSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirBackingFieldSymbol;", "getBackingFieldSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirBackingFieldSymbol;", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "getControlFlowGraphReference", "()Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "delegateFieldSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirDelegateFieldSymbol;", "getDelegateFieldSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirDelegateFieldSymbol;", "getterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertyAccessorSymbol;", "getGetterSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertyAccessorSymbol;", "hasDelegate", "", "getHasDelegate", "()Z", "hasInitializer", "getHasInitializer", "isLocal", "isVal", "isVar", "resolvedInitializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getResolvedInitializer", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "setterSymbol", "getSetterSymbol", "canBeDeprecated", "canBeDeprecated$tree", "tree"})
public class FirPropertySymbol
extends FirVariableSymbol<FirProperty> {
    public FirPropertySymbol(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        super(callableId, null);
    }

    public FirPropertySymbol(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this(new CallableId(name2, null, 2, null));
    }

    public final boolean isLocal() {
        return ((FirProperty)this.getFir()).isLocal();
    }

    @Nullable
    public final FirPropertyAccessorSymbol getGetterSymbol() {
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)this.getFir()).getGetter();
        return firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
    }

    @Nullable
    public final FirPropertyAccessorSymbol getSetterSymbol() {
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)this.getFir()).getSetter();
        return firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
    }

    @Nullable
    public final FirBackingFieldSymbol getBackingFieldSymbol() {
        FirBackingField firBackingField = ((FirProperty)this.getFir()).getBackingField();
        return firBackingField != null ? firBackingField.getSymbol() : null;
    }

    @Nullable
    public final FirDelegateFieldSymbol getDelegateFieldSymbol() {
        return ((FirProperty)this.getFir()).getDelegateFieldSymbol();
    }

    public final boolean getHasInitializer() {
        return ((FirProperty)this.getFir()).getInitializer() != null;
    }

    @Nullable
    public final FirExpression getResolvedInitializer() {
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirProperty)this.getFir()).getInitializer();
    }

    public final boolean getHasDelegate() {
        return ((FirProperty)this.getFir()).getDelegate() != null;
    }

    @Nullable
    public final FirControlFlowGraphReference getControlFlowGraphReference() {
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirProperty)this.getFir()).getControlFlowGraphReference();
    }

    public final boolean isVal() {
        return ((FirProperty)this.getFir()).isVal();
    }

    public final boolean isVar() {
        return ((FirProperty)this.getFir()).isVar();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeDeprecated$tree() {
        boolean bl;
        if (!this.isLocal()) {
            if (this.getCallableId().getClassName() != null) return true;
        }
        if (!((Collection)this.getAnnotations()).isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        Object object = this.getGetterSymbol();
        if (object != null && (object = ((FirBasedSymbol)object).getAnnotations()) != null) {
            if (!((Collection)object).isEmpty()) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        FirPropertyAccessorSymbol firPropertyAccessorSymbol = this.getSetterSymbol();
        Object object2 = firPropertyAccessorSymbol;
        if (firPropertyAccessorSymbol == null) return false;
        List<FirAnnotation> list2 = ((FirBasedSymbol)object2).getAnnotations();
        object2 = list2;
        if (list2 == null) return false;
        if (((Collection)object2).isEmpty()) return false;
        return true;
    }
}

