/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.UnresolvedDeprecationProvider;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirDesignatedStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u0011H\u0004J\"\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u00020-00H\u0084\b\u00f8\u0001\u0000J\u001a\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00106\u001a\u0002022\u0006\u00107\u001a\u0002082\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00109\u001a\u0002022\u0006\u0010.\u001a\u00020\u00112\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u00112\b\u00105\u001a\u0004\u0018\u00010\u0002H&J\u001a\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020>2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020-2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010A\u001a\u00020-2\u0006\u0010@\u001a\u00020-2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010E\u001a\u0002022\u0006\u0010F\u001a\u00020G2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020J2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020L2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010N\u001a\u0002022\u0006\u0010O\u001a\u00020P2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J(\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020P2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00020VH\u0002J\u001a\u0010Q\u001a\u0002022\u0006\u0010R\u001a\u00020S2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010W\u001a\u0002022\u0006\u0010)\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010X\u001a\u0002022\u0006\u0010#\u001a\u00020Y2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Z\u001a\u0002022\u0006\u0010[\u001a\u00020\\2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010a\u001a\u0002022\u0006\u0010b\u001a\u00020c2\b\u00105\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010d\u001a\u00020e*\u00020-H$J\f\u0010f\u001a\u00020e*\u00020-H$R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006g"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClasses", "()Ljava/util/List;", "containingClass", "getContainingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getStatusComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "statusResolver", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getStatusResolver", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "calculateDeprecations", "", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "forceResolveStatusOfCorrespondingClass", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "forceResolveStatusesOfClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "forceResolveStatusesOfSupertypes", "storeClass", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "computeResult", "Lkotlin/Function0;", "transformAnonymousObject", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformClass", "transformClassContent", "firClass", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformDeclaration", "declaration", "transformDeclarationContent", "transformDeclarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "containingProperty", "overriddenStatuses", "", "transformRegularClass", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "transformTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "needResolveMembers", "", "needResolveNestedClassifiers", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,480:1\n217#1,2:505\n219#1,2:509\n145#2,4:481\n145#2,2:485\n147#2,2:489\n145#2,4:491\n145#2,4:495\n145#2,2:503\n147#2,2:511\n145#2,4:513\n145#2,4:517\n145#2,4:521\n145#2,2:525\n147#2,2:545\n145#2,4:547\n145#2,4:551\n1855#3,2:487\n1855#3,2:499\n1855#3,2:501\n1855#3,2:507\n1549#3:527\n1620#3,3:528\n1603#3,9:531\n1855#3:540\n1856#3:542\n1612#3:543\n1#4:541\n1#4:544\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer\n*L\n303#1:505,2\n303#1:509,2\n226#1:481,4\n245#1:485,2\n245#1:489,2\n254#1:491,4\n266#1:495,4\n302#1:503,2\n302#1:511,2\n367#1:513,4\n385#1:517,4\n394#1:521,4\n404#1:525,2\n404#1:545,2\n436#1:547,4\n449#1:551,4\n246#1:487,2\n283#1:499,2\n290#1:501,2\n304#1:507,2\n407#1:527\n407#1:528,3\n409#1:531,9\n409#1:540\n409#1:542\n409#1:543\n409#1:541\n*E\n"})
public abstract class AbstractFirStatusResolveTransformer
extends FirAbstractTreeTransformer<FirResolvedDeclarationStatus> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final StatusComputationSession statusComputationSession;
    @NotNull
    private final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> designationMapForLocalClasses;
    @Nullable
    private final FirScope scopeForLocalClass;
    @NotNull
    private final List<FirClass> classes;
    @NotNull
    private final FirStatusResolver statusResolver;

    public AbstractFirStatusResolveTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)statusComputationSession, (String)"statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, (String)"designationMapForLocalClasses");
        super(FirResolvePhase.STATUS);
        this.session = session;
        this.scopeSession = scopeSession;
        this.statusComputationSession = statusComputationSession;
        this.designationMapForLocalClasses = designationMapForLocalClasses;
        this.scopeForLocalClass = scopeForLocalClass;
        this.classes = new ArrayList();
        this.statusResolver = new FirStatusResolver(this.session, this.scopeSession);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final StatusComputationSession getStatusComputationSession() {
        return this.statusComputationSession;
    }

    @NotNull
    protected final List<FirClass> getClasses() {
        return this.classes;
    }

    @NotNull
    protected final FirStatusResolver getStatusResolver() {
        return this.statusResolver;
    }

    @Nullable
    protected final FirClass getContainingClass() {
        return (FirClass)CollectionsKt.lastOrNull(this.classes);
    }

    protected abstract boolean needResolveMembers(@NotNull FirDeclaration var1);

    protected abstract boolean needResolveNestedClassifiers(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.transformDeclarationContent(file2, data2);
        return file2;
    }

    @Override
    @NotNull
    public FirDeclarationStatus transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)declarationStatus, (String)"declarationStatus");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = data2;
        return firResolvedDeclarationStatus != null ? (FirDeclarationStatus)firResolvedDeclarationStatus : declarationStatus;
    }

    @NotNull
    protected final FirDeclaration storeClass(@NotNull FirClass klass, @NotNull Function0<? extends FirDeclaration> computeResult) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(computeResult, (String)"computeResult");
        boolean $i$f$storeClass = false;
        ((Collection)this.classes).add(klass);
        FirDeclaration result2 = (FirDeclaration)computeResult.invoke();
        this.classes.remove(CollectionsKt.getLastIndex((List)this.classes));
        return result2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirDeclaration firDeclaration;
            boolean bl = false;
            if (declaration instanceof FirCallableDeclaration) {
                if (declaration instanceof FirFunction) {
                    for (FirValueParameter valueParameter2 : ((FirFunction)declaration).getValueParameters()) {
                        this.transformValueParameter(valueParameter2, data2);
                    }
                }
                firDeclaration = declaration;
            } else {
                firDeclaration = (FirDeclaration)this.transformElement((FirElement)declaration, data2);
            }
            return firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(declaration, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = typeAlias.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameter it = (FirTypeParameter)element$iv;
                boolean bl2 = false;
                this.transformDeclaration((FirDeclaration)it, data2);
            }
            typeAlias.transformStatus(this, this.statusResolver.resolveStatus(typeAlias, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            return (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(typeAlias, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(regularClass, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(regularClass, throwable$iv);
            throw null;
        }
        return firStatement;
    }

    @NotNull
    public abstract FirStatement transformClassContent(@NotNull FirClass var1, @Nullable FirResolvedDeclarationStatus var2);

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(anonymousObject, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(anonymousObject, throwable$iv);
            throw null;
        }
        return firStatement;
    }

    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data2) {
        FirDeclaration it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<FirDeclaration> list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            list2 = ((FirRegularClass)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            list2 = ((FirAnonymousObject)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirFile) {
            list2 = ((FirFile)declaration).getDeclarations();
        } else {
            throw new IllegalStateException(("Not supported declaration " + Reflection.getOrCreateKotlinClass(declaration.getClass()).getSimpleName()).toString());
        }
        List<FirDeclaration> declarations2 = list2;
        if (this.needResolveMembers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (it instanceof FirClassLikeDeclaration) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        if (this.needResolveNestedClassifiers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirClassLikeDeclaration)) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        return declaration;
    }

    @Override
    @NotNull
    public FirStatement transformClass(@NotNull FirClass klass, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            AbstractFirStatusResolveTransformer this_$iv = this;
            boolean $i$f$storeClass = false;
            ((Collection)this_$iv.classes).add(klass);
            boolean bl2 = false;
            Iterable $this$forEach$iv = klass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
            FirDeclaration result$iv = this.transformDeclarationContent(klass, data2);
            this_$iv.classes.remove(CollectionsKt.getLastIndex((List)this_$iv.classes));
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(klass, throwable$iv);
            throw null;
        }
    }

    protected final void forceResolveStatusesOfSupertypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            this.forceResolveStatusOfCorrespondingClass(superTypeRef);
        }
    }

    private final void forceResolveStatusOfCorrespondingClass(FirTypeRef typeRef) {
        FirClassifierSymbol<?> superClassSymbol;
        FirClassifierSymbol<?> firClassifierSymbol = superClassSymbol = TypeUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(typeRef), this.session);
        if (firClassifierSymbol != null) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)firClassifierSymbol, FirResolvePhase.SUPER_TYPES);
        }
        FirClassifierSymbol<?> firClassifierSymbol2 = superClassSymbol;
        if (firClassifierSymbol2 instanceof FirRegularClassSymbol) {
            this.forceResolveStatusesOfClass((FirRegularClass)((FirRegularClassSymbol)superClassSymbol).getFir());
        } else if (firClassifierSymbol2 instanceof FirTypeAliasSymbol) {
            this.forceResolveStatusOfCorrespondingClass(((FirTypeAlias)((FirTypeAliasSymbol)superClassSymbol).getFir()).getExpandedTypeRef());
        } else if ((firClassifierSymbol2 instanceof FirTypeParameterSymbol ? true : firClassifierSymbol2 instanceof FirAnonymousObjectSymbol) ? true : firClassifierSymbol2 == null) {
            // empty if block
        }
    }

    private final void forceResolveStatusesOfClass(FirRegularClass regularClass) {
        if (regularClass.getOrigin() instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)regularClass.getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE)) {
            StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
            if (!statusComputationStatus.getRequiresComputation()) {
                return;
            }
            this.statusComputationSession.startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        if (!Intrinsics.areEqual((Object)regularClass.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
        if (!statusComputationStatus.getRequiresComputation()) {
            return;
        }
        if (regularClass.getStatus() instanceof FirResolvedDeclarationStatus && statusComputationStatus == StatusComputationSession.StatusComputationStatus.Computed) {
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        DesignationState designationState = DesignationState.Companion.create(regularClass.getSymbol(), this.designationMapForLocalClasses, false);
        if (designationState == null) {
            return;
        }
        DesignationState designation2 = designationState;
        FirDesignatedStatusResolveTransformer transformer2 = new FirDesignatedStatusResolveTransformer(this.session, this.scopeSession, designation2, this.statusComputationSession, this.designationMapForLocalClasses, this.scopeForLocalClass);
        FirTransformerUtilKt.transformSingle((FirElement)designation2.getFirstDeclaration(), transformer2, null);
        this.statusComputationSession.endComputing(regularClass);
    }

    private final void transformPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty containingProperty, List<? extends FirResolvedDeclarationStatus> overriddenStatuses) {
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            propertyAccessor.transformStatus(this, this.statusResolver.resolveStatus(propertyAccessor, this.getContainingClass(), containingProperty, false, overriddenStatuses));
            propertyAccessor.transformValueParameters(this, null);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(propertyAccessor, throwable$iv);
            throw null;
        }
    }

    static /* synthetic */ void transformPropertyAccessor$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirPropertyAccessor firPropertyAccessor, FirProperty firProperty, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformPropertyAccessor");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        abstractFirStatusResolveTransformer.transformPropertyAccessor(firPropertyAccessor, firProperty, list2);
    }

    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            constructor2.transformStatus(this, this.statusResolver.resolveStatus(constructor2, this.getContainingClass(), false));
            this.calculateDeprecations(constructor2);
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)constructor2, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(constructor2, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirResolvedDeclarationStatus resolvedStatus = this.statusResolver.resolveStatus(simpleFunction, this.getContainingClass(), false);
            simpleFunction.transformStatus(this, resolvedStatus);
            this.calculateDeprecations(simpleFunction);
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(simpleFunction, throwable$iv);
            throw null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirCallableDeclaration it;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            List<FirProperty> overridden = this.statusResolver.getOverriddenProperties(property, this.getContainingClass());
            Iterable $this$map$iv = overridden;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirProperty firProperty = (FirProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirDeclarationStatus firDeclarationStatus = it2.getStatus();
                Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
            }
            List overriddenProperties = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = overridden;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirResolvedDeclarationStatus firResolvedDeclarationStatus;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                FirProperty it3 = (FirProperty)element$iv$iv;
                boolean bl4 = false;
                if (it3.getSetter() == null) {
                    firResolvedDeclarationStatus = null;
                } else {
                    FirPropertyAccessor setter2;
                    FirDeclarationStatus firDeclarationStatus = setter2.getStatus();
                    Intrinsics.checkNotNull((Object)firDeclarationStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                    firResolvedDeclarationStatus = (FirResolvedDeclarationStatus)firDeclarationStatus;
                }
                if (firResolvedDeclarationStatus == null) continue;
                FirResolvedDeclarationStatus it$iv$iv = firResolvedDeclarationStatus;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List overriddenSetters = (List)destination$iv$iv2;
            property.transformStatus(this, this.statusResolver.resolveStatus(property, this.getContainingClass(), false, overriddenProperties));
            FirPropertyAccessor firPropertyAccessor = property.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl6 = false;
                AbstractFirStatusResolveTransformer.transformPropertyAccessor$default(this, (FirPropertyAccessor)it, property, null, 4, null);
            }
            FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl7 = false;
                this.transformPropertyAccessor((FirPropertyAccessor)it, property, overriddenSetters);
            }
            FirBackingField firBackingField = property.getBackingField();
            if (firBackingField != null) {
                it = firBackingField;
                boolean bl8 = false;
                ((FirBackingField)it).transformStatus(this, this.statusResolver.resolveStatus(it, this.getContainingClass(), property, false));
            }
            this.calculateDeprecations(property);
            return property;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(property, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            field2.transformStatus(this, this.statusResolver.resolveStatus(field2, this.getContainingClass(), false));
            this.calculateDeprecations(field2);
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)field2, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirField");
            return (FirField)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(field2, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable FirResolvedDeclarationStatus data2) {
        FirPropertyAccessor firPropertyAccessor;
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        FirPropertyAccessor it = firPropertyAccessor = propertyAccessor;
        boolean bl = false;
        this.transformProperty((FirProperty)it.getPropertySymbol().getFir(), data2);
        return firPropertyAccessor;
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            enumEntry.transformStatus(this, this.statusResolver.resolveStatus(enumEntry, this.getContainingClass(), false));
            this.calculateDeprecations(enumEntry);
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)enumEntry, data2);
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
            return (FirEnumEntry)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(enumEntry, throwable$iv);
            throw null;
        }
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        this.calculateDeprecations(valueParameter2);
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)valueParameter2, data2);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration);
    }

    @Override
    @NotNull
    public FirTypeParameterRef transformTypeParameter(@NotNull FirTypeParameter typeParameter2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeParameter2, data2);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameter");
        return (FirTypeParameter)firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block;
    }

    private final void calculateDeprecations(FirCallableDeclaration simpleFunction) {
        if (simpleFunction.getDeprecationsProvider() instanceof UnresolvedDeprecationProvider) {
            simpleFunction.replaceDeprecationsProvider(DeprecationUtilsKt.getDeprecationsProvider(simpleFunction, this.session));
        }
    }
}

