/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Transformer", "backend.jvm.lower"})
public final class JvmLateinitLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmLateinitLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Transformer transformer2 = new Transformer(this.context);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, transformer2);
        for (IrVariable variable2 : transformer2.getLateinitVariables()) {
            variable2.setLateinit(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u001f*\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u0011*\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lateinitVariables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLateinitVariables", "()Ljava/util/List;", "transformGetter", "", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitVariable", "isLateinitBackingField", "", "isRealLateinit", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n+ 2 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n*L\n1#1,188:1\n218#2,12:189\n*S KotlinDebug\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n*L\n139#1:189,12\n*E\n"})
    private static final class Transformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JvmBackendContext backendContext;
        @NotNull
        private final List<IrVariable> lateinitVariables;

        public Transformer(@NotNull JvmBackendContext backendContext) {
            Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
            this.backendContext = backendContext;
            this.lateinitVariables = new ArrayList();
        }

        @NotNull
        public final List<IrVariable> getLateinitVariables() {
            return this.lateinitVariables;
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (this.isLateinitBackingField(declaration)) {
                boolean bl;
                boolean bl2 = bl = declaration.getInitializer() == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default(declaration, false, false, 3, null);
                    throw new AssertionError((Object)string2);
                }
                declaration.setType(IrTypesKt.makeNullable(declaration.getType()));
            }
            this.transformChildrenVoid(declaration);
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
            if (declaration.isLateinit()) {
                declaration.setType(IrTypesKt.makeNullable(declaration.getType()));
                declaration.setVar(true);
                declaration.setInitializer(IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.backendContext.getIrBuiltIns().getNothingNType()));
                ((Collection)this.lateinitVariables).add(declaration);
            }
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            IrProperty property;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
            IrProperty irProperty2 = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property != null && this.isRealLateinit(property) && Intrinsics.areEqual((Object)declaration, (Object)property.getGetter())) {
                IrField irField = property.getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                this.transformGetter(irField, declaration);
                return declaration;
            }
            this.transformChildrenVoid(declaration);
            return declaration;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration irValue = expression2.getSymbol().getOwner();
            if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
                return expression2;
            }
            BackendContext backendContext = this.backendContext;
            IrDeclarationParent irDeclarationParent = irValue.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            DeclarationIrBuilder $this$visitGetValue_u24lambda_u241 = LowerUtilsKt.createIrBuilder(backendContext, ((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$visitGetValue_u24lambda_u241;
            IrType irType = expression2.getType();
            IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$visitGetValue_u24lambda_u241, ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue));
            IrBuilderWithScope irBuilderWithScope2 = $this$visitGetValue_u24lambda_u241;
            String string2 = irValue.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irValue.name.asString()");
            return ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression, this.backendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string2), ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue), null, 16, null);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrField irField = (IrField)expression2.getSymbol().getOwner();
            if (this.isLateinitBackingField(irField)) {
                expression2.setType(IrTypesKt.makeNullable(expression2.getType()));
            }
            return expression2;
        }

        private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
            IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
            IrProperty property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            return property != null && this.isRealLateinit(property);
        }

        private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
            return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter(expression2.getSymbol())) {
                return expression2;
            }
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression $this$replaceTailExpression$iv = irExpression2;
            boolean $i$f$replaceTailExpression = false;
            IrExpression current$iv = $this$replaceTailExpression$iv;
            IrContainerExpression block$iv = null;
            while (current$iv instanceof IrContainerExpression) {
                block$iv = (IrContainerExpression)current$iv;
                Object object = CollectionsKt.last(((IrContainerExpression)current$iv).getStatements());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                current$iv = (IrExpression)object;
            }
            IrExpression it = current$iv;
            boolean bl = false;
            IrPropertyReference irPropertyReference = it instanceof IrPropertyReference ? (IrPropertyReference)it : null;
            if (irPropertyReference == null) {
                throw new AssertionError((Object)("Property reference expected: " + RenderIrElementKt.render(it)));
            }
            IrPropertyReference irPropertyRef = irPropertyReference;
            Object object = irPropertyRef.getGetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null || (object = IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)object, false, null, 3, null)) == null || (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) == null || (object = (IrProperty)object.getOwner()) == null) {
                throw new AssertionError((Object)("isInitialized cannot be invoked on " + RenderIrElementKt.render(it)));
            }
            Object property = object;
            if (!((IrProperty)property).isLateinit()) {
                boolean bl2 = false;
                String string2 = "isInitialized invoked on non-lateinit property " + RenderIrElementKt.render((IrElement)property);
                throw new IllegalArgumentException(string2.toString());
            }
            IrField irField = ((IrProperty)property).getBackingField();
            if (irField == null) {
                throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
            }
            IrField backingField2 = irField;
            DeclarationIrBuilder $this$visitCall_u24lambda_u244_u24lambda_u243 = LowerUtilsKt.createIrBuilder(this.backendContext, ((IrPropertyReference)it).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            boolean bl3 = false;
            current$iv = ExpressionHelpersKt.irNotEquals($this$visitCall_u24lambda_u244_u24lambda_u243, ExpressionHelpersKt.irGetField$default($this$visitCall_u24lambda_u244_u24lambda_u243, ((IrPropertyReference)it).getDispatchReceiver(), backingField2, null, 4, null), ExpressionHelpersKt.irNull($this$visitCall_u24lambda_u244_u24lambda_u243));
            if (block$iv == null) {
                irExpression = current$iv;
            } else {
                void var2_2;
                block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
                irExpression = var2_2;
            }
            return irExpression;
        }

        private final void transformGetter(IrField backingField2, IrFunction getter2) {
            boolean bl;
            IrType type2 = backingField2.getType();
            boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = false;
                String $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default(backingField2, false, false, 3, null);
                throw new AssertionError((Object)$i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22);
            }
            int startOffset = getter2.getStartOffset();
            int endOffset = getter2.getEndOffset();
            getter2.setBody(this.backendContext.getIrFactory().createBlockBody(startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(this, getter2, startOffset, endOffset, backingField2){
                final /* synthetic */ Transformer this$0;
                final /* synthetic */ IrFunction $getter;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrField $backingField;
                {
                    this.this$0 = $receiver;
                    this.$getter = $getter;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$backingField = $backingField;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                    IrGetValueImpl irGetValueImpl;
                    DeclarationIrBuilder irBuilder;
                    Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                    DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(Transformer.access$getBackendContext$p(this.this$0), (IrSymbol)this.$getter.getSymbol(), this.$startOffset, this.$endOffset);
                    IrFunction irFunction2 = this.$getter;
                    IrField irField = this.$backingField;
                    Transformer transformer2 = this.this$0;
                    DeclarationIrBuilder $this$invoke_u24lambda_u241 = declarationIrBuilder;
                    boolean bl = false;
                    Scope scope2 = $this$invoke_u24lambda_u241.getScope();
                    IrBuilderWithScope irBuilderWithScope = $this$invoke_u24lambda_u241;
                    IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
                    if (irValueParameter != null) {
                        void it;
                        IrValueParameter irValueParameter2 = irValueParameter;
                        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                        Scope scope3 = scope2;
                        boolean bl2 = false;
                        IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$invoke_u24lambda_u241, (IrValueDeclaration)it);
                        scope2 = scope3;
                        irBuilderWithScope = irBuilderWithScope2;
                        irGetValueImpl = irGetValueImpl2;
                    } else {
                        irGetValueImpl = null;
                    }
                    IrVariable resultVar = IrBuilderKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField(irBuilderWithScope, irGetValueImpl, irField, IrTypesKt.makeNullable(irField.getType())), null, false, null, null, 30, null);
                    resultVar.setParent(irFunction2);
                    $this$createBlockBody.getStatements().add(resultVar);
                    IrBuilderWithScope irBuilderWithScope3 = $this$invoke_u24lambda_u241;
                    IrType irType = $this$invoke_u24lambda_u241.getContext().getIrBuiltIns().getNothingType();
                    IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$invoke_u24lambda_u241, ExpressionHelpersKt.irGet($this$invoke_u24lambda_u241, resultVar), ExpressionHelpersKt.irNull($this$invoke_u24lambda_u241));
                    IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$invoke_u24lambda_u241, ExpressionHelpersKt.irGet($this$invoke_u24lambda_u241, resultVar));
                    IrBuilderWithScope irBuilderWithScope4 = $this$invoke_u24lambda_u241;
                    String string2 = irField.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"backingField.name.asString()");
                    IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, Transformer.access$throwUninitializedPropertyAccessException(transformer2, irBuilderWithScope4, string2), null, 16, null);
                    $this$createBlockBody.getStatements().add(throwIfNull);
                }
            })));
        }

        private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name2) {
            return this.backendContext.throwUninitializedPropertyAccessException($this$throwUninitializedPropertyAccessException, name2);
        }

        public static final /* synthetic */ IrExpression access$throwUninitializedPropertyAccessException(Transformer $this, IrBuilderWithScope $receiver, String name2) {
            return $this.throwUninitializedPropertyAccessException($receiver, name2);
        }
    }
}

