/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.ActualClassifiersCollector;
import org.jetbrains.kotlin.backend.common.actualizer.CallablesLinkCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ClassifiersLinkCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollectorKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\t0\bJ:\u0010\f\u001a\u00020\r*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\tH\u0002J6\u0010\u0013\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\t0\b*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector;", "", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/List;)V", "collect", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/name/FqName;", "appendExpectActualCallablesMap", "", "", "allActualDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "typeAliasMap", "appendExpectActualClassifiersMap", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1855#2,2:193\n1855#2,2:195\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector\n*L\n42#1:193,2\n55#1:195,2\n*E\n"})
public final class ExpectActualCollector {
    @NotNull
    private final IrModuleFragment mainFragment;
    @NotNull
    private final List<IrModuleFragment> dependentFragments;

    public ExpectActualCollector(@NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments) {
        Intrinsics.checkNotNullParameter((Object)mainFragment, (String)"mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, (String)"dependentFragments");
        this.mainFragment = mainFragment;
        this.dependentFragments = dependentFragments;
    }

    @NotNull
    public final Pair<Map<IrSymbol, IrSymbol>, Map<FqName, FqName>> collect() {
        Map result2 = new LinkedHashMap();
        Pair<Set<IrDeclaration>, Map<FqName, FqName>> pair = this.appendExpectActualClassifiersMap(result2);
        Set allActualDeclarations = (Set)pair.component1();
        Map typeAliasMap = (Map)pair.component2();
        this.appendExpectActualCallablesMap(result2, allActualDeclarations, typeAliasMap);
        return TuplesKt.to((Object)result2, (Object)typeAliasMap);
    }

    private final Pair<Set<IrDeclaration>, Map<FqName, FqName>> appendExpectActualClassifiersMap(Map<IrSymbol, IrSymbol> $this$appendExpectActualClassifiersMap) {
        Map actualClassifiers = new LinkedHashMap();
        Set allActualDeclarations = new LinkedHashSet();
        Map typeAliasMap = new LinkedHashMap();
        List fragmentsWithActuals = CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)this.dependentFragments, (int)1), (Object)this.mainFragment);
        for (IrModuleFragment fragment : fragmentsWithActuals) {
            new ActualClassifiersCollector(actualClassifiers, allActualDeclarations, typeAliasMap).visitModuleFragment(fragment, (Object)false);
        }
        ClassifiersLinkCollector linkCollector = new ClassifiersLinkCollector($this$appendExpectActualClassifiersMap, actualClassifiers);
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            linkCollector.visitModuleFragment(it);
        }
        return TuplesKt.to((Object)allActualDeclarations, (Object)typeAliasMap);
    }

    private final void appendExpectActualCallablesMap(Map<IrSymbol, IrSymbol> $this$appendExpectActualCallablesMap, Set<? extends IrDeclaration> allActualDeclarations, Map<FqName, FqName> typeAliasMap) {
        Map actualMembers2 = new LinkedHashMap();
        ExpectActualCollectorKt.access$collectActualCallables($this$appendExpectActualCallablesMap, actualMembers2, allActualDeclarations);
        CallablesLinkCollector collector2 = new CallablesLinkCollector($this$appendExpectActualCallablesMap, actualMembers2, typeAliasMap);
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            collector2.visitModuleFragment(it);
        }
    }
}

