/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "isNotExplicit", "", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)Z", "isNullable", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "(Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;)Z", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAsFieldNotSubtype", "property", "checkAsPropertyNotSubtype", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyFieldTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyFieldTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n45#2:99\n45#2:100\n45#2:101\n45#2:102\n1747#3,3:103\n*S KotlinDebug\n*F\n+ 1 FirPropertyFieldTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker\n*L\n37#1:99\n41#1:100\n43#1:101\n47#1:102\n71#1:103,3\n*E\n"})
public final class FirPropertyFieldTypeChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyFieldTypeChecker INSTANCE = new FirPropertyFieldTypeChecker();

    private FirPropertyFieldTypeChecker() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        v0 = declaration.getBackingField();
        if (v0 == null) {
            return;
        }
        backingField = v0;
        if (!DeclarationAttributesKt.getHasExplicitBackingField(declaration)) {
            return;
        }
        typeCheckerContext = TypeComponentsKt.getTypeContext(context.getSession()).newTypeCheckerState(false, false);
        if (declaration.getInitializer() != null) {
            v1 = declaration.getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(v1 != null ? v1.getSource() : null), FirErrors.INSTANCE.getPROPERTY_INITIALIZER_WITH_EXPLICIT_FIELD_DECLARATION(), (DiagnosticContext)context, null, 8, null);
        }
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if ($this$isLateInit$iv.getStatus().isLateInit() && declaration.isVal()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getLATEINIT_FIELD_IN_VAL_PROPERTY(), (DiagnosticContext)context, null, 8, null);
        }
        if (backingField.getInitializer() != null) ** GOTO lbl-1000
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getPROPERTY_FIELD_DECLARATION_MISSING_INITIALIZER(), (DiagnosticContext)context, null, 8, null);
        } else if (backingField.getInitializer() != null) {
            $this$isLateInit$iv = backingField;
            $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getLATEINIT_PROPERTY_FIELD_DECLARATION_WITH_INITIALIZER(), (DiagnosticContext)context, null, 8, null);
            }
        }
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if ($this$isLateInit$iv.getStatus().isLateInit() && this.isNullable(backingField)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getLATEINIT_NULLABLE_BACKING_FIELD(), (DiagnosticContext)context, null, 8, null);
        }
        if (declaration.getDelegate() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getBACKING_FIELD_FOR_DELEGATED_PROPERTY(), (DiagnosticContext)context, null, 8, null);
        }
        if (Intrinsics.areEqual((Object)FirTypeUtilsKt.getConeType(backingField.getReturnTypeRef()), (Object)FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_BACKING_FIELD(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        if (!TypeUtilsKt.isSubtypeOf(backingField, declaration, typeCheckerContext)) {
            this.checkAsFieldNotSubtype(declaration, context, reporter);
        }
        if (!TypeUtilsKt.isSubtypeOf(declaration, backingField, typeCheckerContext)) {
            this.checkAsPropertyNotSubtype(declaration, context, reporter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNullable(FirBackingField $this$isNullable) {
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType($this$isNullable.getReturnTypeRef());
        if (type2 instanceof ConeTypeParameterType) {
            FirResolvedTypeRef it;
            if (ConeTypeUtilsKt.isNullable(type2)) return true;
            Iterable $this$any$iv = ((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FirResolvedTypeRef)element$iv;
                boolean bl = false;
            } while (!ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(it)));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable(type2);
        return bl;
    }

    private final boolean isNotExplicit(FirPropertyAccessor $this$isNotExplicit) {
        return $this$isNotExplicit == null || $this$isNotExplicit instanceof FirDefaultPropertyAccessor;
    }

    private final void checkAsPropertyNotSubtype(FirProperty property, CheckerContext context, DiagnosticReporter reporter) {
        if (property.isVar() && this.isNotExplicit(property.getSetter())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)property.getSource(), FirErrors.INSTANCE.getPROPERTY_MUST_HAVE_SETTER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkAsFieldNotSubtype(FirProperty property, CheckerContext context, DiagnosticReporter reporter) {
        if (this.isNotExplicit(property.getGetter())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)property.getSource(), FirErrors.INSTANCE.getPROPERTY_MUST_HAVE_GETTER(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

