/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecatedInfo;
import org.jetbrains.kotlin.fir.declarations.DeprecatedSinceKotlinInfo;
import org.jetbrains.kotlin.fir.declarations.DeprecationAnnotationInfo;
import org.jetbrains.kotlin.fir.declarations.DeprecationAnnotationInfoPerUseSiteStorage;
import org.jetbrains.kotlin.fir.declarations.DeprecationAnnotationInfoPerUseSiteStorageBuilder;
import org.jetbrains.kotlin.fir.declarations.DeprecationsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.DeprecationsProvider;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.SinceKotlinInfo;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0086\b\u00f8\u0001\u0000\u001a\"\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u001a\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u001a\"\u0010\u0014\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u0006*\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010!\u001a1\u0010\"\u001a\u0004\u0018\u00010\u001c*\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%\u00a2\u0006\u0002\u0010&\u001a\u000e\u0010'\u001a\u0004\u0018\u00010(*\u00020\u0016H\u0002\u001a\u0012\u0010)\u001a\u00020\u0013*\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e\u001a \u0010*\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010+\u001a\u0004\u0018\u00010\u001f*\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"deprecationAnnotationSimpleNames", "", "", "getDeprecationAnnotationSimpleNames", "()Ljava/util/Set;", "buildDeprecationAnnotationInfoPerUseSiteStorage", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationAnnotationInfoPerUseSiteStorage;", "builder", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationAnnotationInfoPerUseSiteStorageBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getDeprecationsAnnotationInfoByUseSiteFromAccessors", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getter", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "setter", "getDeprecationsProviderFromAccessors", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsProvider;", "extractDeprecationAnnotationInfoPerUseSite", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "fromJava", "", "extractDeprecationInfoPerUseSite", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getDeprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "getDeprecationForCallSite", "sites", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/config/ApiVersion;[Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;)Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "getDeprecationLevel", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationsProvider", "getDeprecationsProviderFromAnnotations", "getVersionFromArgument", "name", "Lorg/jetbrains/kotlin/name/Name;", "providers"})
@SourceDebugExtension(value={"SMAP\ndeprecationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeprecationUtilsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirAnnotationUtils.kt\norg/jetbrains/kotlin/fir/declarations/FirAnnotationUtilsKt\n+ 7 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,238:1\n71#1:239\n71#1:240\n71#1:280\n215#2,2:241\n215#2,2:243\n1#3:245\n48#4:246\n48#4:249\n38#4:281\n35#4:282\n38#4:285\n35#4:286\n288#5,2:247\n1747#5,2:283\n1749#5:287\n186#6,2:250\n188#6,4:256\n186#6,2:260\n188#6,4:266\n186#6,2:270\n188#6,4:276\n24#7,4:252\n24#7,4:262\n24#7,4:272\n*S KotlinDebug\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeprecationUtilsKt\n*L\n101#1:239\n122#1:240\n201#1:280\n124#1:241,2\n132#1:243,2\n171#1:246\n174#1:249\n203#1:281\n203#1:282\n208#1:285\n208#1:286\n172#1:247,2\n207#1:283,2\n207#1:287\n196#1:250,2\n196#1:256,4\n197#1:260,2\n197#1:266,4\n198#1:270,2\n198#1:276,4\n196#1:252,4\n197#1:262,4\n198#1:272,4\n*E\n"})
public final class DeprecationUtilsKt {
    @NotNull
    private static final Set<String> deprecationAnnotationSimpleNames;

    @NotNull
    public static final DeprecationAnnotationInfoPerUseSiteStorage buildDeprecationAnnotationInfoPerUseSiteStorage(@NotNull Function1<? super DeprecationAnnotationInfoPerUseSiteStorageBuilder, Unit> builder2) {
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        boolean $i$f$buildDeprecationAnnotationInfoPerUseSiteStorage = false;
        DeprecationAnnotationInfoPerUseSiteStorageBuilder deprecationAnnotationInfoPerUseSiteStorageBuilder = new DeprecationAnnotationInfoPerUseSiteStorageBuilder();
        builder2.invoke((Object)deprecationAnnotationInfoPerUseSiteStorageBuilder);
        return deprecationAnnotationInfoPerUseSiteStorageBuilder.build();
    }

    @Nullable
    public static final DeprecationInfo getDeprecation(@NotNull FirBasedSymbol<?> $this$getDeprecation, @NotNull FirSession session, @Nullable FirElement callSite) {
        Intrinsics.checkNotNullParameter($this$getDeprecation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return DeprecationUtilsKt.getDeprecation($this$getDeprecation, FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).getApiVersion(), callSite);
    }

    @Nullable
    public static final DeprecationInfo getDeprecation(@NotNull FirBasedSymbol<?> $this$getDeprecation, @NotNull ApiVersion apiVersion, @Nullable FirElement callSite) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter($this$getDeprecation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        if ($this$getDeprecation instanceof FirPropertySymbol) {
            FirElement firElement = callSite;
            if (firElement instanceof FirVariableAssignment) {
                AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.PROPERTY};
                deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, apiVersion, annotationUseSiteTargetArray);
            } else if (firElement instanceof FirPropertyAccessExpression) {
                AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.PROPERTY};
                deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, apiVersion, annotationUseSiteTargetArray);
            } else {
                AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY};
                deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, apiVersion, annotationUseSiteTargetArray);
            }
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, apiVersion, new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    @NotNull
    public static final DeprecationsProvider getDeprecationsProvider(@NotNull FirAnnotationContainer $this$getDeprecationsProvider, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeprecationsProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return DeprecationUtilsKt.extractDeprecationInfoPerUseSite($this$getDeprecationsProvider, session).toDeprecationsProvider(FirCachesFactoryKt.getFirCachesFactory(session));
    }

    @NotNull
    public static final DeprecationAnnotationInfoPerUseSiteStorage extractDeprecationInfoPerUseSite(@NotNull FirAnnotationContainer $this$extractDeprecationInfoPerUseSite, @NotNull FirSession session) {
        DeprecationAnnotationInfoPerUseSiteStorageBuilder deprecationAnnotationInfoPerUseSiteStorageBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$extractDeprecationInfoPerUseSite, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        boolean fromJava = $this$extractDeprecationInfoPerUseSite instanceof FirDeclaration && DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)$this$extractDeprecationInfoPerUseSite);
        boolean $i$f$buildDeprecationAnnotationInfoPerUseSiteStorage = false;
        DeprecationAnnotationInfoPerUseSiteStorageBuilder $this$extractDeprecationInfoPerUseSite_u24lambda_u240 = deprecationAnnotationInfoPerUseSiteStorageBuilder = new DeprecationAnnotationInfoPerUseSiteStorageBuilder();
        boolean bl = false;
        $this$extractDeprecationInfoPerUseSite_u24lambda_u240.add(DeprecationUtilsKt.extractDeprecationAnnotationInfoPerUseSite($this$extractDeprecationInfoPerUseSite.getAnnotations(), session, fromJava));
        if ($this$extractDeprecationInfoPerUseSite instanceof FirProperty) {
            $this$extractDeprecationInfoPerUseSite_u24lambda_u240.add(DeprecationUtilsKt.getDeprecationsAnnotationInfoByUseSiteFromAccessors(session, ((FirProperty)$this$extractDeprecationInfoPerUseSite).getGetter(), ((FirProperty)$this$extractDeprecationInfoPerUseSite).getSetter()));
        }
        return deprecationAnnotationInfoPerUseSiteStorageBuilder.build();
    }

    @NotNull
    public static final DeprecationsProvider getDeprecationsProviderFromAccessors(@NotNull FirSession session, @Nullable FirFunction getter2, @Nullable FirFunction setter2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return DeprecationUtilsKt.getDeprecationsAnnotationInfoByUseSiteFromAccessors(session, getter2, setter2).toDeprecationsProvider(FirCachesFactoryKt.getFirCachesFactory(session));
    }

    @NotNull
    public static final DeprecationAnnotationInfoPerUseSiteStorage getDeprecationsAnnotationInfoByUseSiteFromAccessors(@NotNull FirSession session, @Nullable FirFunction getter2, @Nullable FirFunction setter2) {
        DeprecationAnnotationInfoPerUseSiteStorageBuilder deprecationAnnotationInfoPerUseSiteStorageBuilder;
        block5: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            boolean $i$f$buildDeprecationAnnotationInfoPerUseSiteStorage = false;
            DeprecationAnnotationInfoPerUseSiteStorageBuilder $this$getDeprecationsAnnotationInfoByUseSiteFromAccessors_u24lambda_u243 = deprecationAnnotationInfoPerUseSiteStorageBuilder = new DeprecationAnnotationInfoPerUseSiteStorageBuilder();
            boolean bl = false;
            FirFunction firFunction = setter2;
            DeprecationAnnotationInfoPerUseSiteStorage setterDeprecations = firFunction != null ? DeprecationUtilsKt.extractDeprecationInfoPerUseSite(firFunction, session) : null;
            Object object = setterDeprecations;
            if (object != null && (object = ((DeprecationAnnotationInfoPerUseSiteStorage)object).getStorage()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    AnnotationUseSiteTarget useSite = (AnnotationUseSiteTarget)((Object)entry.getKey());
                    List infos = (List)entry.getValue();
                    if (useSite == null) {
                        $this$getDeprecationsAnnotationInfoByUseSiteFromAccessors_u24lambda_u243.add(AnnotationUseSiteTarget.PROPERTY_SETTER, infos);
                        continue;
                    }
                    $this$getDeprecationsAnnotationInfoByUseSiteFromAccessors_u24lambda_u243.add(useSite, infos);
                }
            }
            FirFunction firFunction2 = getter2;
            DeprecationAnnotationInfoPerUseSiteStorage getterDeprecations = firFunction2 != null ? DeprecationUtilsKt.extractDeprecationInfoPerUseSite(firFunction2, session) : null;
            Object object2 = getterDeprecations;
            if (object2 == null || (object2 = ((DeprecationAnnotationInfoPerUseSiteStorage)object2).getStorage()) == null) break block5;
            Object $this$forEach$iv = object2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator3.next();
                boolean bl3 = false;
                AnnotationUseSiteTarget useSite = (AnnotationUseSiteTarget)((Object)entry.getKey());
                List infos = (List)entry.getValue();
                if (useSite == null) {
                    $this$getDeprecationsAnnotationInfoByUseSiteFromAccessors_u24lambda_u243.add(AnnotationUseSiteTarget.PROPERTY_GETTER, infos);
                    continue;
                }
                $this$getDeprecationsAnnotationInfoByUseSiteFromAccessors_u24lambda_u243.add(useSite, infos);
            }
        }
        return deprecationAnnotationInfoPerUseSiteStorageBuilder.build();
    }

    @NotNull
    public static final DeprecationsProvider getDeprecationsProviderFromAnnotations(@NotNull List<? extends FirAnnotation> $this$getDeprecationsProviderFromAnnotations, @NotNull FirSession session, boolean fromJava) {
        Intrinsics.checkNotNullParameter($this$getDeprecationsProviderFromAnnotations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DeprecationAnnotationInfoPerUseSiteStorage deprecationAnnotationByUseSite = DeprecationUtilsKt.extractDeprecationAnnotationInfoPerUseSite($this$getDeprecationsProviderFromAnnotations, session, fromJava);
        return deprecationAnnotationByUseSite.toDeprecationsProvider(FirCachesFactoryKt.getFirCachesFactory(session));
    }

    @Nullable
    public static final DeprecationInfo getDeprecationForCallSite(@NotNull FirBasedSymbol<?> $this$getDeprecationForCallSite, @NotNull ApiVersion apiVersion, AnnotationUseSiteTarget ... sites) {
        Intrinsics.checkNotNullParameter($this$getDeprecationForCallSite, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)sites, (String)"sites");
        FirBasedSymbol<?> firBasedSymbol = $this$getDeprecationForCallSite;
        DeprecationsPerUseSite deprecations2 = firBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$getDeprecationForCallSite).getDeprecation(apiVersion) : (firBasedSymbol instanceof FirClassLikeSymbol ? ((FirClassLikeSymbol)$this$getDeprecationForCallSite).getDeprecation(apiVersion) : null);
        DeprecationsPerUseSite deprecationsPerUseSite = deprecations2;
        if (deprecationsPerUseSite == null) {
            deprecationsPerUseSite = DeprecationsKt.getEmptyDeprecationsPerUseSite();
        }
        return deprecationsPerUseSite.forUseSite(Arrays.copyOf(sites, sites.length));
    }

    private static final ApiVersion getVersionFromArgument(FirAnnotation $this$getVersionFromArgument, Name name2) {
        ApiVersion apiVersion;
        String string2 = FirAnnotationUtilsKt.getStringArgument($this$getVersionFromArgument, name2);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            apiVersion = ApiVersion.Companion.parse(it);
        } else {
            apiVersion = null;
        }
        return apiVersion;
    }

    /*
     * WARNING - void declaration
     */
    private static final DeprecationLevelValue getDeprecationLevel(FirAnnotation $this$getDeprecationLevel) {
        DeprecationLevelValue deprecationLevelValue;
        block11: {
            Object it;
            Object object;
            if (FirAnnotationUtilsKt.getResolved($this$getDeprecationLevel)) {
                object = $this$getDeprecationLevel.getArgumentMapping().getMapping().get(StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedLevel());
            } else {
                DeprecationLevelValue[] deprecationLevelValueArray;
                Object v2;
                block10: {
                    void $this$firstOrNull$iv;
                    FirAnnotationCall firAnnotationCall = $this$getDeprecationLevel instanceof FirAnnotationCall ? (FirAnnotationCall)$this$getDeprecationLevel : null;
                    if (firAnnotationCall == null) {
                        return null;
                    }
                    FirAnnotationCall call2 = firAnnotationCall;
                    Object $this$arguments$iv = call2;
                    boolean $i$f$getArguments = false;
                    $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (FirExpression)element$iv;
                        boolean bl = false;
                        if (!(it instanceof FirNamedArgumentExpression && Intrinsics.areEqual((Object)((FirNamedArgumentExpression)it).getName(), (Object)StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedLevel()))) continue;
                        v2 = element$iv;
                        break block10;
                    }
                    v2 = null;
                }
                FirExpression firExpression2 = v2;
                if (firExpression2 != null && (deprecationLevelValueArray = FirExpressionUtilKt.unwrapArgument(firExpression2)) != null) {
                    object = deprecationLevelValueArray;
                } else {
                    FirCall $this$arguments$iv = (FirCall)((Object)$this$getDeprecationLevel);
                    boolean $i$f$getArguments = false;
                    object = (FirExpression)CollectionsKt.lastOrNull($this$arguments$iv.getArgumentList().getArguments());
                }
            }
            if (object == null) {
                return null;
            }
            DeprecationLevelValue[] argument2 = object;
            FirQualifiedAccessExpression firQualifiedAccessExpression = argument2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)argument2 : null;
            if (firQualifiedAccessExpression == null) {
                return null;
            }
            FirQualifiedAccessExpression targetExpression = firQualifiedAccessExpression;
            FirReference firReference = targetExpression.getCalleeReference();
            Object object2 = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
            if (object2 == null || (object2 = ((FirNamedReference)object2).getName()) == null || (object2 = ((Name)object2).asString()) == null) {
                return null;
            }
            Object targetName = object2;
            for (DeprecationLevelValue deprecationLevelValue2 : DeprecationLevelValue.values()) {
                it = deprecationLevelValue2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Enum)it).name(), (Object)targetName)) continue;
                deprecationLevelValue = deprecationLevelValue2;
                break block11;
            }
            deprecationLevelValue = null;
        }
        return deprecationLevelValue;
    }

    @NotNull
    public static final Set<String> getDeprecationAnnotationSimpleNames() {
        return deprecationAnnotationSimpleNames;
    }

    private static final DeprecationAnnotationInfoPerUseSiteStorage extractDeprecationAnnotationInfoPerUseSite(List<? extends FirAnnotation> $this$extractDeprecationAnnotationInfoPerUseSite, FirSession session, boolean fromJava) {
        DeprecationAnnotationInfoPerUseSiteStorageBuilder deprecationAnnotationInfoPerUseSiteStorageBuilder;
        FirAnnotation it;
        Collection collection;
        boolean $i$f$coneTypeSafe;
        FirTypeRef $this$coneTypeSafe$iv$iv;
        List<? extends FirAnnotation> $this$mapAnnotationsWithClassIdTo$iv;
        List list2;
        List $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2410 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<? extends FirAnnotation> list3 = $this$extractDeprecationAnnotationInfoPerUseSite;
        ClassId classId$iv = StandardClassIds.Annotations.INSTANCE.getDeprecated();
        boolean $i$f$mapAnnotationsWithClassIdTo = false;
        for (FirAnnotation firAnnotation : $this$mapAnnotationsWithClassIdTo$iv) {
            Object object;
            $this$coneTypeSafe$iv$iv = firAnnotation.getAnnotationTypeRef();
            $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if (!Intrinsics.areEqual((Object)((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)classId$iv)) continue;
            FirAnnotation firAnnotation2 = firAnnotation;
            collection = $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2410;
            boolean bl2 = false;
            collection.add(TuplesKt.to((Object)it, (Object)false));
        }
        $this$mapAnnotationsWithClassIdTo$iv = $this$extractDeprecationAnnotationInfoPerUseSite;
        classId$iv = StandardClassIds.Annotations.Java.INSTANCE.getDeprecated();
        $i$f$mapAnnotationsWithClassIdTo = false;
        for (FirAnnotation firAnnotation : $this$mapAnnotationsWithClassIdTo$iv) {
            Object object;
            $this$coneTypeSafe$iv$iv = firAnnotation.getAnnotationTypeRef();
            $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if (!Intrinsics.areEqual((Object)((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)classId$iv)) continue;
            it = firAnnotation;
            collection = $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2410;
            boolean bl3 = false;
            collection.add(TuplesKt.to((Object)it, (Object)true));
        }
        $this$mapAnnotationsWithClassIdTo$iv = $this$extractDeprecationAnnotationInfoPerUseSite;
        classId$iv = StandardClassIds.Annotations.INSTANCE.getSinceKotlin();
        $i$f$mapAnnotationsWithClassIdTo = false;
        for (FirAnnotation firAnnotation : $this$mapAnnotationsWithClassIdTo$iv) {
            Object object;
            $this$coneTypeSafe$iv$iv = firAnnotation.getAnnotationTypeRef();
            $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if (!Intrinsics.areEqual((Object)((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)classId$iv)) continue;
            it = firAnnotation;
            collection = $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2410;
            boolean bl4 = false;
            collection.add(TuplesKt.to((Object)it, (Object)false));
        }
        List annotations2 = CollectionsKt.build((List)list2);
        boolean $i$f$buildDeprecationAnnotationInfoPerUseSiteStorage = false;
        DeprecationAnnotationInfoPerUseSiteStorageBuilder $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2412 = deprecationAnnotationInfoPerUseSiteStorageBuilder = new DeprecationAnnotationInfoPerUseSiteStorageBuilder();
        boolean bl5 = false;
        for (Pair pair : annotations2) {
            FirAnnotation deprecated = (FirAnnotation)pair.component1();
            boolean bl2 = (Boolean)pair.component2();
            FirAnnotation $this$unexpandedClassId$iv = deprecated;
            boolean $i$f$getUnexpandedClassId = false;
            Object $this$unexpandedConeClassLikeType$iv$iv = $this$unexpandedClassId$iv;
            boolean $i$f$getUnexpandedConeClassLikeType22 = false;
            Object bl4 = ((FirAnnotation)$this$unexpandedConeClassLikeType$iv$iv).getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = bl4 instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)bl4 : null;
            Object object = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            Object object2 = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (Intrinsics.areEqual((Object)(object2 != null && (object2 = ((ConeClassLikeType)object2).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object2).getClassId() : null), (Object)StandardClassIds.Annotations.INSTANCE.getSinceKotlin())) {
                boolean wasExperimental;
                boolean bl3;
                Object apiVersion;
                block12: {
                    FirExpression sinceKotlinSingleArgument = FirAnnotationUtilsKt.findArgumentByName(deprecated, StandardClassIds.Annotations.ParameterNames.INSTANCE.getSinceKotlinVersion());
                    FirConstExpression firConstExpression = sinceKotlinSingleArgument instanceof FirConstExpression ? (FirConstExpression)sinceKotlinSingleArgument : null;
                    Object $i$f$getUnexpandedConeClassLikeType22 = firConstExpression != null ? firConstExpression.getValue() : null;
                    $this$unexpandedConeClassLikeType$iv$iv = $i$f$getUnexpandedConeClassLikeType22 instanceof String ? (String)$i$f$getUnexpandedConeClassLikeType22 : null;
                    if ($this$unexpandedConeClassLikeType$iv$iv == null) continue;
                    bl4 = $this$unexpandedConeClassLikeType$iv$iv;
                    object = ApiVersion.Companion;
                    Object p0 = bl4;
                    boolean bl7 = false;
                    $i$f$getUnexpandedConeClassLikeType22 = ((ApiVersion.Companion)object).parse((String)p0);
                    if ($i$f$getUnexpandedConeClassLikeType22 == null) continue;
                    apiVersion = $i$f$getUnexpandedConeClassLikeType22;
                    Iterable $this$any$iv = $this$extractDeprecationAnnotationInfoPerUseSite;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirAnnotation it2 = (FirAnnotation)element$iv;
                            boolean bl8 = false;
                            FirAnnotation $this$unexpandedClassId$iv2 = it2;
                            boolean $i$f$getUnexpandedClassId2 = false;
                            FirAnnotation $this$unexpandedConeClassLikeType$iv$iv2 = $this$unexpandedClassId$iv2;
                            boolean $i$f$getUnexpandedConeClassLikeType3 = false;
                            FirTypeRef firTypeRef = $this$unexpandedConeClassLikeType$iv$iv2.getAnnotationTypeRef();
                            FirResolvedTypeRef firResolvedTypeRef2 = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                            ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
                            Object object3 = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                            if (!Intrinsics.areEqual((Object)(object3 != null && (object3 = ((ConeClassLikeType)object3).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object3).getClassId() : null), (Object)StandardClassIds.Annotations.INSTANCE.getWasExperimental())) continue;
                            bl3 = true;
                            break block12;
                        }
                        bl3 = false;
                    }
                }
                if (wasExperimental = bl3) continue;
                $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2412.add(deprecated.getUseSiteTarget(), new SinceKotlinInfo((ApiVersion)apiVersion));
                continue;
            }
            DeprecationLevelValue deprecationLevelValue = DeprecationUtilsKt.getDeprecationLevel(deprecated);
            if (deprecationLevelValue == null) {
                deprecationLevelValue = DeprecationLevelValue.WARNING;
            }
            DeprecationLevelValue deprecationLevel = deprecationLevelValue;
            boolean propagatesToOverride = !bl2 && !fromJava;
            FirAnnotation deprecatedSinceKotlin = (FirAnnotation)CollectionsKt.firstOrNull(FirAnnotationUtilsKt.getAnnotationsByClassId($this$extractDeprecationAnnotationInfoPerUseSite, StandardClassIds.Annotations.INSTANCE.getDeprecatedSinceKotlin(), session));
            String message = FirAnnotationUtilsKt.getStringArgument(deprecated, StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedMessage());
            DeprecationAnnotationInfo deprecatedInfo = deprecatedSinceKotlin == null ? (DeprecationAnnotationInfo)new DeprecatedInfo(deprecationLevel, propagatesToOverride, message) : (DeprecationAnnotationInfo)new DeprecatedSinceKotlinInfo(DeprecationUtilsKt.getVersionFromArgument(deprecatedSinceKotlin, StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedSinceKotlinWarningSince()), DeprecationUtilsKt.getVersionFromArgument(deprecatedSinceKotlin, StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedSinceKotlinErrorSince()), DeprecationUtilsKt.getVersionFromArgument(deprecatedSinceKotlin, StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedSinceKotlinHiddenSince()), message, propagatesToOverride);
            $this$extractDeprecationAnnotationInfoPerUseSite_u24lambda_u2412.add(deprecated.getUseSiteTarget(), deprecatedInfo);
        }
        return deprecationAnnotationInfoPerUseSiteStorageBuilder.build();
    }

    static {
        Object[] objectArray = new String[3];
        Intrinsics.checkNotNullExpressionValue((Object)StandardClassIds.Annotations.INSTANCE.getDeprecated().getShortClassName().asString(), (String)"Annotations.Deprecated.shortClassName.asString()");
        Intrinsics.checkNotNullExpressionValue((Object)StandardClassIds.Annotations.Java.INSTANCE.getDeprecated().getShortClassName().asString(), (String)"Java.Deprecated.shortClassName.asString()");
        Intrinsics.checkNotNullExpressionValue((Object)StandardClassIds.Annotations.INSTANCE.getSinceKotlin().getShortClassName().asString(), (String)"Annotations.SinceKotlin.shortClassName.asString()");
        deprecationAnnotationSimpleNames = SetsKt.setOf((Object[])objectArray);
    }
}

