/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirDefaultParametersResolver;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "()V", "declaresDefaultValue", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "index", "", "resolve"})
public final class FirDefaultParametersResolver
implements FirSessionComponent {
    public final boolean declaresDefaultValue(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull FirValueParameter valueParameter2, @NotNull FirFunction function2, @Nullable FirScope originScope, int index2) {
        FirTypeScope firTypeScope;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (valueParameter2.getDefaultValue() != null || DeclarationUtilsKt.containsDefaultValue(ExpectActualAttributesKt.getSingleCompatibleExpectForActualOrNull(function2.getSymbol()), index2)) {
            return true;
        }
        if (!(function2 instanceof FirSimpleFunction)) {
            return false;
        }
        FirNamedFunctionSymbol symbol2 = ((FirSimpleFunction)function2).getSymbol();
        FirScope firScope = originScope;
        if (firScope instanceof FirTypeScope) {
            firTypeScope = (FirTypeScope)originScope;
        } else if (firScope instanceof FirAbstractImportingScope) {
            FirRegularClass firRegularClass = ResolveUtilsKt.getContainingClass(function2, session);
            if (firRegularClass == null) {
                return false;
            }
            FirRegularClass containingClass = firRegularClass;
            firTypeScope = FirKotlinScopeProviderKt.scopeForClass(containingClass, ConeSubstitutor.Empty.INSTANCE, session, scopeSession, containingClass.getSymbol().toLookupTag());
        } else {
            return false;
        }
        FirTypeScope typeScope = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(typeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(index2, result2){
            final /* synthetic */ int $index;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$index = $index;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol overridden) {
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                if (DeclarationUtilsKt.containsDefaultValue(overridden, this.$index) || DeclarationUtilsKt.containsDefaultValue(ExpectActualAttributesKt.getSingleCompatibleExpectForActualOrNull(overridden), this.$index)) {
                    this.$result.element = true;
                    return ProcessorAction.STOP;
                }
                return ProcessorAction.NEXT;
            }
        }));
        return result2.element;
    }
}

