/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConeCallConflictResolver;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\n*\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u001a\u0010\r\u001a\u00020\n*\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\u000f\u001a\u00020\n*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeCallConflictResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "chooseMaximallySpecificCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "candidates", "discriminateAbstracts", "", "isShadowedByFieldCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isShadowedByPropertyCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "strictlyDerivedFrom", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "other", "java"})
@SourceDebugExtension(value={"SMAP\nJvmPlatformOverloadsConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmPlatformOverloadsConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver\n+ 2 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n*L\n1#1,83:1\n103#2,4:84\n66#2:88\n107#2,2:89\n94#2,4:91\n78#2:95\n66#2,7:96\n98#2,2:103\n94#2,4:105\n78#2:109\n66#2,7:110\n98#2,2:117\n103#2,4:119\n66#2:123\n107#2,2:124\n*S KotlinDebug\n*F\n+ 1 JvmPlatformOverloadsConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver\n*L\n43#1:84,4\n43#1:88\n43#1:89,2\n46#1:91,4\n46#1:95\n46#1:96,7\n46#1:103,2\n60#1:105,4\n60#1:109\n60#1:110,7\n60#1:117,2\n63#1:119,4\n63#1:123\n63#1:124,2\n*E\n"})
public final class JvmPlatformOverloadsConflictResolver
extends ConeCallConflictResolver {
    @NotNull
    private final FirSession session;

    public JvmPlatformOverloadsConflictResolver(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return candidates2;
        }
        Set result2 = new LinkedHashSet();
        for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirProperty) {
                if (this.isShadowedByFieldCandidate((FirProperty)me, candidates2)) continue;
                ((Collection)result2).add(myCandidate);
                continue;
            }
            if (me instanceof FirField) {
                if (this.isShadowedByPropertyCandidate((FirField)me, candidates2)) continue;
                ((Collection)result2).add(myCandidate);
                continue;
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean isShadowedByFieldCandidate(FirProperty $this$isShadowedByFieldCandidate, Set<Candidate> candidates2) {
        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv;
        FirCallableDeclaration $this$unwrapSubstitutionOverrides$iv = $this$isShadowedByFieldCandidate;
        boolean $i$f$unwrapSubstitutionOverrides = false;
        FirCallableDeclaration current$iv = $this$unwrapSubstitutionOverrides$iv;
        while (true) {
            FirCallableDeclaration next$iv;
            $this$originalForSubstitutionOverride$iv$iv = current$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            if (firCallableDeclaration == null) break;
            current$iv = next$iv = firCallableDeclaration;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(((FirProperty)current$iv).getSymbol());
        if (coneClassLikeLookupTag == null) {
            return false;
        }
        ConeClassLikeLookupTag propertyContainingClassLookupTag = coneClassLikeLookupTag;
        for (Candidate otherCandidate : candidates2) {
            FirField field2;
            $this$originalForSubstitutionOverride$iv$iv = otherCandidate.getSymbol().getFir();
            if (($this$originalForSubstitutionOverride$iv$iv instanceof FirField ? (FirField)$this$originalForSubstitutionOverride$iv$iv : null) == null) continue;
            field2 = field2;
            FirCallableDeclaration $this$unwrapFakeOverrides$iv = field2;
            boolean $i$f$unwrapFakeOverrides = false;
            FirCallableDeclaration current$iv2 = $this$unwrapFakeOverrides$iv;
            while (true) {
                FirCallableDeclaration next$iv;
                FirCallableDeclaration $this$originalIfFakeOverride$iv$iv = current$iv2;
                boolean $i$f$originalIfFakeOverride = false;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                if (firCallableDeclaration == null) {
                    FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                }
                if (firCallableDeclaration == null) break;
                current$iv2 = next$iv = firCallableDeclaration;
            }
            ConeClassLikeLookupTag fieldContainingClassLookupTag = ClassMembersKt.containingClassLookupTag(((FirField)current$iv2).getSymbol());
            if (fieldContainingClassLookupTag == null || this.strictlyDerivedFrom(propertyContainingClassLookupTag, fieldContainingClassLookupTag)) continue;
            return true;
        }
        return false;
    }

    private final boolean isShadowedByPropertyCandidate(FirField $this$isShadowedByPropertyCandidate, Set<Candidate> candidates2) {
        FirCallableDeclaration $this$originalIfFakeOverride$iv$iv;
        FirCallableDeclaration $this$unwrapFakeOverrides$iv = $this$isShadowedByPropertyCandidate;
        boolean $i$f$unwrapFakeOverrides = false;
        FirCallableDeclaration current$iv = $this$unwrapFakeOverrides$iv;
        while (true) {
            FirCallableDeclaration next$iv;
            $this$originalIfFakeOverride$iv$iv = current$iv;
            boolean $i$f$originalIfFakeOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
            if (firCallableDeclaration == null) {
                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                boolean $i$f$getBaseForIntersectionOverride = false;
                firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
            }
            if (firCallableDeclaration == null) break;
            current$iv = next$iv = firCallableDeclaration;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(((FirField)current$iv).getSymbol());
        if (coneClassLikeLookupTag == null) {
            return false;
        }
        ConeClassLikeLookupTag fieldContainingClassLookupTag = coneClassLikeLookupTag;
        for (Candidate otherCandidate : candidates2) {
            FirProperty property2;
            $this$originalIfFakeOverride$iv$iv = otherCandidate.getSymbol().getFir();
            if (($this$originalIfFakeOverride$iv$iv instanceof FirProperty ? (FirProperty)$this$originalIfFakeOverride$iv$iv : null) == null) continue;
            property2 = property2;
            FirCallableDeclaration $this$unwrapSubstitutionOverrides$iv = property2;
            boolean $i$f$unwrapSubstitutionOverrides = false;
            FirCallableDeclaration current$iv2 = $this$unwrapSubstitutionOverrides$iv;
            while (true) {
                FirCallableDeclaration next$iv;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = current$iv2;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
                if (firCallableDeclaration == null) break;
                current$iv2 = next$iv = firCallableDeclaration;
            }
            ConeClassLikeLookupTag propertyContainingClassLookupTag = ClassMembersKt.containingClassLookupTag(((FirProperty)current$iv2).getSymbol());
            if (propertyContainingClassLookupTag == null || !this.strictlyDerivedFrom(propertyContainingClassLookupTag, fieldContainingClassLookupTag)) continue;
            return true;
        }
        return false;
    }

    private final boolean strictlyDerivedFrom(ConeClassLikeLookupTag $this$strictlyDerivedFrom, ConeClassLikeLookupTag other) {
        if (Intrinsics.areEqual((Object)$this$strictlyDerivedFrom, (Object)other)) {
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$strictlyDerivedFrom, this.session);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
        if (firClass == null) {
            return false;
        }
        FirClass thisClass = firClass;
        return SupertypeUtilsKt.isSubclassOf$default(thisClass, other, this.session, true, null, false, 24, null);
    }
}

