/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1#2:54\n533#3,6:55\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n*L\n43#1:55,6\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression2, context)) {
            return;
        }
        Object object = FirExpressionUtilKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object;
        FirOptInUsageBaseChecker $this$check_u24lambda_u242 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (expression2 instanceof FirVariableAssignment) {
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u242.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context, true, null), (Iterable)$this$check_u24lambda_u242.loadExperimentalitiesFromTypeArguments(context, CollectionsKt.emptyList()));
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u242, experimentalities, ((FirVariableAssignment)expression2).getLValue(), context, reporter, null, 16, null);
        } else if (expression2 instanceof FirQualifiedAccessExpression) {
            Object object2;
            FirExpression firExpression2;
            FirExpression it = firExpression2 = ((FirQualifiedAccessExpression)expression2).getDispatchReceiver();
            boolean bl2 = false;
            Object object3 = !(it instanceof FirNoReceiverExpression) ? firExpression2 : null;
            ConeKotlinType dispatchReceiverType = object3 != null && (object3 = ((FirExpression)object3).getTypeRef()) != null && (object3 = FirTypeUtilsKt.getConeType((FirTypeRef)object3)) != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object3, context.getSession()) : null;
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u242.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u242.loadExperimentalitiesFromTypeArguments(context, ((FirQualifiedAccessExpression)expression2).getTypeArguments()));
            KtSourceElement ktSourceElement2 = expression2.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                FirDeclaration firDeclaration;
                block11: {
                    List<FirDeclaration> $this$lastOrNull$iv = context.getContainingDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        FirDeclaration element$iv;
                        FirDeclaration it2 = element$iv = iterator$iv.previous();
                        boolean bl3 = false;
                        if (!(it2 instanceof FirProperty)) continue;
                        firDeclaration = element$iv;
                        break block11;
                    }
                    firDeclaration = null;
                }
                FirDeclaration firDeclaration2 = firDeclaration;
                FirProperty firProperty = firDeclaration2 instanceof FirProperty ? (FirProperty)firDeclaration2 : null;
                if (firProperty == null) {
                    return;
                }
                FirProperty property2 = firProperty;
                object2 = property2.getDelegate();
                if (object2 == null || (object2 = ((FirExpression)object2).getSource()) == null || (object2 = KtSourceElementKt.fakeElement((KtSourceElement)object2, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) == null) {
                    return;
                }
            } else {
                object2 = expression2.getSource();
            }
            KtSourceElement source = object2;
            $this$check_u24lambda_u242.reportNotAcceptedExperimentalities(experimentalities, expression2, context, reporter, source);
        }
    }
}

