/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002JX\u0010\u0010\u001a\u00020\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122&\u0010\u0013\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00160\u00142\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u001c\u0010\u001f\u001a\u00020\u000f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u000f*\u0012\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0002\b\u00030\u0014J\u0016\u0010#\u001a\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015H\u0002J\u0010\u0010$\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0012H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkActualDeclarationHasExpected", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkActual", "", "checkAmbiguousExpects", "actualDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "symbol", "checkAnnotationConstructors", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "expected", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "actual", "isUnderlyingPropertyOfInlineClass", "requireActualModifier", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "allStrongIncompatibilities", "isCompatibleOrWeakCompatible", "isExplicitActualDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,223:1\n33#2:224\n33#2:225\n819#3:226\n847#3,2:227\n223#3,2:233\n1726#3,3:236\n20#4,2:229\n20#4,2:231\n603#5:235\n*S KotlinDebug\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n*L\n36#1:224\n54#1:225\n88#1:226\n88#1:227,2\n130#1:233,2\n181#1:236,3\n110#1:229,2\n111#1:231,2\n166#1:235\n*E\n"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isActual = false;
        if ($this$isActual$iv.getStatus().isActual()) {
            FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$default(this, (FirMemberDeclaration)declaration, context, reporter, false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualDeclarationHasExpected(FirMemberDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, boolean checkActual) {
        FirBasedSymbol<? extends FirDeclaration> symbol2 = declaration.getSymbol();
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> map = ExpectActualAttributesKt.getExpectForActual(symbol2);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> compatibilityToMembersMap = map;
        FirSession session = context.getSession();
        this.checkAmbiguousExpects(symbol2, compatibilityToMembersMap, symbol2, context, reporter);
        KtSourceElement source = declaration.getSource();
        FirMemberDeclaration $this$isActual$iv = declaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            if (this.allStrongIncompatibilities(compatibilityToMembersMap)) {
                return;
            }
            if (compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
                if (checkActual && this.requireActualModifier(symbol2, session)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), (DiagnosticContext)context, null, 8, null);
                }
                return;
            }
        }
        ExpectActualCompatibility singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.singleOrNull((Iterable)compatibilityToMembersMap.keySet());
        if (singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes) {
            void $this$filterNotTo$iv$iv;
            boolean bl = $i$f$isActual = symbol2 instanceof FirRegularClassSymbol || symbol2 instanceof FirTypeAliasSymbol;
            if (_Assertions.ENABLED && !$i$f$isActual) {
                boolean $i$a$-assert-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = false;
                String $i$a$-assert-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + declaration;
                throw new AssertionError((Object)$i$a$-assert-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22);
            }
            Iterable $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Pair p0 = (Pair)element$iv$iv;
                boolean bl2 = false;
                if (FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            if (!((Collection)nonTrivialUnfulfilled).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol2, (Object)nonTrivialUnfulfilled, (DiagnosticContext)context, null, 32, null);
            }
        } else if (!compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol2, compatibilityToMembersMap, (DiagnosticContext)context, null, 32, null);
        } else {
            List<FirBasedSymbol<?>> list2 = compatibilityToMembersMap.get(ExpectActualCompatibility.Compatible.INSTANCE);
            Intrinsics.checkNotNull(list2);
            FirBasedSymbol expected = (FirBasedSymbol)CollectionsKt.first(list2);
            if (expected instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)expected).getClassKind() == ClassKind.ANNOTATION_CLASS) {
                Object v6;
                FirConstructorSymbol actualConstructor;
                block19: {
                    FirConstructorSymbol firConstructorSymbol;
                    boolean $i$f$firstIsInstanceOrNull;
                    Iterable $this$firstIsInstanceOrNull$iv;
                    FirRegularClassSymbol klass = FirExpectActualDeclarationCheckerKt.expandedClass(symbol2, session);
                    Object object = klass;
                    if (object != null && (object = ((FirClassSymbol)object).getDeclarationSymbols()) != null) {
                        Object v4;
                        block18: {
                            $this$firstIsInstanceOrNull$iv = (Iterable)object;
                            $i$f$firstIsInstanceOrNull = false;
                            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                                if (!(element$iv instanceof FirConstructorSymbol)) continue;
                                v4 = element$iv;
                                break block18;
                            }
                            v4 = null;
                        }
                        firConstructorSymbol = v4;
                    } else {
                        firConstructorSymbol = null;
                    }
                    actualConstructor = firConstructorSymbol;
                    $this$firstIsInstanceOrNull$iv = ((FirRegularClassSymbol)expected).getDeclarationSymbols();
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof FirConstructorSymbol)) continue;
                        v6 = element$iv;
                        break block19;
                    }
                    v6 = null;
                }
                FirConstructorSymbol expectedConstructor = v6;
                if (expectedConstructor != null && actualConstructor != null) {
                    this.checkAnnotationConstructors(source, expectedConstructor, actualConstructor, context, reporter);
                }
            }
        }
    }

    static /* synthetic */ void checkActualDeclarationHasExpected$default(FirExpectActualDeclarationChecker firExpectActualDeclarationChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        firExpectActualDeclarationChecker.checkActualDeclarationHasExpected(firMemberDeclaration, checkerContext, diagnosticReporter, bl);
    }

    private final void checkAnnotationConstructors(KtSourceElement source, FirConstructorSymbol expected, FirConstructorSymbol actual, CheckerContext context, DiagnosticReporter reporter) {
        for (FirValueParameterSymbol expectedValueParameter : expected.getValueParameterSymbols()) {
            Object element$iv2;
            block2: {
                Iterable $this$first$iv = actual.getValueParameterSymbols();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expectedValueParameter.getName())) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            FirValueParameterSymbol actualValueDescriptor = (FirValueParameterSymbol)element$iv2;
            if (!expectedValueParameter.getHasDefaultValue() || !actualValueDescriptor.getHasDefaultValue()) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(FirBasedSymbol<?> actualDeclaration, Map<ExpectActualCompatibility<FirBasedSymbol<?>>, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol2, CheckerContext context, DiagnosticReporter reporter) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(compatibility), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.1.INSTANCE), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FirModuleData it = (FirModuleData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol2, (Object)filesWithAtLeastWeaklyCompatibleExpects2, (DiagnosticContext)context, null, 32, null);
        }
    }

    public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<?>, ?> $this$allStrongIncompatibilities) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, (String)"<this>");
            Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                    boolean bl2 = false;
                    if (it instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)it).getKind() == ExpectActualCompatibility.IncompatibilityKind.STRONG) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isCompatibleOrWeakCompatible(ExpectActualCompatibility<? extends FirBasedSymbol<?>> $this$isCompatibleOrWeakCompatible) {
        return $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectActualCompatibility.IncompatibilityKind.WEAK;
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration, FirSession session) {
        return !DeclarationUtilsKt.isAnnotationConstructor(declaration, session) && !DeclarationUtilsKt.isPrimaryConstructorOfInlineOrValueClass(declaration, session) && !this.isUnderlyingPropertyOfInlineClass(declaration);
    }

    private final boolean isUnderlyingPropertyOfInlineClass(FirBasedSymbol<?> declaration) {
        return false;
    }

    private final boolean isExplicitActualDeclaration(FirBasedSymbol<?> $this$isExplicitActualDeclaration) {
        return true;
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(Pair<? extends FirBasedSymbol<?>, ? extends Map<ExpectActualCompatibility.Incompatible<FirBasedSymbol<?>>, ? extends Collection<? extends FirBasedSymbol<?>>>> expectedWithIncompatibility) {
        Object object;
        FirBasedSymbol actualMember;
        FirBasedSymbol expectedMember = (FirBasedSymbol)expectedWithIncompatibility.component1();
        Map incompatibility = (Map)expectedWithIncompatibility.component2();
        Collection collection = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        FirBasedSymbol firBasedSymbol = actualMember = collection != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)collection) : null;
        return actualMember != null && INSTANCE.isExplicitActualDeclaration(actualMember) && !INSTANCE.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((object = ExpectActualAttributesKt.getExpectForActual(actualMember.getFir())) != null && (object = object.values()) != null && (object = (List)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((List)object) : null, (Object)expectedMember);
    }

    public static final /* synthetic */ boolean access$isCompatibleOrWeakCompatible(FirExpectActualDeclarationChecker $this, ExpectActualCompatibility $receiver) {
        return $this.isCompatibleOrWeakCompatible($receiver);
    }
}

