/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorScope;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

public class CommonSupertypes {
    @Nullable
    public static KotlinType commonSupertypeForNonDenotableTypes(@NotNull Collection<KotlinType> types2) {
        KotlinType type2;
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(0);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(0);
        }
        if (types2.isEmpty()) {
            return null;
        }
        if (types2.size() == 1 && (type2 = types2.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types2);
    }

    @NotNull
    public static KotlinType commonSupertype(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(1);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(1);
        }
        if (types2.size() == 1) {
            KotlinType kotlinType = types2.iterator().next();
            if (kotlinType == null) {
                CommonSupertypes.$$$reportNull$$$0(2);
            }
            if (kotlinType == null) {
                CommonSupertypes.$$$reportNull$$$1(2);
            }
            return kotlinType;
        }
        return CommonSupertypes.findCommonSupertype(types2, 0, CommonSupertypes.maxDepth(types2) + 3);
    }

    private static int maxDepth(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(3);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(3);
        }
        int max = 0;
        for (KotlinType type2 : types2) {
            int depth = CommonSupertypes.depth(type2);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(@NotNull KotlinType type2) {
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$1(4);
        }
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$0(4);
        }
        return 1 + CommonSupertypes.maxDepth(CollectionsKt.map(type2.getArguments(), projection -> {
            if (projection.isStarProjection()) {
                return type2.getConstructor().getBuiltIns().getAnyType();
            }
            return projection.getType();
        }));
    }

    @NotNull
    private static KotlinType findCommonSupertype(@NotNull Collection<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(5);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(5);
        }
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types2;
        boolean hasFlexible = false;
        ArrayList<SimpleType> upper = new ArrayList<SimpleType>(types2.size());
        ArrayList<SimpleType> lower2 = new ArrayList<SimpleType>(types2.size());
        for (KotlinType type2 : types2) {
            UnwrappedType unwrappedType = type2.unwrap();
            if (unwrappedType instanceof FlexibleType) {
                if (DynamicTypesKt.isDynamic(unwrappedType)) {
                    UnwrappedType unwrappedType2 = unwrappedType;
                    if (unwrappedType2 == null) {
                        CommonSupertypes.$$$reportNull$$$0(6);
                    }
                    if (unwrappedType2 == null) {
                        CommonSupertypes.$$$reportNull$$$1(6);
                    }
                    return unwrappedType2;
                }
                hasFlexible = true;
                FlexibleType flexibleType = (FlexibleType)unwrappedType;
                upper.add(flexibleType.getUpperBound());
                lower2.add(flexibleType.getLowerBound());
                continue;
            }
            SimpleType simpleType2 = (SimpleType)unwrappedType;
            upper.add(simpleType2);
            lower2.add(simpleType2);
        }
        if (!hasFlexible) {
            return CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth);
        }
        UnwrappedType unwrappedType = KotlinTypeFactory.flexibleType(CommonSupertypes.commonSuperTypeForInflexible(lower2, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth));
        if (unwrappedType == null) {
            CommonSupertypes.$$$reportNull$$$0(7);
        }
        if (unwrappedType == null) {
            CommonSupertypes.$$$reportNull$$$1(7);
        }
        return unwrappedType;
    }

    @NotNull
    private static SimpleType commonSuperTypeForInflexible(@NotNull Collection<SimpleType> types2, int recursionDepth, int maxDepth) {
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(8);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(8);
        }
        assert (!types2.isEmpty());
        LinkedHashSet<SimpleType> typeSet = new LinkedHashSet<SimpleType>(types2);
        boolean nullable = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = (KotlinType)iterator2.next();
            assert (type2 != null);
            assert (!FlexibleTypesKt.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (KotlinTypeKt.isError(type2)) {
                ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.SUPER_TYPE_FOR_ERROR_TYPE, type2.toString());
                if (errorType == null) {
                    CommonSupertypes.$$$reportNull$$$0(9);
                }
                if (errorType == null) {
                    CommonSupertypes.$$$reportNull$$$1(9);
                }
                return errorType;
            }
            nullable |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            KotlinBuiltIns builtIns = types2.iterator().next().getConstructor().getBuiltIns();
            SimpleType simpleType2 = nullable ? builtIns.getNullableNothingType() : builtIns.getNothingType();
            if (simpleType2 == null) {
                CommonSupertypes.$$$reportNull$$$0(10);
            }
            if (simpleType2 == null) {
                CommonSupertypes.$$$reportNull$$$1(10);
            }
            return simpleType2;
        }
        if (typeSet.size() == 1) {
            SimpleType simpleType3 = TypeUtils.makeNullableIfNeeded((SimpleType)typeSet.iterator().next(), nullable);
            if (simpleType3 == null) {
                CommonSupertypes.$$$reportNull$$$0(11);
            }
            if (simpleType3 == null) {
                CommonSupertypes.$$$reportNull$$$1(11);
            }
            return simpleType3;
        }
        Map<TypeConstructor, Set<SimpleType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            LinkedHashSet<SimpleType> merge = new LinkedHashSet<SimpleType>();
            for (Set set : commonSupertypes.values()) {
                merge.addAll(set);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        if (commonSupertypes.isEmpty()) {
            StringBuilder info = new StringBuilder();
            for (SimpleType simpleType4 : types2) {
                String superTypes2 = TypeUtils.getAllSupertypes(simpleType4).stream().map(t -> "-- " + CommonSupertypes.renderTypeFully(t)).collect(Collectors.joining("\n"));
                info.append("Info about ").append(CommonSupertypes.renderTypeFully(simpleType4)).append(": ").append('\n').append("- Supertypes: ").append('\n').append(superTypes2).append('\n').append("- DeclarationDescriptor class: ").append(CommonSupertypes.classOfDeclarationDescriptor(simpleType4)).append('\n').append('\n');
            }
            throw new IllegalStateException("[Report version 3] There is no common supertype for: " + types2 + " \n" + info.toString());
        }
        Map.Entry<TypeConstructor, Set<SimpleType>> entry = commonSupertypes.entrySet().iterator().next();
        SimpleType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        SimpleType simpleType5 = TypeUtils.makeNullableIfNeeded(result2, nullable);
        if (simpleType5 == null) {
            CommonSupertypes.$$$reportNull$$$0(12);
        }
        if (simpleType5 == null) {
            CommonSupertypes.$$$reportNull$$$1(12);
        }
        return simpleType5;
    }

    @NotNull
    private static String renderTypeFully(@NotNull KotlinType type2) {
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$1(13);
        }
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$0(13);
        }
        String string2 = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2) + ", typeConstructor debug: " + CommonSupertypes.renderTypeConstructorVerboseDebugInformation(type2.getConstructor());
        if (string2 == null) {
            CommonSupertypes.$$$reportNull$$$0(14);
        }
        if (string2 == null) {
            CommonSupertypes.$$$reportNull$$$1(14);
        }
        return string2;
    }

    private static String renderTypeConstructorVerboseDebugInformation(TypeConstructor typeConstructor2) {
        if (!(typeConstructor2 instanceof AbstractTypeConstructor)) {
            return typeConstructor2.toString() + "[" + typeConstructor2.getClass().getName() + "]";
        }
        AbstractTypeConstructor abstractTypeConstructor = (AbstractTypeConstructor)typeConstructor2;
        ClassifierDescriptor declarationDescriptor = abstractTypeConstructor.getDeclarationDescriptor();
        String moduleDescriptorString = declarationDescriptor == null ? "<no module for null descriptor>" : Objects.toString(DescriptorUtils.getContainingModule(declarationDescriptor));
        return "descriptor=" + declarationDescriptor + "@" + Integer.toHexString(Objects.hashCode(declarationDescriptor)) + ", moduleDescriptor=" + moduleDescriptorString + ", " + abstractTypeConstructor.renderAdditionalDebugInformation();
    }

    @Nullable
    private static Class<?> classOfDeclarationDescriptor(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2;
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$1(15);
        }
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$0(15);
        }
        if ((descriptor2 = type2.getConstructor().getDeclarationDescriptor()) != null) {
            return descriptor2.getClass();
        }
        return null;
    }

    @NotNull
    private static Map<TypeConstructor, Set<SimpleType>> computeCommonRawSupertypes(@NotNull Collection<SimpleType> types2) {
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(16);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(16);
        }
        assert (!types2.isEmpty());
        HashMap<TypeConstructor, Set<SimpleType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<SimpleType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (SimpleType type2 : types2) {
            HashSet<TypeConstructor> visited2 = new HashSet<TypeConstructor>();
            order = CommonSupertypes.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited2);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited2;
                continue;
            }
            commonSuperclasses.retainAll(visited2);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        LinkedHashMap<TypeConstructor, Set<SimpleType>> result2 = new LinkedHashMap<TypeConstructor, Set<SimpleType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<SimpleType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        LinkedHashMap<TypeConstructor, Set<SimpleType>> linkedHashMap = result2;
        if (linkedHashMap == null) {
            CommonSupertypes.$$$reportNull$$$0(17);
        }
        if (linkedHashMap == null) {
            CommonSupertypes.$$$reportNull$$$1(17);
        }
        return linkedHashMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static SimpleType computeSupertypeProjections(@NotNull TypeConstructor constructor2, @NotNull Set<SimpleType> types2, int recursionDepth, int maxDepth) {
        void var8_17;
        if (constructor2 == null) {
            CommonSupertypes.$$$reportNull$$$1(18);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$1(19);
        }
        if (constructor2 == null) {
            CommonSupertypes.$$$reportNull$$$0(18);
        }
        if (types2 == null) {
            CommonSupertypes.$$$reportNull$$$0(19);
        }
        assert (!types2.isEmpty());
        if (types2.size() == 1) {
            SimpleType simpleType2 = types2.iterator().next();
            if (simpleType2 == null) {
                CommonSupertypes.$$$reportNull$$$0(20);
            }
            if (simpleType2 == null) {
                CommonSupertypes.$$$reportNull$$$1(20);
            }
            return simpleType2;
        }
        List<TypeParameterDescriptor> parameters2 = constructor2.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>(parameters2.size());
        for (TypeParameterDescriptor typeParameterDescriptor : parameters2) {
            LinkedHashSet<TypeProjection> linkedHashSet = new LinkedHashSet<TypeProjection>();
            for (KotlinType kotlinType : types2) {
                linkedHashSet.add(kotlinType.getArguments().get(typeParameterDescriptor.getIndex()));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(typeParameterDescriptor, linkedHashSet, recursionDepth, maxDepth));
        }
        boolean nullable = false;
        for (KotlinType kotlinType : types2) {
            nullable |= kotlinType.isMarkedNullable();
        }
        ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof ClassDescriptor) {
            MemberScope memberScope2 = ((ClassDescriptor)classifierDescriptor).getMemberScope(newProjections);
        } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
            MemberScope memberScope3 = classifierDescriptor.getDefaultType().getMemberScope();
        } else {
            ErrorScope errorScope = ErrorUtils.createErrorScope(ErrorScopeKind.NON_CLASSIFIER_SUPER_TYPE_SCOPE, true, new String[0]);
        }
        SimpleType simpleType3 = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), constructor2, newProjections, nullable, (MemberScope)var8_17);
        if (simpleType3 == null) {
            CommonSupertypes.$$$reportNull$$$0(21);
        }
        if (simpleType3 == null) {
            CommonSupertypes.$$$reportNull$$$1(21);
        }
        return simpleType3;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        TypeProjection singleBestProjection;
        if (parameterDescriptor == null) {
            CommonSupertypes.$$$reportNull$$$1(22);
        }
        if (typeProjections == null) {
            CommonSupertypes.$$$reportNull$$$1(23);
        }
        if (parameterDescriptor == null) {
            CommonSupertypes.$$$reportNull$$$0(22);
        }
        if (typeProjections == null) {
            CommonSupertypes.$$$reportNull$$$0(23);
        }
        if ((singleBestProjection = FlexibleTypesKt.singleBestRepresentative(typeProjections)) != null) {
            TypeProjection typeProjection = singleBestProjection;
            if (typeProjection == null) {
                CommonSupertypes.$$$reportNull$$$0(24);
            }
            if (typeProjection == null) {
                CommonSupertypes.$$$reportNull$$$1(24);
            }
            return typeProjection;
        }
        if (recursionDepth >= maxDepth) {
            TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
            if (typeProjection == null) {
                CommonSupertypes.$$$reportNull$$$0(25);
            }
            if (typeProjection == null) {
                CommonSupertypes.$$$reportNull$$$1(25);
            }
            return typeProjection;
        }
        LinkedHashSet<KotlinType> ins = new LinkedHashSet<KotlinType>();
        LinkedHashSet<KotlinType> outs = new LinkedHashSet<KotlinType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind = projection.getProjectionKind();
            if (projectionKind.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            assert (!outs.isEmpty()) : "Out projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            Variance projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            KotlinType superType2 = CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth);
            for (KotlinType upperBound : parameterDescriptor.getUpperBounds()) {
                if (TypeUtilsKt.isSubtypeOf(superType2, upperBound)) continue;
                return new StarProjectionImpl(parameterDescriptor);
            }
            return new TypeProjectionImpl(projectionKind, superType2);
        }
        if (ins != null) {
            assert (!ins.isEmpty()) : "In projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            KotlinType intersection = TypeIntersector.intersectTypes(ins);
            if (intersection == null) {
                TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
                if (typeProjection == null) {
                    CommonSupertypes.$$$reportNull$$$0(26);
                }
                if (typeProjection == null) {
                    CommonSupertypes.$$$reportNull$$$1(26);
                }
                return typeProjection;
            }
            Variance projectionKind = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            return new TypeProjectionImpl(projectionKind, intersection);
        }
        TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
        if (typeProjection == null) {
            CommonSupertypes.$$$reportNull$$$0(27);
        }
        if (typeProjection == null) {
            CommonSupertypes.$$$reportNull$$$1(27);
        }
        return typeProjection;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor2 == null) {
            CommonSupertypes.$$$reportNull$$$1(28);
        }
        if (markerSet == null) {
            CommonSupertypes.$$$reportNull$$$1(29);
        }
        if (typeConstructor2 == null) {
            CommonSupertypes.$$$reportNull$$$0(28);
        }
        if (markerSet == null) {
            CommonSupertypes.$$$reportNull$$$0(29);
        }
        markerSet.add(typeConstructor2);
        for (KotlinType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }

    @NotNull
    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull SimpleType type2, final @NotNull Map<TypeConstructor, Set<SimpleType>> constructorToAllInstances, @NotNull Set<TypeConstructor> visited2) {
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$1(30);
        }
        if (constructorToAllInstances == null) {
            CommonSupertypes.$$$reportNull$$$1(31);
        }
        if (visited2 == null) {
            CommonSupertypes.$$$reportNull$$$1(32);
        }
        if (type2 == null) {
            CommonSupertypes.$$$reportNull$$$0(30);
        }
        if (constructorToAllInstances == null) {
            CommonSupertypes.$$$reportNull$$$0(31);
        }
        if (visited2 == null) {
            CommonSupertypes.$$$reportNull$$$0(32);
        }
        List list2 = DFS.dfs(Collections.singletonList(type2), current -> {
            TypeSubstitutor substitutor2 = TypeSubstitutor.create(current);
            Collection<KotlinType> supertypes2 = current.getConstructor().getSupertypes();
            ArrayList<SimpleType> result2 = new ArrayList<SimpleType>(supertypes2.size());
            for (KotlinType supertype2 : supertypes2) {
                if (visited2.contains(supertype2.getConstructor())) continue;
                result2.add(FlexibleTypesKt.lowerIfFlexible(substitutor2.safeSubstitute(supertype2, Variance.INVARIANT)));
            }
            return result2;
        }, current -> visited2.add(current.getConstructor()), new DFS.NodeHandlerWithListResult<SimpleType, TypeConstructor>(){

            @Override
            public boolean beforeChildren(SimpleType current) {
                Set instances = constructorToAllInstances.computeIfAbsent(current.getConstructor(), k -> new LinkedHashSet());
                instances.add(current);
                return true;
            }

            @Override
            public void afterChildren(SimpleType current) {
                ((LinkedList)this.result).addFirst(current.getConstructor());
            }
        });
        if (list2 == null) {
            CommonSupertypes.$$$reportNull$$$0(33);
        }
        if (list2 == null) {
            CommonSupertypes.$$$reportNull$$$1(33);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/CommonSupertypes";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProjections";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerSet";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorToAllInstances";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/CommonSupertypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSupertype";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonSupertype";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuperTypeForInflexible";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "renderTypeFully";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonRawSupertypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSupertypeProjections";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSupertypeProjection";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "topologicallySortSuperclassesAndRecordAllInstances";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commonSupertypeForNonDenotableTypes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commonSupertype";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maxDepth";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "depth";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommonSupertype";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "commonSuperTypeForInflexible";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderTypeFully";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "classOfDeclarationDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeCommonRawSupertypes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeSupertypeProjections";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeSupertypeProjection";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "markAll";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "topologicallySortSuperclassesAndRecordAllInstances";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/CommonSupertypes";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProjections";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerSet";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorToAllInstances";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/CommonSupertypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSupertype";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonSupertype";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuperTypeForInflexible";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "renderTypeFully";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonRawSupertypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSupertypeProjections";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSupertypeProjection";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "topologicallySortSuperclassesAndRecordAllInstances";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commonSupertypeForNonDenotableTypes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commonSupertype";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maxDepth";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "depth";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommonSupertype";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "commonSuperTypeForInflexible";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderTypeFully";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "classOfDeclarationDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeCommonRawSupertypes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeSupertypeProjections";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeSupertypeProjection";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "markAll";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "topologicallySortSuperclassesAndRecordAllInstances";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

