/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lcom/intellij/psi/PsiElement;", "()V", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPsi", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "isApplicable", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnderscoredTypeArgumentSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnderscoredTypeArgumentSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,69:1\n508#2,4:70\n*S KotlinDebug\n*F\n+ 1 FirUnderscoredTypeArgumentSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker\n*L\n40#1:70,4\n*E\n"})
public final class FirUnderscoredTypeArgumentSyntaxChecker
extends FirExpressionSyntaxChecker<FirFunctionCall, PsiElement> {
    @NotNull
    public static final FirUnderscoredTypeArgumentSyntaxChecker INSTANCE = new FirUnderscoredTypeArgumentSyntaxChecker();

    private FirUnderscoredTypeArgumentSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirFunctionCall element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !((Collection)element.getTypeArguments()).isEmpty();
    }

    @Override
    public void checkPsi(@NotNull FirFunctionCall element, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection typeProjection : element.getTypeArguments()) {
            KtTypeReference typeReference;
            KtTypeProjection psiTypeArgument;
            KtSourceElement ktSourceElement = typeProjection.getSource();
            Object object = ktSourceElement != null ? KtSourceElementKt.getPsi(ktSourceElement) : null;
            KtTypeProjection ktTypeProjection = object instanceof KtTypeProjection ? (KtTypeProjection)object : null;
            if (ktTypeProjection == null || (psiTypeArgument = ktTypeProjection).getTypeReference() == null || !typeReference.isPlaceholder()) continue;
            for (KtAnnotationEntry annotation2 : typeReference.getAnnotationEntries()) {
                KtPsiSourceElement ktPsiSourceElement;
                PsiElement $this$toKtPsiSourceElement_u24default$iv = (PsiElement)annotation2;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                    ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktPsiSourceElement, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"annotations on an underscored type argument", (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    @Override
    public void checkLightTree(@NotNull FirFunctionCall element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection typeProjection : element.getTypeArguments()) {
            List<LighterASTNode> annotations2;
            KtSourceElement ktSourceElement = typeProjection.getSource();
            if (ktSourceElement == null || (ktSourceElement = ktSourceElement.getLighterASTNode()) == null) continue;
            KtSourceElement lightTreeTypeArgument = ktSourceElement;
            if (!FirUnderscoreHelpersKt.isUnderscore(String.valueOf(LightTreePositioningStrategiesKt.userType(source.getTreeStructure(), (LighterASTNode)lightTreeTypeArgument))) || LightTreePositioningStrategiesKt.annotations(source.getTreeStructure(), (LighterASTNode)lightTreeTypeArgument) == null) continue;
            for (LighterASTNode annotation2 : annotations2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)FirSourceUtilsKt.buildChildSourceElement(source, annotation2), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"annotations on an underscored type argument", (DiagnosticContext)context, null, 16, null);
            }
        }
    }
}

