/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithCandidates;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInvisibleSetter", "checkValReassignment", "checkValReassignmentOnValueParameter", "checkValReassignmentViaBackingField", "checkVariableExpected", "isInOwnersInitializer", "", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isConflictingError", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReassignmentAndInvisibleSetterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 6 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,164:1\n24#2:165\n83#3,5:166\n82#3,3:176\n87#3:180\n1747#4,3:171\n63#5:174\n60#5:175\n82#6:179\n*S KotlinDebug\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n*L\n81#1:165\n96#1:166,5\n52#1:176,3\n52#1:180\n131#1:171,3\n47#1:174\n47#1:175\n52#1:179\n*E\n"})
public final class FirReassignmentAndInvisibleSetterChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirReassignmentAndInvisibleSetterChecker INSTANCE = new FirReassignmentAndInvisibleSetterChecker();

    private FirReassignmentAndInvisibleSetterChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkInvisibleSetter(expression2, context, reporter);
        this.checkValReassignmentViaBackingField(expression2, context, reporter);
        this.checkValReassignmentOnValueParameter(expression2, context, reporter);
        this.checkVariableExpected(expression2, context, reporter);
        this.checkValReassignment(expression2, context, reporter);
    }

    private final void checkInvisibleSetter(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        block5: {
            Object object;
            KtDiagnosticFactory3<FirPropertySymbol, Visibility, CallableId> ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement;
            FirCallableSymbol callableSymbol;
            block7: {
                block6: {
                    FirRegularClassSymbol symbol2;
                    FirReference firReference = FirExpressionUtilKt.getCalleeReference(expression2);
                    FirCallableSymbol firCallableSymbol = callableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
                    if (!(callableSymbol instanceof FirPropertySymbol) || !FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression2, (FirPropertySymbol)callableSymbol)) break block5;
                    FirExpression explicitReceiver = FirExpressionUtilKt.getExplicitReceiver(expression2);
                    if (explicitReceiver instanceof FirSmartCastExpression && (symbol2 = FirHelpersKt.toRegularClassSymbol(((FirSmartCastExpression)explicitReceiver).getOriginalExpression().getTypeRef(), context.getSession())) != null) {
                        for (FirBasedSymbol<?> declarationSymbol : symbol2.getDeclarationSymbols()) {
                            if (!(declarationSymbol instanceof FirPropertySymbol) || !Intrinsics.areEqual((Object)((FirPropertySymbol)declarationSymbol).getName(), (Object)callableSymbol.getName()) || FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression2, (FirPropertySymbol)declarationSymbol)) continue;
                            return;
                        }
                    }
                    abstractKtSourceElement = expression2.getLValue().getSource();
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getINVISIBLE_SETTER();
                    object = ((FirPropertySymbol)callableSymbol).getSetterSymbol();
                    if (object == null) break block6;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)object;
                    boolean $i$f$getVisibility = false;
                    object = $this$visibility$iv.getResolvedStatus().getVisibility();
                    if (object != null) break block7;
                }
                object = Visibilities.Private.INSTANCE;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)callableSymbol, object, (Object)callableSymbol.getCallableId(), (DiagnosticContext)context, null, 64, null);
        }
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        Object object;
        FirElement firElement;
        FirBackingFieldSymbol propertySymbol;
        FirBackingFieldReference backingFieldReference;
        block7: {
            FirReference firReference = FirExpressionUtilKt.getCalleeReference(expression2);
            FirBackingFieldReference firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol = backingFieldReference.getResolvedSymbol();
            if (propertySymbol.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirPropertyAccessor)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirPropertyAccessor)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirPropertyAccessor it = (FirPropertyAccessor)firElement2;
                boolean bl = false;
                firElement = it.isGetter() ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block7;
            }
            firElement = null;
        }
        if ((object = (FirPropertyAccessor)firElement) == null || (object = ((FirPropertyAccessor)object).getSymbol()) == null) {
            return;
        }
        Object closestGetter = object;
        if (!Intrinsics.areEqual((Object)propertySymbol.getGetterSymbol(), (Object)closestGetter)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), (Object)propertySymbol, (DiagnosticContext)context, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameter(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        Object object = FirExpressionUtilKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object valueParameter2 = object;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), valueParameter2, (DiagnosticContext)context, null, 16, null);
    }

    private final void checkVariableExpected(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        block4: {
            block3: {
                FirReference calleeReference = FirExpressionUtilKt.getCalleeReference(expression2);
                if (!(FirExpressionUtilKt.unwrapLValue(expression2) instanceof FirPropertyAccessExpression)) break block3;
                FirReference firReference = calleeReference;
                if (firReference != null ? this.isConflictingError(firReference) : false) break block4;
                FirReference firReference2 = calleeReference;
                if ((firReference2 != null ? FirReferenceUtilsKt.toResolvedVariableSymbol$default(firReference2, false, 1, null) : null) != null) break block4;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVARIABLE_EXPECTED(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isConflictingError(FirReference $this$isConflictingError) {
        boolean bl;
        block10: {
            if (!FirReferenceUtilsKt.isError($this$isConflictingError)) {
                return false;
            }
            ConeDiagnostic it = ((FirDiagnosticHolder)((Object)$this$isConflictingError)).getDiagnostic();
            if (it instanceof ConeSimpleDiagnostic) {
                bl = ((ConeSimpleDiagnostic)it).getKind() == DiagnosticKind.VariableExpected;
            } else if (it instanceof ConeUnresolvedNameError) {
                bl = true;
            } else if (it instanceof ConeDiagnosticWithCandidates) {
                Iterable $this$any$iv = ((ConeDiagnosticWithCandidates)it).getCandidates();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractCandidate it2 = (AbstractCandidate)element$iv;
                        boolean bl2 = false;
                        if (!(it2.getSymbol() instanceof FirPropertySymbol)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void checkValReassignment(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        Object object = FirExpressionUtilKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object property2 = object;
        if (((FirPropertySymbol)property2).isVar()) {
            return;
        }
        if (((FirPropertySymbol)property2).isLocal() && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property2, false)) {
            return;
        }
        if (this.isInOwnersInitializer(FirExpressionUtilKt.getDispatchReceiver(expression2), context) && FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)property2, true)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), property2, (DiagnosticContext)context, null, 16, null);
    }

    private final boolean isInOwnersInitializer(FirExpression receiver, CheckerContext context) {
        Object object = receiver instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)receiver : null;
        if (object == null || (object = ((FirThisReceiverExpression)object).getCalleeReference()) == null || (object = ((FirThisReference)object).getBoundSymbol()) == null) {
            return false;
        }
        Object uninitializedThisSymbol = object;
        boolean foundInitializer = false;
        Iterator<FirDeclaration> iterator2 = context.getContainingDeclarations().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            FirDeclaration declaration = iterator2.next();
            if (!(declaration instanceof FirClass)) continue;
            FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.getOrNull(context.getContainingDeclarations(), (int)(i + 1));
            foundInitializer = (firDeclaration != null ? !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(firDeclaration) : false) ? false : foundInitializer || Intrinsics.areEqual(((FirClass)declaration).getSymbol(), (Object)uninitializedThisSymbol);
        }
        return foundInitializer;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkInvisibleSetter$shouldInvisibleSetterBeReported(CheckerContext $context, FirVariableAssignment $expression, FirPropertySymbol symbol2) {
        Object setterFir;
        Object object = symbol2.getSetterSymbol();
        if (object == null || (object = (FirPropertyAccessor)((FirBasedSymbol)object).getFir()) == null) {
            FirCallableSymbol $this$originalForSubstitutionOverride$iv = symbol2;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
            boolean $i$f$getOriginalForSubstitutionOverride2 = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            FirCallableSymbol firCallableSymbol = (FirPropertySymbol)((FirCallableSymbol)((FirPropertySymbol)(firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null)));
            object = firCallableSymbol != null && (firCallableSymbol = ((FirPropertySymbol)firCallableSymbol).getSetterSymbol()) != null ? (FirPropertyAccessor)firCallableSymbol.getFir() : null;
        }
        if ((setterFir = object) != null) {
            FirElement firElement;
            FirElement firElement2;
            FirVisibilityChecker firVisibilityChecker;
            FirMemberDeclaration firMemberDeclaration;
            FirSession firSession;
            block5: {
                void $this$findClosest_u24default$iv;
                CheckerContext checkerContext = $context;
                firSession = $context.getSession();
                firMemberDeclaration = (FirMemberDeclaration)setterFir;
                firVisibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker($context.getSession());
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement firElement3;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirFile)) {
                        firDeclaration = null;
                    }
                    if ((firElement2 = (FirElement)((FirFile)firDeclaration)) == null) continue;
                    FirElement $i$f$getOriginalForSubstitutionOverride2 = firElement3 = firElement2;
                    boolean bl = false;
                    FirElement it = $i$f$getOriginalForSubstitutionOverride2;
                    firElement2 = true ? firElement3 : null;
                    if (firElement2 == null) {
                        continue;
                    }
                    break block5;
                }
                firElement2 = null;
            }
            FirElement firElement4 = firElement = firElement2;
            Intrinsics.checkNotNull(firElement4);
            return !FirVisibilityChecker.isVisible$default(firVisibilityChecker, firMemberDeclaration, firSession, (FirFile)firElement4, $context.getContainingDeclarations(), new ExpressionReceiverValue(FirExpressionUtilKt.getDispatchReceiver($expression)), false, null, false, null, 480, null);
        }
        return false;
    }
}

