/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.extensions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.extensions.FirExtensionApiInternals;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderImplKt;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.extensions.predicate.AbstractPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.LookupPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.PredicateVisitor;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001c\u0010\u0019\u001a\u00020\u000f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0017J\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u000b0\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cache", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "declarationPredicateMatcher", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "lookupPredicateMatcher", "Lorg/jetbrains/kotlin/fir/extensions/predicate/LookupPredicate;", "registeredPluginAnnotations", "Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotations;", "fileHasPluginAnnotations", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getOwnersOfDeclaration", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getSymbolsByPredicate", "predicate", "matches", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate;", "registerAnnotatedDeclaration", "", "owners", "Lkotlinx/collections/immutable/PersistentList;", "registerOwnersDeclarations", "Cache", "Matcher", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirPredicateBasedProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1446#2,5:216\n766#2:221\n857#2,2:222\n1549#2:224\n1620#2,3:225\n1603#2,9:228\n1855#2:237\n1856#2:239\n1612#2:240\n766#2:241\n857#2,2:242\n1855#2,2:245\n1855#2,2:247\n1549#2:249\n1620#2,3:250\n1855#2,2:253\n1855#2,2:255\n1#3:238\n1#3:244\n*S KotlinDebug\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl\n*L\n39#1:216,5\n42#1:221\n42#1:222,2\n42#1:224\n42#1:225,3\n56#1:228,9\n56#1:237\n56#1:239\n56#1:240\n57#1:241\n57#1:242,2\n62#1:245,2\n66#1:247,2\n74#1:249\n74#1:250,3\n82#1:253,2\n86#1:255,2\n56#1:238\n*E\n"})
public final class FirPredicateBasedProviderImpl
extends FirPredicateBasedProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirRegisteredPluginAnnotations registeredPluginAnnotations;
    @NotNull
    private final Cache cache;
    @NotNull
    private final Matcher<DeclarationPredicate> declarationPredicateMatcher;
    @NotNull
    private final Matcher<LookupPredicate> lookupPredicateMatcher;

    public FirPredicateBasedProviderImpl(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.registeredPluginAnnotations = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session);
        this.cache = new Cache();
        this.declarationPredicateMatcher = new Matcher();
        this.lookupPredicateMatcher = new Matcher();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirBasedSymbol<?>> getSymbolsByPredicate(@NotNull LookupPredicate predicate) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirDeclaration it;
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Set<FqName> annotations2 = predicate.getAnnotations();
        if (annotations2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = annotations2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FqName it2 = (FqName)element$iv;
            boolean bl = false;
            Collection collection2 = this.cache.getDeclarationByAnnotation().get((Object)it2);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"cache.declarationByAnnotation[it]");
            Collection collection3 = this.cache.getDeclarationsUnderAnnotated().get((Object)it2);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"cache.declarationsUnderAnnotated[it]");
            Iterable list$iv = CollectionsKt.plus((Collection)collection2, (Iterable)collection3);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set declarations2 = (Set)destination$iv;
        Iterable $this$filter$iv = declarations2;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirDeclaration)element$iv$iv;
            boolean bl = false;
            AbstractPredicate abstractPredicate = predicate;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.matches(abstractPredicate, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirDeclaration)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean fileHasPluginAnnotations(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.cache.getFilesWithPluginAnnotations().contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FirExtensionApiInternals
    public void registerAnnotatedDeclaration(@NotNull FirDeclaration declaration, @NotNull PersistentList<? extends FirDeclaration> owners) {
        FqName it;
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(owners, (String)"owners");
        this.cache.getOwnersForDeclaration().put(declaration, owners);
        this.registerOwnersDeclarations(declaration, owners);
        if (declaration.getAnnotations().isEmpty()) {
            return;
        }
        Iterable iterable = declaration.getAnnotations();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FqName it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotation it2 = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (CallableIdUtilsKt.fqName(it2, this.session) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!this.registeredPluginAnnotations.getAnnotations().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it3 = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        List list2 = !((Collection)it3).isEmpty() ? $this$filter$iv : null;
        if (list2 == null) {
            return;
        }
        List matchingAnnotations = list2;
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull((List)((List)owners));
        if (firDeclaration != null) {
            FirDeclaration owner = firDeclaration;
            boolean bl4 = false;
            Iterable $this$forEach$iv = matchingAnnotations;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FqName)element$iv;
                boolean bl5 = false;
                this.cache.getDeclarationsHasAnnotated().put((Object)it, (Object)owner);
            }
            this.cache.getAnnotationsOfHasAnnotated().putAll((Object)owner, (Iterable)matchingAnnotations);
        }
        Iterable $this$forEach$iv = matchingAnnotations;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it4 = (FqName)element$iv;
            boolean bl6 = false;
            this.cache.getDeclarationByAnnotation().put((Object)it4, (Object)declaration);
        }
        this.cache.getAnnotationsOfDeclaration().putAll((Object)declaration, (Iterable)matchingAnnotations);
        Object object = CollectionsKt.first((List)((List)owners));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
        FirFile file2 = (FirFile)object;
        ((Collection)this.cache.getFilesWithPluginAnnotations()).add(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<FirBasedSymbol<?>> getOwnersOfDeclaration(@NotNull FirDeclaration declaration) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PersistentList<FirDeclaration> persistentList = this.cache.getOwnersForDeclaration().get(declaration);
        if (persistentList != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)persistentList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirDeclaration firDeclaration = (FirDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final void registerOwnersDeclarations(FirDeclaration declaration, PersistentList<? extends FirDeclaration> owners) {
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull((List)((List)owners));
        if (firDeclaration == null) {
            return;
        }
        FirDeclaration lastOwner = firDeclaration;
        Set annotationsFromLastOwner = this.cache.getAnnotationsOfDeclaration().get((Object)lastOwner);
        Set annotationsFromPreviousOwners = this.cache.getAnnotationsOfUnderAnnotated().get((Object)lastOwner);
        Intrinsics.checkNotNullExpressionValue((Object)annotationsFromLastOwner, (String)"annotationsFromLastOwner");
        Iterable $this$forEach$iv = annotationsFromLastOwner;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsParentAnnotated().put((Object)it, (Object)declaration);
        }
        this.cache.getAnnotationsOfParentAnnotated().putAll((Object)declaration, (Iterable)annotationsFromLastOwner);
        Intrinsics.checkNotNullExpressionValue((Object)annotationsFromPreviousOwners, (String)"annotationsFromPreviousOwners");
        Set allParentDeclarations = SetsKt.plus((Set)annotationsFromLastOwner, (Iterable)annotationsFromPreviousOwners);
        Iterable $this$forEach$iv2 = allParentDeclarations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            this.cache.getDeclarationsUnderAnnotated().put((Object)it, (Object)declaration);
        }
        this.cache.getAnnotationsOfUnderAnnotated().putAll((Object)declaration, (Iterable)allParentDeclarations);
    }

    @Override
    public boolean matches(@NotNull AbstractPredicate<?> predicate, @NotNull FirDeclaration declaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        AbstractPredicate<?> abstractPredicate = predicate;
        if (abstractPredicate instanceof DeclarationPredicate) {
            bl = (Boolean)((DeclarationPredicate)predicate).accept((PredicateVisitor)this.declarationPredicateMatcher, declaration);
        } else if (abstractPredicate instanceof LookupPredicate) {
            bl = (Boolean)((LookupPredicate)predicate).accept((PredicateVisitor)this.lookupPredicateMatcher, declaration);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR!\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR!\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR!\u0010\u0016\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR!\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR#\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Cache;", "", "()V", "annotationsOfDeclaration", "Lcom/google/common/collect/LinkedHashMultimap;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "getAnnotationsOfDeclaration", "()Lcom/google/common/collect/LinkedHashMultimap;", "annotationsOfHasAnnotated", "Lcom/google/common/collect/Multimap;", "getAnnotationsOfHasAnnotated", "()Lcom/google/common/collect/Multimap;", "annotationsOfParentAnnotated", "getAnnotationsOfParentAnnotated", "annotationsOfUnderAnnotated", "getAnnotationsOfUnderAnnotated", "declarationByAnnotation", "getDeclarationByAnnotation", "declarationsHasAnnotated", "getDeclarationsHasAnnotated", "declarationsParentAnnotated", "getDeclarationsParentAnnotated", "declarationsUnderAnnotated", "getDeclarationsUnderAnnotated", "filesWithPluginAnnotations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesWithPluginAnnotations", "()Ljava/util/Set;", "ownersForDeclaration", "", "Lkotlinx/collections/immutable/PersistentList;", "getOwnersForDeclaration", "()Ljava/util/Map;", "resolve"})
    private static final class Cache {
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationByAnnotation;
        @NotNull
        private final LinkedHashMultimap<FirDeclaration, FqName> annotationsOfDeclaration;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsUnderAnnotated;
        @NotNull
        private final LinkedHashMultimap<FirDeclaration, FqName> annotationsOfUnderAnnotated;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsParentAnnotated;
        @NotNull
        private final Multimap<FirDeclaration, FqName> annotationsOfParentAnnotated;
        @NotNull
        private final Multimap<FqName, FirDeclaration> declarationsHasAnnotated;
        @NotNull
        private final Multimap<FirDeclaration, FqName> annotationsOfHasAnnotated;
        @NotNull
        private final Map<FirDeclaration, PersistentList<FirDeclaration>> ownersForDeclaration;
        @NotNull
        private final Set<FirFile> filesWithPluginAnnotations;

        public Cache() {
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap, (String)"create()");
            this.declarationByAnnotation = (Multimap)linkedHashMultimap;
            LinkedHashMultimap linkedHashMultimap2 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap2, (String)"create()");
            this.annotationsOfDeclaration = linkedHashMultimap2;
            LinkedHashMultimap linkedHashMultimap3 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap3, (String)"create()");
            this.declarationsUnderAnnotated = (Multimap)linkedHashMultimap3;
            LinkedHashMultimap linkedHashMultimap4 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap4, (String)"create()");
            this.annotationsOfUnderAnnotated = linkedHashMultimap4;
            LinkedHashMultimap linkedHashMultimap5 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap5, (String)"create()");
            this.declarationsParentAnnotated = (Multimap)linkedHashMultimap5;
            LinkedHashMultimap linkedHashMultimap6 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap6, (String)"create()");
            this.annotationsOfParentAnnotated = (Multimap)linkedHashMultimap6;
            LinkedHashMultimap linkedHashMultimap7 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap7, (String)"create()");
            this.declarationsHasAnnotated = (Multimap)linkedHashMultimap7;
            LinkedHashMultimap linkedHashMultimap8 = LinkedHashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap8, (String)"create()");
            this.annotationsOfHasAnnotated = (Multimap)linkedHashMultimap8;
            this.ownersForDeclaration = new LinkedHashMap();
            this.filesWithPluginAnnotations = new LinkedHashSet();
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationByAnnotation() {
            return this.declarationByAnnotation;
        }

        @NotNull
        public final LinkedHashMultimap<FirDeclaration, FqName> getAnnotationsOfDeclaration() {
            return this.annotationsOfDeclaration;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsUnderAnnotated() {
            return this.declarationsUnderAnnotated;
        }

        @NotNull
        public final LinkedHashMultimap<FirDeclaration, FqName> getAnnotationsOfUnderAnnotated() {
            return this.annotationsOfUnderAnnotated;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsParentAnnotated() {
            return this.declarationsParentAnnotated;
        }

        @NotNull
        public final Multimap<FirDeclaration, FqName> getAnnotationsOfParentAnnotated() {
            return this.annotationsOfParentAnnotated;
        }

        @NotNull
        public final Multimap<FqName, FirDeclaration> getDeclarationsHasAnnotated() {
            return this.declarationsHasAnnotated;
        }

        @NotNull
        public final Multimap<FirDeclaration, FqName> getAnnotationsOfHasAnnotated() {
            return this.annotationsOfHasAnnotated;
        }

        @NotNull
        public final Map<FirDeclaration, PersistentList<FirDeclaration>> getOwnersForDeclaration() {
            return this.ownersForDeclaration;
        }

        @NotNull
        public final Set<FirFile> getFilesWithPluginAnnotations() {
            return this.filesWithPluginAnnotations;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00052\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0002J\"\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00052\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0002J\"\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00052\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00052\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\nH\u0002J#\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010#J#\u0010$\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010&J#\u0010'\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher;", "P", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate;", "Lorg/jetbrains/kotlin/fir/extensions/predicate/PredicateVisitor;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl;)V", "matchHasAnnotatedWith", "declaration", "annotations", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "matchParentWith", "matchUnder", "matchWith", "visitAncestorAnnotatedWith", "predicate", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AncestorAnnotatedWith;", "data", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AncestorAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAnd", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$And;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$And;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$AnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitHasAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$HasAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$HasAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitMetaAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$MetaAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$MetaAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitOr", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$Or;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$Or;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitParentAnnotatedWith", "Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$ParentAnnotatedWith;", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate$ParentAnnotatedWith;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "visitPredicate", "(Lorg/jetbrains/kotlin/fir/extensions/predicate/AbstractPredicate;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Ljava/lang/Boolean;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirPredicateBasedProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,215:1\n1747#2,3:216\n1747#2,3:220\n1747#2,3:223\n1747#2,3:226\n1747#2,3:229\n1747#2,3:232\n51#3:219\n*S KotlinDebug\n*F\n+ 1 FirPredicateBasedProviderImpl.kt\norg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProviderImpl$Matcher\n*L\n142#1:216,3\n151#1:220,3\n153#1:223,3\n157#1:226,3\n161#1:229,3\n165#1:232,3\n150#1:219\n*E\n"})
    private final class Matcher<P extends AbstractPredicate<P>>
    extends PredicateVisitor<P, Boolean, FirDeclaration> {
        @Override
        @NotNull
        public Boolean visitPredicate(@NotNull AbstractPredicate<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            throw new IllegalStateException("Should not be there");
        }

        @Override
        @NotNull
        public Boolean visitAnd(@NotNull AbstractPredicate.And<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return (Boolean)predicate.getA().accept(this, (FirDeclaration)data2) != false && (Boolean)predicate.getB().accept(this, (FirDeclaration)data2) != false;
        }

        @Override
        @NotNull
        public Boolean visitOr(@NotNull AbstractPredicate.Or<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return (Boolean)predicate.getA().accept(this, (FirDeclaration)data2) != false || (Boolean)predicate.getB().accept(this, (FirDeclaration)data2) != false;
        }

        @Override
        @NotNull
        public Boolean visitAnnotatedWith(@NotNull AbstractPredicate.AnnotatedWith<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.matchWith(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitAncestorAnnotatedWith(@NotNull AbstractPredicate.AncestorAnnotatedWith<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.matchUnder(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitParentAnnotatedWith(@NotNull AbstractPredicate.ParentAnnotatedWith<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.matchParentWith(data2, predicate.getAnnotations());
        }

        @Override
        @NotNull
        public Boolean visitHasAnnotatedWith(@NotNull AbstractPredicate.HasAnnotatedWith<P> predicate, @NotNull FirDeclaration data2) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.matchHasAnnotatedWith(data2, predicate.getAnnotations());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Boolean visitMetaAnnotatedWith(@NotNull AbstractPredicate.MetaAnnotatedWith<P> predicate, @NotNull FirDeclaration data2) {
            boolean bl;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                Iterable iterable = data2.getAnnotations();
                FirPredicateBasedProviderImpl firPredicateBasedProviderImpl = FirPredicateBasedProviderImpl.this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation annotation2 = (FirAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!FirPredicateBasedProviderImplKt.markedWithMetaAnnotation(annotation2, firPredicateBasedProviderImpl.session, data2, predicate.getMetaAnnotations(), predicate.getIncludeItself())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block9: {
                Iterable $this$any$iv;
                if (declaration instanceof FirClass) {
                    Object $this$isLocal$iv = (FirClassLikeDeclaration)declaration;
                    boolean $i$f$isLocal2 = false;
                    if (((FirClassLikeDeclaration)$this$isLocal$iv).getSymbol().getClassId().isLocal()) {
                        boolean bl2;
                        block8: {
                            $this$isLocal$iv = declaration.getAnnotations();
                            FirPredicateBasedProviderImpl $i$f$isLocal2 = FirPredicateBasedProviderImpl.this;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    FirAnnotation it = (FirAnnotation)element$iv;
                                    boolean bl3 = false;
                                    if (!CollectionsKt.contains((Iterable)annotations2, (Object)CallableIdUtilsKt.fqName(it, $i$f$isLocal2.session))) continue;
                                    bl2 = true;
                                    break block8;
                                }
                                bl2 = false;
                            }
                        }
                        return bl2;
                    }
                }
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfDeclaration().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cache.annotationsOfDeclaration[declaration]");
                $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl4 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchUnder(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Set set = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfUnderAnnotated().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cache.annotationsOfUnderAnnotated[declaration]");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchParentWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Collection collection = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfParentAnnotated().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"cache.annotationsOfParentAnnotated[declaration]");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchHasAnnotatedWith(FirDeclaration declaration, Set<FqName> annotations2) {
            boolean bl;
            block3: {
                Collection collection = FirPredicateBasedProviderImpl.this.cache.getAnnotationsOfHasAnnotated().get((Object)declaration);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"cache.annotationsOfHasAnnotated[declaration]");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName it = (FqName)element$iv;
                        boolean bl2 = false;
                        if (!annotations2.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

