/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageTypeRefChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageTypeRefChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,61:1\n21#2,4:62\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageTypeRefChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker\n*L\n34#1:62,4\n*E\n"})
public final class FirOptInUsageTypeRefChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirOptInUsageTypeRefChecker INSTANCE = new FirOptInUsageTypeRefChecker();

    private FirOptInUsageTypeRefChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object object;
        FirAnnotation lastAnnotationCall;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = source = typeRef.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType coneType = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneType.getLookupTag(), context.getSession());
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)symbol2, FirResolvePhase.STATUS);
        ClassId classId = symbol2.getClassId();
        Object object2 = CollectionsKt.lastOrNull(context.getQualifiedAccessOrAssignmentsOrAnnotationCalls());
        FirAnnotation firAnnotation = lastAnnotationCall = object2 instanceof FirAnnotation ? (FirAnnotation)object2 : null;
        if (lastAnnotationCall == null || lastAnnotationCall.getAnnotationTypeRef() != typeRef) {
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) || Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
            } else if (symbol2 instanceof FirRegularClassSymbol && FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((FirRegularClassSymbol)symbol2).getFir(), OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), context.getSession()) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context, null, 8, null);
            }
        }
        FirClass firClass = (object = CollectionsKt.lastOrNull(context.getContainingDeclarations())) instanceof FirClass ? (FirClass)object : null;
        List list2 = firClass != null ? firClass.getSuperTypeRefs() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        boolean isSupertypeRef = list2.contains(typeRef);
        FirOptInUsageBaseChecker $this$check_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set<FirOptInUsageBaseChecker.Experimentality> classifierExperimentalities = isSupertypeRef ? $this$check_u24lambda_u240.loadExperimentalitiesFromSupertype(symbol2, context) : $this$check_u24lambda_u240.loadExperimentalities((FirBasedSymbol)symbol2, context, false, null);
        Set experimentalities = SetsKt.plus(classifierExperimentalities, (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromConeArguments(context, ArraysKt.toList((Object[])coneType.getTypeArguments())));
        $this$check_u24lambda_u240.reportNotAcceptedExperimentalities(experimentalities, typeRef, context, reporter);
    }
}

