/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a-\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0018H\u0082\b\u001a\u001e\u0010\u0019\u001a\u00020\u0001*\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u001e\u0010\u001b\u001a\u00020\u0001*\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0012\u0010!\u001a\u00020\u0001*\u00020\"2\u0006\u0010\u001f\u001a\u00020 \u001a\u0010\u0010#\u001a\u0004\u0018\u00010$*\u0006\u0012\u0002\b\u00030%\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u001c\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u001c\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0010\u00a8\u0006&"}, d2={"canHaveOpenMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "hasExplicitReturnType", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getHasExplicitReturnType", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isExtensionMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "isLocalMember", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isInsideExpectClass", "containingClass", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyExpect", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isEffectivelyExternal", "isEffectivelyFinal", "isTypedEqualsInValueClass", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "needsMultiFieldValueClassFlattening", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\ndeclarationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n39#1:135\n40#1:137\n39#1:141\n40#1:143\n34#2:136\n42#2:142\n17#2,2:150\n57#2:152\n17#2,2:154\n34#2:156\n42#2:157\n42#2:158\n1747#3,3:138\n1747#3,3:144\n1747#3,3:147\n37#4:153\n80#5:159\n98#5:160\n66#5:161\n1#6:162\n*S KotlinDebug\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n*L\n26#1:135\n26#1:137\n30#1:141\n30#1:143\n26#1:136\n30#1:142\n44#1:150,2\n46#1:152\n50#1:154,2\n57#1:156\n66#1:157\n76#1:158\n26#1:138,3\n30#1:144,3\n40#1:147,3\n46#1:153\n93#1:159\n94#1:160\n119#1:161\n*E\n"})
public final class DeclarationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirClass containingClass, @NotNull CheckerContext context) {
        boolean bl;
        boolean $i$f$isExpect;
        FirMemberDeclaration $this$isExpect$iv;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExpect$iv = klass;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExpect$iv = klass;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirClass containingClass, @NotNull CheckerContext context) {
        boolean bl;
        boolean $i$f$isExternal;
        FirMemberDeclaration $this$isExternal$iv;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExternal$iv = klass;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExternal$iv = klass;
                    $i$f$isExternal = false;
                    if ($this$isExternal$iv.getStatus().isExternal()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInsideSpecificClass(FirClass containingClass, CheckerContext context, Function1<? super FirClass, Boolean> predicate) {
        boolean bl;
        boolean $i$f$isInsideSpecificClass = false;
        if ((Boolean)predicate.invoke((Object)containingClass) != false) return true;
        Iterable $this$any$iv = CollectionsKt.asReversed(context.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if (it instanceof FirRegularClass && ((Boolean)predicate.invoke((Object)it)).booleanValue()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyFinal(@NotNull FirMemberDeclaration $this$isEffectivelyFinal, @NotNull CheckerContext context) {
        Modality modality$iv;
        Object modality$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyFinal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FirMemberDeclaration $this$isFinal$iv = $this$isEffectivelyFinal;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getStatus().getModality();
        if (modality == null ? true : (modality$iv2 = modality) == Modality.FINAL) {
            return true;
        }
        modality$iv2 = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        FirRegularClass firRegularClass = modality$iv2 instanceof FirRegularClass ? (FirRegularClass)modality$iv2 : null;
        if (firRegularClass == null) {
            return true;
        }
        FirRegularClass containingClass = firRegularClass;
        FirClass $this$isEnumClass$iv = containingClass;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            return false;
        }
        FirMemberDeclaration $this$isFinal$iv2 = containingClass;
        boolean $i$f$isFinal2 = false;
        Modality modality2 = $this$isFinal$iv2.getStatus().getModality();
        return modality2 == null ? true : (modality$iv = modality2) == Modality.FINAL;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirClass containingClass, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExpect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExpectClass(containingClass, context);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirClass containingClass, @NotNull CheckerContext context) {
        block9: {
            block10: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isExternal;
                Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
                boolean $i$f$isExternal2 = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof FirPropertyAccessor) {
                    Object object = CollectionsKt.last(context.getContainingDeclarations());
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirProperty");
                    FirProperty property2 = (FirProperty)object;
                    return DeclarationUtilsKt.isEffectivelyExternal(property2, containingClass, context);
                }
                if (!($this$isEffectivelyExternal instanceof FirProperty)) break block9;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getGetter();
                if (firPropertyAccessor != null) {
                    FirMemberDeclaration $this$isExternal$iv2 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl2 = $this$isExternal$iv2.getStatus().isExternal();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block9;
                if (!((FirProperty)$this$isEffectivelyExternal).isVar()) break block10;
                FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$isEffectivelyExternal).getSetter();
                if (firPropertyAccessor2 != null) {
                    FirMemberDeclaration $this$isExternal$iv3 = firPropertyAccessor2;
                    $i$f$isExternal = false;
                    bl = $this$isExternal$iv3.getStatus().isExternal();
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExternalClass(containingClass, context);
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveOpenMembers, (String)"<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalMember, (String)"<this>");
        return DeclarationUtilsKt.isLocalMember($this$isLocalMember.getSymbol());
    }

    public static final boolean isLocalMember(@NotNull FirBasedSymbol<?> $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isLocalMember, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isLocalMember;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = ((FirPropertySymbol)$this$isLocalMember).isLocal();
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol $this$isLocal$iv = (FirNamedFunctionSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual((Object)$this$isLocal$iv.getRawStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableDeclaration $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionMember, (String)"<this>");
        return DeclarationUtilsKt.isExtensionMember($this$isExtensionMember.getSymbol());
    }

    public static final boolean isExtensionMember(@NotNull FirCallableSymbol<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, (String)"<this>");
        return $this$isExtensionMember.getResolvedReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }

    @Nullable
    public static final FirConstructorSymbol primaryConstructorSymbol(@NotNull FirClassSymbol<?> $this$primaryConstructorSymbol) {
        Intrinsics.checkNotNullParameter($this$primaryConstructorSymbol, (String)"<this>");
        for (FirBasedSymbol<?> declarationSymbol : $this$primaryConstructorSymbol.getDeclarationSymbols()) {
            if (!(declarationSymbol instanceof FirConstructorSymbol) || !((FirConstructorSymbol)declarationSymbol).isPrimary()) continue;
            return (FirConstructorSymbol)declarationSymbol;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTypedEqualsInValueClass(@NotNull FirSimpleFunction $this$isTypedEqualsInValueClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypedEqualsInValueClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$isTypedEqualsInValueClass);
        Object object = coneClassLikeLookupTag;
        if (coneClassLikeLookupTag == null) return false;
        FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, session);
        object = firRegularClassSymbol;
        if (firRegularClassSymbol == null) return false;
        Object $this$isTypedEqualsInValueClass_u24lambda_u245 = object;
        boolean bl = false;
        ConeClassLikeType valueClassStarProjection = ConeTypeUtilsKt.replaceArgumentsWithStarProjections(ScopeUtilsKt.defaultType((FirClassSymbol)$this$isTypedEqualsInValueClass_u24lambda_u245));
        FirSimpleFunction $this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244 = $this$isTypedEqualsInValueClass;
        boolean bl2 = false;
        if (!$this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getContextReceivers().isEmpty()) return false;
        if ($this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getReceiverParameter() != null) return false;
        if (!Intrinsics.areEqual((Object)$this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        FirClassLikeSymbol $this$isInline$iv = (FirClassLikeSymbol)$this$isTypedEqualsInValueClass_u24lambda_u245;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getRawStatus().isInline()) return false;
        if ($this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getValueParameters().size() != 1) return false;
        if (!FirTypeUtilsKt.isBoolean($this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getReturnTypeRef())) {
            if (!FirTypeUtilsKt.isNothing($this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getReturnTypeRef())) return false;
        }
        ConeKotlinType it = FirTypeUtilsKt.getConeType($this$isTypedEqualsInValueClass_u24lambda_u245_u24lambda_u244.getValueParameters().get(0).getReturnTypeRef());
        boolean bl3 = false;
        if (!(it instanceof ConeClassLikeType)) return false;
        if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.replaceArgumentsWithStarProjections((ConeClassLikeType)it), (Object)valueClassStarProjection)) return false;
        return true;
    }

    public static final boolean needsMultiFieldValueClassFlattening(@NotNull FirTypeRef $this$needsMultiFieldValueClassFlattening, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$needsMultiFieldValueClassFlattening, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeInferenceContext $this$needsMultiFieldValueClassFlattening_u24lambda_u246 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$needsMultiFieldValueClassFlattening_u24lambda_u246.isMultiFieldValueClass($this$needsMultiFieldValueClassFlattening_u24lambda_u246.typeConstructor(FirTypeUtilsKt.getConeType($this$needsMultiFieldValueClassFlattening))) && !ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType($this$needsMultiFieldValueClassFlattening));
    }

    public static final boolean getHasExplicitReturnType(@NotNull FirCallableSymbol<?> $this$hasExplicitReturnType) {
        Intrinsics.checkNotNullParameter($this$hasExplicitReturnType, (String)"<this>");
        FirResolvedTypeRef returnTypeRef = $this$hasExplicitReturnType.getResolvedReturnTypeRef();
        return returnTypeRef.getDelegatedTypeRef() != null || returnTypeRef instanceof FirImplicitUnitTypeRef;
    }
}

