/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectActualInTheSameModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "declarationSource", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "getDeclarationSource", "(Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nExpectActualInTheSameModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualInTheSameModuleChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectActualInTheSameModuleChecker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n76#2:68\n96#2,5:69\n1#3:74\n1726#4,3:75\n*S KotlinDebug\n*F\n+ 1 ExpectActualInTheSameModuleChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectActualInTheSameModuleChecker\n*L\n30#1:68\n30#1:69,5\n52#1:75,3\n*E\n"})
public final class ExpectActualInTheSameModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final ExpectActualInTheSameModuleChecker INSTANCE = new ExpectActualInTheSameModuleChecker();

    private ExpectActualInTheSameModuleChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        List list2;
        ModuleDescriptor module;
        block21: {
            block20: {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
                    return;
                }
                if (!(descriptor2 instanceof MemberDescriptor)) {
                    return;
                }
                if (!(declaration instanceof KtNamedDeclaration)) {
                    return;
                }
                if (!((MemberDescriptor)descriptor2).isExpect()) {
                    return;
                }
                if (!(((MemberDescriptor)descriptor2).getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
                    return;
                }
                module = DescriptorUtilsKt.getModule(descriptor2);
                list2 = ExpectedActualResolver.findActualForExpected$default(ExpectedActualResolver.INSTANCE, (MemberDescriptor)descriptor2, module, null, 4, null);
                if (list2 == null) break block20;
                List $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                Map map = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    Iterable list$iv$iv = (List)it.getValue();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List p0 = $i$f$flatMap = (List)destination$iv$iv;
                boolean bl = false;
                list2 = !((Collection)p0).isEmpty() ? $i$f$flatMap : null;
                if (list2 != null) break block21;
            }
            return;
        }
        List actuals = list2;
        if (TargetPlatformKt.isCommon(module.getPlatform())) {
            boolean bl;
            block19: {
                Iterable $this$all$iv = actuals;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MemberDescriptor it = (MemberDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(it), (Object)module)) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        } else {
            KtFile ktFile = ((KtNamedDeclaration)declaration).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"declaration.containingKtFile");
            if (Intrinsics.areEqual((Object)IsCommonSourceKt.isCommonSource(ktFile), (Object)true)) {
                return;
            }
        }
        context.getTrace().report(Errors.EXPECT_AND_ACTUAL_IN_THE_SAME_MODULE.on((KtNamedDeclaration)declaration, (MemberDescriptor)descriptor2));
        for (MemberDescriptor actual : actuals) {
            KtNamedDeclaration actualSource;
            if (this.getDeclarationSource(actual) == null) continue;
            context.getTrace().report(Errors.EXPECT_AND_ACTUAL_IN_THE_SAME_MODULE.on((KtNamedDeclaration)((PsiElement)actualSource), (MemberDescriptor)descriptor2));
        }
    }

    private final KtNamedDeclaration getDeclarationSource(MemberDescriptor $this$declarationSource) {
        SourceElement sourceElement = $this$declarationSource.getSource();
        KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
        KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
        return ktElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktElement : null;
    }
}

