/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u0002H\u0017\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0005J/\u0010#\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010$\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020\u0005J\b\u0010*\u001a\u0004\u0018\u00010\u0005J\u0006\u0010+\u001a\u00020\u0014J\u0006\u0010,\u001a\u00020\u0014J\b\u0010-\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u0011J\u0006\u00101\u001a\u00020\u000eJ\u0016\u00102\u001a\u00020\f2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J'\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020:09\u00a2\u0006\u0002\b;J\u001c\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020:0&J6\u0010>\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\f2\u0006\u0010?\u001a\u0002H\u00172\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020:09\u00a2\u0006\u0002\b;\u00a2\u0006\u0002\u0010@J8\u0010A\u001a\u0002H\u0017\"\n\b\u0000\u0010\u0017*\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u0002H\u00172\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020:09\u00a2\u0006\u0002\b;\u00a2\u0006\u0002\u0010BJ3\u0010C\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u00122\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020:09\u00a2\u0006\u0002\b;J)\u0010E\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\b\u0010F\u001a\u0004\u0018\u00010\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&\u00a2\u0006\u0002\u0010GJ)\u0010H\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\b\u0010F\u001a\u0004\u0018\u00010\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170&\u00a2\u0006\u0002\u0010GR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "", "()V", "classStack", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "containingFirClassStack", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "currentlyGeneratedDelegatedConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "functionStack", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "parentStack", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "propertyStack", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "safeCallSubjectVariableStack", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "whenSubjectVariableStack", "applyParentFromStackTo", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "containerFirClass", "containingFileIfAny", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "defaultConversionTypeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irClass", "forDelegatingConstructorCall", "constructor", "f", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getConstructorForCurrentlyGeneratedDelegatedConstructor", "itClass", "lastClass", "lastSafeCallSubject", "lastWhenSubject", "parent", "parentAccessorOfPropertyFromStack", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "property", "parentFromStack", "returnTarget", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "withClass", "klass", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "withContainingFirClass", "containingFirClass", "withFunction", "function", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "withParent", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "withProperty", "firProperty", "withSafeCallSubject", "subject", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withWhenSubject", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrConversionScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConversionScope.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class Fir2IrConversionScope {
    @NotNull
    private final List<IrDeclarationParent> parentStack = new ArrayList();
    @NotNull
    private final List<FirClass> containingFirClassStack = new ArrayList();
    @NotNull
    private final Map<IrClass, IrConstructor> currentlyGeneratedDelegatedConstructors = new LinkedHashMap();
    @NotNull
    private final List<IrFunction> functionStack = new ArrayList();
    @NotNull
    private final List<Pair<IrProperty, FirProperty>> propertyStack = new ArrayList();
    @NotNull
    private final List<IrClass> classStack = new ArrayList();
    @NotNull
    private final List<IrVariable> whenSubjectVariableStack = new ArrayList();
    @NotNull
    private final List<IrVariable> safeCallSubjectVariableStack = new ArrayList();

    public final <T extends IrDeclarationParent> T withParent(T parent2, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (parent2 == null) {
            return parent2;
        }
        ((Collection)this.parentStack).add(parent2);
        f.invoke(parent2);
        this.parentStack.remove(this.parentStack.size() - 1);
        return parent2;
    }

    public final <T> T forDelegatingConstructorCall(@NotNull IrConstructor constructor2, @NotNull IrClass irClass2, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.currentlyGeneratedDelegatedConstructors.put(irClass2, constructor2);
        Object result2 = f.invoke();
        this.currentlyGeneratedDelegatedConstructors.remove(irClass2);
        return (T)result2;
    }

    @Nullable
    public final IrConstructor getConstructorForCurrentlyGeneratedDelegatedConstructor(@NotNull IrClass itClass) {
        Intrinsics.checkNotNullParameter((Object)itClass, (String)"itClass");
        return this.currentlyGeneratedDelegatedConstructors.get(itClass);
    }

    @Nullable
    public final IrFile containingFileIfAny() {
        Object object = CollectionsKt.getOrNull(this.parentStack, (int)0);
        return object instanceof IrFile ? (IrFile)object : null;
    }

    public final void withContainingFirClass(@NotNull FirClass containingFirClass, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)containingFirClass, (String)"containingFirClass");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        ((Collection)this.containingFirClassStack).add(containingFirClass);
        f.invoke();
        this.containingFirClassStack.remove(this.containingFirClassStack.size() - 1);
    }

    @NotNull
    public final IrDeclarationParent parentFromStack() {
        return (IrDeclarationParent)CollectionsKt.last(this.parentStack);
    }

    @Nullable
    public final IrSimpleFunction parentAccessorOfPropertyFromStack(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        for (IrDeclarationParent parent2 : CollectionsKt.asReversedMutable(this.parentStack)) {
            IrDeclarationParent irDeclarationParent = parent2;
            if (Intrinsics.areEqual((Object)irDeclarationParent, (Object)property2.getGetter())) {
                return property2.getGetter();
            }
            if (!Intrinsics.areEqual((Object)irDeclarationParent, (Object)property2.getSetter())) continue;
            return property2.getSetter();
        }
        return null;
    }

    @NotNull
    public final <T extends IrDeclaration> T applyParentFromStackTo(@NotNull T declaration) {
        Intrinsics.checkNotNullParameter(declaration, (String)"declaration");
        declaration.setParent((IrDeclarationParent)CollectionsKt.last(this.parentStack));
        return declaration;
    }

    @Nullable
    public final FirClass containerFirClass() {
        return (FirClass)CollectionsKt.lastOrNull(this.containingFirClassStack);
    }

    @NotNull
    public final <T extends IrFunction> T withFunction(@NotNull T function2, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        ((Collection)this.functionStack).add(function2);
        f.invoke(function2);
        this.functionStack.remove(this.functionStack.size() - 1);
        return function2;
    }

    @NotNull
    public final IrProperty withProperty(@NotNull IrProperty property2, @Nullable FirProperty firProperty, @NotNull Function1<? super IrProperty, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        ((Collection)this.propertyStack).add(TuplesKt.to((Object)property2, (Object)firProperty));
        f.invoke((Object)property2);
        this.propertyStack.remove(this.propertyStack.size() - 1);
        return property2;
    }

    public static /* synthetic */ IrProperty withProperty$default(Fir2IrConversionScope fir2IrConversionScope, IrProperty irProperty2, FirProperty firProperty, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            firProperty = null;
        }
        return fir2IrConversionScope.withProperty(irProperty2, firProperty, (Function1<? super IrProperty, Unit>)function1);
    }

    @NotNull
    public final IrClass withClass(@NotNull IrClass klass, @NotNull Function1<? super IrClass, Unit> f) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        ((Collection)this.classStack).add(klass);
        f.invoke((Object)klass);
        this.classStack.remove(this.classStack.size() - 1);
        return klass;
    }

    public final <T> T withWhenSubject(@Nullable IrVariable subject, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (subject != null) {
            ((Collection)this.whenSubjectVariableStack).add(subject);
        }
        Object result2 = f.invoke();
        if (subject != null) {
            this.whenSubjectVariableStack.remove(this.whenSubjectVariableStack.size() - 1);
        }
        return (T)result2;
    }

    public final <T> T withSafeCallSubject(@Nullable IrVariable subject, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (subject != null) {
            ((Collection)this.safeCallSubjectVariableStack).add(subject);
        }
        Object result2 = f.invoke();
        if (subject != null) {
            this.safeCallSubjectVariableStack.remove(this.safeCallSubjectVariableStack.size() - 1);
        }
        return (T)result2;
    }

    @NotNull
    public final IrFunction returnTarget(@NotNull FirReturnExpression expression2, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrFunction irFunction2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
        FirFunction firTarget = expression2.getTarget().getLabeledElement();
        if (firTarget instanceof FirConstructor) {
            irFunction2 = Fir2IrDeclarationStorage.getCachedIrConstructor$default(declarationStorage, (FirConstructor)firTarget, null, 2, null);
        } else if (firTarget instanceof FirPropertyAccessor) {
            IrFunction answer = null;
            for (Pair pair : CollectionsKt.asReversedMutable(this.propertyStack)) {
                FirProperty firProperty;
                IrProperty property2 = (IrProperty)pair.component1();
                FirProperty firProperty2 = firProperty = (FirProperty)pair.component2();
                if ((firProperty2 != null ? firProperty2.getGetter() : null) == firTarget) {
                    answer = property2.getGetter();
                    continue;
                }
                FirProperty firProperty3 = firProperty;
                if ((firProperty3 != null ? firProperty3.getSetter() : null) != firTarget) continue;
                answer = property2.getSetter();
            }
            irFunction2 = answer;
        } else {
            irFunction2 = declarationStorage.getCachedIrFunction(firTarget);
        }
        IrFunction irTarget = irFunction2;
        for (IrFunction potentialTarget : CollectionsKt.asReversedMutable(this.functionStack)) {
            if (!Intrinsics.areEqual((Object)potentialTarget, (Object)irTarget)) continue;
            return potentialTarget;
        }
        return (IrFunction)CollectionsKt.last(this.functionStack);
    }

    @Nullable
    public final IrDeclarationParent parent() {
        return (IrDeclarationParent)CollectionsKt.lastOrNull(this.parentStack);
    }

    @NotNull
    public final ConversionTypeContext defaultConversionTypeContext() {
        IrDeclarationParent irDeclarationParent = this.parent();
        IrFunction irFunction2 = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
        return (irFunction2 != null ? AdditionalIrUtilsKt.isSetter(irFunction2) : false) ? ConversionTypeContext.Companion.getIN_SETTER$fir2ir() : ConversionTypeContext.Companion.getDEFAULT$fir2ir();
    }

    @Nullable
    public final IrValueParameter dispatchReceiverParameter(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        for (IrFunction function2 : CollectionsKt.asReversedMutable(this.functionStack)) {
            IrValueParameter irValueParameter;
            if (!Intrinsics.areEqual((Object)IrUtilsKt.getParentClassOrNull(function2), (Object)irClass2)) continue;
            if (function2 instanceof IrConstructor && irClass2.isInner() && (irValueParameter = irClass2.getThisReceiver()) != null) {
                IrValueParameter it = irValueParameter;
                boolean bl = false;
                return it;
            }
            irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter == null) continue;
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            return it;
        }
        return irClass2.getThisReceiver();
    }

    @Nullable
    public final IrClass lastClass() {
        return (IrClass)CollectionsKt.lastOrNull(this.classStack);
    }

    @NotNull
    public final IrVariable lastWhenSubject() {
        return (IrVariable)CollectionsKt.last(this.whenSubjectVariableStack);
    }

    @NotNull
    public final IrVariable lastSafeCallSubject() {
        return (IrVariable)CollectionsKt.last(this.safeCallSubjectVariableStack);
    }
}

