/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,68:1\n1774#2,4:69\n37#3:73\n34#4:74\n*S KotlinDebug\n*F\n+ 1 FirJsNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker\n*L\n24#1:69,4\n38#1:73\n39#1:74\n*E\n"})
public final class FirJsNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsNameChecker INSTANCE = new FirJsNameChecker();

    private FirJsNameChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        KtSourceElement jsNameSource;
        block21: {
            block20: {
                boolean $i$f$isOverride;
                Object $this$isOverride$iv;
                block19: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    if (declaration instanceof FirProperty) {
                        int namedAccessorCount;
                        int n;
                        Object[] objectArray = new FirPropertyAccessorSymbol[2];
                        FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
                        objectArray[0] = firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
                        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
                        objectArray[1] = firPropertyAccessor2 != null ? firPropertyAccessor2.getSymbol() : null;
                        List accessors = CollectionsKt.listOfNotNull((Object[])objectArray);
                        Iterable $this$count$iv = accessors;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                FirPropertyAccessorSymbol it = (FirPropertyAccessorSymbol)element$iv;
                                boolean bl = false;
                                if (!(FirJsHelpersKt.getJsName(it, context.getSession()) != null) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = namedAccessorCount = count$iv;
                        }
                        if (namedAccessorCount > 0 && namedAccessorCount < accessors.size()) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getJS_NAME_IS_NOT_ON_ALL_ACCESSORS(), (DiagnosticContext)context, null, 8, null);
                        }
                    }
                    FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JsStandardClassIds.Annotations.JsName, context.getSession());
                    if (firAnnotation == null) {
                        return;
                    }
                    FirAnnotation jsName = firAnnotation;
                    KtSourceElement ktSourceElement = jsName.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = jsNameSource = declaration.getSource();
                    }
                    if (FirHelpersKt.getAnnotationStringParameter(declaration.getSymbol(), JsStandardClassIds.Annotations.JsNative, context.getSession()) != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_NAMED_NATIVE(), (DiagnosticContext)context, null, 8, null);
                    }
                    if (!(declaration instanceof FirCallableDeclaration)) break block19;
                    $this$isOverride$iv = (FirMemberDeclaration)declaration;
                    $i$f$isOverride = false;
                    if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) break block20;
                }
                if (!(declaration instanceof FirPropertyAccessor)) break block21;
                $this$isOverride$iv = ((FirPropertyAccessor)declaration).getPropertySymbol();
                $i$f$isOverride = false;
                if (!((FirCallableSymbol)$this$isOverride$iv).getRawStatus().isOverride()) break block21;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
        }
        if ((firDeclaration = declaration) instanceof FirConstructor) {
            if (((FirConstructor)declaration).isPrimary()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_PRIMARY_CONSTRUCTOR_PROHIBITED(), (DiagnosticContext)context, null, 8, null);
            }
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            FirPropertySymbol property2 = ((FirPropertyAccessor)declaration).getPropertySymbol();
            if (FirJsHelpersKt.getJsName(property2, context.getSession()) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_ACCESSOR_AND_PROPERTY(), (DiagnosticContext)context, null, 8, null);
            }
        } else if (firDeclaration instanceof FirProperty && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_EXTENSION_PROPERTY(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

