/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguouslyResolvedAnnotationFromPlugin;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.TransformUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeWithSubstitutionKt;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u0002012\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00102\u001a\u00020\"2\u0006\u00103\u001a\u0002042\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00105\u001a\u00020\"2\u0006\u00106\u001a\u0002072\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010G\u001a\u00020+2\u0006\u0010*\u001a\u00020+2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010K\u001a\u00020\"2\u0006\u0010L\u001a\u00020M2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020R2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020D2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010W\u001a\u00020\"2\u0006\u0010X\u001a\u00020Y2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010Z\u001a\u00020&2\u0006\u0010[\u001a\u00020\\H\u0002J,\u0010]\u001a\u0002H^\"\u0004\b\u0000\u0010^2\u0006\u0010_\u001a\u00020\u00112\u000e\b\u0004\u0010`\u001a\b\u0012\u0004\u0012\u0002H^0aH\u0082\b\u00a2\u0006\u0002\u0010bJ$\u0010c\u001a\u0002H^\"\u0004\b\u0000\u0010^2\u000e\b\u0004\u0010d\u001a\b\u0012\u0004\u0012\u0002H^0aH\u0082\b\u00a2\u0006\u0002\u0010eJ\f\u0010f\u001a\u00020&*\u00020gH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "initialScopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "initialCurrentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/collections/ArrayDeque;)V", "currentDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "currentFile", "scopes", "", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "towerScope", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "hasSupertypePathToParameter", "", "currentTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "visited", "", "resolveClassContent", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "data", "resolveConstructedTypeRefForDelegatedConstructorCall", "", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "setAccessorTypesByPropertyType", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "transformAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "enumEntry", "transformField", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "transformFile", "file", "transformImplicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformProperty", "transformReceiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "receiverParameter", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "typeRef", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "unboundCyclesInTypeParametersSupertypes", "typeParametersOwner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "withDeclaration", "T", "declaration", "action", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withScopeCleanup", "l", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addTypeParametersScope", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTypeResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n+ 6 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 7 FirSpecificTypeResolverTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n295#1,8:371\n295#1,2:384\n297#1,6:388\n295#1,8:405\n295#1,8:417\n295#1,2:433\n66#1,7:435\n297#1,6:442\n295#1,8:456\n295#1,2:468\n66#1,7:470\n297#1,6:477\n66#1,7:505\n295#1,2:523\n297#1,6:536\n295#1,8:542\n146#2,2:379\n148#2,2:395\n146#2,2:403\n148#2,2:413\n146#2,2:415\n148#2,2:425\n146#2,4:427\n146#2,2:431\n148#2,2:448\n146#2,2:454\n148#2,2:464\n146#2,2:466\n148#2,2:483\n146#2,2:503\n148#2,2:512\n146#2,2:514\n148#2,2:521\n64#3,3:381\n68#3:394\n64#3,6:397\n1855#4,2:386\n1549#4:450\n1620#4,3:451\n1747#4,2:489\n1749#4:495\n800#4,11:525\n57#5,4:485\n57#5,4:517\n21#6,4:491\n67#7,7:496\n1#8:516\n*S KotlinDebug\n*F\n+ 1 FirTypeResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTypeResolveTransformer\n*L\n85#1:371,8\n94#1:384,2\n94#1:388,6\n114#1:405,8\n121#1:417,8\n139#1:433,2\n140#1:435,7\n139#1:442,6\n174#1:456,8\n184#1:468,2\n185#1:470,7\n184#1:477,6\n240#1:505,7\n310#1:523,2\n310#1:536,6\n324#1:542,8\n92#1:379,2\n92#1:395,2\n113#1:403,2\n113#1:413,2\n120#1:415,2\n120#1:425,2\n127#1:427,4\n138#1:431,2\n138#1:448,2\n173#1:454,2\n173#1:464,2\n183#1:466,2\n183#1:483,2\n239#1:503,2\n239#1:512,2\n256#1:514,2\n256#1:521,2\n93#1:381,3\n93#1:394\n108#1:397,6\n96#1:386,2\n170#1:450\n170#1:451,3\n216#1:489,2\n216#1:495\n318#1:525,11\n198#1:485,4\n270#1:517,4\n217#1:491,4\n228#1:496,7\n*E\n"})
public class FirTypeResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;
    @NotNull
    private final List<FirScope> scopes;
    @NotNull
    private final List<FirScope> towerScope;
    @Nullable
    private FirDeclaration currentDeclaration;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @Nullable
    private FirFile currentFile;

    public FirTypeResolveTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirScope> initialScopes, @Nullable FirFile initialCurrentFile, @NotNull ArrayDeque<FirClass> classDeclarationsStack) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter(initialScopes, (String)"initialScopes");
        Intrinsics.checkNotNullParameter(classDeclarationsStack, (String)"classDeclarationsStack");
        super(FirResolvePhase.TYPES);
        this.session = session;
        this.scopeSession = scopeSession;
        this.classDeclarationsStack = classDeclarationsStack;
        this.scopes = new ArrayList();
        this.towerScope = CollectionsKt.asReversedMutable(this.scopes);
        this.scopes.addAll(CollectionsKt.asReversed(initialScopes));
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(this.session, false, null, 6, null);
        this.currentFile = initialCurrentFile;
    }

    public /* synthetic */ FirTypeResolveTransformer(FirSession firSession, ScopeSession scopeSession, List list2, FirFile firFile, ArrayDeque arrayDeque, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            firFile = null;
        }
        if ((n & 0x10) != 0) {
            arrayDeque = new ArrayDeque();
        }
        this(firSession, scopeSession, list2, firFile, (ArrayDeque<FirClass>)arrayDeque);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withDeclaration(FirDeclaration declaration, Function0<? extends T> action) {
        Object object;
        boolean $i$f$withDeclaration = false;
        FirDeclaration oldDeclaration = this.currentDeclaration;
        try {
            this.currentDeclaration = declaration;
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.currentDeclaration = oldDeclaration;
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkSessionConsistency(file2);
        this.currentFile = file2;
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl = false;
        this.scopes.addAll(ImportingScopesKt.createImportingScopes$default(file2, this.getSession(), this.scopeSession, false, 8, null));
        FirFile result$iv = FirTypeResolveTransformer.super.transformFile(file2, data2);
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            int it$iv = n3++;
            boolean bl2 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return result$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
            boolean $i$f$withClassDeclarationCleanup = false;
            classDeclarations$iv.addLast((Object)regularClass);
            try {
                int n;
                boolean bl2 = false;
                FirTypeResolveTransformer this_$iv = this;
                boolean $i$f$withScopeCleanup = false;
                int sizeBefore$iv = this_$iv.scopes.size();
                boolean bl3 = false;
                this.addTypeParametersScope(regularClass);
                Iterable $this$forEach$iv = regularClass.getTypeParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                    boolean bl4 = false;
                    it.accept(this, data2);
                }
                this.unboundCyclesInTypeParametersSupertypes(regularClass);
                Unit result$iv = Unit.INSTANCE;
                int size$iv = this_$iv.scopes.size();
                int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                n = size$iv - sizeBefore$iv;
                int n3 = 0;
                while (n3 < n) {
                    int it$iv = n3++;
                    boolean bl5 = false;
                    this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
                }
                FirStatement firStatement = this.resolveClassContent(regularClass, data2);
                return firStatement;
            }
            finally {
                classDeclarations$iv.removeLast();
            }
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(regularClass, throwable$iv);
            throw null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        ArrayDeque<FirClass> classDeclarations$iv = this.classDeclarationsStack;
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)anonymousObject);
        try {
            boolean bl = false;
            FirStatement firStatement = this.resolveClassContent(anonymousObject, data2);
            return firStatement;
        }
        finally {
            classDeclarations$iv.removeLast();
        }
    }

    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            int n;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = this_$iv.scopes.size();
            boolean bl2 = false;
            this.addTypeParametersScope(constructor2);
            FirDeclaration result$iv = this.transformDeclaration(constructor2, data2);
            int size$iv = this_$iv.scopes.size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int it$iv = n3++;
                boolean bl3 = false;
                this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
            }
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirConstructor");
            return (FirConstructor)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(constructor2, throwable$iv);
            throw null;
        }
    }

    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        FirTypeAlias firTypeAlias;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            int n;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = this_$iv.scopes.size();
            boolean bl2 = false;
            this.addTypeParametersScope(typeAlias);
            FirDeclaration result$iv = this.transformDeclaration(typeAlias, data2);
            int size$iv = this_$iv.scopes.size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int it$iv = n3++;
                boolean bl3 = false;
                this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
            }
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            firTypeAlias = (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(typeAlias, throwable$iv);
            throw null;
        }
        return firTypeAlias;
    }

    @NotNull
    public FirEnumEntry transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data2) {
        FirEnumEntry firEnumEntry;
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            enumEntry.transformReturnTypeRef(this, data2);
            enumEntry.transformTypeParameters(this, data2);
            enumEntry.transformAnnotations(this, data2);
            firEnumEntry = enumEntry;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(enumEntry, throwable$iv);
            throw null;
        }
        return firEnumEntry;
    }

    @Override
    @NotNull
    public FirReceiverParameter transformReceiverParameter(@NotNull FirReceiverParameter receiverParameter, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)receiverParameter, (String)"receiverParameter");
        return receiverParameter.transformAnnotations(this, data2).transformTypeRef(this, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirProperty transformProperty(@NotNull FirProperty property2, @Nullable Object data2) {
        FirProperty firProperty;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            int n;
            FirProperty firProperty2;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = this_$iv.scopes.size();
            boolean bl2 = false;
            FirTypeResolveTransformer this_$iv2 = this;
            boolean $i$f$withDeclaration = false;
            FirDeclaration oldDeclaration$iv = this_$iv2.currentDeclaration;
            try {
                this_$iv2.currentDeclaration = property2;
                boolean bl3 = false;
                this.addTypeParametersScope(property2);
                property2.transformTypeParameters(this, data2).transformReturnTypeRef(this, data2).transformReceiverParameter(this, data2).transformContextReceivers(this, data2).transformGetter(this, data2).transformSetter(this, data2).transformBackingField(this, data2).transformAnnotations(this, data2);
                if (Intrinsics.areEqual((Object)DeclarationAttributesKt.isFromVararg(property2), (Object)true)) {
                    TransformUtilsKt.transformTypeToArrayType(property2);
                    FirBackingField firBackingField = property2.getBackingField();
                    if (firBackingField != null) {
                        TransformUtilsKt.transformTypeToArrayType(firBackingField);
                    }
                    this.setAccessorTypesByPropertyType(property2);
                }
                if (property2.getReturnTypeRef() instanceof FirResolvedTypeRef && property2.getDelegate() != null) {
                    this.setAccessorTypesByPropertyType(property2);
                }
                this.unboundCyclesInTypeParametersSupertypes(property2);
                firProperty2 = property2;
            }
            finally {
                this_$iv2.currentDeclaration = oldDeclaration$iv;
            }
            FirProperty result$iv = firProperty2;
            int size$iv = this_$iv.scopes.size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int it$iv = n3++;
                boolean bl4 = false;
                this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
            }
            firProperty = result$iv;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(property2, throwable$iv);
            throw null;
        }
        return firProperty;
    }

    /*
     * WARNING - void declaration
     */
    private final void setAccessorTypesByPropertyType(FirProperty property2) {
        block2: {
            void $this$mapTo$iv$iv;
            Object object;
            FirPropertyAccessor firPropertyAccessor = property2.getGetter();
            if (firPropertyAccessor != null) {
                firPropertyAccessor.replaceReturnTypeRef(property2.getReturnTypeRef());
            }
            if ((object = property2.getSetter()) == null || (object = ((FirPropertyAccessor)object).getValueParameters()) == null) break block2;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                it.replaceReturnTypeRef(property2.getReturnTypeRef());
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
    }

    @NotNull
    public FirField transformField(@NotNull FirField field2, @Nullable Object data2) {
        FirField firField;
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            int n;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = this_$iv.scopes.size();
            boolean bl2 = false;
            field2.transformReturnTypeRef(this, data2).transformAnnotations(this, data2);
            FirField result$iv = field2;
            int size$iv = this_$iv.scopes.size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int it$iv = n3++;
                boolean bl3 = false;
                this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
            }
            firField = result$iv;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(field2, throwable$iv);
            throw null;
        }
        return firField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data2) {
        FirSimpleFunction firSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            int n;
            FirDeclaration firDeclaration;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = this_$iv.scopes.size();
            boolean bl2 = false;
            FirTypeResolveTransformer this_$iv2 = this;
            boolean $i$f$withDeclaration = false;
            FirDeclaration oldDeclaration$iv = this_$iv2.currentDeclaration;
            try {
                FirDeclaration firDeclaration2;
                this_$iv2.currentDeclaration = simpleFunction;
                boolean bl3 = false;
                this.addTypeParametersScope(simpleFunction);
                FirDeclaration it = firDeclaration2 = this.transformDeclaration(simpleFunction, data2);
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner");
                this.unboundCyclesInTypeParametersSupertypes((FirTypeParametersOwner)((Object)it));
                firDeclaration = firDeclaration2;
            }
            finally {
                this_$iv2.currentDeclaration = oldDeclaration$iv;
            }
            FirDeclaration result$iv = firDeclaration;
            int size$iv = this_$iv.scopes.size();
            int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = size$iv - sizeBefore$iv;
            int n3 = 0;
            while (n3 < n) {
                int it$iv = n3++;
                boolean bl5 = false;
                this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
            }
            FirDeclaration firDeclaration3 = result$iv;
            Intrinsics.checkNotNull((Object)firDeclaration3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
            firSimpleFunction = (FirSimpleFunction)firDeclaration3;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(simpleFunction, throwable$iv);
            throw null;
        }
        return firSimpleFunction;
    }

    private final void unboundCyclesInTypeParametersSupertypes(FirTypeParameterRefsOwner typeParametersOwner) {
        for (FirTypeParameterRef typeParameter2 : typeParametersOwner.getTypeParameters()) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            if (!(typeParameter2 instanceof FirTypeParameter) || !this.hasSupertypePathToParameter((FirTypeParameter)typeParameter2, (FirTypeParameter)typeParameter2, new LinkedHashSet())) continue;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2421 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$unboundCyclesInTypeParametersSupertypes_u24lambda_u2421.setDiagnostic(new ConeCyclicTypeBound(typeParameter2.getSymbol(), (ImmutableList<? extends FirTypeRef>)ExtensionsKt.toImmutableList((Iterable)((FirTypeParameter)typeParameter2).getBounds())));
            FirErrorTypeRef errorType = firErrorTypeRefBuilder.build();
            ((FirTypeParameter)typeParameter2).replaceBounds(CollectionsKt.listOf((Object)errorType));
        }
    }

    private final boolean hasSupertypePathToParameter(FirTypeParameter currentTypeParameter, FirTypeParameter typeParameter2, Set<FirTypeParameter> visited2) {
        boolean bl;
        block8: {
            if (!((Collection)visited2).isEmpty() && Intrinsics.areEqual((Object)currentTypeParameter, (Object)typeParameter2)) {
                return true;
            }
            if (!visited2.add(currentTypeParameter)) {
                return false;
            }
            Iterable $this$any$iv = currentTypeParameter.getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Object object;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl3 = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                        coneKotlinType = null;
                    }
                    if ((object = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType))) == null || (object = ((ConeTypeParameterType)object).getLookupTag()) == null || (object = ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol()) == null || (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) == null) {
                        bl2 = false;
                    } else {
                        Object nextTypeParameter = object;
                        bl2 = this.hasSupertypePathToParameter((FirTypeParameter)nextTypeParameter, typeParameter2, visited2);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public FirTypeRef transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)implicitTypeRef, (String)"implicitTypeRef");
        return implicitTypeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public FirResolvedTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Object data2) {
        FirResolvedTypeRef firResolvedTypeRef;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirSpecificTypeResolverTransformer firSpecificTypeResolverTransformer = this.typeResolverTransformer;
        FirFile file$iv = this.currentFile;
        boolean $i$f$withFile = false;
        FirFile oldValue$iv = this_$iv.currentFile;
        this_$iv.currentFile = file$iv;
        try {
            void $this$transformTypeRef_u24lambda_u2423 = this_$iv;
            boolean bl = false;
            firResolvedTypeRef = (FirResolvedTypeRef)typeRef.transform(this.typeResolverTransformer, new ScopeClassDeclaration(this.towerScope, (List)this.classDeclarationsStack, null, this.currentDeclaration, 4, null));
        }
        finally {
            this_$iv.currentFile = oldValue$iv;
        }
        return firResolvedTypeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Object data2) {
        FirValueParameter firValueParameter;
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirValueParameter firValueParameter2;
            boolean bl = false;
            FirTypeResolveTransformer this_$iv = this;
            boolean $i$f$withDeclaration = false;
            FirDeclaration oldDeclaration$iv = this_$iv.currentDeclaration;
            try {
                this_$iv.currentDeclaration = valueParameter2;
                boolean bl2 = false;
                valueParameter2.transformReturnTypeRef(this, data2);
                valueParameter2.transformAnnotations(this, data2);
                TransformUtilsKt.transformVarargTypeToArrayType(valueParameter2);
                firValueParameter2 = valueParameter2;
            }
            finally {
                this_$iv.currentDeclaration = oldDeclaration$iv;
            }
            firValueParameter = firValueParameter2;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(valueParameter2, throwable$iv);
            throw null;
        }
        return firValueParameter;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block;
    }

    @Override
    @NotNull
    public FirStatement transformAnnotation(@NotNull FirAnnotation annotation2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            FirTypeRef originalTypeRef = annotationCall.getAnnotationTypeRef();
            if (originalTypeRef instanceof FirResolvedTypeRef) {
                switch (WhenMappings.$EnumSwitchMapping$0[annotationCall.getAnnotationResolvePhase().ordinal()]) {
                    case 1: {
                        if (originalTypeRef instanceof FirErrorTypeRef) {
                            FirAnnotationCall firAnnotationCall;
                            FirAnnotationCall it = firAnnotationCall = annotationCall;
                            boolean bl2 = false;
                            it.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.Types);
                            return firAnnotationCall;
                        }
                        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                        throw null;
                    }
                    case 2: {
                        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                        annotationCall.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.Types);
                        FirTypeRef firTypeRef = ((FirResolvedTypeRef)originalTypeRef).getDelegatedTypeRef();
                        if (firTypeRef == null || (firTypeRef = (FirTypeRef)FirTransformerUtilKt.transformSingle((FirElement)firTypeRef, this, data2)) == null) {
                            return annotationCall;
                        }
                        FirTypeRef alternativeResolvedTypeRef = firTypeRef;
                        ConeKotlinType coneTypeFromCompilerRequiredPhase = FirTypeUtilsKt.getConeType(originalTypeRef);
                        ConeKotlinType coneTypeFromTypesPhase = FirTypeUtilsKt.getConeType(alternativeResolvedTypeRef);
                        if (Intrinsics.areEqual((Object)coneTypeFromTypesPhase, (Object)coneTypeFromCompilerRequiredPhase)) return annotationCall;
                        boolean $i$f$buildErrorTypeRef = false;
                        FirErrorTypeRefBuilder $this$transformAnnotationCall_u24lambda_u2428_u24lambda_u2427 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                        boolean bl3 = false;
                        $this$transformAnnotationCall_u24lambda_u2428_u24lambda_u2427.setSource(originalTypeRef.getSource());
                        $this$transformAnnotationCall_u24lambda_u2428_u24lambda_u2427.setType(coneTypeFromCompilerRequiredPhase);
                        $this$transformAnnotationCall_u24lambda_u2428_u24lambda_u2427.setDelegatedTypeRef(((FirResolvedTypeRef)originalTypeRef).getDelegatedTypeRef());
                        $this$transformAnnotationCall_u24lambda_u2428_u24lambda_u2427.setDiagnostic(new ConeAmbiguouslyResolvedAnnotationFromPlugin(coneTypeFromCompilerRequiredPhase, coneTypeFromTypesPhase));
                        FirErrorTypeRef errorTypeRef = firErrorTypeRefBuilder.build();
                        annotationCall.replaceAnnotationTypeRef(errorTypeRef);
                    }
                    default: {
                        return annotationCall;
                    }
                }
            } else {
                FirTypeRef transformedTypeRef = (FirTypeRef)FirTransformerUtilKt.transformSingle((FirElement)originalTypeRef, this, data2);
                annotationCall.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.Types);
                annotationCall.replaceAnnotationTypeRef(transformedTypeRef);
            }
            return annotationCall;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(annotationCall, throwable$iv);
            throw null;
        }
    }

    private final <T> T withScopeCleanup(Function0<? extends T> l) {
        int n;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore = this.scopes.size();
        Object result2 = l.invoke();
        int size = this.scopes.size();
        int n2 = n = size >= sizeBefore ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size - sizeBefore;
        int n3 = 0;
        while (n3 < n) {
            int it = n3++;
            boolean bl = false;
            this.scopes.remove(CollectionsKt.getLastIndex(this.scopes));
        }
        return (T)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement resolveClassContent(FirClass firClass, Object data2) {
        Object object;
        boolean bl;
        int it$iv;
        int n;
        Object constructor22;
        void $this$filterIsInstanceTo$iv$iv;
        FirTypeResolveTransformer this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl2 = false;
        firClass.transformAnnotations(this, null);
        if (firClass instanceof FirRegularClass) {
            this.addTypeParametersScope(firClass);
        }
        Iterable $this$filterIsInstance$iv = firClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Object object2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object constructor22 : (List)destination$iv$iv) {
            FirDelegatedConstructorCall p0;
            if (((FirConstructor)constructor22).getDelegatedConstructor() == null) continue;
            boolean bl3 = false;
            this.resolveConstructedTypeRefForDelegatedConstructorCall(p0);
        }
        Object result$iv = Unit.INSTANCE;
        int size$iv = this_$iv.scopes.size();
        int n2 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = size$iv - sizeBefore$iv;
        int n3 = 0;
        while (n3 < n) {
            it$iv = n3++;
            bl = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        this_$iv = this;
        $i$f$withScopeCleanup = false;
        sizeBefore$iv = this_$iv.scopes.size();
        boolean bl4 = false;
        constructor22 = this.getSession();
        List superTypes2 = CollectionsKt.asReversed((List)SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, (FirSession)constructor22, true, null, 32, null));
        for (ConeClassLikeType superType2 : superTypes2) {
            FirContainingNamesAwareScope nestedClassifierScope;
            if (ScopesKt.getNestedClassifierScope(superType2.getLookupTag(), this.getSession(), this.scopeSession) == null) continue;
            boolean bl5 = false;
            FirContainingNamesAwareScope scope2 = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope, superType2, this.getSession());
            this.scopes.add(scope2);
        }
        FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), firClass);
        if (firNestedClassifierScope != null) {
            object2 = firNestedClassifierScope;
            object = this.scopes;
            FirScope p0 = (FirScope)object2;
            boolean bl6 = false;
            object.add(p0);
        }
        if (firClass instanceof FirRegularClass) {
            FirRegularClass companionObject2;
            FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClass)firClass).getCompanionObjectSymbol();
            FirRegularClass firRegularClass = companionObject2 = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
            if (companionObject2 != null) {
                FirNestedClassifierScope firNestedClassifierScope2 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), companionObject2);
                if (firNestedClassifierScope2 != null) {
                    object = firNestedClassifierScope2;
                    List list2 = this.scopes;
                    FirScope p0 = (FirScope)object;
                    boolean bl7 = false;
                    list2.add(p0);
                }
            }
            this.addTypeParametersScope(firClass);
        }
        result$iv = (FirClass)this.transformElement((FirElement)firClass, data2);
        size$iv = this_$iv.scopes.size();
        int n4 = n = size$iv >= sizeBefore$iv ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        n = size$iv - sizeBefore$iv;
        n3 = 0;
        while (n3 < n) {
            it$iv = n3++;
            bl = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return (FirStatement)result$iv;
    }

    private final void resolveConstructedTypeRefForDelegatedConstructorCall(FirDelegatedConstructorCall delegatedConstructorCall2) {
        delegatedConstructorCall2.replaceConstructedTypeRef((FirTypeRef)delegatedConstructorCall2.getConstructedTypeRef().transform(this, null));
        delegatedConstructorCall2.transformCalleeReference(this, null);
    }

    private final void addTypeParametersScope(FirMemberDeclaration $this$addTypeParametersScope) {
        if (!((Collection)$this$addTypeParametersScope.getTypeParameters()).isEmpty()) {
            this.scopes.add(new FirMemberTypeParameterScope($this$addTypeParametersScope));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirAnnotationResolvePhase.values().length];
            try {
                nArray[FirAnnotationResolvePhase.Unresolved.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirAnnotationResolvePhase.CompilerRequiredAnnotations.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirAnnotationResolvePhase.Types.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

