/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0010H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0012H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0013H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0014H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0015H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0016H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0017H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "", "represent", "", "it", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "appendOperatorTag", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendRepresentation", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationInspector.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,282:1\n13579#2,2:283\n1855#3:285\n1856#3:287\n1855#3,2:288\n1855#3,2:291\n1855#3,2:293\n1855#3,2:295\n1855#3,2:297\n1855#3,2:299\n1855#3,2:301\n1#4:286\n38#5:290\n*S KotlinDebug\n*F\n+ 1 FirDeclarationInspector.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter\n*L\n84#1:283,2\n130#1:285\n130#1:287\n133#1:288,2\n164#1:291,2\n169#1:293,2\n182#1:295,2\n202#1:297,2\n207#1:299,2\n216#1:301,2\n158#1:290\n*E\n"})
public interface FirDeclarationPresenter {
    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull FirElement it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$appendRepresentation.append("NO_REPRESENTATION");
    }

    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull ClassId it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$appendRepresentation.append(it.getPackageFqName().asString());
        $this$appendRepresentation.append('/');
        $this$appendRepresentation.append(it.getRelativeClassName().asString());
    }

    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull CallableId it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getClassName() != null) {
            $this$appendRepresentation.append(it.getPackageName().asString());
            $this$appendRepresentation.append('/');
            $this$appendRepresentation.append(it.getClassName());
            $this$appendRepresentation.append('.');
            $this$appendRepresentation.append(it.getCallableName());
        } else {
            $this$appendRepresentation.append(it.getPackageName().asString());
            $this$appendRepresentation.append('/');
            $this$appendRepresentation.append(it.getCallableName());
        }
    }

    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull ConeTypeProjection it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConeTypeProjection coneTypeProjection = it;
        if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            $this$appendRepresentation.append('*');
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            $this$appendRepresentation.append("in ");
            this.appendRepresentation($this$appendRepresentation, ((ConeKotlinTypeProjectionIn)it).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            $this$appendRepresentation.append("out ");
            this.appendRepresentation($this$appendRepresentation, ((ConeKotlinTypeProjectionOut)it).getType());
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            this.appendRepresentation($this$appendRepresentation, (ConeKotlinType)it);
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            // empty if block
        }
    }

    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConeKotlinType coneKotlinType = it;
        if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.appendRepresentation($this$appendRepresentation, ((ConeDefinitelyNotNullType)it).getOriginal());
            $this$appendRepresentation.append(it.getNullability().getSuffix());
        } else if (coneKotlinType instanceof ConeErrorType) {
            $this$appendRepresentation.append("ERROR(");
            $this$appendRepresentation.append(((ConeErrorType)it).getDiagnostic().getReason());
            $this$appendRepresentation.append(')');
        } else if (coneKotlinType instanceof ConeCapturedType) {
            $this$appendRepresentation.append(((ConeCapturedType)it).getConstructor().getProjection());
            $this$appendRepresentation.append(it.getNullability().getSuffix());
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            this.appendRepresentation($this$appendRepresentation, ((ConeClassLikeType)it).getLookupTag().getClassId());
            if (!(it.getTypeArguments().length == 0)) {
                $this$appendRepresentation.append('<');
                ConeTypeProjection[] $this$forEach$iv = it.getTypeArguments();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection that = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    this.appendRepresentation($this$appendRepresentation, that);
                    $this$appendRepresentation.append(',');
                }
                $this$appendRepresentation.append('>');
            }
            $this$appendRepresentation.append(it.getNullability().getSuffix());
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            $this$appendRepresentation.append(((ConeLookupTagBasedType)it).getLookupTag().getName());
            $this$appendRepresentation.append(it.getNullability().getSuffix());
        } else if (coneKotlinType instanceof ConeIntegerLiteralConstantType) {
            $this$appendRepresentation.append(((ConeIntegerLiteralConstantType)it).getValue());
            $this$appendRepresentation.append(it.getNullability().getSuffix());
        } else if (coneKotlinType instanceof ConeIntegerConstantOperatorType) {
            $this$appendRepresentation.append("IOT");
            $this$appendRepresentation.append(it.getNullability().getSuffix());
        } else if ((coneKotlinType instanceof ConeFlexibleType ? true : coneKotlinType instanceof ConeIntersectionType) ? true : coneKotlinType instanceof ConeStubType) {
            $this$appendRepresentation.append("ERROR");
        }
    }

    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull FirTypeRef it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof FirResolvedTypeRef) {
            this.appendRepresentation($this$appendRepresentation, ((FirResolvedTypeRef)it).getType());
        } else {
            $this$appendRepresentation.append("?");
        }
    }

    /*
     * WARNING - void declaration
     */
    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull FirTypeParameter it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$appendRepresentation.append(it.getName().asString());
        $this$appendRepresentation.append(':');
        switch (it.getBounds().size()) {
            case 0: {
                break;
            }
            case 1: {
                this.appendRepresentation($this$appendRepresentation, it.getBounds().get(0));
                break;
            }
            default: {
                Object that;
                TreeSet set = SetsKt.sortedSetOf((Object[])new String[0]);
                Iterable $this$forEach$iv = it.getBounds();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$appendRepresentation_u24lambda_u242_u24lambda_u241;
                    StringBuilder stringBuilder2;
                    that = (FirTypeRef)element$iv;
                    boolean bl = false;
                    StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                    TreeSet treeSet = set;
                    boolean bl2 = false;
                    this.appendRepresentation((StringBuilder)$this$appendRepresentation_u24lambda_u242_u24lambda_u241, (FirTypeRef)that);
                    String string2 = stringBuilder2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                    treeSet.add(string2);
                }
                $this$forEach$iv = set;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    that = (String)element$iv;
                    boolean bl = false;
                    $this$appendRepresentation.append((String)that);
                    $this$appendRepresentation.append(',');
                }
            }
        }
    }

    default public void appendRepresentation(@NotNull StringBuilder $this$appendRepresentation, @NotNull FirValueParameter it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendRepresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isVararg()) {
            $this$appendRepresentation.append("vararg ");
        }
        this.appendRepresentation($this$appendRepresentation, it.getReturnTypeRef());
    }

    @NotNull
    default public String represent(@NotNull FirVariable it) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringBuilder $this$represent_u24lambda_u245 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$represent_u24lambda_u245.append('[');
        FirPureAbstractElement firPureAbstractElement = it.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it2 = firPureAbstractElement;
            boolean bl2 = false;
            this.appendRepresentation($this$represent_u24lambda_u245, (FirTypeRef)it2);
        }
        $this$represent_u24lambda_u245.append(']');
        this.appendRepresentation($this$represent_u24lambda_u245, it.getSymbol().getCallableId());
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    default public void appendOperatorTag(@NotNull StringBuilder $this$appendOperatorTag, @NotNull FirSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)$this$appendOperatorTag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirMemberDeclaration $this$isOperator$iv = it;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator()) {
            $this$appendOperatorTag.append("operator ");
        }
    }

    @NotNull
    default public String represent(@NotNull FirSimpleFunction it) {
        FirPureAbstractElement it2;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringBuilder $this$represent_u24lambda_u2410 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = it.getContextReceivers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (FirContextReceiver)element$iv;
            boolean bl2 = false;
            this.appendRepresentation($this$represent_u24lambda_u2410, it2);
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append('<');
        $this$forEach$iv = it.getTypeParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (FirTypeParameter)element$iv;
            boolean bl3 = false;
            this.appendRepresentation($this$represent_u24lambda_u2410, (FirTypeParameter)it2);
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append('>');
        $this$represent_u24lambda_u2410.append('[');
        FirPureAbstractElement firPureAbstractElement = it.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it3 = firPureAbstractElement;
            boolean bl4 = false;
            this.appendRepresentation($this$represent_u24lambda_u2410, (FirTypeRef)it3);
        }
        $this$represent_u24lambda_u2410.append(']');
        this.appendOperatorTag($this$represent_u24lambda_u2410, it);
        this.appendRepresentation($this$represent_u24lambda_u2410, it.getSymbol().getCallableId());
        $this$represent_u24lambda_u2410.append('(');
        $this$forEach$iv = it.getValueParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it4 = (FirValueParameter)element$iv;
            boolean bl5 = false;
            this.appendRepresentation($this$represent_u24lambda_u2410, it4);
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append(')');
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    default public String represent(@NotNull FirTypeAlias it) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringBuilder $this$represent_u24lambda_u2411 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$represent_u24lambda_u2411.append('[');
        $this$represent_u24lambda_u2411.append(']');
        this.appendRepresentation($this$represent_u24lambda_u2411, it.getSymbol().getClassId());
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    default public String represent(@NotNull FirRegularClass it) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringBuilder $this$represent_u24lambda_u2412 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$represent_u24lambda_u2412.append('[');
        $this$represent_u24lambda_u2412.append(']');
        this.appendRepresentation($this$represent_u24lambda_u2412, it.getSymbol().getClassId());
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    default public String represent(@NotNull FirConstructor it, @NotNull FirRegularClass owner) {
        FirElement it2;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        StringBuilder $this$represent_u24lambda_u2416 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = it.getContextReceivers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (FirContextReceiver)element$iv;
            boolean bl2 = false;
            this.appendRepresentation($this$represent_u24lambda_u2416, it2);
            $this$represent_u24lambda_u2416.append(',');
        }
        $this$represent_u24lambda_u2416.append('<');
        $this$forEach$iv = it.getTypeParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (FirTypeParameterRef)element$iv;
            boolean bl3 = false;
            this.appendRepresentation($this$represent_u24lambda_u2416, it2);
            $this$represent_u24lambda_u2416.append(',');
        }
        $this$represent_u24lambda_u2416.append('>');
        $this$represent_u24lambda_u2416.append('[');
        $this$represent_u24lambda_u2416.append(']');
        this.appendRepresentation($this$represent_u24lambda_u2416, owner.getSymbol().getClassId());
        $this$represent_u24lambda_u2416.append('(');
        $this$forEach$iv = it.getValueParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (FirValueParameter)element$iv;
            boolean bl4 = false;
            this.appendRepresentation($this$represent_u24lambda_u2416, (FirValueParameter)it2);
            $this$represent_u24lambda_u2416.append(',');
        }
        $this$represent_u24lambda_u2416.append(')');
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }
}

