/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/SamTypeApproximator;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "typeApproximator", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "getSamTypeForValueParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "carefulApproximationOfContravariantProjection", "", "removeExternalProjections", "backend-common"})
@SourceDebugExtension(value={"SMAP\nSamTypeFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamTypeFactory.kt\norg/jetbrains/kotlin/backend/common/SamTypeApproximator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1559#2:94\n1590#2,4:95\n*S KotlinDebug\n*F\n+ 1 SamTypeFactory.kt\norg/jetbrains/kotlin/backend/common/SamTypeApproximator\n*L\n65#1:94\n65#1:95,4\n*E\n"})
public final class SamTypeApproximator {
    @NotNull
    private final TypeApproximator typeApproximator;

    public SamTypeApproximator(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.typeApproximator = new TypeApproximator(builtIns, languageVersionSettings2);
    }

    @Nullable
    public final KotlinType getSamTypeForValueParameter(@NotNull ValueParameterDescriptor valueParameter2, boolean carefulApproximationOfContravariantProjection) {
        KotlinType originalSingleArgumentType;
        KotlinType singleArgumentType;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
                singleArgumentType = null;
                originalSingleArgumentType = null;
                KotlinType varargElementType2 = valueParameter2.getVarargElementType();
                if (varargElementType2 != null) {
                    boolean bl;
                    singleArgumentType = varargElementType2;
                    originalSingleArgumentType = valueParameter2.getOriginal().getVarargElementType();
                    boolean bl2 = bl = originalSingleArgumentType != null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-SamTypeApproximator$getSamTypeForValueParameter$22 = false;
                        String $i$a$-assert-SamTypeApproximator$getSamTypeForValueParameter$22 = "Value parameter and original value parameter have inconsistent varargs: " + valueParameter2 + "; " + valueParameter2.getOriginal();
                        throw new AssertionError((Object)$i$a$-assert-SamTypeApproximator$getSamTypeForValueParameter$22);
                    }
                } else {
                    KotlinType kotlinType = valueParameter2.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"valueParameter.type");
                    singleArgumentType = kotlinType;
                    originalSingleArgumentType = valueParameter2.getOriginal().getType();
                }
                if (KotlinTypeKt.isError(singleArgumentType)) break block8;
                KotlinType kotlinType = originalSingleArgumentType;
                Intrinsics.checkNotNull((Object)kotlinType);
                if (!KotlinTypeKt.isError(kotlinType)) break block9;
            }
            return null;
        }
        KotlinType originalTypeToUse = KotlinBuiltIns.isNothing(singleArgumentType) ? TypeUtilsKt.replaceArgumentsWithNothing(originalSingleArgumentType) : singleArgumentType;
        KotlinTypeMarker kotlinTypeMarker = this.typeApproximator.approximateToSubType(originalTypeToUse, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.UpperBoundAwareIntersectionTypeApproximator.INSTANCE);
        if (kotlinTypeMarker == null) {
            kotlinTypeMarker = originalTypeToUse;
        }
        KotlinTypeMarker approximatedOriginalTypeToUse = kotlinTypeMarker;
        Intrinsics.checkNotNull((Object)approximatedOriginalTypeToUse, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.KotlinType");
        KotlinType cfr_ignored_0 = (KotlinType)approximatedOriginalTypeToUse;
        return this.removeExternalProjections((KotlinType)approximatedOriginalTypeToUse, carefulApproximationOfContravariantProjection);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeExternalProjections(KotlinType $this$removeExternalProjections, boolean carefulApproximationOfContravariantProjection) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$removeExternalProjections.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            TypeProjection typeProjection;
            void argument2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (carefulApproximationOfContravariantProjection && argument2.getProjectionKind() == Variance.IN_VARIANCE) {
                TypeParameterDescriptor parameter2;
                void i;
                List<TypeParameterDescriptor> list2 = $this$removeExternalProjections.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"constructor.parameters");
                if ((TypeParameterDescriptor)CollectionsKt.getOrNull(list2, (int)i) == null) {
                    return null;
                }
                List<KotlinType> list3 = parameter2.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"parameter.upperBounds");
                KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull(list3);
                if (kotlinType == null || (kotlinType = FlexibleTypesKt.upperIfFlexible(kotlinType)) == null) {
                    return null;
                }
                KotlinType upperBound = kotlinType;
                if (!TypeUtilsKt.isNullableAny(upperBound)) {
                    return null;
                }
                typeProjection = TypeUtilsKt.asTypeProjection(upperBound);
            } else {
                typeProjection = new TypeProjectionImpl(Variance.INVARIANT, argument2.getType());
            }
            collection.add(typeProjection);
        }
        List newArguments2 = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default($this$removeExternalProjections, newArguments2, null, null, 6, null);
    }
}

