/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.Nullability;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityInterpreter;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityValuesKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerPass", "backend"})
public final class RedundantNullCheckMethodTransformer
extends MethodTransformer {
    @NotNull
    private final GenerationState generationState;

    public RedundantNullCheckMethodTransformer(@NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.generationState = generationState;
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        boolean changes;
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        while (changes = new TransformerPass(internalClassName, methodNode, this.generationState).run()) {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002()B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\u0006\u0010\u0015\u001a\u00020\nJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010 \u001a\u00020\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\nH\u0002J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020%2\u0006\u0010&\u001a\u00020\nH\u0002J\f\u0010'\u001a\u00020\n*\u00020\u0013H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "changes", "", "getGenerationState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getInternalClassName", "()Ljava/lang/String;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeNullabilities", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "run", "transformInstanceOf", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "nullability", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/Nullability;", "value", "transformTrivialCheckExpressionValueIsNotNull", "transformTrivialCheckNotNull", "transformTrivialCheckNotNullWithMessage", "transformTrivialChecks", "nullabilityMap", "transformTrivialInstanceOf", "constValue", "transformTrivialNullJump", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "alwaysTrue", "isOptimizable", "NullabilityAssumptions", "NullabilityAssumptionsBuilder", "backend"})
    @SourceDebugExtension(value={"SMAP\nRedundantNullCheckMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,530:1\n18987#2,2:531\n1#3:533\n*S KotlinDebug\n*F\n+ 1 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass\n*L\n51#1:531,2\n*E\n"})
    private static final class TransformerPass {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final GenerationState generationState;
        private boolean changes;

        public TransformerPass(@NotNull String internalClassName, @NotNull MethodNode methodNode, @NotNull GenerationState generationState) {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
            this.generationState = generationState;
        }

        @NotNull
        public final String getInternalClassName() {
            return this.internalClassName;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        @NotNull
        public final GenerationState getGenerationState() {
            return this.generationState;
        }

        public final boolean run() {
            boolean bl;
            block2: {
                AbstractInsnNode[] abstractInsnNodeArray = this.methodNode.instructions.toArray();
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"methodNode.instructions.toArray()");
                Object[] $this$none$iv = abstractInsnNodeArray;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isOptimizable(it)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (bl) {
                return false;
            }
            NullabilityAssumptions nullabilityAssumptions = new NullabilityAssumptionsBuilder().injectNullabilityAssumptions();
            Map<AbstractInsnNode, StrictBasicValue> nullabilityMap = this.analyzeNullabilities();
            nullabilityAssumptions.revert();
            this.transformTrivialChecks(nullabilityMap);
            return this.changes;
        }

        private final Map<AbstractInsnNode, StrictBasicValue> analyzeNullabilities() {
            Frame<V>[] frameArray = MethodTransformer.analyze(this.internalClassName, this.methodNode, new NullabilityInterpreter(this.generationState));
            Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(internalClassNam\u2026rpreter(generationState))");
            Frame<V>[] frames = frameArray;
            AbstractInsnNode[] insns = this.methodNode.instructions.toArray();
            LinkedHashMap nullabilityMap = new LinkedHashMap();
            int n = insns.length;
            for (int i = 0; i < n; ++i) {
                StrictBasicValue value2;
                Nullability nullability;
                Frame frame;
                if (frames[i] == null) continue;
                AbstractInsnNode insn = insns[i];
                Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                BasicValue basicValue = RedundantNullCheckMethodTransformerKt.isInstanceOfOrNullCheck(insn) ? (BasicValue)StackTransformationUtilsKt.top(frame) : (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn) ? (BasicValue)StackTransformationUtilsKt.top(frame) : (RedundantNullCheckMethodTransformerKt.isCheckNotNullWithMessage(insn) ? (BasicValue)StackTransformationUtilsKt.peek(frame, 1) : (RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn) ? (BasicValue)StackTransformationUtilsKt.peek(frame, 1) : null)));
                StrictBasicValue strictBasicValue = basicValue instanceof StrictBasicValue ? (StrictBasicValue)basicValue : null;
                if (strictBasicValue == null || (nullability = NullabilityValuesKt.getNullability(value2 = strictBasicValue)) == Nullability.NULLABLE) continue;
                ((Map)nullabilityMap).put(insn, value2);
            }
            return nullabilityMap;
        }

        private final boolean isOptimizable(AbstractInsnNode $this$isOptimizable) {
            return $this$isOptimizable.getOpcode() == 198 || $this$isOptimizable.getOpcode() == 199 || $this$isOptimizable.getOpcode() == 193 || RedundantNullCheckMethodTransformerKt.isCheckNotNull($this$isOptimizable) || RedundantNullCheckMethodTransformerKt.isCheckNotNullWithMessage($this$isOptimizable) || RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull($this$isOptimizable);
        }

        private final void transformTrivialChecks(Map<AbstractInsnNode, ? extends StrictBasicValue> nullabilityMap) {
            for (Map.Entry<AbstractInsnNode, ? extends StrictBasicValue> entry : nullabilityMap.entrySet()) {
                AbstractInsnNode insn = entry.getKey();
                StrictBasicValue value2 = entry.getValue();
                Nullability nullability = NullabilityValuesKt.getNullability(value2);
                switch (insn.getOpcode()) {
                    case 198: {
                        Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        this.transformTrivialNullJump((JumpInsnNode)insn, nullability == Nullability.NULL);
                        break;
                    }
                    case 199: {
                        Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        this.transformTrivialNullJump((JumpInsnNode)insn, nullability == Nullability.NOT_NULL);
                        break;
                    }
                    case 193: {
                        Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
                        this.transformInstanceOf((TypeInsnNode)insn, nullability, value2);
                        break;
                    }
                    case 184: {
                        if (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn)) {
                            this.transformTrivialCheckNotNull(insn, nullability);
                            break;
                        }
                        if (RedundantNullCheckMethodTransformerKt.isCheckNotNullWithMessage(insn)) {
                            this.transformTrivialCheckNotNullWithMessage(insn, nullability);
                            break;
                        }
                        if (!RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn)) break;
                        this.transformTrivialCheckExpressionValueIsNotNull(insn, nullability);
                    }
                }
            }
        }

        private final void transformTrivialNullJump(JumpInsnNode insn, boolean alwaysTrue) {
            this.changes = true;
            InsnList $this$transformTrivialNullJump_u24lambda_u241 = this.methodNode.instructions;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$transformTrivialNullJump_u24lambda_u241, (String)"transformTrivialNullJump$lambda$1");
            RedundantNullCheckMethodTransformerKt.popReferenceValueBefore($this$transformTrivialNullJump_u24lambda_u241, (AbstractInsnNode)insn);
            if (alwaysTrue) {
                $this$transformTrivialNullJump_u24lambda_u241.set((AbstractInsnNode)insn, (AbstractInsnNode)new JumpInsnNode(167, insn.label));
            } else {
                $this$transformTrivialNullJump_u24lambda_u241.remove((AbstractInsnNode)insn);
            }
        }

        private final void transformInstanceOf(TypeInsnNode insn, Nullability nullability, StrictBasicValue value2) {
            AbstractInsnNode abstractInsnNode = insn.getPrevious();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"insn.previous");
            if (ReifiedTypeInliner.Companion.isOperationReifiedMarker(abstractInsnNode)) {
                return;
            }
            if (nullability == Nullability.NULL) {
                this.changes = true;
                this.transformTrivialInstanceOf((AbstractInsnNode)insn, false);
            } else if (nullability == Nullability.NOT_NULL && Intrinsics.areEqual((Object)value2.getType().getInternalName(), (Object)insn.desc)) {
                this.changes = true;
                this.transformTrivialInstanceOf((AbstractInsnNode)insn, true);
            }
        }

        private final void transformTrivialInstanceOf(AbstractInsnNode insn, boolean constValue) {
            InsnList $this$transformTrivialInstanceOf_u24lambda_u242 = this.methodNode.instructions;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$transformTrivialInstanceOf_u24lambda_u242, (String)"transformTrivialInstanceOf$lambda$2");
            RedundantNullCheckMethodTransformerKt.popReferenceValueBefore($this$transformTrivialInstanceOf_u24lambda_u242, insn);
            $this$transformTrivialInstanceOf_u24lambda_u242.set(insn, (AbstractInsnNode)(constValue ? new InsnNode(4) : new InsnNode(3)));
        }

        private final void transformTrivialCheckNotNull(AbstractInsnNode insn, Nullability nullability) {
            Object object;
            block5: {
                block4: {
                    AbstractInsnNode abstractInsnNode;
                    if (nullability != Nullability.NOT_NULL) {
                        return;
                    }
                    object = insn.getPrevious();
                    if (object == null) break block4;
                    AbstractInsnNode it = abstractInsnNode = object;
                    boolean bl = false;
                    object = it.getOpcode() == 89 || it.getOpcode() == 25 ? abstractInsnNode : null;
                    if (object != null) break block5;
                }
                return;
            }
            AbstractInsnNode previousInsn = object;
            InsnList $this$transformTrivialCheckNotNull_u24lambda_u244 = this.methodNode.instructions;
            boolean bl = false;
            $this$transformTrivialCheckNotNull_u24lambda_u244.remove(previousInsn);
            $this$transformTrivialCheckNotNull_u24lambda_u244.remove(insn);
        }

        private final void transformTrivialCheckNotNullWithMessage(AbstractInsnNode insn, Nullability nullability) {
            Object object;
            AbstractInsnNode ldcInsn;
            block10: {
                block9: {
                    AbstractInsnNode it;
                    Object object2;
                    block8: {
                        block7: {
                            AbstractInsnNode abstractInsnNode;
                            if (nullability != Nullability.NOT_NULL) {
                                return;
                            }
                            object2 = insn.getPrevious();
                            if (object2 == null) break block7;
                            it = abstractInsnNode = object2;
                            boolean bl = false;
                            object2 = it.getOpcode() == 18 ? abstractInsnNode : null;
                            if (object2 != null) break block8;
                        }
                        return;
                    }
                    ldcInsn = object2;
                    object = ldcInsn.getPrevious();
                    if (object == null) break block9;
                    AbstractInsnNode it2 = it = object;
                    boolean bl = false;
                    object = it2.getOpcode() == 89 || it2.getOpcode() == 25 ? it : null;
                    if (object != null) break block10;
                }
                return;
            }
            AbstractInsnNode previousInsn = object;
            InsnList $this$transformTrivialCheckNotNullWithMessage_u24lambda_u247 = this.methodNode.instructions;
            boolean bl = false;
            $this$transformTrivialCheckNotNullWithMessage_u24lambda_u247.remove(previousInsn);
            $this$transformTrivialCheckNotNullWithMessage_u24lambda_u247.remove(ldcInsn);
            $this$transformTrivialCheckNotNullWithMessage_u24lambda_u247.remove(insn);
        }

        private final void transformTrivialCheckExpressionValueIsNotNull(AbstractInsnNode insn, Nullability nullability) {
            Object object;
            block5: {
                block4: {
                    AbstractInsnNode abstractInsnNode;
                    if (nullability != Nullability.NOT_NULL) {
                        return;
                    }
                    object = insn.getPrevious();
                    if (object == null) break block4;
                    AbstractInsnNode it = abstractInsnNode = object;
                    boolean bl = false;
                    object = it.getOpcode() == 18 ? abstractInsnNode : null;
                    if (object != null) break block5;
                }
                return;
            }
            AbstractInsnNode ldcInsn = object;
            InsnList $this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u249 = this.methodNode.instructions;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u249, (String)"transformTrivialCheckExp\u2026onValueIsNotNull$lambda$9");
            RedundantNullCheckMethodTransformerKt.popReferenceValueBefore($this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u249, ldcInsn);
            $this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u249.remove(ldcInsn);
            $this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u249.remove(insn);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0017\u001a\u00020\u0015J\u001d\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u0002H\u0019\u00a2\u0006\u0002\u0010\u001bR-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions;", "", "(Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;)V", "originalLabels", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lkotlin/collections/HashMap;", "getOriginalLabels", "()Ljava/util/HashMap;", "syntheticInstructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/ArrayList;", "getSyntheticInstructions", "()Ljava/util/ArrayList;", "listOfSynthetics", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "block", "Lkotlin/Function1;", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "", "Lkotlin/ExtensionFunctionType;", "revert", "synthetic", "T", "insn", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "backend"})
        @SourceDebugExtension(value={"SMAP\nRedundantNullCheckMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions\n+ 2 CoroutineTransformerMethodVisitor.kt\norg/jetbrains/kotlin/codegen/coroutines/CoroutineTransformerMethodVisitorKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,530:1\n1146#2,5:531\n1855#3,2:536\n*S KotlinDebug\n*F\n+ 1 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions\n*L\n441#1:531,5\n450#1:536,2\n*E\n"})
        public final class NullabilityAssumptions {
            @NotNull
            private final HashMap<JumpInsnNode, LabelNode> originalLabels = new HashMap();
            @NotNull
            private final ArrayList<AbstractInsnNode> syntheticInstructions = new ArrayList();

            @NotNull
            public final HashMap<JumpInsnNode, LabelNode> getOriginalLabels() {
                return this.originalLabels;
            }

            @NotNull
            public final ArrayList<AbstractInsnNode> getSyntheticInstructions() {
                return this.syntheticInstructions;
            }

            @NotNull
            public final <T extends AbstractInsnNode> T synthetic(@NotNull T insn) {
                Intrinsics.checkNotNullParameter(insn, (String)"insn");
                this.syntheticInstructions.add(insn);
                return insn;
            }

            @NotNull
            public final InsnList listOfSynthetics(@NotNull Function1<? super InstructionAdapter, Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv);
                block.invoke((Object)instructionAdapter);
                InsnList insnList = tmpMethodNode$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"tmpMethodNode.instructions");
                InsnList insnList2 = insnList;
                for (AbstractInsnNode insn : insnList2) {
                    this.synthetic(insn);
                }
                return insnList2;
            }

            public final void revert() {
                InsnList $this$revert_u24lambda_u241 = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                Iterable $this$forEach$iv = this.syntheticInstructions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    $this$revert_u24lambda_u241.remove(it);
                }
                for (Map.Entry entry : ((Map)this.originalLabels).entrySet()) {
                    LabelNode originalLabel;
                    JumpInsnNode jumpInsn = (JumpInsnNode)entry.getKey();
                    jumpInsn.label = originalLabel = (LabelNode)entry.getValue();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\f\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u00060\u0012R\u00020\u0013J \u0010\u0015\u001a\u00020\n*\u00060\u0012R\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0017\u001a\u00020\n*\u00060\u0012R\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0018\u001a\u00020\n*\u00060\u0012R\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0019\u001a\u00020\n*\u00060\u0012R\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\n*\u00060\u0012R\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\u001c\u001a\u00020\n*\u00060\u0012R\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptionsBuilder;", "", "(Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;)V", "checksDependingOnVariable", "Ljava/util/HashMap;", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "addDependentCheck", "", "insn", "aLoadInsn", "Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;", "addDependentCheckForCheckNotNull", "checkedValueInsn", "collectVariableDependentChecks", "injectAssumptions", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions;", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;", "injectNullabilityAssumptions", "injectAssumptionsForInsn", "varIndex", "injectAssumptionsForInstanceOfCheck", "injectAssumptionsForNotNullAssertion", "injectAssumptionsForNullCheck", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "injectCodeForStoreNotNull", "injectCodeForThrowIntrinsic", "backend"})
        @SourceDebugExtension(value={"SMAP\nRedundantNullCheckMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptionsBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions\n+ 5 CoroutineTransformerMethodVisitor.kt\norg/jetbrains/kotlin/codegen/coroutines/CoroutineTransformerMethodVisitorKt\n*L\n1#1,530:1\n1#2:531\n361#3,7:532\n441#4:539\n442#4,4:545\n441#4:549\n442#4,4:555\n441#4:559\n442#4,4:565\n441#4:569\n442#4,4:575\n441#4:579\n442#4,4:585\n441#4:589\n442#4,4:595\n1146#5,5:540\n1146#5,5:550\n1146#5,5:560\n1146#5,5:570\n1146#5,5:580\n1146#5,5:590\n*S KotlinDebug\n*F\n+ 1 RedundantNullCheckMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptionsBuilder\n*L\n252#1:532,7\n311#1:539\n311#1:545,4\n319#1:549\n319#1:555,4\n356#1:559\n356#1:565,4\n391#1:569\n391#1:575,4\n404#1:579\n404#1:585,4\n421#1:589\n421#1:595,4\n311#1:540,5\n319#1:550,5\n356#1:560,5\n391#1:570,5\n404#1:580,5\n421#1:590,5\n*E\n"})
        private final class NullabilityAssumptionsBuilder {
            @NotNull
            private final HashMap<Integer, List<AbstractInsnNode>> checksDependingOnVariable = new HashMap();

            @NotNull
            public final NullabilityAssumptions injectNullabilityAssumptions() {
                this.collectVariableDependentChecks();
                return this.injectAssumptions();
            }

            private final void collectVariableDependentChecks() {
                for (AbstractInsnNode insn : TransformerPass.this.getMethodNode().instructions) {
                    AbstractInsnNode insn1;
                    AbstractInsnNode aLoadInsn;
                    AbstractInsnNode ldcInsn;
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    if (RedundantNullCheckMethodTransformerKt.isInstanceOfOrNullCheck(insn)) {
                        AbstractInsnNode previous2;
                        AbstractInsnNode previous;
                        if (insn.getPrevious() == null) continue;
                        if (previous.getOpcode() == 25) {
                            this.addDependentCheck(insn, (VarInsnNode)previous);
                            continue;
                        }
                        if (previous.getOpcode() != 89 || previous.getPrevious() == null || previous2.getOpcode() != 25) continue;
                        this.addDependentCheck(insn, (VarInsnNode)previous2);
                        continue;
                    }
                    if (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn)) {
                        AbstractInsnNode checkedValueInsn;
                        if (insn.getPrevious() == null) continue;
                        this.addDependentCheckForCheckNotNull(insn, checkedValueInsn);
                        continue;
                    }
                    if (RedundantNullCheckMethodTransformerKt.isCheckNotNullWithMessage(insn)) {
                        Object object = insn.getPrevious();
                        if (object != null) {
                            AbstractInsnNode checkedValueInsn;
                            AbstractInsnNode abstractInsnNode;
                            AbstractInsnNode it = abstractInsnNode = object;
                            boolean bl = false;
                            object = it.getOpcode() == 18 ? abstractInsnNode : null;
                            if (object == null || (ldcInsn = object).getPrevious() == null) continue;
                            this.addDependentCheckForCheckNotNull(insn, checkedValueInsn);
                        }
                        continue;
                    }
                    if (RedundantNullCheckMethodTransformerKt.isCheckParameterIsNotNull(insn)) {
                        if (insn.getPrevious() == null || ldcInsn.getOpcode() != 18 || ldcInsn.getPrevious() == null || aLoadInsn.getOpcode() != 25) continue;
                        this.addDependentCheck(insn, (VarInsnNode)aLoadInsn);
                        continue;
                    }
                    if (!RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn) || insn.getPrevious() == null || ldcInsn.getOpcode() != 18) continue;
                    aLoadInsn = null;
                    if (ldcInsn.getPrevious() == null) continue;
                    if (insn1.getOpcode() == 25) {
                        aLoadInsn = (VarInsnNode)insn1;
                    } else if (insn1.getOpcode() == 89) {
                        AbstractInsnNode insn2;
                        if (insn1.getPrevious() == null) continue;
                        if (insn2.getOpcode() == 25) {
                            aLoadInsn = (VarInsnNode)insn2;
                        }
                    }
                    if (aLoadInsn == null) continue;
                    this.addDependentCheck(insn, (VarInsnNode)aLoadInsn);
                }
            }

            private final void addDependentCheckForCheckNotNull(AbstractInsnNode insn, AbstractInsnNode checkedValueInsn) {
                AbstractInsnNode aLoadInsn;
                AbstractInsnNode abstractInsnNode;
                if (checkedValueInsn.getOpcode() == 89) {
                    abstractInsnNode = checkedValueInsn.getPrevious();
                    if (abstractInsnNode == null) {
                        return;
                    }
                } else {
                    abstractInsnNode = checkedValueInsn;
                }
                if ((aLoadInsn = abstractInsnNode).getOpcode() != 25) {
                    return;
                }
                Intrinsics.checkNotNull((Object)aLoadInsn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                this.addDependentCheck(insn, (VarInsnNode)aLoadInsn);
            }

            /*
             * WARNING - void declaration
             */
            private final void addDependentCheck(AbstractInsnNode insn, VarInsnNode aLoadInsn) {
                Object object;
                void $this$getOrPut$iv;
                Map map = this.checksDependingOnVariable;
                Integer key$iv = aLoadInsn.var;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new SmartList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(insn);
            }

            private final NullabilityAssumptions injectAssumptions() {
                NullabilityAssumptions nullabilityAssumptions = new NullabilityAssumptions();
                for (Map.Entry entry : ((Map)this.checksDependingOnVariable).entrySet()) {
                    int varIndex = ((Number)entry.getKey()).intValue();
                    List dependentChecks = (List)entry.getValue();
                    for (AbstractInsnNode checkInsn : dependentChecks) {
                        this.injectAssumptionsForInsn(nullabilityAssumptions, varIndex, checkInsn);
                    }
                }
                for (AbstractInsnNode insn : TransformerPass.this.getMethodNode().instructions) {
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    if (!RedundantNullCheckMethodTransformerKt.isThrowIntrinsic(insn)) continue;
                    this.injectCodeForThrowIntrinsic(nullabilityAssumptions, insn);
                }
                return nullabilityAssumptions;
            }

            private final void injectAssumptionsForInsn(NullabilityAssumptions $this$injectAssumptionsForInsn, int varIndex, AbstractInsnNode insn) {
                switch (insn.getOpcode()) {
                    case 198: 
                    case 199: {
                        Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                        this.injectAssumptionsForNullCheck($this$injectAssumptionsForInsn, varIndex, (JumpInsnNode)insn);
                        break;
                    }
                    case 184: {
                        if (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn) || RedundantNullCheckMethodTransformerKt.isCheckNotNullWithMessage(insn) || RedundantNullCheckMethodTransformerKt.isCheckParameterIsNotNull(insn) || RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn)) {
                            this.injectAssumptionsForNotNullAssertion($this$injectAssumptionsForInsn, varIndex, insn);
                            break;
                        }
                        if (PseudoInsnsKt.isPseudo(insn, PseudoInsn.STORE_NOT_NULL)) {
                            this.injectCodeForStoreNotNull($this$injectAssumptionsForInsn, insn);
                            break;
                        }
                        throw new AssertionError((Object)("Expected non-null assertion: " + UtilKt.getDebugText(insn)));
                    }
                    case 193: {
                        this.injectAssumptionsForInstanceOfCheck($this$injectAssumptionsForInsn, varIndex, insn);
                    }
                }
            }

            private final void injectAssumptionsForNullCheck(NullabilityAssumptions $this$injectAssumptionsForNullCheck, int varIndex, JumpInsnNode insn) {
                NullabilityAssumptions this_$iv;
                InstructionAdapter instructionAdapter;
                boolean jumpsIfNull = insn.getOpcode() == 198;
                LabelNode labelNode = insn.label;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insn.label");
                LabelNode originalLabel = CodegenUtilKt.linkWithLabel(labelNode);
                ((Map)$this$injectAssumptionsForNullCheck.getOriginalLabels()).put(insn, originalLabel);
                insn.label = (LabelNode)$this$injectAssumptionsForNullCheck.synthetic((AbstractInsnNode)new LabelNode(new Label()));
                AbstractInsnNode insertAfterNull = jumpsIfNull ? (AbstractInsnNode)insn.label : (AbstractInsnNode)insn;
                AbstractInsnNode insertAfterNonNull = jumpsIfNull ? (AbstractInsnNode)insn : (AbstractInsnNode)insn.label;
                InsnList $this$injectAssumptionsForNullCheck_u24lambda_u244 = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                $this$injectAssumptionsForNullCheck_u24lambda_u244.add((AbstractInsnNode)insn.label);
                NullabilityAssumptions nullabilityAssumptions = $this$injectAssumptionsForNullCheck;
                AbstractInsnNode abstractInsnNode = insertAfterNull;
                InsnList insnList = $this$injectAssumptionsForNullCheck_u24lambda_u244;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u242 = instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl2 = false;
                $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u242.aconst(null);
                $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u242.store(varIndex, AsmTypes.OBJECT_TYPE);
                if (jumpsIfNull) {
                    $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u242.goTo(originalLabel.getLabel());
                }
                InsnList insnList2 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"tmpMethodNode.instructions");
                InsnList insnList$iv = insnList2;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode, insnList3);
                this_$iv = $this$injectAssumptionsForNullCheck;
                abstractInsnNode = insertAfterNonNull;
                insnList = $this$injectAssumptionsForNullCheck_u24lambda_u244;
                $i$f$listOfSynthetics = false;
                $i$f$withInstructionAdapter = false;
                tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u243 = instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl3 = false;
                $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u243.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u243);
                $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u243.store(varIndex, AsmTypes.OBJECT_TYPE);
                if (!jumpsIfNull) {
                    $this$injectAssumptionsForNullCheck_u24lambda_u244_u24lambda_u243.goTo(originalLabel.getLabel());
                }
                InsnList insnList4 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList4, (String)"tmpMethodNode.instructions");
                insnList$iv = insnList4;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    this_$iv.synthetic(insn$iv);
                }
                insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode, insnList3);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectAssumptionsForNotNullAssertion(NullabilityAssumptions $this$injectAssumptionsForNotNullAssertion, int varIndex, AbstractInsnNode insn) {
                InstructionAdapter instructionAdapter;
                NullabilityAssumptions nullabilityAssumptions = $this$injectAssumptionsForNotNullAssertion;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList = TransformerPass.this.getMethodNode().instructions;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter $this$injectAssumptionsForNotNullAssertion_u24lambda_u245 = instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl = false;
                $this$injectAssumptionsForNotNullAssertion_u24lambda_u245.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectAssumptionsForNotNullAssertion_u24lambda_u245);
                $this$injectAssumptionsForNotNullAssertion_u24lambda_u245.store(varIndex, AsmTypes.OBJECT_TYPE);
                InsnList insnList2 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"tmpMethodNode.instructions");
                InsnList insnList$iv = insnList2;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode, insnList3);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectAssumptionsForInstanceOfCheck(NullabilityAssumptions $this$injectAssumptionsForInstanceOfCheck, int varIndex, AbstractInsnNode insn) {
                InstructionAdapter instructionAdapter;
                AbstractInsnNode abstractInsnNode = insn.getNext();
                if (abstractInsnNode == null) {
                    return;
                }
                AbstractInsnNode next = abstractInsnNode;
                if (next.getOpcode() != 153 && next.getOpcode() != 154) {
                    return;
                }
                if (!(next instanceof JumpInsnNode)) {
                    return;
                }
                boolean jumpsIfInstance = ((JumpInsnNode)next).getOpcode() == 154;
                LabelNode originalLabel = null;
                AbstractInsnNode insertAfterNotNull = null;
                if (jumpsIfInstance) {
                    LabelNode labelNode = ((JumpInsnNode)next).label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"next.label");
                    originalLabel = CodegenUtilKt.linkWithLabel(labelNode);
                    Map map = $this$injectAssumptionsForInstanceOfCheck.getOriginalLabels();
                    AbstractInsnNode abstractInsnNode2 = next;
                    LabelNode labelNode2 = ((JumpInsnNode)next).label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"next.label");
                    LabelNode labelNode3 = labelNode2;
                    map.put(abstractInsnNode2, labelNode3);
                    LabelNode newLabel = (LabelNode)$this$injectAssumptionsForInstanceOfCheck.synthetic((AbstractInsnNode)new LabelNode(new Label()));
                    TransformerPass.this.getMethodNode().instructions.add((AbstractInsnNode)newLabel);
                    ((JumpInsnNode)next).label = newLabel;
                    insertAfterNotNull = (AbstractInsnNode)newLabel;
                } else {
                    originalLabel = null;
                    insertAfterNotNull = next;
                }
                InsnList $this$injectAssumptionsForInstanceOfCheck_u24lambda_u247 = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                NullabilityAssumptions nullabilityAssumptions = $this$injectAssumptionsForInstanceOfCheck;
                AbstractInsnNode abstractInsnNode3 = insertAfterNotNull;
                InsnList insnList = $this$injectAssumptionsForInstanceOfCheck_u24lambda_u247;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter $this$injectAssumptionsForInstanceOfCheck_u24lambda_u247_u24lambda_u246 = instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl2 = false;
                $this$injectAssumptionsForInstanceOfCheck_u24lambda_u247_u24lambda_u246.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectAssumptionsForInstanceOfCheck_u24lambda_u247_u24lambda_u246);
                $this$injectAssumptionsForInstanceOfCheck_u24lambda_u247_u24lambda_u246.store(varIndex, AsmTypes.OBJECT_TYPE);
                if (originalLabel != null) {
                    $this$injectAssumptionsForInstanceOfCheck_u24lambda_u247_u24lambda_u246.goTo(originalLabel.getLabel());
                }
                InsnList insnList2 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"tmpMethodNode.instructions");
                InsnList insnList$iv = insnList2;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode3, insnList3);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectCodeForThrowIntrinsic(NullabilityAssumptions $this$injectCodeForThrowIntrinsic, AbstractInsnNode insn) {
                InstructionAdapter instructionAdapter;
                InsnList $this$injectCodeForThrowIntrinsic_u24lambda_u249 = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                NullabilityAssumptions nullabilityAssumptions = $this$injectCodeForThrowIntrinsic;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList = $this$injectCodeForThrowIntrinsic_u24lambda_u249;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter $this$injectCodeForThrowIntrinsic_u24lambda_u249_u24lambda_u248 = instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl2 = false;
                $this$injectCodeForThrowIntrinsic_u24lambda_u249_u24lambda_u248.aconst(null);
                $this$injectCodeForThrowIntrinsic_u24lambda_u249_u24lambda_u248.athrow();
                InsnList insnList2 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"tmpMethodNode.instructions");
                InsnList insnList$iv = insnList2;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode, insnList3);
                ++TransformerPass.this.getMethodNode().maxStack;
            }

            /*
             * WARNING - void declaration
             */
            private final void injectCodeForStoreNotNull(NullabilityAssumptions $this$injectCodeForStoreNotNull, AbstractInsnNode insn) {
                InstructionAdapter instructionAdapter;
                AbstractInsnNode previous = insn.getPrevious();
                if (previous.getOpcode() != 58) {
                    return;
                }
                InsnList $this$injectCodeForStoreNotNull_u24lambda_u2411 = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                NullabilityAssumptions nullabilityAssumptions = $this$injectCodeForStoreNotNull;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList = $this$injectCodeForStoreNotNull_u24lambda_u2411;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter $this$injectCodeForStoreNotNull_u24lambda_u2411_u24lambda_u2410 = instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)previous, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                int varIndex = ((VarInsnNode)previous).var;
                $this$injectCodeForStoreNotNull_u24lambda_u2411_u24lambda_u2410.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectCodeForStoreNotNull_u24lambda_u2411_u24lambda_u2410);
                $this$injectCodeForStoreNotNull_u24lambda_u2411_u24lambda_u2410.store(varIndex, AsmTypes.OBJECT_TYPE);
                InsnList insnList2 = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"tmpMethodNode.instructions");
                InsnList insnList$iv = insnList2;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InsnList insnList3 = insnList$iv;
                insnList.insert(abstractInsnNode, insnList3);
            }
        }
    }
}

