/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u000e*\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001a\u0010\u0011\u001a\u00020\u000e*\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\u0013\u001a\u00020\u000e*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "transformerComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "chooseMaximallySpecificCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "candidates", "discriminateAbstracts", "", "isShadowedByFieldCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isShadowedByPropertyCandidate", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "strictlyDerivedFrom", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "other", "java"})
@SourceDebugExtension(value={"SMAP\nJvmPlatformOverloadsConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmPlatformOverloadsConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver\n+ 2 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n*L\n1#1,92:1\n97#2,4:93\n60#2:97\n101#2,2:98\n88#2,4:100\n72#2:104\n60#2,7:105\n92#2,2:112\n88#2,4:114\n72#2:118\n60#2,7:119\n92#2,2:126\n97#2,4:128\n60#2:132\n101#2,2:133\n*S KotlinDebug\n*F\n+ 1 JvmPlatformOverloadsConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver\n*L\n51#1:93,4\n51#1:97\n51#1:98,2\n54#1:100,4\n54#1:104\n54#1:105,7\n54#1:112,2\n68#1:114,4\n68#1:118\n68#1:119,7\n68#1:126,2\n71#1:128,4\n71#1:132\n71#1:133,2\n*E\n"})
public final class JvmPlatformOverloadsConflictResolver
extends AbstractConeCallConflictResolver {
    public JvmPlatformOverloadsConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents, @NotNull BodyResolveComponents transformerComponents) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        Intrinsics.checkNotNullParameter((Object)transformerComponents, (String)"transformerComponents");
        super(specificityComparator, inferenceComponents, transformerComponents);
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getInferenceComponents().getSession()).supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return candidates2;
        }
        Set result2 = new LinkedHashSet();
        for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirProperty) {
                if (this.isShadowedByFieldCandidate((FirProperty)me, candidates2)) continue;
                ((Collection)result2).add(myCandidate);
                continue;
            }
            if (me instanceof FirField) {
                if (this.isShadowedByPropertyCandidate((FirField)me, candidates2)) continue;
                ((Collection)result2).add(myCandidate);
                continue;
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean isShadowedByFieldCandidate(FirProperty $this$isShadowedByFieldCandidate, Set<Candidate> candidates2) {
        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv;
        FirCallableDeclaration $this$unwrapSubstitutionOverrides$iv = $this$isShadowedByFieldCandidate;
        boolean $i$f$unwrapSubstitutionOverrides = false;
        FirCallableDeclaration current$iv = $this$unwrapSubstitutionOverrides$iv;
        while (true) {
            FirCallableDeclaration next$iv;
            $this$originalForSubstitutionOverride$iv$iv = current$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            if (firCallableDeclaration == null) break;
            current$iv = next$iv = firCallableDeclaration;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(((FirProperty)current$iv).getSymbol());
        if (coneClassLikeLookupTag == null) {
            return false;
        }
        ConeClassLikeLookupTag propertyContainingClassLookupTag = coneClassLikeLookupTag;
        for (Candidate otherCandidate : candidates2) {
            FirField field2;
            $this$originalForSubstitutionOverride$iv$iv = otherCandidate.getSymbol().getFir();
            if (($this$originalForSubstitutionOverride$iv$iv instanceof FirField ? (FirField)$this$originalForSubstitutionOverride$iv$iv : null) == null) continue;
            field2 = field2;
            FirCallableDeclaration $this$unwrapFakeOverrides$iv = field2;
            boolean $i$f$unwrapFakeOverrides = false;
            FirCallableDeclaration current$iv2 = $this$unwrapFakeOverrides$iv;
            while (true) {
                FirCallableDeclaration next$iv;
                FirCallableDeclaration $this$originalIfFakeOverride$iv$iv = current$iv2;
                boolean $i$f$originalIfFakeOverride = false;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                if (firCallableDeclaration == null) {
                    FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                }
                if (firCallableDeclaration == null) break;
                current$iv2 = next$iv = firCallableDeclaration;
            }
            ConeClassLikeLookupTag fieldContainingClassLookupTag = ClassMembersKt.containingClassLookupTag(((FirField)current$iv2).getSymbol());
            if (fieldContainingClassLookupTag == null || this.strictlyDerivedFrom(propertyContainingClassLookupTag, fieldContainingClassLookupTag)) continue;
            return true;
        }
        return false;
    }

    private final boolean isShadowedByPropertyCandidate(FirField $this$isShadowedByPropertyCandidate, Set<Candidate> candidates2) {
        FirCallableDeclaration $this$originalIfFakeOverride$iv$iv;
        FirCallableDeclaration $this$unwrapFakeOverrides$iv = $this$isShadowedByPropertyCandidate;
        boolean $i$f$unwrapFakeOverrides = false;
        FirCallableDeclaration current$iv = $this$unwrapFakeOverrides$iv;
        while (true) {
            FirCallableDeclaration next$iv;
            $this$originalIfFakeOverride$iv$iv = current$iv;
            boolean $i$f$originalIfFakeOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
            if (firCallableDeclaration == null) {
                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                boolean $i$f$getBaseForIntersectionOverride = false;
                firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
            }
            if (firCallableDeclaration == null) break;
            current$iv = next$iv = firCallableDeclaration;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(((FirField)current$iv).getSymbol());
        if (coneClassLikeLookupTag == null) {
            return false;
        }
        ConeClassLikeLookupTag fieldContainingClassLookupTag = coneClassLikeLookupTag;
        for (Candidate otherCandidate : candidates2) {
            FirProperty property2;
            $this$originalIfFakeOverride$iv$iv = otherCandidate.getSymbol().getFir();
            if (($this$originalIfFakeOverride$iv$iv instanceof FirProperty ? (FirProperty)$this$originalIfFakeOverride$iv$iv : null) == null) continue;
            property2 = property2;
            FirCallableDeclaration $this$unwrapSubstitutionOverrides$iv = property2;
            boolean $i$f$unwrapSubstitutionOverrides = false;
            FirCallableDeclaration current$iv2 = $this$unwrapSubstitutionOverrides$iv;
            while (true) {
                FirCallableDeclaration next$iv;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = current$iv2;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
                if (firCallableDeclaration == null) break;
                current$iv2 = next$iv = firCallableDeclaration;
            }
            ConeClassLikeLookupTag propertyContainingClassLookupTag = ClassMembersKt.containingClassLookupTag(((FirProperty)current$iv2).getSymbol());
            if (propertyContainingClassLookupTag == null || !this.strictlyDerivedFrom(propertyContainingClassLookupTag, fieldContainingClassLookupTag)) continue;
            return true;
        }
        return false;
    }

    private final boolean strictlyDerivedFrom(ConeClassLikeLookupTag $this$strictlyDerivedFrom, ConeClassLikeLookupTag other) {
        if (Intrinsics.areEqual((Object)$this$strictlyDerivedFrom, (Object)other)) {
            return false;
        }
        FirSession session = this.getInferenceComponents().getSession();
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$strictlyDerivedFrom, session);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
        if (firClass == null) {
            return false;
        }
        FirClass thisClass = firClass;
        return SupertypeUtilsKt.isSubclassOf$default(thisClass, other, session, true, null, false, 24, null);
    }
}

