/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J6\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J6\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J*\u0010\u0019\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010\u001c\u001a\u00020\u001b*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u001b*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010 \u001a\u0004\u0018\u00010!*\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010&\u001a\u00020\u0016*\u00020\u0010H\u0002J\u0014\u0010'\u001a\u00020\u001b*\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010(\u001a\u00020\u001b*\u00020\u0010H\u0002J\u0010\u0010)\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030%H\u0002J\u0014\u0010*\u001a\u00020\u001b*\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotated", "targetSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "outerProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkForInterface", "checkOverrideCannotBeStatic", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkStaticOnConstOrJvmField", "chooseMostSpecific", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "a", "b", "reportStaticNotInProperObject", "supportsJvmStaticInInterface", "", "containerIsInterface", "outerLevel", "", "containerIsNonCompanionObject", "findAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getContainerAt", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getMinimumVisibility", "hasAnnotationNamedAs", "hasExternalParts", "isCompanion", "supports", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmStaticChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n21#3:253\n42#3:254\n42#3:255\n42#3:256\n42#3:257\n21#3:258\n21#3:259\n21#3:260\n37#3:261\n44#3:262\n64#3:264\n34#4:263\n71#5:265\n288#6,2:266\n*S KotlinDebug\n*F\n+ 1 FirJvmStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker\n*L\n127#1:253\n133#1:254\n144#1:255\n147#1:256\n151#1:257\n158#1:258\n161#1:259\n165#1:260\n187#1:261\n203#1:262\n220#1:264\n211#1:263\n239#1:265\n246#1:266,2\n*E\n"})
public final class FirJvmStaticChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmStaticChecker INSTANCE = new FirJvmStaticChecker();

    private FirJvmStaticChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirPropertyAccessor it;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration instanceof FirConstructor) {
                return;
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            FirAnnotation declarationAnnotation = this.findAnnotation(declaration, StandardClassIds.Annotations.INSTANCE.getJvmStatic());
            if (declarationAnnotation != null) {
                FirJvmStaticChecker.checkAnnotated$default(this, declaration, context, reporter, declaration.getSource(), null, 16, null);
            }
            if (!(declaration instanceof FirProperty)) break block5;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirJvmStaticChecker.check$checkIfAnnotated(context, declaration, reporter, it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                FirJvmStaticChecker.check$checkIfAnnotated(context, declaration, reporter, it);
            }
        }
    }

    private final void checkAnnotated(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getContainerAt(context, 0);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> container = firClassLikeSymbol;
        boolean supportsJvmStaticInInterface = this.supports(context, LanguageFeature.JvmStaticInInterface);
        boolean containerIsAnonymous = Intrinsics.areEqual((Object)container.getClassId().getShortClassName(), (Object)SpecialNames.ANONYMOUS);
        if (FirHelpersKt.getClassKind(container) != ClassKind.OBJECT || !this.isCompanion(container) && containerIsAnonymous) {
            this.reportStaticNotInProperObject(context, reporter, supportsJvmStaticInInterface, targetSource);
        } else if (this.isCompanion(container) && this.containerIsInterface(context, 1)) {
            if (supportsJvmStaticInInterface) {
                this.checkForInterface(declaration, context, reporter, targetSource);
            } else {
                this.reportStaticNotInProperObject(context, reporter, supportsJvmStaticInInterface, targetSource);
            }
        }
        this.checkOverrideCannotBeStatic((FirMemberDeclaration)declaration, context, reporter, targetSource, outerProperty);
        this.checkStaticOnConstOrJvmField(declaration, context, reporter, targetSource);
    }

    static /* synthetic */ void checkAnnotated$default(FirJvmStaticChecker firJvmStaticChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, FirProperty firProperty, int n, Object object) {
        if ((n & 0x10) != 0) {
            firProperty = null;
        }
        firJvmStaticChecker.checkAnnotated(firDeclaration, checkerContext, diagnosticReporter, ktSourceElement, firProperty);
    }

    private final void reportStaticNotInProperObject(CheckerContext context, DiagnosticReporter reporter, boolean supportsJvmStaticInInterface, KtSourceElement targetSource) {
        KtDiagnosticFactory0 properDiagnostic = supportsJvmStaticInInterface ? FirJvmErrors.INSTANCE.getJVM_STATIC_NOT_IN_OBJECT_OR_COMPANION() : FirJvmErrors.INSTANCE.getJVM_STATIC_NOT_IN_OBJECT_OR_CLASS_COMPANION();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, properDiagnostic, (DiagnosticContext)context, null, 8, null);
    }

    private final void checkForInterface(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource) {
        boolean isExternal;
        boolean bl;
        Visibility visibility2;
        Visibility visibility3;
        if (!(declaration instanceof FirCallableDeclaration)) {
            return;
        }
        if (declaration instanceof FirProperty) {
            visibility3 = this.getMinimumVisibility((FirProperty)declaration);
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            visibility3 = visibility2 = $this$visibility$iv.getStatus().getVisibility();
        }
        if (declaration instanceof FirProperty) {
            bl = this.hasExternalParts((FirProperty)declaration);
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            bl = isExternal = $this$isExternal$iv.getStatus().isExternal();
        }
        if (!Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Public.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_NON_PUBLIC_MEMBER(), (DiagnosticContext)context, null, 8, null);
        } else if (isExternal) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_EXTERNAL_IN_INTERFACE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasExternalParts(FirProperty $this$hasExternalParts) {
        block5: {
            block4: {
                hasExternal = false;
                $this$isExternal$iv = $this$hasExternalParts;
                $i$f$isExternal = false;
                hasExternal = $this$isExternal$iv.getStatus().isExternal();
                v0 = $this$hasExternalParts.getGetter();
                if (v0 == null) break block4;
                it = v0;
                $i$a$-let-FirJvmStaticChecker$hasExternalParts$1 = false;
                if (hasExternal) ** GOTO lbl-1000
                $this$isExternal$iv = it;
                $i$f$isExternal = false;
                if ($this$isExternal$iv.getStatus().isExternal()) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                hasExternal = v1;
            }
            v2 = $this$hasExternalParts.getSetter();
            if (v2 == null) break block5;
            it = v2;
            $i$a$-let-FirJvmStaticChecker$hasExternalParts$2 = false;
            if (hasExternal) ** GOTO lbl-1000
            $this$isExternal$iv = it;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            hasExternal = v3;
        }
        return hasExternal;
    }

    private final Visibility getMinimumVisibility(FirProperty $this$getMinimumVisibility) {
        Visibility minVisibility;
        block1: {
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirPropertyAccessor it;
            minVisibility = null;
            FirMemberDeclaration $this$visibility$iv2 = $this$getMinimumVisibility;
            boolean $i$f$getVisibility2 = false;
            minVisibility = $this$visibility$iv2.getStatus().getVisibility();
            FirPropertyAccessor firPropertyAccessor = $this$getMinimumVisibility.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                $this$visibility$iv = it;
                $i$f$getVisibility = false;
                minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
            }
            FirPropertyAccessor firPropertyAccessor2 = $this$getMinimumVisibility.getSetter();
            if (firPropertyAccessor2 == null) break block1;
            it = firPropertyAccessor2;
            boolean bl = false;
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
        }
        return minVisibility;
    }

    private final Visibility chooseMostSpecific(Visibility a, Visibility b) {
        Integer n = a.compareTo(b);
        if (n == null) {
            return a;
        }
        int difference2 = n;
        return difference2 > 0 ? b : a;
    }

    private final void checkOverrideCannotBeStatic(FirMemberDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        boolean isOverride;
        boolean bl;
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        FirProperty firProperty = outerProperty;
        if (firProperty != null) {
            $this$isOverride$iv = firProperty;
            $i$f$isOverride = false;
            bl = $this$isOverride$iv.getStatus().isOverride();
        } else {
            $this$isOverride$iv = declaration;
            $i$f$isOverride = false;
            bl = isOverride = $this$isOverride$iv.getStatus().isOverride();
        }
        if (!isOverride || !this.containerIsNonCompanionObject(context, 0)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getOVERRIDE_CANNOT_BE_STATIC(), (DiagnosticContext)context, null, 8, null);
    }

    static /* synthetic */ void checkOverrideCannotBeStatic$default(FirJvmStaticChecker firJvmStaticChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, FirProperty firProperty, int n, Object object) {
        if ((n & 0x10) != 0) {
            firProperty = null;
        }
        firJvmStaticChecker.checkOverrideCannotBeStatic(firMemberDeclaration, checkerContext, diagnosticReporter, ktSourceElement, firProperty);
    }

    private final void checkStaticOnConstOrJvmField(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource) {
        block4: {
            block3: {
                block2: {
                    if (!(declaration instanceof FirProperty)) break block2;
                    FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isConst = false;
                    if ($this$isConst$iv.getStatus().isConst()) break block3;
                }
                if (!this.hasAnnotationNamedAs(declaration, StandardClassIds.Annotations.INSTANCE.getJvmField())) break block4;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_CONST_OR_JVM_FIELD(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean containerIsInterface(CheckerContext $this$containerIsInterface, int outerLevel) {
        boolean bl;
        Object object = this.getContainerAt($this$containerIsInterface, outerLevel);
        if (object != null && (object = FirHelpersKt.getClassKind(object)) != null) {
            Object $this$isInterface$iv = object;
            boolean $i$f$isInterface = false;
            bl = $this$isInterface$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containerIsNonCompanionObject(CheckerContext $this$containerIsNonCompanionObject, int outerLevel) {
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getContainerAt($this$containerIsNonCompanionObject, outerLevel);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> containingClassSymbol = firClassLikeSymbol;
        Object e = containingClassSymbol.getFir();
        if (!(e instanceof FirRegularClass)) return false;
        FirRegularClass firRegularClass = (FirRegularClass)e;
        if (firRegularClass == null) {
            return false;
        }
        FirRegularClass containingClass = firRegularClass;
        if (containingClass.getClassKind() != ClassKind.OBJECT) return false;
        FirRegularClass $this$isCompanion$iv = containingClass;
        boolean $i$f$isCompanion = false;
        if ($this$isCompanion$iv.getStatus().isCompanion()) return false;
        return true;
    }

    private final FirClassLikeSymbol<?> getContainerAt(CheckerContext $this$getContainerAt, int outerLevel) {
        int correction = CollectionsKt.lastOrNull($this$getContainerAt.getContainingDeclarations()) instanceof FirProperty ? 1 : 0;
        FirDeclaration last = (FirDeclaration)CollectionsKt.getOrNull((List)CollectionsKt.asReversed($this$getContainerAt.getContainingDeclarations()), (int)(outerLevel + correction));
        return last instanceof FirClassLikeDeclaration ? ((FirClassLikeDeclaration)last).getSymbol() : null;
    }

    private final boolean supports(CheckerContext $this$supports, LanguageFeature feature) {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$supports.getSession()).supportsFeature(feature);
    }

    private final boolean isCompanion(FirClassLikeSymbol<?> $this$isCompanion) {
        boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = $this$isCompanion instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$isCompanion : null;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean hasAnnotationNamedAs(FirDeclaration $this$hasAnnotationNamedAs, ClassId classId) {
        return this.findAnnotation($this$hasAnnotationNamedAs, classId) != null;
    }

    private final FirAnnotation findAnnotation(FirDeclaration $this$findAnnotation, ClassId classId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef())), (Object)classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void check$checkIfAnnotated(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirDeclaration it) {
        if (!FirAnnotationUtilsKt.hasAnnotation(it, StandardClassIds.Annotations.INSTANCE.getJvmStatic(), $context.getSession())) {
            return;
        }
        KtSourceElement ktSourceElement = it.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = $declaration.getSource();
        }
        KtSourceElement targetSource = ktSourceElement;
        INSTANCE.checkAnnotated(it, $context, $reporter, targetSource, $declaration instanceof FirProperty ? (FirProperty)$declaration : null);
    }
}

