/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrivateInlineFunctionsReturningAnonymousObjectsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkTypeAndArguments", "frontend"})
public final class PrivateInlineFunctionsReturningAnonymousObjectsChecker
implements DeclarationChecker {
    @NotNull
    public static final PrivateInlineFunctionsReturningAnonymousObjectsChecker INSTANCE = new PrivateInlineFunctionsReturningAnonymousObjectsChecker();

    private PrivateInlineFunctionsReturningAnonymousObjectsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isInline() && DescriptorVisibilities.isPrivate(((SimpleFunctionDescriptor)descriptor2).getVisibility()) && declaration instanceof KtNamedFunction)) {
            return;
        }
        PsiElement psiElement = ((KtNamedFunction)declaration).getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        KotlinType kotlinType = ((SimpleFunctionDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        this.checkTypeAndArguments(returnType2, nameIdentifier, context);
    }

    private final void checkTypeAndArguments(KotlinType type2, PsiElement reportOn, DeclarationCheckerContext context) {
        this.checkType(type2, reportOn, context);
        for (TypeProjection argument2 : type2.getArguments()) {
            KotlinType kotlinType = argument2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument.type");
            this.checkTypeAndArguments(kotlinType, reportOn, context);
        }
    }

    private final void checkType(KotlinType type2, PsiElement reportOn, DeclarationCheckerContext context) {
        TypeConstructor returnTypeConstructor = type2.getConstructor();
        ClassifierDescriptor classifierDescriptor = returnTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor returnTypeDeclarationDescriptor = classifierDescriptor;
        if (DescriptorUtils.isAnonymousObject(returnTypeDeclarationDescriptor)) {
            context.getTrace().report(Errors.PRIVATE_INLINE_FUNCTIONS_RETURNING_ANONYMOUS_OBJECTS.on(reportOn));
        }
    }
}

