/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\u0003\u00a8\u0006\u000f"}, d2={"checkModConvention", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "modifier", "Lcom/intellij/psi/PsiElement;", "shouldWarnAboutDeprecatedModFromBuiltIns", "", "warnAboutDeprecatedOrForbiddenMod", "reportOn", "isOperatorMod", "frontend"})
public final class OperatorCallCheckerKt {
    public static final boolean isOperatorMod(@NotNull FunctionDescriptor $this$isOperatorMod) {
        Intrinsics.checkNotNullParameter((Object)$this$isOperatorMod, (String)"<this>");
        return $this$isOperatorMod.isOperator() && ((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.values()).contains((Object)$this$isOperatorMod.getName());
    }

    public static final boolean shouldWarnAboutDeprecatedModFromBuiltIns(@NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        return languageVersionSettings2.supportsFeature(LanguageFeature.OperatorRem) && languageVersionSettings2.getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0;
    }

    private static final void checkModConvention(FunctionDescriptor descriptor2, LanguageVersionSettings languageVersionSettings2, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        if (!OperatorCallCheckerKt.isOperatorMod(descriptor2)) {
            return;
        }
        if (KotlinBuiltIns.isUnderKotlinPackage(descriptor2)) {
            if (OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(languageVersionSettings2)) {
                OperatorCallCheckerKt.warnAboutDeprecatedOrForbiddenMod(descriptor2, diagnosticHolder, modifier, languageVersionSettings2);
            }
        } else if (languageVersionSettings2.supportsFeature(LanguageFeature.OperatorRem)) {
            OperatorCallCheckerKt.warnAboutDeprecatedOrForbiddenMod(descriptor2, diagnosticHolder, modifier, languageVersionSettings2);
        }
    }

    private static final void warnAboutDeprecatedOrForbiddenMod(FunctionDescriptor descriptor2, DiagnosticSink diagnosticHolder, PsiElement reportOn, LanguageVersionSettings languageVersionSettings2) {
        Name newNameConvention;
        DiagnosticFactory2<PsiElement, FunctionDescriptor, String> diagnosticFactory = languageVersionSettings2.supportsFeature(LanguageFeature.ProhibitOperatorMod) ? Errors.FORBIDDEN_BINARY_MOD_AS_REM : Errors.DEPRECATED_BINARY_MOD_AS_REM;
        Name name2 = newNameConvention = (Name)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.inverse().get((Object)descriptor2.getName());
        Intrinsics.checkNotNull((Object)name2);
        diagnosticHolder.report(diagnosticFactory.on(reportOn, descriptor2, name2.asString()));
    }

    public static final /* synthetic */ void access$checkModConvention(FunctionDescriptor descriptor2, LanguageVersionSettings languageVersionSettings2, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        OperatorCallCheckerKt.checkModConvention(descriptor2, languageVersionSettings2, diagnosticHolder, modifier);
    }
}

