/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirReceiverParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty2TypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00f2\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005\u001a\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a.\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u001a\u0018\u0010%\u001a\u00020\u001d2\b\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020(\u001a\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,\u001a\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0000\u001a\n\u00100\u001a\u000201*\u000202\u001a\u0016\u00103\u001a\u00020\u0001*\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0002\u001a\n\u00104\u001a\u000201*\u000205\u001a0\u00106\u001a\u000207*\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u001f2\b\u00109\u001a\u0004\u0018\u00010\u001f2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\"H\u0002\u001a\u001a\u0010<\u001a\u00020=*\u00020\u001d2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u001f\u001a\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u0010*\b\u0012\u0004\u0012\u00020@0\u00102\u0006\u0010A\u001a\u00020B\u001aU\u0010C\u001a\u00020D\"\u0004\b\u0000\u0010\u0015*\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020I2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010J\u001a\u00020\u0001\u00a2\u0006\u0002\u0010K\u001a.\u0010L\u001a\u00020M*\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020O2\b\u00109\u001a\u0004\u0018\u00010\u001f2\b\u00108\u001a\u0004\u0018\u00010\u001f\u001a.\u0010P\u001a\u000207*\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020\u00012\b\u00109\u001a\u0004\u0018\u00010\u001f2\b\u00108\u001a\u0004\u0018\u00010\u001f\u001a$\u0010R\u001a\u00020S*\u00020\u000e2\u0006\u0010T\u001a\u00020\u000e2\u0006\u0010U\u001a\u00020\u00012\b\u00109\u001a\u0004\u0018\u00010\u001f\u001a\u001c\u0010V\u001a\u00020W*\u00020\u000e2\u0006\u0010T\u001a\u00020\u000e2\b\u00109\u001a\u0004\u0018\u00010\u001f\u001a\u001e\u0010X\u001a\u00020D\"\u0004\b\u0000\u0010\u0015*\u00020Y2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u001a\n\u0010Z\u001a\u00020\u0001*\u00020,\u001a\n\u0010[\u001a\u00020\u0019*\u00020\u001b\u001a\n\u0010\\\u001a\u00020\u000e*\u00020\u000e\u001a\f\u0010]\u001a\u0004\u0018\u00010\"*\u00020O\u001a\n\u0010^\u001a\u00020_*\u00020O\u001a\f\u0010`\u001a\u0004\u0018\u00010\"*\u00020O\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006a"}, d2={"isUnderscore", "", "", "(Ljava/lang/CharSequence;)Z", "ownerRegularClassTypeParametersCount", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularClassTypeParametersCount", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Ljava/lang/Integer;", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "buildBalancedOrExpressionTree", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "conditions", "", "lower", "upper", "currentDispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "T", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "escapedStringToCharacter", "Lorg/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "text", "", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "calleeReferenceSource", "name", "Lorg/jetbrains/kotlin/name/Name;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "processLegacyContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "translateEscape", "c", "", "asReceiverParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "checkReceiver", "convertToReceiverParameter", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "createSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "receiver", "filterUseSiteTarget", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "isExtension", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Ljava/lang/Integer;Lorg/jetbrains/kotlin/fir/builder/Context;Z)V", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lcom/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "initContainingClassAttr", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isContractPresentFirCheck", "parseCharacter", "pullUpSafeCallIfNecessary", "toBinaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toUnaryName", "raw-fir.common"})
@SourceDebugExtension(value={"SMAP\nConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n+ 2 FirElvisExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElvisExpressionBuilderKt\n+ 3 FirBinaryLogicExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBinaryLogicExpressionBuilderKt\n+ 4 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 5 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 6 FirComparisonExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirComparisonExpressionBuilderKt\n+ 7 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 8 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 9 FirPropertyAccessorBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyAccessorBuilderKt\n+ 10 FirImplicitTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirImplicitTypeRefBuilderKt\n+ 11 FirImplicitTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirImplicitTypeRefBuilderKt$buildImplicitTypeRef$1\n+ 12 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 13 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 14 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 15 FirLegacyRawContractDescriptionBuilder.kt\norg/jetbrains/kotlin/fir/contracts/builder/FirLegacyRawContractDescriptionBuilderKt\n+ 16 FirCheckedSafeCallSubjectBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckedSafeCallSubjectBuilderKt\n+ 17 FirSafeCallExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSafeCallExpressionBuilderKt\n+ 18 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 19 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 20 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 21 FirReceiverParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirReceiverParameterBuilderKt\n+ 22 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 23 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 24 FirImplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirImplicitThisReferenceBuilderKt\n+ 25 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 26 FirDelegateFieldReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirDelegateFieldReferenceBuilderKt\n+ 27 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n*L\n1#1,634:1\n60#2,4:635\n59#3,4:639\n73#4,4:643\n73#4,4:655\n73#4,4:679\n73#4,4:701\n73#4,4:723\n41#5,4:647\n41#5,4:659\n41#5,4:667\n41#5,4:683\n41#5,4:705\n41#5,4:727\n57#6,4:651\n68#7,4:663\n68#7,4:671\n68#7,4:735\n68#7,4:814\n42#8,4:675\n42#8,4:739\n42#8,4:826\n99#9,4:687\n99#9,4:709\n37#10,5:691\n37#10,5:717\n37#11:696\n37#11:722\n60#12,4:697\n96#13,4:713\n33#14,4:731\n39#15,4:743\n50#16,4:747\n56#17,4:751\n1603#18,9:755\n1855#18:764\n1856#18:779\n1612#18:780\n819#18:785\n847#18,2:786\n83#19,13:765\n1#20:778\n44#21,4:781\n44#21,4:788\n1064#22,2:792\n82#23,4:794\n82#23,4:802\n39#24,4:798\n39#24,4:806\n51#25,4:810\n40#26,4:818\n67#27,4:822\n*S KotlinDebug\n*F\n+ 1 ConversionUtils.kt\norg/jetbrains/kotlin/fir/builder/ConversionUtilsKt\n*L\n172#1:635,4\n182#1:639,4\n199#1:643,4\n248#1:655,4\n388#1:679,4\n416#1:701,4\n469#1:723,4\n201#1:647,4\n250#1:659,4\n268#1:667,4\n390#1:683,4\n419#1:705,4\n472#1:727,4\n235#1:651,4\n266#1:663,4\n281#1:671,4\n479#1:735,4\n351#1:814,4\n283#1:675,4\n480#1:739,4\n364#1:826,4\n403#1:687,4\n442#1:709,4\n407#1:691,5\n457#1:717,5\n407#1:696\n457#1:722\n415#1:697,4\n452#1:713,4\n476#1:731,4\n503#1:743,4\n535#1:747,4\n544#1:751,4\n569#1:755,9\n569#1:764\n569#1:779\n569#1:780\n583#1:785\n583#1:786,2\n571#1:765,13\n569#1:778\n579#1:781,4\n591#1:788,4\n605#1:792,2\n332#1:794,4\n338#1:802,4\n334#1:798,4\n340#1:806,4\n343#1:810,4\n353#1:818,4\n362#1:822,4\n*E\n"})
public final class ConversionUtilsKt {
    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        String string2 = $this$parseCharacter.substring(1, $this$parseCharacter.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String text = string2;
        if (((CharSequence)text).length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text.charAt(0) != '\\' ? (text.length() == 1 ? new CharacterWithDiagnostic(text.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl2 = bl = ((CharSequence)text).length() > 0 && text.charAt(0) == '\\';
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Only escaped sequences must be passed to this routine: " + text;
            throw new AssertionError((Object)string2);
        }
        String string3 = text.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String escape = string3;
        switch (escape.length()) {
            case 0: {
                return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                String string4 = escape.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                Integer intValue = StringsKt.toIntOrNull((String)string4, (int)16);
                if (intValue == null) break;
                return new CharacterWithDiagnostic((char)intValue.intValue());
            }
        }
        return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c) {
        char c2 = c;
        return c2 == 't' ? new CharacterWithDiagnostic('\t') : (c2 == 'b' ? new CharacterWithDiagnostic('\b') : (c2 == 'n' ? new CharacterWithDiagnostic('\n') : (c2 == 'r' ? new CharacterWithDiagnostic('\r') : (c2 == '\'' ? new CharacterWithDiagnostic('\'') : (c2 == '\"' ? new CharacterWithDiagnostic('\"') : (c2 == '\\' ? new CharacterWithDiagnostic('\\') : (c2 == '$' ? new CharacterWithDiagnostic('$') : new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape))))))));
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"BINARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"<this>");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"UNARY_OPERATION_NAMES");
        return (Name)((Map)immutableBiMap).get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"<this>");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQ))) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSEQ))) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSEQ))) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MULTEQ))) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIVEQ))) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERCEQ))) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.AS_KEYWORD))) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.AS_SAFE))) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw new AssertionError((Object)$this$toFirOperation.toString());
        }
        return firOperation;
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable KtSourceElement baseSource) {
        FirElvisExpressionBuilder firElvisExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildElvisExpression = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u241 = firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl = false;
        $this$generateNotNullOrOther_u24lambda_u241.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u241.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u241.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable KtSourceElement baseSource) {
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildBinaryLogicExpression = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u242 = firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl = false;
        $this$generateLazyLogicalOperation_u24lambda_u242.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u242.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u242.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u242.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument2, boolean inverted, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u244_u24lambda_u243;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument2, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u244 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u244.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u244;
        boolean bl2 = false;
        KtSourceElement ktSourceElement2 = operationReferenceSource;
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setSource(ktSourceElement2 != null ? KtSourceElementKt.fakeElement(ktSourceElement2, KtFakeSourceElementKind.DesugaredInvertedContains.INSTANCE) : null);
        $this$generateContainsOperation_u24lambda_u244_u24lambda_u243.setName(OperatorNameConventions.NOT);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u244.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u244.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument2, @NotNull IElementType operatorToken, @Nullable KtSourceElement baseSource, @Nullable KtSourceElement operationReferenceSource) {
        FirComparisonExpressionBuilder firComparisonExpressionBuilder;
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"COMPARISON_OPERATIONS");
        if (!CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)operatorToken)) {
            boolean $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = false;
            String $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw new IllegalArgumentException($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22.toString());
        }
        KtSourceElement ktSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE) : null, argument2, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            firOperation = FirOperation.GT_EQ;
        } else {
            throw new IllegalStateException(("Unknown " + operatorToken).toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u246 = firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl = false;
        $this$generateComparisonExpression_u24lambda_u246.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u246.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u246.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, KtSourceElement operationReferenceSource, KtSourceElement baseSource, FirExpression argument2, Name conventionName) {
        void $this$createConventionCall_u24lambda_u248_u24lambda_u247;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u248 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        $this$createConventionCall_u24lambda_u248.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u248;
        boolean bl2 = false;
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u248_u24lambda_u247.setName(conventionName);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u248.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u248.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument2));
        $this$createConventionCall_u24lambda_u248.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable KtSourceElement qualifiedSource, @Nullable KtSourceElement calleeReferenceSource, @NotNull Name name2, @Nullable ConeDiagnostic diagnostic) {
        void $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249;
        KtSourceElement ktSourceElement;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2410 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessExpression_u24lambda_u2410.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2410;
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)calleeReferenceSource, (Object)qualifiedSource)) {
            KtSourceElement ktSourceElement2 = calleeReferenceSource;
            ktSourceElement = ktSourceElement2 != null ? KtSourceElementKt.fakeElement(ktSourceElement2, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE) : null;
        } else {
            ktSourceElement = calleeReferenceSource;
        }
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setSource(ktSourceElement);
        $this$generateAccessExpression_u24lambda_u2410_u24lambda_u249.setName(name2);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        if (diagnostic != null) {
            $this$generateAccessExpression_u24lambda_u2410.getNonFatalDiagnostics().add(diagnostic);
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    public static /* synthetic */ FirQualifiedAccessExpression generateAccessExpression$default(KtSourceElement ktSourceElement, KtSourceElement ktSourceElement2, Name name2, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 8) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.generateAccessExpression(ktSourceElement, ktSourceElement2, name2, coneDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable KtSourceElement source, @NotNull FirVariable variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2412 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2412;
        boolean bl2 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2412_u24lambda_u2411.setResolvedSymbol((FirBasedSymbol)variable2.getSymbol());
        firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    @Nullable
    public static final FirClassSymbol<?> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularOrAnonymousObjectSymbol, (String)"<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        return firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : null);
    }

    @Nullable
    public static final Integer getOwnerRegularClassTypeParametersCount(@NotNull FirClassBuilder $this$ownerRegularClassTypeParametersCount) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularClassTypeParametersCount, (String)"<this>");
        return $this$ownerRegularClassTypeParametersCount instanceof FirRegularClassBuilder ? Integer.valueOf($this$ownerRegularClassTypeParametersCount.getTypeParameters().size()) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @Nullable Integer ownerRegularClassTypeParametersCount, @NotNull Context<T> context, boolean isExtension) {
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Object object;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Object object2;
        Object $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425;
        boolean $i$f$buildPropertyAccessor22;
        void $this$generateAccessorsByDelegate_u24lambda_u2424_u24lambda_u2423;
        void $this$generateAccessorsByDelegate_u24lambda_u2424;
        FirFunctionCallBuilder firFunctionCallBuilder;
        FirDelegateFieldSymbol firDelegateFieldSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol it = firDelegateFieldSymbol = new FirDelegateFieldSymbol($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean bl = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it);
        FirDelegateFieldSymbol delegateFieldSymbol = firDelegateFieldSymbol;
        boolean isMember = ownerRegularOrAnonymousObjectSymbol != null;
        KtSourceElement ktSourceElement = delegateBuilder.getSource();
        KtSourceElement fakeSource = ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) : null;
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = delegateBuilder;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24lambda_u2424.setExplicitReceiver(delegateBuilder.getExpression());
        boolean $i$f$buildSimpleNamedReference3 = false;
        Object object3 = new FirSimpleNamedReferenceBuilder();
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = object3;
        void var18_30 = $this$generateAccessorsByDelegate_u24lambda_u2424;
        boolean bl3 = false;
        $this$generateAccessorsByDelegate_u24lambda_u2424_u24lambda_u2423.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24lambda_u2424_u24lambda_u2423.setName(OperatorNameConventions.PROVIDE_DELEGATE);
        var18_30.setCalleeReference(((FirSimpleNamedReferenceBuilder)object3).build());
        $this$generateAccessorsByDelegate_u24lambda_u2424.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
        $this$generateAccessorsByDelegate_u24lambda_u2424.setOrigin(FirFunctionCallOrigin.Operator);
        $this$generateAccessorsByDelegate_u24lambda_u2424.setSource(fakeSource);
        ((FirWrappedDelegateExpressionBuilder)firAnnotationContainerBuilder2).setDelegateProvider(firFunctionCallBuilder.build());
        $this$generateAccessorsByDelegate.setDelegate(delegateBuilder.build());
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void it2;
            void $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426;
            void $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427;
            void $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428;
            FirDeclarationStatusImpl firDeclarationStatusImpl;
            void $this$generateAccessorsByDelegate_u24lambda_u2429;
            FirPropertyAccessor firPropertyAccessor = $this$generateAccessorsByDelegate.getGetter();
            List<FirAnnotation> annotations2 = firPropertyAccessor != null ? firPropertyAccessor.getAnnotations() : null;
            FirFunctionTarget returnTarget = new FirFunctionTarget(null, false);
            FirPropertyAccessor firPropertyAccessor2 = $this$generateAccessorsByDelegate.getGetter();
            FirDeclarationStatus getterStatus = firPropertyAccessor2 != null ? firPropertyAccessor2.getStatus() : null;
            $i$f$buildPropertyAccessor22 = false;
            object3 = $i$f$buildSimpleNamedReference3 = new FirPropertyAccessorBuilder();
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2429.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2429.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2429.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef22 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = bl3 = new FirImplicitTypeRefBuilder();
            void var21_41 = $this$generateAccessorsByDelegate_u24lambda_u2429;
            boolean bl5 = false;
            FirImplicitTypeRefBuilder $this$null = firImplicitTypeRefBuilder;
            var21_41.setReturnTypeRef(bl3.build());
            $this$generateAccessorsByDelegate_u24lambda_u2429.setGetter(true);
            Object object4 = getterStatus;
            if (object4 == null || (object4 = object4.getVisibility()) == null) {
                object4 = Visibilities.Unknown.INSTANCE;
            }
            FirDeclarationStatusImpl $i$f$buildImplicitTypeRef22 = firDeclarationStatusImpl = new FirDeclarationStatusImpl((Visibility)object4, Modality.FINAL);
            var21_41 = $this$generateAccessorsByDelegate_u24lambda_u2429;
            boolean $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = false;
            FirDeclarationStatus firDeclarationStatus = getterStatus;
            ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425).setInline(firDeclarationStatus != null ? firDeclarationStatus.isInline() : ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425).isInline());
            var21_41.setStatus(firDeclarationStatusImpl);
            $this$generateAccessorsByDelegate_u24lambda_u2429.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            Object $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425 = new FirReturnExpressionBuilder();
            var21_41 = $this$generateAccessorsByDelegate_u24lambda_u2429;
            boolean bl6 = false;
            boolean $i$f$buildFunctionCall2 = false;
            object2 = new FirFunctionCallBuilder();
            firAnnotationContainerBuilder = object2;
            void var28_50 = $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428;
            boolean bl7 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount));
            boolean $i$f$buildSimpleNamedReference2 = false;
            object = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = object;
            firPropertyAccessExpressionBuilder = $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427;
            boolean bl8 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426.setName(OperatorNameConventions.GET_VALUE);
            ((FirFunctionCallBuilder)((Object)firPropertyAccessExpressionBuilder)).setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setOrigin(FirFunctionCallOrigin.Operator);
            var28_50.setResult(((FirFunctionCallBuilder)object2).build());
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428.setTarget(returnTarget);
            FirStatement firStatement = ((FirReturnExpressionBuilder)$this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425).build();
            var21_41.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2429.getAnnotations().addAll((Collection<FirAnnotation>)annotations2);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2429.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            FirPropertyAccessor $i$f$buildPropertyAccessor22 = ((FirPropertyAccessorBuilder)$i$f$buildSimpleNamedReference3).build();
            Object $i$f$buildSimpleNamedReference3 = $i$f$buildPropertyAccessor22;
            boolean bl9 = false;
            returnTarget.bind((FirTargetElement)it2);
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it2, context);
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setGetter($i$f$buildPropertyAccessor22);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
            void $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436;
            Object $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2433;
            void $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437;
            Object object5;
            void $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2431;
            void $this$generateAccessorsByDelegate_u24lambda_u2438;
            FirPropertyAccessor firPropertyAccessor = $this$generateAccessorsByDelegate.getSetter();
            List<FirAnnotation> annotations3 = firPropertyAccessor != null ? firPropertyAccessor.getAnnotations() : null;
            Object object6 = $this$generateAccessorsByDelegate.getSetter();
            List<FirAnnotation> parameterAnnotations = object6 != null && (object6 = ((FirPropertyAccessor)object6).getValueParameters()) != null && (object6 = (FirValueParameter)CollectionsKt.firstOrNull((List)object6)) != null ? ((FirValueParameter)object6).getAnnotations() : null;
            FirPropertyAccessor firPropertyAccessor3 = $this$generateAccessorsByDelegate.getSetter();
            FirDeclarationStatus setterStatus = firPropertyAccessor3 != null ? firPropertyAccessor3.getStatus() : null;
            $i$f$buildPropertyAccessor22 = false;
            Object it2 = new FirPropertyAccessorBuilder();
            FirPropertyAccessorBuilder bl9 = it2;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl10 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2438.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2438.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2438.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2438.setReturnTypeRef(moduleData.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2438.setGetter(false);
            Object object7 = setterStatus;
            if (object7 == null || (object7 = object7.getVisibility()) == null) {
                object7 = Visibilities.Unknown.INSTANCE;
            }
            $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425 = new FirDeclarationStatusImpl((Visibility)object7, Modality.FINAL);
            FirDeclarationStatusImpl $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2428 = $this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425;
            void var20_40 = $this$generateAccessorsByDelegate_u24lambda_u2438;
            boolean bl11 = false;
            FirDeclarationStatus firDeclarationStatus = setterStatus;
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2431.setInline(firDeclarationStatus != null ? firDeclarationStatus.isInline() : $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2431.isInline());
            var20_40.setStatus((FirDeclarationStatus)$this$generateAccessorsByDelegate_u24lambda_u2429_u24lambda_u2425);
            $this$generateAccessorsByDelegate_u24lambda_u2438.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildValueParameter = false;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder3 = new FirValueParameterBuilder();
            FirValueParameterBuilder $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432 = firAnnotationContainerBuilder3;
            boolean bl12 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setContainingFunctionSymbol($this$generateAccessorsByDelegate_u24lambda_u2438.getSymbol());
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            object2 = object5 = new FirImplicitTypeRefBuilder();
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432;
            boolean bl13 = false;
            Object $this$null = object2;
            ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(((FirImplicitTypeRefBuilder)object5).build());
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setSymbol(new FirValueParameterSymbol($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.setVararg(false);
            if (parameterAnnotations != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432.getAnnotations().addAll((Collection<FirAnnotation>)parameterAnnotations);
            }
            FirValueParameter parameter2 = ((FirValueParameterBuilder)firAnnotationContainerBuilder3).build();
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2438.getValueParameters()).add(parameter2);
            boolean $i$f$buildFunctionCall3 = false;
            firAnnotationContainerBuilder3 = new FirFunctionCallBuilder();
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2432 = firAnnotationContainerBuilder3;
            var20_40 = $this$generateAccessorsByDelegate_u24lambda_u2438;
            boolean bl14 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount));
            boolean $i$f$buildSimpleNamedReference4 = false;
            $this$null = object5 = new FirSimpleNamedReferenceBuilder();
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437;
            boolean bl15 = false;
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2433).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2433).setName(OperatorNameConventions.SET_VALUE);
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setCalleeReference(((FirSimpleNamedReferenceBuilder)object5).build());
            boolean $i$f$buildArgumentList = false;
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2433 = object5 = new FirArgumentListBuilder();
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437;
            boolean bl16 = false;
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, false, 32, null));
            ((Collection)$this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate));
            object = $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.getArguments();
            boolean $i$f$buildPropertyAccessExpression = false;
            FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            boolean bl17 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
            boolean bl18 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setName(SpecialNames.IMPLICIT_SET_PARAMETER);
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setResolvedSymbol(parameter2.getSymbol());
            firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            FirPropertyAccessExpression firPropertyAccessExpression = firPropertyAccessExpressionBuilder.build();
            object.add(firPropertyAccessExpression);
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setArgumentList(((FirArgumentListBuilder)object5).build());
            $this$generateAccessorsByDelegate_u24lambda_u2438_u24lambda_u2437.setOrigin(FirFunctionCallOrigin.Operator);
            FirStatement firStatement = ((FirFunctionCallBuilder)firAnnotationContainerBuilder3).build();
            var20_40.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations3 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2438.getAnnotations().addAll((Collection<FirAnnotation>)annotations3);
            }
            $this$generateAccessorsByDelegate_u24lambda_u2438.setPropertySymbol($this$generateAccessorsByDelegate.getSymbol());
            FirPropertyAccessor firPropertyAccessor4 = ((FirPropertyAccessorBuilder)it2).build();
            it2 = firPropertyAccessor4;
            boolean bl19 = false;
            ConversionUtilsKt.initContainingClassAttr((FirCallableDeclaration)it2, context);
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setSetter(firPropertyAccessor4);
        }
    }

    @Nullable
    public static final FirContractDescription processLegacyContractDescription(@NotNull FirBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (ConversionUtilsKt.isContractPresentFirCheck(block)) {
            FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder;
            FirFunctionCall contractCall2 = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement(block, processLegacyContractDescription.contractCall.1.INSTANCE);
            boolean $i$f$buildLegacyRawContractDescription = false;
            FirLegacyRawContractDescriptionBuilder $this$processLegacyContractDescription_u24lambda_u2440 = firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
            boolean bl = false;
            $this$processLegacyContractDescription_u24lambda_u2440.setSource(contractCall2.getSource());
            $this$processLegacyContractDescription_u24lambda_u2440.setContractCall(contractCall2);
            return firLegacyRawContractDescriptionBuilder.build();
        }
        return null;
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"<this>");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        FirFunctionCall firFunctionCall = firstStatement instanceof FirFunctionCall ? (FirFunctionCall)firstStatement : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall2 = firFunctionCall;
        if (!Intrinsics.areEqual((Object)contractCall2.getCalleeReference().getName().asString(), (Object)"contract")) {
            return false;
        }
        FirExpression firExpression2 = contractCall2.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall2, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firQualifiedAccessExpression2 == null) {
            return false;
        }
        FirQualifiedAccessExpression receiverOfReceiver = firQualifiedAccessExpression2;
        return receiverOfReceiver.getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name2) {
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        FirReference firReference = receiver.getCalleeReference();
        Object object = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (object == null || (object = ((FirNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
            return false;
        }
        Object receiverName = object;
        return Intrinsics.areEqual((Object)receiverName, (Object)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression createSafeCall(@NotNull FirQualifiedAccessExpression $this$createSafeCall, @NotNull FirExpression receiver, @NotNull KtSourceElement source) {
        void $this$createSafeCall_u24lambda_u2444_u24lambda_u2443;
        FirExpressionRef<FirExpression> $this$createSafeCall_u24lambda_u2442_u24lambda_u2441;
        FirExpressionRef<FirExpression> firExpressionRef;
        Intrinsics.checkNotNullParameter((Object)$this$createSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = new FirCheckedSafeCallSubjectBuilder();
        FirCheckedSafeCallSubjectBuilder $this$createSafeCall_u24lambda_u2442 = firAnnotationContainerBuilder;
        boolean bl = false;
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef = new FirExpressionRef<FirExpression>();
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = $this$createSafeCall_u24lambda_u2442;
        boolean bl2 = false;
        $this$createSafeCall_u24lambda_u2442_u24lambda_u2441.bind(receiver);
        ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder2).setOriginalReceiverRef(firExpressionRef);
        KtSourceElement ktSourceElement = receiver.getSource();
        $this$createSafeCall_u24lambda_u2442.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE) : null);
        FirCheckedSafeCallSubject checkedSafeCallSubject = ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder).build();
        $this$createSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        boolean $i$f$buildSafeCallExpression = false;
        FirAnnotationContainerBuilder $this$createSafeCall_u24lambda_u2444 = firAnnotationContainerBuilder = new FirSafeCallExpressionBuilder();
        boolean bl3 = false;
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2444).setReceiver(receiver);
        $this$createSafeCall_u24lambda_u2442_u24lambda_u2441 = firExpressionRef = new FirExpressionRef();
        firAnnotationContainerBuilder2 = $this$createSafeCall_u24lambda_u2444;
        boolean bl4 = false;
        $this$createSafeCall_u24lambda_u2444_u24lambda_u2443.bind((FirExpression)checkedSafeCallSubject);
        ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder2).setCheckedSubjectRef(firExpressionRef);
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2444).setSelector($this$createSafeCall);
        ((FirSafeCallExpressionBuilder)$this$createSafeCall_u24lambda_u2444).setSource(source);
        return ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder).build();
    }

    @NotNull
    public static final FirExpression pullUpSafeCallIfNecessary(@NotNull FirExpression $this$pullUpSafeCallIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$pullUpSafeCallIfNecessary, (String)"<this>");
        if (!($this$pullUpSafeCallIfNecessary instanceof FirQualifiedAccessExpression)) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).getExplicitReceiver();
        FirSafeCallExpression firSafeCallExpression = firExpression2 instanceof FirSafeCallExpression ? (FirSafeCallExpression)firExpression2 : null;
        if (firSafeCallExpression == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirSafeCallExpression safeCall = firSafeCallExpression;
        FirStatement firStatement = safeCall.getSelector();
        FirExpression firExpression3 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
        if (firExpression3 == null) {
            return $this$pullUpSafeCallIfNecessary;
        }
        FirExpression safeCallSelector = firExpression3;
        ((FirQualifiedAccessExpression)$this$pullUpSafeCallIfNecessary).replaceExplicitReceiver(safeCallSelector);
        safeCall.replaceSelector($this$pullUpSafeCallIfNecessary);
        return safeCall;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> filterUseSiteTarget(@NotNull List<? extends FirAnnotationCall> $this$filterUseSiteTarget, @NotNull AnnotationUseSiteTarget target) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterUseSiteTarget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Iterable $this$mapNotNull$iv = $this$filterUseSiteTarget;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirAnnotationCall firAnnotationCall;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() != target) {
                firAnnotationCall = null;
            } else {
                FirAnnotationCallBuilder firAnnotationCallBuilder;
                boolean $i$f$buildAnnotationCallCopy = false;
                FirAnnotationCallBuilder copyBuilder$iv = new FirAnnotationCallBuilder();
                copyBuilder$iv.setSource(it.getSource());
                copyBuilder$iv.setUseSiteTarget(it.getUseSiteTarget());
                copyBuilder$iv.setAnnotationTypeRef(it.getAnnotationTypeRef());
                copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)it.getTypeArguments());
                copyBuilder$iv.setArgumentList(it.getArgumentList());
                copyBuilder$iv.setCalleeReference(it.getCalleeReference());
                copyBuilder$iv.setArgumentMapping(it.getArgumentMapping());
                copyBuilder$iv.setAnnotationResolvePhase(it.getAnnotationResolvePhase());
                FirAnnotationCallBuilder $this$filterUseSiteTarget_u24lambda_u2446_u24lambda_u2445 = firAnnotationCallBuilder = copyBuilder$iv;
                boolean bl3 = false;
                KtSourceElement ktSourceElement = it.getSource();
                $this$filterUseSiteTarget_u24lambda_u2446_u24lambda_u2445.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE) : null);
                firAnnotationCall = firAnnotationCallBuilder.build();
            }
            if (firAnnotationCall == null) continue;
            FirAnnotationCall it$iv$iv = firAnnotationCall;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirReceiverParameter convertToReceiverParameter(@NotNull FirTypeRef $this$convertToReceiverParameter) {
        void $this$filterNotTo$iv$iv;
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$convertToReceiverParameter, (String)"<this>");
        FirTypeRef typeRef = $this$convertToReceiverParameter;
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$convertToReceiverParameter_u24lambda_u2448 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = typeRef.getSource();
        $this$convertToReceiverParameter_u24lambda_u2448.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.ReceiverFromType.INSTANCE) : null);
        Collection collection = $this$convertToReceiverParameter_u24lambda_u2448.getAnnotations();
        List<FirAnnotation> list2 = typeRef.getAnnotations();
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
        CollectionsKt.addAll((Collection)collection, (Iterable)ConversionUtilsKt.filterUseSiteTarget(list2, AnnotationUseSiteTarget.RECEIVER));
        Iterable $this$filterNot$iv = typeRef.getAnnotations();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (it.getUseSiteTarget() == AnnotationUseSiteTarget.RECEIVER) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTypeRefAnnotations = (List)destination$iv$iv;
        if (filteredTypeRefAnnotations.size() != typeRef.getAnnotations().size()) {
            typeRef.replaceAnnotations(filteredTypeRefAnnotations);
        }
        $this$convertToReceiverParameter_u24lambda_u2448.setTypeRef(typeRef);
        return firReceiverParameterBuilder.build();
    }

    @NotNull
    public static final FirReceiverParameter asReceiverParameter(@NotNull FirImplicitTypeRef $this$asReceiverParameter) {
        FirReceiverParameterBuilder firReceiverParameterBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asReceiverParameter, (String)"<this>");
        boolean $i$f$buildReceiverParameter = false;
        FirReceiverParameterBuilder $this$asReceiverParameter_u24lambda_u2449 = firReceiverParameterBuilder = new FirReceiverParameterBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = $this$asReceiverParameter.getSource();
        $this$asReceiverParameter_u24lambda_u2449.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.ReceiverFromType.INSTANCE) : null);
        $this$asReceiverParameter_u24lambda_u2449.setTypeRef($this$asReceiverParameter);
        return firReceiverParameterBuilder.build();
    }

    public static final <T> void initContainingClassAttr(@NotNull FirCallableDeclaration $this$initContainingClassAttr, @NotNull Context<T> context) {
        Intrinsics.checkNotNullParameter((Object)$this$initContainingClassAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Object object = ConversionUtilsKt.currentDispatchReceiverType(context);
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$initContainingClassAttr, (ConeClassLikeLookupTag)object);
    }

    @Nullable
    public static final <T> ConeClassLikeType currentDispatchReceiverType(@NotNull Context<T> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return (ConeClassLikeType)CollectionsKt.lastOrNull(context.getDispatchReceiverTypesStack());
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isUnderscore, (String)"<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final FirExpression buildBalancedOrExpressionTree(@NotNull List<? extends FirExpression> conditions2, int lower2, int upper) {
        Intrinsics.checkNotNullParameter(conditions2, (String)"conditions");
        int size = upper - lower2 + 1;
        int middle = size / 2 + lower2;
        if (lower2 == upper) {
            return conditions2.get(middle);
        }
        FirExpression leftNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions2, lower2, middle - 1);
        FirExpression rightNode = ConversionUtilsKt.buildBalancedOrExpressionTree(conditions2, middle, upper);
        KtSourceElement ktSourceElement = leftNode.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = rightNode.getSource();
        }
        return ConversionUtilsKt.generateLazyLogicalOperation(leftNode, rightNode, false, ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.WhenCondition.INSTANCE) : null);
    }

    public static /* synthetic */ FirExpression buildBalancedOrExpressionTree$default(List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = CollectionsKt.getLastIndex((List)list2);
        }
        return ConversionUtilsKt.buildBalancedOrExpressionTree(list2, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private static final FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, KtSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Integer $ownerRegularClassTypeParametersCount, boolean forDispatchReceiver) {
        FirExpression firExpression2;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415_u24lambda_u2414;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415;
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415_u24lambda_u2414.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417;
            Object $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2416;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            Object object = new FirImplicitThisReferenceBuilder();
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2415_u24lambda_u2414 = object;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl3 = false;
            ((FirImplicitThisReferenceBuilder)$this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2416).setBoundSymbol((FirBasedSymbol)$ownerRegularOrAnonymousObjectSymbol);
            firThisReceiverExpressionBuilder3.setCalleeReference(((FirImplicitThisReferenceBuilder)object).build());
            boolean $i$f$buildResolvedTypeRef = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2416 = object = new FirResolvedTypeRefBuilder();
            firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418;
            boolean bl4 = false;
            Integer n = $ownerRegularClassTypeParametersCount;
            int typeParameterNumber = n != null ? n : 0;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2418_u24lambda_u2417.setType(TypeConstructionUtilsKt.constructStarProjectedType$default($ownerRegularOrAnonymousObjectSymbol, typeParameterNumber, false, 2, null));
            firThisReceiverExpressionBuilder3.setTypeRef(((FirResolvedTypeRefBuilder)object).build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Null.INSTANCE, null, null, false, 24, null);
        }
        return firExpression2;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl, FirClassSymbol firClassSymbol, KtSourceElement ktSourceElement, FirPropertyBuilder firPropertyBuilder, Integer n, boolean bl2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl, firClassSymbol, ktSourceElement, firPropertyBuilder, n, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final FirPropertyAccessExpression generateAccessorsByDelegate$delegateAccess(KtSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Integer $ownerRegularClassTypeParametersCount) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420_u24lambda_u2419.setResolvedSymbol(delegateFieldSymbol);
        firPropertyAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2420.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $ownerRegularClassTypeParametersCount, true));
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(KtSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422_u24lambda_u2421;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
        boolean $i$f$buildCallableReferenceAccess = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422_u24lambda_u2421.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422_u24lambda_u2421.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422_u24lambda_u2421.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        firCallableReferenceAccessBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2422.setTypeRef(!isMember && !$isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty0TypeRef(null, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty0TypeRef(null, ConeStarProjection.INSTANCE)) : (isMember && $isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE)) : (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE))));
        return firCallableReferenceAccessBuilder.build();
    }
}

