/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaShadowedFieldReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallableReferenceAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaShadowedFieldReferenceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaShadowedFieldReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaShadowedFieldReferenceChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n24#2:73\n1#3:74\n*S KotlinDebug\n*F\n+ 1 FirJavaShadowedFieldReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaShadowedFieldReferenceChecker\n*L\n35#1:73\n*E\n"})
public final class FirJavaShadowedFieldReferenceChecker
extends FirExpressionChecker<FirCallableReferenceAccess> {
    @NotNull
    public static final FirJavaShadowedFieldReferenceChecker INSTANCE = new FirJavaShadowedFieldReferenceChecker();

    private FirJavaShadowedFieldReferenceChecker() {
    }

    @Override
    public void check(@NotNull FirCallableReferenceAccess expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block7: {
            FirExpression firExpression2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirNamedReference firNamedReference = expression2.getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
            if (firResolvedNamedReference == null) {
                return;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            FirBasedSymbol<?> firBasedSymbol = reference.getResolvedSymbol();
            FirFieldSymbol firFieldSymbol = firBasedSymbol instanceof FirFieldSymbol ? (FirFieldSymbol)firBasedSymbol : null;
            if (firFieldSymbol == null) {
                return;
            }
            FirFieldSymbol referredSymbol = firFieldSymbol;
            FirCallableSymbol $this$visibility$iv = referredSymbol;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)JavaVisibilities.ProtectedAndPackage.INSTANCE)) {
                return;
            }
            FirSession session = context.getSession();
            Object object = ClassMembersKt.containingClassLookupTag(referredSymbol);
            if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, session)) == null) {
                return;
            }
            Object fieldContainingClassSymbol = object;
            FirFile firFile = context.getContainingFile();
            if (Intrinsics.areEqual((Object)(firFile != null ? UtilsKt.getPackageFqName(firFile) : null), (Object)((FirClassLikeSymbol)fieldContainingClassSymbol).getClassId().getPackageFqName())) {
                return;
            }
            FirExpression it = firExpression2 = expression2.getDispatchReceiver();
            boolean bl = false;
            FirExpression firExpression3 = !(it instanceof FirNoReceiverExpression) ? firExpression2 : null;
            if (firExpression3 == null) {
                return;
            }
            FirExpression dispatchReceiver = firExpression3;
            FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getConeType(dispatchReceiver.getTypeRef()), session, context.getSessionHolder().getScopeSession(), FakeOverrideTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.TYPES);
            if (firTypeScope == null) {
                return;
            }
            FirTypeScope scope2 = firTypeScope;
            Ref.ObjectRef shadowingPropertyClassId = new Ref.ObjectRef();
            scope2.processPropertiesByName(referredSymbol.getName(), (Function1)new Function1<FirVariableSymbol<?>, Unit>(session, (FirRegularClassSymbol)fieldContainingClassSymbol, (Ref.ObjectRef<ClassId>)shadowingPropertyClassId){
                final /* synthetic */ FirSession $session;
                final /* synthetic */ FirRegularClassSymbol $fieldContainingClassSymbol;
                final /* synthetic */ Ref.ObjectRef<ClassId> $shadowingPropertyClassId;
                {
                    this.$session = $session;
                    this.$fieldContainingClassSymbol = $fieldContainingClassSymbol;
                    this.$shadowingPropertyClassId = $shadowingPropertyClassId;
                    super(1);
                }

                public final void invoke(@NotNull FirVariableSymbol<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    if (!(it instanceof FirPropertySymbol)) {
                        return;
                    }
                    if (!DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)it)) {
                        return;
                    }
                    Object object = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)it);
                    if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, this.$session)) == null) {
                        return;
                    }
                    Object propertyContainingClassSymbol = object;
                    if (SupertypeUtilsKt.isSubclassOf((FirClassSymbol)propertyContainingClassSymbol, this.$fieldContainingClassSymbol.toLookupTag(), this.$session, true, false)) {
                        this.$shadowingPropertyClassId.element = ((FirClassLikeSymbol)propertyContainingClassSymbol).getClassId();
                    }
                }
            });
            ClassId classId = (ClassId)shadowingPropertyClassId.element;
            if (classId == null) break block7;
            ClassId it2 = classId;
            boolean bl2 = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reference.getSource(), FirJvmErrors.INSTANCE.getJAVA_SHADOWED_PROTECTED_FIELD_REFERENCE(), (Object)((FirClassLikeSymbol)fieldContainingClassSymbol).getClassId(), (Object)it2, (DiagnosticContext)context, null, 32, null);
        }
    }
}

