/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression2, context)) {
            return;
        }
        Object object = FirExpressionUtilKt.getCalleeReference(expression2);
        if (object == null || (object = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object;
        FirOptInUsageBaseChecker $this$check_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (expression2 instanceof FirVariableAssignment) {
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context, true, null), (Iterable)$this$check_u24lambda_u241.loadExperimentalitiesFromTypeArguments(context, CollectionsKt.emptyList()));
            $this$check_u24lambda_u241.reportNotAcceptedExperimentalities(experimentalities, ((FirVariableAssignment)expression2).getLValue(), context, reporter);
        } else if (expression2 instanceof FirQualifiedAccessExpression) {
            FirExpression firExpression2;
            FirExpression it = firExpression2 = ((FirQualifiedAccessExpression)expression2).getDispatchReceiver();
            boolean bl2 = false;
            Object object2 = !(it instanceof FirNoReceiverExpression) ? firExpression2 : null;
            ConeKotlinType dispatchReceiverType = object2 != null && (object2 = ((FirExpression)object2).getTypeRef()) != null && (object2 = FirTypeUtilsKt.getConeType((FirTypeRef)object2)) != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object2, context.getSession()) : null;
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u241.loadExperimentalitiesFromTypeArguments(context, ((FirQualifiedAccessExpression)expression2).getTypeArguments()));
            $this$check_u24lambda_u241.reportNotAcceptedExperimentalities(experimentalities, expression2, context, reporter);
        }
    }
}

